/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.gui;

import javax.swing.JEditorPane;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;

public class MessageTextArea
extends JEditorPane
implements InSimListener {
    private static final long serialVersionUID = 1L;
    private String rawData = "";

    protected MessageTextArea() {
        this.setEditable(false);
        this.setContentType("text/html");
    }

    public void packetReceived(InSimResponse packet) {
        if (packet instanceof MessageResponse) {
            MessageResponse data = (MessageResponse)packet;
            System.out.println(data.getMessage());
            this.rawData = this.rawData + data.getMessage() + "</font><br>";
            this.setText(this.prettyPrint(this.rawData));
        }
    }

    private String prettyPrint(String msg) {
        StringBuffer prettyMsg = new StringBuffer();
        for (int i = 0; i < msg.length(); ++i) {
            if (msg.charAt(i) == '\u0000') continue;
            if (msg.length() > i + 1 && msg.charAt(i) == '^' && msg.charAt(i + 1) == 'L') {
                ++i;
                prettyMsg.append("<font color=\"#00FF00\">");
                continue;
            }
            if (msg.charAt(i) == '\n') {
                prettyMsg.append("<br>");
                continue;
            }
            prettyMsg.append("" + msg.charAt(i));
        }
        return prettyMsg.toString();
    }
}

