/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.SetDirectCameraRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.CameraPositionResponse;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;
import net.sf.jinsim.response.StateResponse;
import net.sf.jinsim.response.VersionResponse;
import net.sf.jinsim.types.InSimVector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JInSimTestPanel
extends JPanel
implements InSimListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private JTextArea errors = new JTextArea();
    private JSlider headingSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    private JSlider pitchSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    private JSlider rollSlider = new JSlider(Short.MIN_VALUE, Short.MAX_VALUE);
    private JTextArea versionText;
    private JTextArea stateText;
    private JTextArea messageText;
    private SimpleClient client;
    private SetDirectCameraRequest cameraPosRequest;
    private static Log log = LogFactory.getLog(JInSimTestPanel.class);

    public JInSimTestPanel(String hostname, int port, String password) throws Exception {
        this.setLayout(new BoxLayout(this, 1));
        JPanel cameraControlPanel = new JPanel();
        cameraControlPanel.setLayout(new BoxLayout(cameraControlPanel, 1));
        JPanel headingPanel = new JPanel();
        headingPanel.setLayout(new BoxLayout(headingPanel, 0));
        this.headingSlider.setEnabled(false);
        this.headingSlider.setPaintLabels(true);
        this.headingSlider.setPaintTicks(true);
        this.headingSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.headingSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.headingSlider.addChangeListener(this);
        headingPanel.add(this.headingSlider);
        headingPanel.add(new JLabel("Heading"));
        cameraControlPanel.add(headingPanel);
        JPanel pitchPanel = new JPanel();
        pitchPanel.setLayout(new BoxLayout(pitchPanel, 0));
        this.pitchSlider.setEnabled(false);
        this.pitchSlider.setPaintLabels(true);
        this.pitchSlider.setPaintTicks(true);
        this.pitchSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.pitchSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.pitchSlider.addChangeListener(this);
        pitchPanel.add(this.pitchSlider);
        pitchPanel.add(new JLabel("Pitch"));
        cameraControlPanel.add(pitchPanel);
        JPanel rollPanel = new JPanel();
        rollPanel.setLayout(new BoxLayout(rollPanel, 0));
        this.rollSlider.setEnabled(false);
        this.rollSlider.setPaintLabels(true);
        this.rollSlider.setPaintTicks(true);
        this.rollSlider.setMajorTickSpacing(Short.MAX_VALUE);
        this.rollSlider.setLabelTable(this.headingSlider.createStandardLabels(66000, 0));
        this.rollSlider.addChangeListener(this);
        rollPanel.add(this.rollSlider);
        rollPanel.add(new JLabel("Roll"));
        cameraControlPanel.add(rollPanel);
        this.add(cameraControlPanel);
        JButton versionButton = new JButton("Version");
        versionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TinyRequest request = new TinyRequest(Tiny.VERSION);
                try {
                    JInSimTestPanel.this.client.send(request);
                    TinyRequest cameraRequest = new TinyRequest(Tiny.SEND_CAMERA_POSITION);
                    JInSimTestPanel.this.client.send(cameraRequest);
                }
                catch (IOException e1) {
                    JInSimTestPanel.this.errors.setText(e1.getMessage());
                }
            }
        });
        this.add(versionButton);
        this.versionText = new JTextArea();
        this.versionText.setSize(new Dimension(250, 100));
        this.add(this.versionText);
        JButton stateButton = new JButton("Request Info");
        stateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TinyRequest statePacket = new TinyRequest(Tiny.SEND_STATE_INFO);
                try {
                    JInSimTestPanel.this.client.send(statePacket);
                }
                catch (IOException e1) {
                    JInSimTestPanel.this.errors.setText(e1.getMessage());
                }
            }
        });
        this.add(stateButton);
        this.stateText = new JTextArea();
        this.stateText.setSize(new Dimension(250, 100));
        JScrollPane stateTextPane = new JScrollPane(this.stateText);
        stateTextPane.setPreferredSize(new Dimension(250, 100));
        this.add(stateTextPane);
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JInSimTestPanel.this.client.close();
                    System.exit(0);
                }
                catch (Exception e1) {
                    JInSimTestPanel.this.errors.setText(e1.getMessage());
                }
            }
        });
        this.messageText = new JTextArea();
        JScrollPane messageTextPane = new JScrollPane(this.messageText);
        messageTextPane.setPreferredSize(new Dimension(250, 100));
        this.add(messageTextPane);
        this.add(quitButton);
        this.add(this.errors);
        this.client = new SimpleClient();
        this.client.connect(new UDPChannel(hostname, port), password, "GUI");
        this.client.addListener(this);
        TinyRequest cameraRequest = new TinyRequest(Tiny.SEND_CAMERA_POSITION);
        this.client.send(cameraRequest);
    }

    public void packetReceived(InSimResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("packetReceived: " + response));
        }
        if (response instanceof CameraPositionResponse) {
            CameraPositionResponse cameraResponse = (CameraPositionResponse)response;
            this.cameraPosRequest = new SetDirectCameraRequest(cameraResponse);
            this.cameraPosRequest.setPosition(new InSimVector(0, 0, 0));
            this.cameraPosRequest.setFlags((short)8192);
            this.cameraPosRequest.setCameraType((byte)4);
            this.cameraPosRequest.setTime((short)500);
            this.headingSlider.setValue(this.cameraPosRequest.getHeading());
            this.headingSlider.setEnabled(true);
            this.pitchSlider.setValue(this.cameraPosRequest.getPitch());
            this.pitchSlider.setEnabled(true);
            this.rollSlider.setValue(this.cameraPosRequest.getRoll());
            this.rollSlider.setEnabled(true);
        } else if (response instanceof VersionResponse) {
            this.versionText.setText(response.toString());
        } else if (response instanceof StateResponse) {
            this.stateText.setText(response.toString());
        } else if (response instanceof MessageResponse) {
            this.messageText.append(((MessageResponse)response).getMessage() + "\n");
        } else {
            log.debug((Object)("Unknown response: " + response));
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (this.cameraPosRequest == null) {
            this.errors.append("Cannot set camera!");
            return;
        }
        JSlider source = (JSlider)event.getSource();
        if (source == this.headingSlider) {
            this.cameraPosRequest.setHeading((short)(source.getValue() * -1));
        } else if (source == this.pitchSlider) {
            this.cameraPosRequest.setPitch((short)(source.getValue() * -1));
        } else if (source == this.rollSlider) {
            this.cameraPosRequest.setRoll((short)(source.getValue() * -1));
        }
        try {
            this.client.send(this.cameraPosRequest);
        }
        catch (IOException e1) {
            this.errors.setText(e1.getMessage());
        }
    }
}

