/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.button;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.ButtonRequest;
import net.sf.jinsim.response.ButtonClickedResponse;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;

public class Main
implements InSimListener {
    private SimpleClient client;
    private String hostname;
    private int port;
    private String adminPassword;
    private boolean isClicked = false;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Run button test");
        try {
            this.client = new SimpleClient();
            UDPChannel channel = new UDPChannel(this.hostname, this.port);
            this.client.addListener(this);
            this.client.connect(channel, this.adminPassword, "ButtonTest");
            ButtonRequest buttonRequest = new ButtonRequest();
            buttonRequest.setButtonStyle(ButtonRequest.BUTTON_STYLE_GREEN | ButtonRequest.BUTTON_STYLE_LIGHT | ButtonRequest.BUTTON_STYLE_CLICK);
            buttonRequest.setText("My first Button");
            buttonRequest.setConnectionId((byte)-1);
            buttonRequest.setClickId((byte)1);
            buttonRequest.setRequestInfo((byte)1);
            buttonRequest.setLeft((byte)75);
            buttonRequest.setTop((byte)30);
            buttonRequest.setWidth((byte)50);
            buttonRequest.setHeight((byte)5);
            this.client.send(buttonRequest);
            while (!this.isClicked) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void packetReceived(InSimResponse response) {
        if (response instanceof MessageResponse) {
            MessageResponse msgResponse = (MessageResponse)response;
            System.out.println(msgResponse.getMessage());
        } else if (response instanceof ButtonClickedResponse) {
            ButtonClickedResponse buttonClickResponse = (ButtonClickedResponse)response;
            this.isClicked = true;
            System.out.println("Left Click: " + buttonClickResponse.isLeftClick());
            System.out.println("Right Click: " + buttonClickResponse.isRightClick());
            System.out.println("Ctrl: " + buttonClickResponse.isCtrl());
            System.out.println("Shift: " + buttonClickResponse.isShift());
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.message.Main <hostname> <port> <admin password>");
        }
    }
}

