/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;
import net.sf.jinsim.Channel;
import net.sf.jinsim.Client;
import net.sf.jinsim.UDPChannel;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.response.OutGaugeResponse;
import net.sf.jinsim.response.OutSimResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutChannel
implements Channel {
    private static final int BUFFER_SIZE = 96;
    private static final int OUT_GAUGE_SIZE = 96;
    private static final int OUT_SIM_SIZE = 68;
    private Client client;
    private boolean running;
    static Log log = LogFactory.getLog(UDPChannel.class);
    protected DatagramChannel datagramChannel;
    protected InetSocketAddress address;

    public OutChannel(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public OutChannel(InetSocketAddress inetSocketAddress) throws IOException {
        this.address = inetSocketAddress;
        this.datagramChannel = DatagramChannel.open();
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.socket().bind(new InetSocketAddress(this.address.getPort()));
    }

    public void close() throws IOException {
        this.running = false;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public void send(InSimRequest packet) throws IOException {
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void run() {
        this.running = true;
        ByteBuffer buffer = ByteBuffer.allocateDirect(96);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        while (this.running) {
            try {
                this.datagramChannel.receive(buffer);
                if (buffer.position() == 96) {
                    buffer.flip();
                    OutGaugeResponse reponse = new OutGaugeResponse();
                    reponse.construct(buffer);
                    this.client.notifyListeners(reponse);
                    buffer.flip();
                } else if (buffer.position() == 68 || buffer.position() == 64) {
                    buffer.flip();
                    OutSimResponse response = new OutSimResponse();
                    response.construct(buffer);
                    this.client.notifyListeners(response);
                    buffer.flip();
                }
                Thread.sleep(10L);
            }
            catch (Exception e) {
                log.error((Object)"Something went wrong!", (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.running;
    }
}

