/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Encoding {
    private static Log log = LogFactory.getLog(Encoding.class);
    private static char[] codePageLatinToUnicode = new char[256];
    private static char[] codePageCentralEuropeToUnicode = new char[256];
    private static char[] codePageCyrillicToUnicode = new char[256];
    private static char[] codePageGreekToUnicode = new char[256];
    private static char[] codePageTurkishToUnicode = new char[256];
    private static char[] codePageBalticToUnicode = new char[256];
    private static char[] codePageJapaneseToUnicode = new char[256];

    public static String decodeString(byte[] byteArray) {
        StringBuffer result = new StringBuffer();
        char[] currentCodePage = codePageLatinToUnicode;
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] == 94) {
                if (i + 1 >= byteArray.length) continue;
                switch (byteArray[++i]) {
                    case 69: {
                        currentCodePage = codePageCentralEuropeToUnicode;
                        break;
                    }
                    case 67: {
                        currentCodePage = codePageCyrillicToUnicode;
                        break;
                    }
                    case 76: {
                        currentCodePage = codePageLatinToUnicode;
                        break;
                    }
                    case 71: {
                        currentCodePage = codePageGreekToUnicode;
                        break;
                    }
                    case 84: {
                        currentCodePage = codePageTurkishToUnicode;
                        break;
                    }
                    case 66: {
                        currentCodePage = codePageBalticToUnicode;
                        break;
                    }
                    case 74: {
                        currentCodePage = codePageJapaneseToUnicode;
                        break;
                    }
                    case 115: {
                        result.append('/');
                        break;
                    }
                    case 100: {
                        result.append('\\');
                        break;
                    }
                    case 97: {
                        result.append('*');
                        break;
                    }
                    case 99: {
                        result.append(':');
                        break;
                    }
                    case 113: {
                        result.append('?');
                        break;
                    }
                    case 116: {
                        result.append('\"');
                        break;
                    }
                    case 60: {
                        result.append('<');
                        break;
                    }
                    case 62: {
                        result.append('>');
                        break;
                    }
                    case 94: {
                        result.append('^');
                        break;
                    }
                    case 58: {
                        result.append("^:");
                        currentCodePage = codePageLatinToUnicode;
                        break;
                    }
                    default: {
                        --i;
                        result.append("^");
                        break;
                    }
                }
                continue;
            }
            int index = byteArray[i] & 0xFF;
            if (index > 127 && index <= 256) {
                result.append(Character.toString(currentCodePage[index]));
                continue;
            }
            result.append(Character.toString((char)byteArray[i]));
        }
        return result.toString().trim();
    }

    public static byte[] encodeString(String text) {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream(text.length() * 2);
        char[] currentCodePage = codePageLatinToUnicode;
        char[][] codePages = new char[][]{codePageLatinToUnicode, codePageCentralEuropeToUnicode, codePageCyrillicToUnicode, codePageGreekToUnicode, codePageTurkishToUnicode, codePageBalticToUnicode, codePageJapaneseToUnicode};
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch > '\u0000' && ch < '\u0080') {
                byteArrayStream.write((byte)ch);
            }
            if (ch <= '\u007f') continue;
            boolean found = false;
            for (int k = 0; k < codePages.length && !found; ++k) {
                char[] codePage = codePages[k];
                for (int j = 128; j < 256 && !found; ++j) {
                    if (codePage[j] != ch) continue;
                    if (codePage != currentCodePage) {
                        byteArrayStream.write(94);
                        byteArrayStream.write((byte)codePage[0]);
                        currentCodePage = codePage;
                    }
                    byteArrayStream.write((byte)j);
                    found = true;
                }
            }
            if (found) continue;
            log.warn((Object)("Cannot Encode character '" + ch + "'"));
        }
        return byteArrayStream.toByteArray();
    }

    static {
        Encoding.codePageCentralEuropeToUnicode[0] = 69;
        Encoding.codePageCentralEuropeToUnicode[128] = 8364;
        Encoding.codePageCentralEuropeToUnicode[130] = 8218;
        Encoding.codePageCentralEuropeToUnicode[132] = 8222;
        Encoding.codePageCentralEuropeToUnicode[133] = 8230;
        Encoding.codePageCentralEuropeToUnicode[134] = 8224;
        Encoding.codePageCentralEuropeToUnicode[135] = 8225;
        Encoding.codePageCentralEuropeToUnicode[137] = 8240;
        Encoding.codePageCentralEuropeToUnicode[138] = 352;
        Encoding.codePageCentralEuropeToUnicode[139] = 8249;
        Encoding.codePageCentralEuropeToUnicode[140] = 346;
        Encoding.codePageCentralEuropeToUnicode[141] = 356;
        Encoding.codePageCentralEuropeToUnicode[142] = 381;
        Encoding.codePageCentralEuropeToUnicode[143] = 377;
        Encoding.codePageCentralEuropeToUnicode[145] = 8216;
        Encoding.codePageCentralEuropeToUnicode[146] = 8217;
        Encoding.codePageCentralEuropeToUnicode[147] = 8220;
        Encoding.codePageCentralEuropeToUnicode[148] = 8221;
        Encoding.codePageCentralEuropeToUnicode[149] = 8226;
        Encoding.codePageCentralEuropeToUnicode[150] = 8211;
        Encoding.codePageCentralEuropeToUnicode[151] = 8212;
        Encoding.codePageCentralEuropeToUnicode[153] = 8482;
        Encoding.codePageCentralEuropeToUnicode[154] = 353;
        Encoding.codePageCentralEuropeToUnicode[155] = 8250;
        Encoding.codePageCentralEuropeToUnicode[156] = 347;
        Encoding.codePageCentralEuropeToUnicode[157] = 357;
        Encoding.codePageCentralEuropeToUnicode[158] = 382;
        Encoding.codePageCentralEuropeToUnicode[159] = 378;
        Encoding.codePageCentralEuropeToUnicode[160] = 160;
        Encoding.codePageCentralEuropeToUnicode[161] = 711;
        Encoding.codePageCentralEuropeToUnicode[162] = 728;
        Encoding.codePageCentralEuropeToUnicode[163] = 321;
        Encoding.codePageCentralEuropeToUnicode[164] = 164;
        Encoding.codePageCentralEuropeToUnicode[165] = 260;
        Encoding.codePageCentralEuropeToUnicode[166] = 166;
        Encoding.codePageCentralEuropeToUnicode[167] = 167;
        Encoding.codePageCentralEuropeToUnicode[168] = 168;
        Encoding.codePageCentralEuropeToUnicode[169] = 169;
        Encoding.codePageCentralEuropeToUnicode[170] = 350;
        Encoding.codePageCentralEuropeToUnicode[171] = 171;
        Encoding.codePageCentralEuropeToUnicode[172] = 172;
        Encoding.codePageCentralEuropeToUnicode[173] = 173;
        Encoding.codePageCentralEuropeToUnicode[174] = 174;
        Encoding.codePageCentralEuropeToUnicode[175] = 379;
        Encoding.codePageCentralEuropeToUnicode[176] = 176;
        Encoding.codePageCentralEuropeToUnicode[177] = 177;
        Encoding.codePageCentralEuropeToUnicode[178] = 731;
        Encoding.codePageCentralEuropeToUnicode[179] = 322;
        Encoding.codePageCentralEuropeToUnicode[180] = 180;
        Encoding.codePageCentralEuropeToUnicode[181] = 181;
        Encoding.codePageCentralEuropeToUnicode[182] = 182;
        Encoding.codePageCentralEuropeToUnicode[183] = 183;
        Encoding.codePageCentralEuropeToUnicode[184] = 184;
        Encoding.codePageCentralEuropeToUnicode[185] = 261;
        Encoding.codePageCentralEuropeToUnicode[186] = 351;
        Encoding.codePageCentralEuropeToUnicode[187] = 187;
        Encoding.codePageCentralEuropeToUnicode[188] = 317;
        Encoding.codePageCentralEuropeToUnicode[189] = 733;
        Encoding.codePageCentralEuropeToUnicode[190] = 318;
        Encoding.codePageCentralEuropeToUnicode[191] = 380;
        Encoding.codePageCentralEuropeToUnicode[192] = 340;
        Encoding.codePageCentralEuropeToUnicode[193] = 193;
        Encoding.codePageCentralEuropeToUnicode[194] = 194;
        Encoding.codePageCentralEuropeToUnicode[195] = 258;
        Encoding.codePageCentralEuropeToUnicode[196] = 196;
        Encoding.codePageCentralEuropeToUnicode[197] = 313;
        Encoding.codePageCentralEuropeToUnicode[198] = 262;
        Encoding.codePageCentralEuropeToUnicode[199] = 199;
        Encoding.codePageCentralEuropeToUnicode[200] = 268;
        Encoding.codePageCentralEuropeToUnicode[201] = 201;
        Encoding.codePageCentralEuropeToUnicode[202] = 280;
        Encoding.codePageCentralEuropeToUnicode[203] = 203;
        Encoding.codePageCentralEuropeToUnicode[204] = 282;
        Encoding.codePageCentralEuropeToUnicode[205] = 205;
        Encoding.codePageCentralEuropeToUnicode[206] = 206;
        Encoding.codePageCentralEuropeToUnicode[207] = 270;
        Encoding.codePageCentralEuropeToUnicode[208] = 272;
        Encoding.codePageCentralEuropeToUnicode[209] = 323;
        Encoding.codePageCentralEuropeToUnicode[210] = 327;
        Encoding.codePageCentralEuropeToUnicode[211] = 211;
        Encoding.codePageCentralEuropeToUnicode[212] = 212;
        Encoding.codePageCentralEuropeToUnicode[213] = 336;
        Encoding.codePageCentralEuropeToUnicode[214] = 214;
        Encoding.codePageCentralEuropeToUnicode[215] = 215;
        Encoding.codePageCentralEuropeToUnicode[216] = 344;
        Encoding.codePageCentralEuropeToUnicode[217] = 366;
        Encoding.codePageCentralEuropeToUnicode[218] = 218;
        Encoding.codePageCentralEuropeToUnicode[219] = 368;
        Encoding.codePageCentralEuropeToUnicode[220] = 220;
        Encoding.codePageCentralEuropeToUnicode[221] = 221;
        Encoding.codePageCentralEuropeToUnicode[222] = 354;
        Encoding.codePageCentralEuropeToUnicode[223] = 223;
        Encoding.codePageCentralEuropeToUnicode[224] = 341;
        Encoding.codePageCentralEuropeToUnicode[225] = 225;
        Encoding.codePageCentralEuropeToUnicode[226] = 226;
        Encoding.codePageCentralEuropeToUnicode[227] = 259;
        Encoding.codePageCentralEuropeToUnicode[228] = 228;
        Encoding.codePageCentralEuropeToUnicode[229] = 314;
        Encoding.codePageCentralEuropeToUnicode[230] = 263;
        Encoding.codePageCentralEuropeToUnicode[231] = 231;
        Encoding.codePageCentralEuropeToUnicode[232] = 269;
        Encoding.codePageCentralEuropeToUnicode[233] = 233;
        Encoding.codePageCentralEuropeToUnicode[234] = 281;
        Encoding.codePageCentralEuropeToUnicode[235] = 235;
        Encoding.codePageCentralEuropeToUnicode[236] = 283;
        Encoding.codePageCentralEuropeToUnicode[237] = 237;
        Encoding.codePageCentralEuropeToUnicode[238] = 238;
        Encoding.codePageCentralEuropeToUnicode[239] = 271;
        Encoding.codePageCentralEuropeToUnicode[240] = 273;
        Encoding.codePageCentralEuropeToUnicode[241] = 324;
        Encoding.codePageCentralEuropeToUnicode[242] = 328;
        Encoding.codePageCentralEuropeToUnicode[243] = 243;
        Encoding.codePageCentralEuropeToUnicode[244] = 244;
        Encoding.codePageCentralEuropeToUnicode[245] = 337;
        Encoding.codePageCentralEuropeToUnicode[246] = 246;
        Encoding.codePageCentralEuropeToUnicode[247] = 247;
        Encoding.codePageCentralEuropeToUnicode[248] = 345;
        Encoding.codePageCentralEuropeToUnicode[249] = 367;
        Encoding.codePageCentralEuropeToUnicode[250] = 250;
        Encoding.codePageCentralEuropeToUnicode[251] = 369;
        Encoding.codePageCentralEuropeToUnicode[252] = 252;
        Encoding.codePageCentralEuropeToUnicode[253] = 253;
        Encoding.codePageCentralEuropeToUnicode[254] = 355;
        Encoding.codePageCentralEuropeToUnicode[255] = 729;
        Encoding.codePageCyrillicToUnicode[0] = 67;
        Encoding.codePageCyrillicToUnicode[128] = 1026;
        Encoding.codePageCyrillicToUnicode[129] = 1027;
        Encoding.codePageCyrillicToUnicode[130] = 8218;
        Encoding.codePageCyrillicToUnicode[131] = 1107;
        Encoding.codePageCyrillicToUnicode[132] = 8222;
        Encoding.codePageCyrillicToUnicode[133] = 8230;
        Encoding.codePageCyrillicToUnicode[134] = 8224;
        Encoding.codePageCyrillicToUnicode[135] = 8225;
        Encoding.codePageCyrillicToUnicode[136] = 8364;
        Encoding.codePageCyrillicToUnicode[137] = 8240;
        Encoding.codePageCyrillicToUnicode[138] = 1033;
        Encoding.codePageCyrillicToUnicode[139] = 8249;
        Encoding.codePageCyrillicToUnicode[140] = 1034;
        Encoding.codePageCyrillicToUnicode[141] = 1036;
        Encoding.codePageCyrillicToUnicode[142] = 1035;
        Encoding.codePageCyrillicToUnicode[143] = 1039;
        Encoding.codePageCyrillicToUnicode[144] = 1106;
        Encoding.codePageCyrillicToUnicode[145] = 8216;
        Encoding.codePageCyrillicToUnicode[146] = 8217;
        Encoding.codePageCyrillicToUnicode[147] = 8220;
        Encoding.codePageCyrillicToUnicode[148] = 8221;
        Encoding.codePageCyrillicToUnicode[149] = 8226;
        Encoding.codePageCyrillicToUnicode[150] = 8211;
        Encoding.codePageCyrillicToUnicode[151] = 8212;
        Encoding.codePageCyrillicToUnicode[153] = 8482;
        Encoding.codePageCyrillicToUnicode[154] = 1113;
        Encoding.codePageCyrillicToUnicode[155] = 8250;
        Encoding.codePageCyrillicToUnicode[156] = 1114;
        Encoding.codePageCyrillicToUnicode[157] = 1116;
        Encoding.codePageCyrillicToUnicode[158] = 1115;
        Encoding.codePageCyrillicToUnicode[159] = 1119;
        Encoding.codePageCyrillicToUnicode[160] = 160;
        Encoding.codePageCyrillicToUnicode[161] = 1038;
        Encoding.codePageCyrillicToUnicode[162] = 1118;
        Encoding.codePageCyrillicToUnicode[163] = 1032;
        Encoding.codePageCyrillicToUnicode[164] = 164;
        Encoding.codePageCyrillicToUnicode[165] = 1168;
        Encoding.codePageCyrillicToUnicode[166] = 166;
        Encoding.codePageCyrillicToUnicode[167] = 167;
        Encoding.codePageCyrillicToUnicode[168] = 1025;
        Encoding.codePageCyrillicToUnicode[169] = 169;
        Encoding.codePageCyrillicToUnicode[170] = 1028;
        Encoding.codePageCyrillicToUnicode[171] = 171;
        Encoding.codePageCyrillicToUnicode[172] = 172;
        Encoding.codePageCyrillicToUnicode[173] = 173;
        Encoding.codePageCyrillicToUnicode[174] = 174;
        Encoding.codePageCyrillicToUnicode[175] = 1031;
        Encoding.codePageCyrillicToUnicode[176] = 176;
        Encoding.codePageCyrillicToUnicode[177] = 177;
        Encoding.codePageCyrillicToUnicode[178] = 1030;
        Encoding.codePageCyrillicToUnicode[179] = 1110;
        Encoding.codePageCyrillicToUnicode[180] = 1169;
        Encoding.codePageCyrillicToUnicode[181] = 181;
        Encoding.codePageCyrillicToUnicode[182] = 182;
        Encoding.codePageCyrillicToUnicode[183] = 183;
        Encoding.codePageCyrillicToUnicode[184] = 1105;
        Encoding.codePageCyrillicToUnicode[185] = 8470;
        Encoding.codePageCyrillicToUnicode[186] = 1108;
        Encoding.codePageCyrillicToUnicode[187] = 187;
        Encoding.codePageCyrillicToUnicode[188] = 1112;
        Encoding.codePageCyrillicToUnicode[189] = 1029;
        Encoding.codePageCyrillicToUnicode[190] = 1109;
        Encoding.codePageCyrillicToUnicode[191] = 1111;
        Encoding.codePageCyrillicToUnicode[192] = 1040;
        Encoding.codePageCyrillicToUnicode[193] = 1041;
        Encoding.codePageCyrillicToUnicode[194] = 1042;
        Encoding.codePageCyrillicToUnicode[195] = 1043;
        Encoding.codePageCyrillicToUnicode[196] = 1044;
        Encoding.codePageCyrillicToUnicode[197] = 1045;
        Encoding.codePageCyrillicToUnicode[198] = 1046;
        Encoding.codePageCyrillicToUnicode[199] = 1047;
        Encoding.codePageCyrillicToUnicode[200] = 1048;
        Encoding.codePageCyrillicToUnicode[201] = 1049;
        Encoding.codePageCyrillicToUnicode[202] = 1050;
        Encoding.codePageCyrillicToUnicode[203] = 1051;
        Encoding.codePageCyrillicToUnicode[204] = 1052;
        Encoding.codePageCyrillicToUnicode[205] = 1053;
        Encoding.codePageCyrillicToUnicode[206] = 1054;
        Encoding.codePageCyrillicToUnicode[207] = 1055;
        Encoding.codePageCyrillicToUnicode[208] = 1056;
        Encoding.codePageCyrillicToUnicode[209] = 1057;
        Encoding.codePageCyrillicToUnicode[210] = 1058;
        Encoding.codePageCyrillicToUnicode[211] = 1059;
        Encoding.codePageCyrillicToUnicode[212] = 1060;
        Encoding.codePageCyrillicToUnicode[213] = 1061;
        Encoding.codePageCyrillicToUnicode[214] = 1062;
        Encoding.codePageCyrillicToUnicode[215] = 1063;
        Encoding.codePageCyrillicToUnicode[216] = 1064;
        Encoding.codePageCyrillicToUnicode[217] = 1065;
        Encoding.codePageCyrillicToUnicode[218] = 1066;
        Encoding.codePageCyrillicToUnicode[219] = 1067;
        Encoding.codePageCyrillicToUnicode[220] = 1068;
        Encoding.codePageCyrillicToUnicode[221] = 1069;
        Encoding.codePageCyrillicToUnicode[222] = 1070;
        Encoding.codePageCyrillicToUnicode[223] = 1071;
        Encoding.codePageCyrillicToUnicode[224] = 1072;
        Encoding.codePageCyrillicToUnicode[225] = 1073;
        Encoding.codePageCyrillicToUnicode[226] = 1074;
        Encoding.codePageCyrillicToUnicode[227] = 1075;
        Encoding.codePageCyrillicToUnicode[228] = 1076;
        Encoding.codePageCyrillicToUnicode[229] = 1077;
        Encoding.codePageCyrillicToUnicode[230] = 1078;
        Encoding.codePageCyrillicToUnicode[231] = 1079;
        Encoding.codePageCyrillicToUnicode[232] = 1080;
        Encoding.codePageCyrillicToUnicode[233] = 1081;
        Encoding.codePageCyrillicToUnicode[234] = 1082;
        Encoding.codePageCyrillicToUnicode[235] = 1083;
        Encoding.codePageCyrillicToUnicode[236] = 1084;
        Encoding.codePageCyrillicToUnicode[237] = 1085;
        Encoding.codePageCyrillicToUnicode[238] = 1086;
        Encoding.codePageCyrillicToUnicode[239] = 1087;
        Encoding.codePageCyrillicToUnicode[240] = 1088;
        Encoding.codePageCyrillicToUnicode[241] = 1089;
        Encoding.codePageCyrillicToUnicode[242] = 1090;
        Encoding.codePageCyrillicToUnicode[243] = 1091;
        Encoding.codePageCyrillicToUnicode[244] = 1092;
        Encoding.codePageCyrillicToUnicode[245] = 1093;
        Encoding.codePageCyrillicToUnicode[246] = 1094;
        Encoding.codePageCyrillicToUnicode[247] = 1095;
        Encoding.codePageCyrillicToUnicode[248] = 1096;
        Encoding.codePageCyrillicToUnicode[249] = 1097;
        Encoding.codePageCyrillicToUnicode[250] = 1098;
        Encoding.codePageCyrillicToUnicode[251] = 1099;
        Encoding.codePageCyrillicToUnicode[252] = 1100;
        Encoding.codePageCyrillicToUnicode[253] = 1101;
        Encoding.codePageCyrillicToUnicode[254] = 1102;
        Encoding.codePageCyrillicToUnicode[255] = 1103;
        Encoding.codePageLatinToUnicode[0] = 76;
        Encoding.codePageLatinToUnicode[128] = 8364;
        Encoding.codePageLatinToUnicode[130] = 8218;
        Encoding.codePageLatinToUnicode[131] = 402;
        Encoding.codePageLatinToUnicode[132] = 8222;
        Encoding.codePageLatinToUnicode[133] = 8230;
        Encoding.codePageLatinToUnicode[134] = 8224;
        Encoding.codePageLatinToUnicode[135] = 8225;
        Encoding.codePageLatinToUnicode[136] = 710;
        Encoding.codePageLatinToUnicode[137] = 8240;
        Encoding.codePageLatinToUnicode[138] = 352;
        Encoding.codePageLatinToUnicode[139] = 8249;
        Encoding.codePageLatinToUnicode[140] = 338;
        Encoding.codePageLatinToUnicode[142] = 381;
        Encoding.codePageLatinToUnicode[145] = 8216;
        Encoding.codePageLatinToUnicode[146] = 8217;
        Encoding.codePageLatinToUnicode[147] = 8220;
        Encoding.codePageLatinToUnicode[148] = 8221;
        Encoding.codePageLatinToUnicode[149] = 8226;
        Encoding.codePageLatinToUnicode[150] = 8211;
        Encoding.codePageLatinToUnicode[151] = 8212;
        Encoding.codePageLatinToUnicode[152] = 732;
        Encoding.codePageLatinToUnicode[153] = 8482;
        Encoding.codePageLatinToUnicode[154] = 353;
        Encoding.codePageLatinToUnicode[155] = 8250;
        Encoding.codePageLatinToUnicode[156] = 339;
        Encoding.codePageLatinToUnicode[158] = 382;
        Encoding.codePageLatinToUnicode[159] = 376;
        Encoding.codePageLatinToUnicode[160] = 160;
        Encoding.codePageLatinToUnicode[161] = 161;
        Encoding.codePageLatinToUnicode[162] = 162;
        Encoding.codePageLatinToUnicode[163] = 163;
        Encoding.codePageLatinToUnicode[164] = 164;
        Encoding.codePageLatinToUnicode[165] = 165;
        Encoding.codePageLatinToUnicode[166] = 166;
        Encoding.codePageLatinToUnicode[167] = 167;
        Encoding.codePageLatinToUnicode[168] = 168;
        Encoding.codePageLatinToUnicode[169] = 169;
        Encoding.codePageLatinToUnicode[170] = 170;
        Encoding.codePageLatinToUnicode[171] = 171;
        Encoding.codePageLatinToUnicode[172] = 172;
        Encoding.codePageLatinToUnicode[173] = 173;
        Encoding.codePageLatinToUnicode[174] = 174;
        Encoding.codePageLatinToUnicode[175] = 175;
        Encoding.codePageLatinToUnicode[176] = 176;
        Encoding.codePageLatinToUnicode[177] = 177;
        Encoding.codePageLatinToUnicode[178] = 178;
        Encoding.codePageLatinToUnicode[179] = 179;
        Encoding.codePageLatinToUnicode[180] = 180;
        Encoding.codePageLatinToUnicode[181] = 181;
        Encoding.codePageLatinToUnicode[182] = 182;
        Encoding.codePageLatinToUnicode[183] = 183;
        Encoding.codePageLatinToUnicode[184] = 184;
        Encoding.codePageLatinToUnicode[185] = 185;
        Encoding.codePageLatinToUnicode[186] = 186;
        Encoding.codePageLatinToUnicode[187] = 187;
        Encoding.codePageLatinToUnicode[188] = 188;
        Encoding.codePageLatinToUnicode[189] = 189;
        Encoding.codePageLatinToUnicode[190] = 190;
        Encoding.codePageLatinToUnicode[191] = 191;
        Encoding.codePageLatinToUnicode[192] = 192;
        Encoding.codePageLatinToUnicode[193] = 193;
        Encoding.codePageLatinToUnicode[194] = 194;
        Encoding.codePageLatinToUnicode[195] = 195;
        Encoding.codePageLatinToUnicode[196] = 196;
        Encoding.codePageLatinToUnicode[197] = 197;
        Encoding.codePageLatinToUnicode[198] = 198;
        Encoding.codePageLatinToUnicode[199] = 199;
        Encoding.codePageLatinToUnicode[200] = 200;
        Encoding.codePageLatinToUnicode[201] = 201;
        Encoding.codePageLatinToUnicode[202] = 202;
        Encoding.codePageLatinToUnicode[203] = 203;
        Encoding.codePageLatinToUnicode[204] = 204;
        Encoding.codePageLatinToUnicode[205] = 205;
        Encoding.codePageLatinToUnicode[206] = 206;
        Encoding.codePageLatinToUnicode[207] = 207;
        Encoding.codePageLatinToUnicode[208] = 208;
        Encoding.codePageLatinToUnicode[209] = 209;
        Encoding.codePageLatinToUnicode[210] = 210;
        Encoding.codePageLatinToUnicode[211] = 211;
        Encoding.codePageLatinToUnicode[212] = 212;
        Encoding.codePageLatinToUnicode[213] = 213;
        Encoding.codePageLatinToUnicode[214] = 214;
        Encoding.codePageLatinToUnicode[215] = 215;
        Encoding.codePageLatinToUnicode[216] = 216;
        Encoding.codePageLatinToUnicode[217] = 217;
        Encoding.codePageLatinToUnicode[218] = 218;
        Encoding.codePageLatinToUnicode[219] = 219;
        Encoding.codePageLatinToUnicode[220] = 220;
        Encoding.codePageLatinToUnicode[221] = 221;
        Encoding.codePageLatinToUnicode[222] = 222;
        Encoding.codePageLatinToUnicode[223] = 223;
        Encoding.codePageLatinToUnicode[224] = 224;
        Encoding.codePageLatinToUnicode[225] = 225;
        Encoding.codePageLatinToUnicode[226] = 226;
        Encoding.codePageLatinToUnicode[227] = 227;
        Encoding.codePageLatinToUnicode[228] = 228;
        Encoding.codePageLatinToUnicode[229] = 229;
        Encoding.codePageLatinToUnicode[230] = 230;
        Encoding.codePageLatinToUnicode[231] = 231;
        Encoding.codePageLatinToUnicode[232] = 232;
        Encoding.codePageLatinToUnicode[233] = 233;
        Encoding.codePageLatinToUnicode[234] = 234;
        Encoding.codePageLatinToUnicode[235] = 235;
        Encoding.codePageLatinToUnicode[236] = 236;
        Encoding.codePageLatinToUnicode[237] = 237;
        Encoding.codePageLatinToUnicode[238] = 238;
        Encoding.codePageLatinToUnicode[239] = 239;
        Encoding.codePageLatinToUnicode[240] = 240;
        Encoding.codePageLatinToUnicode[241] = 241;
        Encoding.codePageLatinToUnicode[242] = 242;
        Encoding.codePageLatinToUnicode[243] = 243;
        Encoding.codePageLatinToUnicode[244] = 244;
        Encoding.codePageLatinToUnicode[245] = 245;
        Encoding.codePageLatinToUnicode[246] = 246;
        Encoding.codePageLatinToUnicode[247] = 247;
        Encoding.codePageLatinToUnicode[248] = 248;
        Encoding.codePageLatinToUnicode[249] = 249;
        Encoding.codePageLatinToUnicode[250] = 250;
        Encoding.codePageLatinToUnicode[251] = 251;
        Encoding.codePageLatinToUnicode[252] = 252;
        Encoding.codePageLatinToUnicode[253] = 253;
        Encoding.codePageLatinToUnicode[254] = 254;
        Encoding.codePageLatinToUnicode[255] = 255;
        Encoding.codePageGreekToUnicode[0] = 71;
        Encoding.codePageGreekToUnicode[128] = 8364;
        Encoding.codePageGreekToUnicode[130] = 8218;
        Encoding.codePageGreekToUnicode[131] = 402;
        Encoding.codePageGreekToUnicode[132] = 8222;
        Encoding.codePageGreekToUnicode[133] = 8230;
        Encoding.codePageGreekToUnicode[134] = 8224;
        Encoding.codePageGreekToUnicode[135] = 8225;
        Encoding.codePageGreekToUnicode[137] = 8240;
        Encoding.codePageGreekToUnicode[139] = 8249;
        Encoding.codePageGreekToUnicode[145] = 8216;
        Encoding.codePageGreekToUnicode[146] = 8217;
        Encoding.codePageGreekToUnicode[147] = 8220;
        Encoding.codePageGreekToUnicode[148] = 8221;
        Encoding.codePageGreekToUnicode[149] = 8226;
        Encoding.codePageGreekToUnicode[150] = 8211;
        Encoding.codePageGreekToUnicode[151] = 8212;
        Encoding.codePageGreekToUnicode[153] = 8482;
        Encoding.codePageGreekToUnicode[155] = 8250;
        Encoding.codePageGreekToUnicode[160] = 160;
        Encoding.codePageGreekToUnicode[161] = 901;
        Encoding.codePageGreekToUnicode[162] = 902;
        Encoding.codePageGreekToUnicode[163] = 163;
        Encoding.codePageGreekToUnicode[164] = 164;
        Encoding.codePageGreekToUnicode[165] = 165;
        Encoding.codePageGreekToUnicode[166] = 166;
        Encoding.codePageGreekToUnicode[167] = 167;
        Encoding.codePageGreekToUnicode[168] = 168;
        Encoding.codePageGreekToUnicode[169] = 169;
        Encoding.codePageGreekToUnicode[171] = 171;
        Encoding.codePageGreekToUnicode[172] = 172;
        Encoding.codePageGreekToUnicode[173] = 173;
        Encoding.codePageGreekToUnicode[174] = 174;
        Encoding.codePageGreekToUnicode[175] = 8213;
        Encoding.codePageGreekToUnicode[176] = 176;
        Encoding.codePageGreekToUnicode[177] = 177;
        Encoding.codePageGreekToUnicode[178] = 178;
        Encoding.codePageGreekToUnicode[179] = 179;
        Encoding.codePageGreekToUnicode[180] = 900;
        Encoding.codePageGreekToUnicode[181] = 181;
        Encoding.codePageGreekToUnicode[182] = 182;
        Encoding.codePageGreekToUnicode[183] = 183;
        Encoding.codePageGreekToUnicode[184] = 904;
        Encoding.codePageGreekToUnicode[185] = 905;
        Encoding.codePageGreekToUnicode[186] = 906;
        Encoding.codePageGreekToUnicode[187] = 187;
        Encoding.codePageGreekToUnicode[188] = 908;
        Encoding.codePageGreekToUnicode[189] = 189;
        Encoding.codePageGreekToUnicode[190] = 910;
        Encoding.codePageGreekToUnicode[191] = 911;
        Encoding.codePageGreekToUnicode[192] = 912;
        Encoding.codePageGreekToUnicode[193] = 913;
        Encoding.codePageGreekToUnicode[194] = 914;
        Encoding.codePageGreekToUnicode[195] = 915;
        Encoding.codePageGreekToUnicode[196] = 916;
        Encoding.codePageGreekToUnicode[197] = 917;
        Encoding.codePageGreekToUnicode[198] = 918;
        Encoding.codePageGreekToUnicode[199] = 919;
        Encoding.codePageGreekToUnicode[200] = 920;
        Encoding.codePageGreekToUnicode[201] = 921;
        Encoding.codePageGreekToUnicode[202] = 922;
        Encoding.codePageGreekToUnicode[203] = 923;
        Encoding.codePageGreekToUnicode[204] = 924;
        Encoding.codePageGreekToUnicode[205] = 925;
        Encoding.codePageGreekToUnicode[206] = 926;
        Encoding.codePageGreekToUnicode[207] = 927;
        Encoding.codePageGreekToUnicode[208] = 928;
        Encoding.codePageGreekToUnicode[209] = 929;
        Encoding.codePageGreekToUnicode[211] = 931;
        Encoding.codePageGreekToUnicode[212] = 932;
        Encoding.codePageGreekToUnicode[213] = 933;
        Encoding.codePageGreekToUnicode[214] = 934;
        Encoding.codePageGreekToUnicode[215] = 935;
        Encoding.codePageGreekToUnicode[216] = 936;
        Encoding.codePageGreekToUnicode[217] = 937;
        Encoding.codePageGreekToUnicode[218] = 938;
        Encoding.codePageGreekToUnicode[219] = 939;
        Encoding.codePageGreekToUnicode[220] = 940;
        Encoding.codePageGreekToUnicode[221] = 941;
        Encoding.codePageGreekToUnicode[222] = 942;
        Encoding.codePageGreekToUnicode[223] = 943;
        Encoding.codePageGreekToUnicode[224] = 944;
        Encoding.codePageGreekToUnicode[225] = 945;
        Encoding.codePageGreekToUnicode[226] = 946;
        Encoding.codePageGreekToUnicode[227] = 947;
        Encoding.codePageGreekToUnicode[228] = 948;
        Encoding.codePageGreekToUnicode[229] = 949;
        Encoding.codePageGreekToUnicode[230] = 950;
        Encoding.codePageGreekToUnicode[231] = 951;
        Encoding.codePageGreekToUnicode[232] = 952;
        Encoding.codePageGreekToUnicode[233] = 953;
        Encoding.codePageGreekToUnicode[234] = 954;
        Encoding.codePageGreekToUnicode[235] = 955;
        Encoding.codePageGreekToUnicode[236] = 956;
        Encoding.codePageGreekToUnicode[237] = 957;
        Encoding.codePageGreekToUnicode[238] = 958;
        Encoding.codePageGreekToUnicode[239] = 959;
        Encoding.codePageGreekToUnicode[240] = 960;
        Encoding.codePageGreekToUnicode[241] = 961;
        Encoding.codePageGreekToUnicode[242] = 962;
        Encoding.codePageGreekToUnicode[243] = 963;
        Encoding.codePageGreekToUnicode[244] = 964;
        Encoding.codePageGreekToUnicode[245] = 965;
        Encoding.codePageGreekToUnicode[246] = 966;
        Encoding.codePageGreekToUnicode[247] = 967;
        Encoding.codePageGreekToUnicode[248] = 968;
        Encoding.codePageGreekToUnicode[249] = 969;
        Encoding.codePageGreekToUnicode[250] = 970;
        Encoding.codePageGreekToUnicode[251] = 971;
        Encoding.codePageGreekToUnicode[252] = 972;
        Encoding.codePageGreekToUnicode[253] = 973;
        Encoding.codePageGreekToUnicode[254] = 974;
        Encoding.codePageTurkishToUnicode[0] = 84;
        Encoding.codePageTurkishToUnicode[128] = 8364;
        Encoding.codePageTurkishToUnicode[130] = 8218;
        Encoding.codePageTurkishToUnicode[131] = 402;
        Encoding.codePageTurkishToUnicode[132] = 8222;
        Encoding.codePageTurkishToUnicode[133] = 8230;
        Encoding.codePageTurkishToUnicode[134] = 8224;
        Encoding.codePageTurkishToUnicode[135] = 8225;
        Encoding.codePageTurkishToUnicode[136] = 710;
        Encoding.codePageTurkishToUnicode[137] = 8240;
        Encoding.codePageTurkishToUnicode[138] = 352;
        Encoding.codePageTurkishToUnicode[139] = 8249;
        Encoding.codePageTurkishToUnicode[140] = 338;
        Encoding.codePageTurkishToUnicode[145] = 8216;
        Encoding.codePageTurkishToUnicode[146] = 8217;
        Encoding.codePageTurkishToUnicode[147] = 8220;
        Encoding.codePageTurkishToUnicode[148] = 8221;
        Encoding.codePageTurkishToUnicode[149] = 8226;
        Encoding.codePageTurkishToUnicode[150] = 8211;
        Encoding.codePageTurkishToUnicode[151] = 8212;
        Encoding.codePageTurkishToUnicode[152] = 732;
        Encoding.codePageTurkishToUnicode[153] = 8482;
        Encoding.codePageTurkishToUnicode[154] = 353;
        Encoding.codePageTurkishToUnicode[155] = 8250;
        Encoding.codePageTurkishToUnicode[156] = 339;
        Encoding.codePageTurkishToUnicode[159] = 376;
        Encoding.codePageTurkishToUnicode[160] = 160;
        Encoding.codePageTurkishToUnicode[161] = 161;
        Encoding.codePageTurkishToUnicode[162] = 162;
        Encoding.codePageTurkishToUnicode[163] = 163;
        Encoding.codePageTurkishToUnicode[164] = 164;
        Encoding.codePageTurkishToUnicode[165] = 165;
        Encoding.codePageTurkishToUnicode[166] = 166;
        Encoding.codePageTurkishToUnicode[167] = 167;
        Encoding.codePageTurkishToUnicode[168] = 168;
        Encoding.codePageTurkishToUnicode[169] = 169;
        Encoding.codePageTurkishToUnicode[170] = 170;
        Encoding.codePageTurkishToUnicode[171] = 171;
        Encoding.codePageTurkishToUnicode[172] = 172;
        Encoding.codePageTurkishToUnicode[173] = 173;
        Encoding.codePageTurkishToUnicode[174] = 174;
        Encoding.codePageTurkishToUnicode[175] = 175;
        Encoding.codePageTurkishToUnicode[176] = 176;
        Encoding.codePageTurkishToUnicode[177] = 177;
        Encoding.codePageTurkishToUnicode[178] = 178;
        Encoding.codePageTurkishToUnicode[179] = 179;
        Encoding.codePageTurkishToUnicode[180] = 180;
        Encoding.codePageTurkishToUnicode[181] = 181;
        Encoding.codePageTurkishToUnicode[182] = 182;
        Encoding.codePageTurkishToUnicode[183] = 183;
        Encoding.codePageTurkishToUnicode[184] = 184;
        Encoding.codePageTurkishToUnicode[185] = 185;
        Encoding.codePageTurkishToUnicode[186] = 186;
        Encoding.codePageTurkishToUnicode[187] = 187;
        Encoding.codePageTurkishToUnicode[188] = 188;
        Encoding.codePageTurkishToUnicode[189] = 189;
        Encoding.codePageTurkishToUnicode[190] = 190;
        Encoding.codePageTurkishToUnicode[191] = 191;
        Encoding.codePageTurkishToUnicode[192] = 192;
        Encoding.codePageTurkishToUnicode[193] = 193;
        Encoding.codePageTurkishToUnicode[194] = 194;
        Encoding.codePageTurkishToUnicode[195] = 195;
        Encoding.codePageTurkishToUnicode[196] = 196;
        Encoding.codePageTurkishToUnicode[197] = 197;
        Encoding.codePageTurkishToUnicode[198] = 198;
        Encoding.codePageTurkishToUnicode[199] = 199;
        Encoding.codePageTurkishToUnicode[200] = 200;
        Encoding.codePageTurkishToUnicode[201] = 201;
        Encoding.codePageTurkishToUnicode[202] = 202;
        Encoding.codePageTurkishToUnicode[203] = 203;
        Encoding.codePageTurkishToUnicode[204] = 204;
        Encoding.codePageTurkishToUnicode[205] = 205;
        Encoding.codePageTurkishToUnicode[206] = 206;
        Encoding.codePageTurkishToUnicode[207] = 207;
        Encoding.codePageTurkishToUnicode[208] = 286;
        Encoding.codePageTurkishToUnicode[209] = 209;
        Encoding.codePageTurkishToUnicode[210] = 210;
        Encoding.codePageTurkishToUnicode[211] = 211;
        Encoding.codePageTurkishToUnicode[212] = 212;
        Encoding.codePageTurkishToUnicode[213] = 213;
        Encoding.codePageTurkishToUnicode[214] = 214;
        Encoding.codePageTurkishToUnicode[215] = 215;
        Encoding.codePageTurkishToUnicode[216] = 216;
        Encoding.codePageTurkishToUnicode[217] = 217;
        Encoding.codePageTurkishToUnicode[218] = 218;
        Encoding.codePageTurkishToUnicode[219] = 219;
        Encoding.codePageTurkishToUnicode[220] = 220;
        Encoding.codePageTurkishToUnicode[221] = 304;
        Encoding.codePageTurkishToUnicode[222] = 350;
        Encoding.codePageTurkishToUnicode[223] = 223;
        Encoding.codePageTurkishToUnicode[224] = 224;
        Encoding.codePageTurkishToUnicode[225] = 225;
        Encoding.codePageTurkishToUnicode[226] = 226;
        Encoding.codePageTurkishToUnicode[227] = 227;
        Encoding.codePageTurkishToUnicode[228] = 228;
        Encoding.codePageTurkishToUnicode[229] = 229;
        Encoding.codePageTurkishToUnicode[230] = 230;
        Encoding.codePageTurkishToUnicode[231] = 231;
        Encoding.codePageTurkishToUnicode[232] = 232;
        Encoding.codePageTurkishToUnicode[233] = 233;
        Encoding.codePageTurkishToUnicode[234] = 234;
        Encoding.codePageTurkishToUnicode[235] = 235;
        Encoding.codePageTurkishToUnicode[236] = 236;
        Encoding.codePageTurkishToUnicode[237] = 237;
        Encoding.codePageTurkishToUnicode[238] = 238;
        Encoding.codePageTurkishToUnicode[239] = 239;
        Encoding.codePageTurkishToUnicode[240] = 287;
        Encoding.codePageTurkishToUnicode[241] = 241;
        Encoding.codePageTurkishToUnicode[242] = 242;
        Encoding.codePageTurkishToUnicode[243] = 243;
        Encoding.codePageTurkishToUnicode[244] = 244;
        Encoding.codePageTurkishToUnicode[245] = 245;
        Encoding.codePageTurkishToUnicode[246] = 246;
        Encoding.codePageTurkishToUnicode[247] = 247;
        Encoding.codePageTurkishToUnicode[248] = 248;
        Encoding.codePageTurkishToUnicode[249] = 249;
        Encoding.codePageTurkishToUnicode[250] = 250;
        Encoding.codePageTurkishToUnicode[251] = 251;
        Encoding.codePageTurkishToUnicode[252] = 252;
        Encoding.codePageTurkishToUnicode[253] = 305;
        Encoding.codePageTurkishToUnicode[254] = 351;
        Encoding.codePageTurkishToUnicode[255] = 255;
        Encoding.codePageBalticToUnicode[0] = 66;
        Encoding.codePageBalticToUnicode[128] = 8364;
        Encoding.codePageBalticToUnicode[130] = 8218;
        Encoding.codePageBalticToUnicode[132] = 8222;
        Encoding.codePageBalticToUnicode[133] = 8230;
        Encoding.codePageBalticToUnicode[134] = 8224;
        Encoding.codePageBalticToUnicode[135] = 8225;
        Encoding.codePageBalticToUnicode[137] = 8240;
        Encoding.codePageBalticToUnicode[139] = 8249;
        Encoding.codePageBalticToUnicode[141] = 168;
        Encoding.codePageBalticToUnicode[142] = 711;
        Encoding.codePageBalticToUnicode[143] = 184;
        Encoding.codePageBalticToUnicode[145] = 8216;
        Encoding.codePageBalticToUnicode[146] = 8217;
        Encoding.codePageBalticToUnicode[147] = 8220;
        Encoding.codePageBalticToUnicode[148] = 8221;
        Encoding.codePageBalticToUnicode[149] = 8226;
        Encoding.codePageBalticToUnicode[150] = 8211;
        Encoding.codePageBalticToUnicode[151] = 8212;
        Encoding.codePageBalticToUnicode[153] = 8482;
        Encoding.codePageBalticToUnicode[155] = 8250;
        Encoding.codePageBalticToUnicode[157] = 175;
        Encoding.codePageBalticToUnicode[158] = 731;
        Encoding.codePageBalticToUnicode[160] = 160;
        Encoding.codePageBalticToUnicode[162] = 162;
        Encoding.codePageBalticToUnicode[163] = 163;
        Encoding.codePageBalticToUnicode[164] = 164;
        Encoding.codePageBalticToUnicode[166] = 166;
        Encoding.codePageBalticToUnicode[167] = 167;
        Encoding.codePageBalticToUnicode[168] = 216;
        Encoding.codePageBalticToUnicode[169] = 169;
        Encoding.codePageBalticToUnicode[170] = 342;
        Encoding.codePageBalticToUnicode[171] = 171;
        Encoding.codePageBalticToUnicode[172] = 172;
        Encoding.codePageBalticToUnicode[173] = 173;
        Encoding.codePageBalticToUnicode[174] = 174;
        Encoding.codePageBalticToUnicode[175] = 198;
        Encoding.codePageBalticToUnicode[176] = 176;
        Encoding.codePageBalticToUnicode[177] = 177;
        Encoding.codePageBalticToUnicode[178] = 178;
        Encoding.codePageBalticToUnicode[179] = 179;
        Encoding.codePageBalticToUnicode[180] = 180;
        Encoding.codePageBalticToUnicode[181] = 181;
        Encoding.codePageBalticToUnicode[182] = 182;
        Encoding.codePageBalticToUnicode[183] = 183;
        Encoding.codePageBalticToUnicode[184] = 248;
        Encoding.codePageBalticToUnicode[185] = 185;
        Encoding.codePageBalticToUnicode[186] = 343;
        Encoding.codePageBalticToUnicode[187] = 187;
        Encoding.codePageBalticToUnicode[188] = 188;
        Encoding.codePageBalticToUnicode[189] = 189;
        Encoding.codePageBalticToUnicode[190] = 190;
        Encoding.codePageBalticToUnicode[191] = 230;
        Encoding.codePageBalticToUnicode[192] = 260;
        Encoding.codePageBalticToUnicode[193] = 302;
        Encoding.codePageBalticToUnicode[194] = 256;
        Encoding.codePageBalticToUnicode[195] = 262;
        Encoding.codePageBalticToUnicode[196] = 196;
        Encoding.codePageBalticToUnicode[197] = 197;
        Encoding.codePageBalticToUnicode[198] = 280;
        Encoding.codePageBalticToUnicode[199] = 274;
        Encoding.codePageBalticToUnicode[200] = 268;
        Encoding.codePageBalticToUnicode[201] = 201;
        Encoding.codePageBalticToUnicode[202] = 377;
        Encoding.codePageBalticToUnicode[203] = 278;
        Encoding.codePageBalticToUnicode[204] = 290;
        Encoding.codePageBalticToUnicode[205] = 310;
        Encoding.codePageBalticToUnicode[206] = 298;
        Encoding.codePageBalticToUnicode[207] = 315;
        Encoding.codePageBalticToUnicode[208] = 352;
        Encoding.codePageBalticToUnicode[209] = 323;
        Encoding.codePageBalticToUnicode[210] = 325;
        Encoding.codePageBalticToUnicode[211] = 211;
        Encoding.codePageBalticToUnicode[212] = 332;
        Encoding.codePageBalticToUnicode[213] = 213;
        Encoding.codePageBalticToUnicode[214] = 214;
        Encoding.codePageBalticToUnicode[215] = 215;
        Encoding.codePageBalticToUnicode[216] = 370;
        Encoding.codePageBalticToUnicode[217] = 321;
        Encoding.codePageBalticToUnicode[218] = 346;
        Encoding.codePageBalticToUnicode[219] = 362;
        Encoding.codePageBalticToUnicode[220] = 220;
        Encoding.codePageBalticToUnicode[221] = 379;
        Encoding.codePageBalticToUnicode[222] = 381;
        Encoding.codePageBalticToUnicode[223] = 223;
        Encoding.codePageBalticToUnicode[224] = 261;
        Encoding.codePageBalticToUnicode[225] = 303;
        Encoding.codePageBalticToUnicode[226] = 257;
        Encoding.codePageBalticToUnicode[227] = 263;
        Encoding.codePageBalticToUnicode[228] = 228;
        Encoding.codePageBalticToUnicode[229] = 229;
        Encoding.codePageBalticToUnicode[230] = 281;
        Encoding.codePageBalticToUnicode[231] = 275;
        Encoding.codePageBalticToUnicode[232] = 269;
        Encoding.codePageBalticToUnicode[233] = 233;
        Encoding.codePageBalticToUnicode[234] = 378;
        Encoding.codePageBalticToUnicode[235] = 279;
        Encoding.codePageBalticToUnicode[236] = 291;
        Encoding.codePageBalticToUnicode[237] = 311;
        Encoding.codePageBalticToUnicode[238] = 299;
        Encoding.codePageBalticToUnicode[239] = 316;
        Encoding.codePageBalticToUnicode[240] = 353;
        Encoding.codePageBalticToUnicode[241] = 324;
        Encoding.codePageBalticToUnicode[242] = 326;
        Encoding.codePageBalticToUnicode[243] = 243;
        Encoding.codePageBalticToUnicode[244] = 333;
        Encoding.codePageBalticToUnicode[245] = 245;
        Encoding.codePageBalticToUnicode[246] = 246;
        Encoding.codePageBalticToUnicode[247] = 247;
        Encoding.codePageBalticToUnicode[248] = 371;
        Encoding.codePageBalticToUnicode[249] = 322;
        Encoding.codePageBalticToUnicode[250] = 347;
        Encoding.codePageBalticToUnicode[251] = 363;
        Encoding.codePageBalticToUnicode[252] = 252;
        Encoding.codePageBalticToUnicode[253] = 380;
        Encoding.codePageBalticToUnicode[254] = 382;
        Encoding.codePageBalticToUnicode[255] = 729;
        Encoding.codePageJapaneseToUnicode[0] = 74;
        Encoding.codePageJapaneseToUnicode[128] = 8364;
        Encoding.codePageJapaneseToUnicode[133] = 8230;
        Encoding.codePageJapaneseToUnicode[134] = 8224;
        Encoding.codePageJapaneseToUnicode[135] = 8225;
        Encoding.codePageJapaneseToUnicode[136] = 169;
        Encoding.codePageJapaneseToUnicode[137] = 163;
        Encoding.codePageJapaneseToUnicode[139] = 8249;
        Encoding.codePageJapaneseToUnicode[149] = 8226;
        Encoding.codePageJapaneseToUnicode[152] = 174;
        Encoding.codePageJapaneseToUnicode[153] = 8482;
        Encoding.codePageJapaneseToUnicode[154] = 127;
        Encoding.codePageJapaneseToUnicode[155] = 8250;
        Encoding.codePageJapaneseToUnicode[156] = 177;
        Encoding.codePageJapaneseToUnicode[157] = 185;
        Encoding.codePageJapaneseToUnicode[158] = 178;
        Encoding.codePageJapaneseToUnicode[159] = 179;
        Encoding.codePageJapaneseToUnicode[161] = 65377;
        Encoding.codePageJapaneseToUnicode[162] = 65378;
        Encoding.codePageJapaneseToUnicode[163] = 65379;
        Encoding.codePageJapaneseToUnicode[164] = 65380;
        Encoding.codePageJapaneseToUnicode[165] = 65381;
        Encoding.codePageJapaneseToUnicode[166] = 65382;
        Encoding.codePageJapaneseToUnicode[167] = 65383;
        Encoding.codePageJapaneseToUnicode[168] = 65384;
        Encoding.codePageJapaneseToUnicode[169] = 65385;
        Encoding.codePageJapaneseToUnicode[170] = 65386;
        Encoding.codePageJapaneseToUnicode[171] = 65387;
        Encoding.codePageJapaneseToUnicode[172] = 65388;
        Encoding.codePageJapaneseToUnicode[173] = 65389;
        Encoding.codePageJapaneseToUnicode[174] = 65390;
        Encoding.codePageJapaneseToUnicode[175] = 65391;
        Encoding.codePageJapaneseToUnicode[176] = 65392;
        Encoding.codePageJapaneseToUnicode[177] = 65393;
        Encoding.codePageJapaneseToUnicode[178] = 65394;
        Encoding.codePageJapaneseToUnicode[179] = 65395;
        Encoding.codePageJapaneseToUnicode[180] = 65396;
        Encoding.codePageJapaneseToUnicode[181] = 65397;
        Encoding.codePageJapaneseToUnicode[182] = 65398;
        Encoding.codePageJapaneseToUnicode[183] = 65399;
        Encoding.codePageJapaneseToUnicode[184] = 65400;
        Encoding.codePageJapaneseToUnicode[185] = 65401;
        Encoding.codePageJapaneseToUnicode[186] = 65402;
        Encoding.codePageJapaneseToUnicode[187] = 65403;
        Encoding.codePageJapaneseToUnicode[188] = 65404;
        Encoding.codePageJapaneseToUnicode[189] = 65405;
        Encoding.codePageJapaneseToUnicode[190] = 65406;
        Encoding.codePageJapaneseToUnicode[191] = 65407;
        Encoding.codePageJapaneseToUnicode[192] = 65408;
        Encoding.codePageJapaneseToUnicode[193] = 65409;
        Encoding.codePageJapaneseToUnicode[194] = 65410;
        Encoding.codePageJapaneseToUnicode[195] = 65411;
        Encoding.codePageJapaneseToUnicode[196] = 65412;
        Encoding.codePageJapaneseToUnicode[197] = 65413;
        Encoding.codePageJapaneseToUnicode[198] = 65414;
        Encoding.codePageJapaneseToUnicode[199] = 65415;
        Encoding.codePageJapaneseToUnicode[200] = 65416;
        Encoding.codePageJapaneseToUnicode[201] = 65417;
        Encoding.codePageJapaneseToUnicode[202] = 65418;
        Encoding.codePageJapaneseToUnicode[203] = 65419;
        Encoding.codePageJapaneseToUnicode[204] = 65420;
        Encoding.codePageJapaneseToUnicode[205] = 65421;
        Encoding.codePageJapaneseToUnicode[206] = 65422;
        Encoding.codePageJapaneseToUnicode[207] = 65423;
        Encoding.codePageJapaneseToUnicode[208] = 65424;
        Encoding.codePageJapaneseToUnicode[209] = 65425;
        Encoding.codePageJapaneseToUnicode[210] = 65426;
        Encoding.codePageJapaneseToUnicode[211] = 65427;
        Encoding.codePageJapaneseToUnicode[212] = 65428;
        Encoding.codePageJapaneseToUnicode[213] = 65429;
        Encoding.codePageJapaneseToUnicode[214] = 65430;
        Encoding.codePageJapaneseToUnicode[215] = 65431;
        Encoding.codePageJapaneseToUnicode[216] = 65432;
        Encoding.codePageJapaneseToUnicode[217] = 65433;
        Encoding.codePageJapaneseToUnicode[218] = 65434;
        Encoding.codePageJapaneseToUnicode[219] = 65435;
        Encoding.codePageJapaneseToUnicode[220] = 65436;
        Encoding.codePageJapaneseToUnicode[221] = 65437;
        Encoding.codePageJapaneseToUnicode[222] = 65438;
        Encoding.codePageJapaneseToUnicode[223] = 65439;
    }
}

