/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import net.sf.jinsim.Channel;
import net.sf.jinsim.OutChannel;
import net.sf.jinsim.Small;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.request.InitRequest;
import net.sf.jinsim.request.SmallRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimResponse;

public abstract class Client {
    private Channel channel;
    protected InitRequest initRequest;
    private boolean requestVersion;
    private short interval;
    private int udpPort;
    private OutChannel outChannel;

    public short getInterval() {
        return this.interval;
    }

    public void setInterval(short interval) {
        this.interval = interval;
    }

    public void connect(Channel channel, String password, String name) throws IOException {
        this.connect(channel, password, name, (short)0, 0, 0);
    }

    public void connect(Channel channel, String password, String name, short flags, int interval, int udpPort) throws IOException {
        this.channel = channel;
        this.udpPort = udpPort;
        channel.setClient(this);
        Thread channelThread = new Thread(channel);
        channelThread.start();
        this.initRequest = new InitRequest();
        this.initRequest.setRequestVersion(this.requestVersion);
        if (udpPort > 0 && udpPort < 65536) {
            this.initRequest.setUdpPort((short)udpPort);
        } else {
            this.initRequest.setUdpPort(0);
        }
        this.initRequest.setPassword(password);
        this.initRequest.setName(name);
        this.initRequest.setFlags(flags);
        this.initRequest.setInterval((short)interval);
        this.send(this.initRequest);
    }

    private void enableOutChannel() throws IOException {
        if (this.outChannel == null) {
            this.outChannel = new OutChannel(this.udpPort);
            Thread outGaugeThread = new Thread(this.outChannel);
            this.outChannel.setClient(this);
            outGaugeThread.start();
        }
    }

    public void enableOutGauge(int interval) throws IOException {
        this.enableOutChannel();
        SmallRequest request = new SmallRequest(Small.START_SENDING_GAUGES, interval);
        this.send(request);
    }

    public void enableOutSim(int interval) throws IOException {
        this.enableOutChannel();
        SmallRequest request = new SmallRequest(Small.START_SENDING_POSITION, interval);
        this.send(request);
    }

    public void disableOutGauge() throws IOException {
        this.enableOutGauge(0);
    }

    public void disableOutSim() throws IOException {
        this.enableOutSim(0);
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isConnected()) {
            this.send(new TinyRequest(Tiny.CLOSE));
            if (this.outChannel != null) {
                this.disableOutGauge();
                this.disableOutSim();
                this.outChannel.close();
            }
            this.channel.close();
        }
    }

    public void send(InSimRequest packet) throws IOException {
        this.channel.send(packet);
    }

    public abstract void notifyListeners(InSimResponse var1);

    public void setRequestVersion(boolean requestVersion) {
        this.requestVersion = requestVersion;
    }
}

