/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sf.jinsim.Channel;
import net.sf.jinsim.Client;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.ResponseFactory;
import net.sf.jinsim.response.UnhandledPacketTypeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractChannel
implements Channel {
    static Log log = LogFactory.getLog(AbstractChannel.class);
    protected static final int BUFFER_SIZE = 512;
    private static final long TIMEOUT = 30000L;
    protected Client client;
    protected boolean running;
    protected ByteBuffer sendBuffer = ByteBuffer.allocateDirect(512);

    public AbstractChannel() {
        this.sendBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public synchronized void close() throws IOException {
        this.running = false;
    }

    public void run() {
        this.running = true;
        ResponseFactory packetFactory = ResponseFactory.getInstance();
        ByteBuffer buffer = ByteBuffer.allocateDirect(512);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(1);
        long currentTime = System.currentTimeMillis();
        int size = 0;
        InSimResponse packetData = null;
        while (this.running) {
            try {
                int numberRead;
                if (size == 0) {
                    sizeBuffer.clear();
                    int numberRead2 = -1;
                    try {
                        numberRead2 = this.receive(sizeBuffer);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    if (numberRead2 == -1) {
                        this.close();
                        return;
                    }
                    if (numberRead2 > 0) {
                        sizeBuffer.flip();
                        size = (sizeBuffer.get() & 0xFF) - 1;
                        if (size < 0) {
                            size = 0;
                        } else {
                            buffer.limit(size);
                        }
                    }
                }
                if (size != 0 && (numberRead = this.receive(buffer)) == -1) {
                    this.close();
                    return;
                }
                if (size > 0 && buffer.position() == size) {
                    buffer.flip();
                    try {
                        packetData = packetFactory.getPacketData(buffer);
                    }
                    catch (UnhandledPacketTypeException ex) {
                        log.error((Object)("Unknown packet: " + ex.getMessage()));
                    }
                    buffer.flip();
                    size = 0;
                    this.client.notifyListeners(packetData);
                }
                if (currentTime + 30000L < System.currentTimeMillis()) {
                    this.client.send(new TinyRequest(Tiny.PING));
                    currentTime = System.currentTimeMillis();
                }
                Thread.sleep(10L);
            }
            catch (Exception e) {
                log.error((Object)"Something went wrong!", (Throwable)e);
            }
        }
    }

    public synchronized void send(InSimRequest packet) throws IOException {
        packet.assemble(this.sendBuffer);
        this.sendBuffer.flip();
        int size = packet.getSize();
        if (log.isDebugEnabled()) {
            byte[] bytes = new byte[size];
            this.sendBuffer.get(bytes);
            this.sendBuffer.flip();
            String message = "SEND: bytes in " + (Object)((Object)packet.getType()) + " buffer: [";
            for (int i = 0; i < size; ++i) {
                message = message + bytes[i] + ", ";
            }
            log.debug((Object)(message + "]"));
        }
        this.send(this.sendBuffer);
    }

    protected abstract void send(ByteBuffer var1) throws IOException;

    public void setClient(Client client) {
        this.client = client;
    }

    protected abstract int receive(ByteBuffer var1) throws IOException;

    public boolean isConnected() {
        return this.running;
    }
}

