<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
	
	<html>
	<head>
		<title><xsl:value-of select="LFSPoints/DriversChampionship/@Name" /> Championship</title>

		<style type="text/css">
			
			*
			{
				padding:0px;
				margin:0px;
			}
			
			body
			{
				font-family:verdana;
			}
			
			#container
			{
				width:750px;
				margin-left:20px;				
				margin-top:10px;
			}
			
			#header	h1
			{
				
				font-size:1.4em;
				padding:10px;
				padding-bottom:15px;
				text-align:center;
			}
				
			table.championshipsTable
			{
				padding:0px;
				margin-bottom:20px;
			}			
				
			table.championshipsTable tr td h2
			{
				margin-bottom:10px;
				font-size:1.0em;
				text-align:center;
			}
		
			table.championshipsTable tr td table
			{
				border:1px dotted #ccc;
				width:365px;
			}
		
			table.championshipsTable tr td table tr td
			{
				font-size:0.7em;
				padding:4px;
				padding-top:3px;
				padding-bottom:3px;
			}
		
			table.championshipsTable tr td table tr.driversColumnHeader, table tr td table tr.teamsColumnHeader
			{
				background-color:#9acd32;
			}
			
			table.championshipsTable tr td table.driversTable
			{
				margin-right:10px;
			}
				
			#raceResultsHeader h3
			{
				font-size:1.0em;
				margin-bottom:20px;
				text-align:center;
			}
			
			table.raceResultsTable 
			{
				width:745px;
				margin-bottom:30px;
				border:1px dotted #ccc;
			}
		
			table.raceResultsTable tr td.raceResultsTitleRow
			{
				background-color:#E67300;
				color:#fff;
			}
		
			table.raceResultsTable tr td.raceResultsTitleRow h3
			{
				font-size:0.9em;
				padding:4px;
			}
		
			table.raceResultsTable tr.raceResultsColumnHeader td
			{
				padding:4px;
				font-size:0.7em;
			}
		
			table.raceResultsTable tr td table.driverResultsTable
			{
				width:738px;
			}
		
			table.raceResultsTable tr td table.driverResultsTable tr.driverResultsColumnHeader
			{
				background-color:#ddd;
			}
		
			table.raceResultsTable tr td table.driverResultsTable tr td
			{
				font-size:0.7em;
				padding:4px;
				padding-top:3px;
				padding-bottom:3px;
			}
				
			#footer
			{
				text-align:center;
				font-size:0.7em;
				margin-bottom:20px;
			}
			
		</style>
		
	</head>
	<body>
		<div id="container">
			<div id="header">
				<h1><xsl:value-of select="LFSPoints/DriversChampionship/@Name" /> Championship</h1>
			</div>
			
			<table class="championshipsTable">
				<tr>
					<td><h2>Drivers Standings</h2></td>
					<td><h2>Teams Standings</h2></td>
				</tr>
				<tr>
					<td valign="top">
            
						<table class="driversTable">
							<tr class="driversColumnHeader">
								<td><b>#</b></td>
								<td><b>Driver</b></td>
								<td><b>Team</b></td>
								<td><b>Pts</b></td>
							</tr>
							<xsl:for-each select="LFSPoints/DriversChampionship/Result">
								<tr>
									<td><xsl:value-of select="@Position" /></td>
									<td><xsl:value-of select="@Name" /></td>
									<td><xsl:value-of select="@Team" /></td>
									<td><xsl:value-of select="@Points" /></td>
								</tr>
							</xsl:for-each>
						</table>		
            
					</td>
					<td valign="top">
            
						<table class="teamsTable">
							<tr class="teamsColumnHeader">
								<td><b>#</b></td>
								<td><b>Team</b></td>
								<td><b>Pts</b></td>
							</tr>
							<xsl:for-each select="LFSPoints/TeamsChampionship/Result">
								<tr>
									<td><xsl:value-of select="@Position" /></td>
									<td><xsl:value-of select="@Name" /></td>
									<td><xsl:value-of select="@Points" /></td>
								</tr>
							</xsl:for-each>
						</table>			
            
					</td>
				</tr>			
			</table>	

			<div id="raceResultsHeader">
				<h3>Race Results</h3>
			</div>
			
			<xsl:for-each select="LFSPoints/Replays/Replay">
				<table class="raceResultsTable">
					<tr>
						<td class="raceResultsTitleRow" colspan="4"><h3><xsl:value-of select="@Name" /></h3></td>
					</tr>
					<tr class="raceResultsColumnHeader"> 
						<td><b>Track:</b></td>
						<td><xsl:value-of select="FullTrackName" /></td>
						<td><b>Date:</b></td>
						<td><xsl:value-of select="StartTime" /></td>
					</tr>
					<tr class="raceResultsColumnHeader">
						<td><b>Laps:</b></td>
						<td><xsl:value-of select="Laps" /></td>
						<td><b>Finished:</b></td>
						<td><xsl:value-of select="NumFinished" /> / <xsl:value-of select="NumPlayers" /></td>
					</tr>
					<tr>
					<td colspan="4">
            
						<table class="driverResultsTable">
							<tr class="driverResultsColumnHeader">
								<td><b>Pos</b></td>
								<td><b>Driver</b></td>
								<td><b>Car</b></td>
								<td><b>Team</b></td>
								<td><b>Qual</b></td>
								<td><b>Fastest Lap</b></td>
								<td><b>Race Time</b></td>						
							</tr>
							<xsl:for-each select="Drivers/Driver">						
								<tr>	
									<td><xsl:value-of select="FinalPosition" /></td>
									<td><xsl:value-of select="PlayerName" /></td>
									<td><xsl:value-of select="ShortCarName" /></td>
									<td><xsl:value-of select="TeamName" /></td>
									<td>
										<xsl:if test="StartPosition = 0">
											(None)
										</xsl:if>
										<xsl:if test="StartPosition != 0">
											<xsl:value-of select="StartPosition" />
										</xsl:if>
									</td>
									<td><xsl:value-of select="BestLapTime/@Time" /></td>									
									<td><xsl:value-of select="RaceTime" /></td>
								</tr>
							</xsl:for-each>	
						</table>
            
					</td>
					</tr>
				</table>
			</xsl:for-each>			
			
			<div id="footer">
				<!-- Please keep this bit! :)  -->
				Created by <a href="http://www.lfsforum.net/showthread.php?t=31513">LFSPoints</a>.
			</div>			
		</div>		
	</body>
	</html>
	
</xsl:template>
</xsl:stylesheet>