import struct, socket, os, math

is_isi = "BBBBHHBBH16s16s"
is_ver = "BBBB8s6sH"
is_cpp = "BBBB3lHHHBBfHH"
is_tiny = "BBBB"
is_small = "BBBBL"
outsimpack = "I3ffff3f3f3L"

config = open('camlevel_cfg.txt', 'r')
for cfgLine in config:
    cfgline = cfgLine.split("\n")[0]
    if cfgLine.split("=")[0] == "insim_port":
        insimport = int(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "outsim_port":
        outsimport = int(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "pitch_multi":
        pitch_multi = float(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "roll_multi":
        roll_multi = float(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "average_window":
        average_window = int(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "average_multi":
        average_multi = float(cfgLine.split("=")[1].split("#")[0])
    elif cfgLine.split("=")[0] == "camera_average":
        camera_average= int(cfgLine.split("=")[1].split("#")[0])
config.close()

pitch_list = [0]*average_window
roll_list = [0]*average_window

socket.setdefaulttimeout(10)

insim = socket.socket()
insim.connect(('127.0.0.1',insimport))
insim.send(struct.pack(is_isi, 44,1,0,0,outsimport,0,0,0,0,'','CamLevel'))
insim.send(struct.pack(is_small, 8,4,0,1,1))
outsim = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
outsim.bind(('127.0.0.1',outsimport))
while True:
    try:
        pitch, roll = (struct.unpack(outsimpack, outsim.recv(64))[5:7])
        pitch, roll = math.degrees(pitch),math.degrees(roll)
        del pitch_list[0]
        pitch_list.append(pitch)
        del roll_list[0]
        roll_list.append(roll)
        pitch = pitch - (sum(pitch_list) / average_window)*average_multi
        roll = roll - (sum(roll_list) / average_window)*average_multi
        pitch, roll = pitch * pitch_multi, roll * roll_multi
        pitch = int(pitch * 182.044444444444)
        roll = int(roll * 182.0444444444)
        if pitch < 0:
            pitch = -pitch
        else:
            pitch = 65535 - pitch
        if roll < 0:
            roll = -roll
        else:
            roll = 65535 - roll
        insim.send(struct.pack(is_cpp, 32,9,0,0,0,0,0,21,pitch,roll,
                              255,255,90.0,camera_average,8192))
    except socket.timeout:
        insim.send(struct.pack(is_small, 8,4,0,1,0))
        insim.send(struct.pack(is_small, 8,4,0,1,1))
        pitch_list = [0]*average_window
        roll_list = [0]*average_window
