#include <windows.h>
#include "DirectManager.h"
#include "ImeProc.h"
#include "ImeDraw.h"
#pragma comment(linker, "/nodefaultlib:libci")





#ifndef RELEASE
#define RELEASE(x){if(x != NULL){x->Release();}}
#endif




HINSTANCE	g_hinst = NULL;		// CX^Xnh
HWND		g_hwnd = NULL;		// EBhEnh
bool		g_active = false;	// EBhEɃtH[JX邩tO

ImeProc imeProc;
ImeDraw imeDraw;



bool flag = 0;



//====================================================================
//	EBhEvV[W
//===================================================================
LRESULT WndProc(HWND hwnd, UINT umsg, WPARAM wparam, LPARAM lparam)
{
	switch(umsg)
	{
	case WM_IME_SETCONTEXT:
		flag = 1;
		return imeProc.SetCon(lparam);
	case WM_KEYDOWN:
		flag = 1;
		return imeProc.KeyDown(wparam);
	case WM_KEYUP:
		flag = 1;
		return imeProc.KeyUp(wparam);
	case WM_IME_COMPOSITION:
		flag = 1;
		return imeProc.Compo(lparam);
	case WM_IME_STARTCOMPOSITION:
		flag = 1;
		return imeProc.StartCompo();
	case WM_IME_ENDCOMPOSITION:
		flag = 1;
		return imeProc.EndCompo();
	case WM_IME_NOTIFY:
		flag = 1;
		return imeProc.Nofity(wparam,hwnd);
	case WM_SETFOCUS:
		g_active = true;
		break;
	case WM_KILLFOCUS:
		g_active = false;
		break;
	case WM_PAINT:
		ValidateRect(hwnd, NULL);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	case WM_CLOSE:
		PostQuitMessage(0);
        break;
	default:
		return DefWindowProc(hwnd, umsg, wparam, lparam);
	}
	return (0L);
}




//===========================================================
//	Gg|Cg	vO͊Jn܂B
//===========================================================
int APIENTRY WinMain(HINSTANCE hinst, HINSTANCE hprevinst, LPSTR lpcmdline, int ncmdshow)
{
	g_hinst = hinst;	// CX^Xnh̃Rs[

	DirectManager::SetObj(new DirectManager);
	DirectManager *pDirectManager = DirectManager::GetObj();

	//=====================================================
	//gp萔̒`
	//=====================================================
	const char windowclassname[] = "windowclassname";	// EBhENX
	const char windowname[] = "windowname";				// EBhE
	BOOL windowed = TRUE;								// EBhE[htXN[[h
	const int clientwidth = 512;						// EBhẺ̑傫
	const int clientheight = 512;						// EBhȄc̑傫
	const int MY_WINDOW_SYS = (WS_OVERLAPPED | WS_MINIMIZEBOX |WS_SYSMENU |WS_CAPTION | WS_VISIBLE);//EBhÊƂ̃EBhEVXe
	const int  MY_FULL_SYS = (WS_POPUP | WS_SYSMENU | WS_VISIBLE | WS_BORDER); //tXN[̂Ƃ̃EBhEVXe
	
	//=====================================================
	//EBhENX̒`
	//=====================================================
	WNDCLASSEX wcex;
	wcex.cbSize			= sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= g_hinst;
	wcex.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= windowclassname;
	wcex.hIconSm		= LoadIcon(NULL, IDI_APPLICATION);
	RegisterClassEx(&wcex);

	//=====================================================
	//EBhE̍쐬
	//=====================================================
	int windowwidth = clientwidth + GetSystemMetrics(SM_CXDLGFRAME) * 2;
	int windowheight = clientheight + GetSystemMetrics(SM_CYDLGFRAME) * 2 + GetSystemMetrics(SM_CYCAPTION);
	g_hwnd = CreateWindow(windowclassname, windowname,windowed ? MY_WINDOW_SYS:MY_FULL_SYS ,
							CW_USEDEFAULT, CW_USEDEFAULT, windowwidth, windowheight, NULL, NULL, g_hinst, NULL);

	imeProc.Init(g_hwnd);
	//=====================================================
	//DirectManageȑ
	//=====================================================
	if(FAILED(pDirectManager->Init(g_hwnd, clientwidth, clientheight, windowed)))
	{
		return -1;
	}
	
	LPDIRECT3DDEVICE9 pDevice = pDirectManager->GetDevice();
	pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
	pDevice->SetRenderState(D3DRS_ALPHAREF, 0x00000001);
	
	pDevice->SetRenderState(D3DRS_ALPHATESTENABLE, TRUE); 
	pDevice->SetRenderState(D3DRS_ALPHAFUNC, D3DCMP_GREATEREQUAL);
	
	
	//pDevice->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
	//pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	

	imeDraw.Init();


	g_active = true;


	MSG msg;
	BOOL bmsg;
	PeekMessage(&msg, NULL, 0U, 0U, PM_NOREMOVE );

	while(WM_QUIT != msg.message)
	{
		if(g_active)
		{
			bmsg = PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE );			
		}
		else
		{
			bmsg = GetMessage( &msg, NULL, 0U, 0U );
		}

		if(bmsg) 
		{
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else
		{
			if(flag == 1)
			{
				flag = 0;
				imeDraw.CreateText(imeProc);
			}
			//=====================================================
			//vÕCƂȂƂłB
			//=====================================================
			
			//`Jn
			pDirectManager->BeginScene();
			
			imeDraw.Draw(imeProc);
			pDirectManager->EndScene();
		}
	}

	pDirectManager->UnInit();
	SAFE_DELETE(pDirectManager);
	return 0;
}

