#include "ImeDraw.h"
#include "ImeProc.h"
#include "DirectManager.h"

ImeDraw::ImeDraw()
{

}

ImeDraw::~ImeDraw()
{



}

void ImeDraw::Init()
{
	SetObjectInfo(v1,D3DXVECTOR2(256.0f,256.0f),D3DXVECTOR2(512.0f,512.0f),D3DCOLOR_XRGB(255,255,255),0.0f,0.0f,1.0f,1.0f);
	m_AllText.Init(DirectManager::GetObj()->GetDevice(), 1,512,512);
	m_ListText.Init(DirectManager::GetObj()->GetDevice(), 1,512,512);
	
	
	m_AllText.SetAntiAlias(0);
	m_ListText.SetAntiAlias(0);
	count = 0;
}

//========================================================================
//_tH[}bg`֐łB
//========================================================================
void ImeDraw::SetVertex(MY_VERTEX *v,float x,float y,float z,D3DCOLOR color,float tu,float tv,float rhw)
{
	v->x = x;
	v->y = y;
	v->z = z;
	v->color = color;
	v->tu = tu;
	v->tv = tv;
	v->rhw=rhw;
}

//========================================================================
//Ŏlp`֐łB͈ɍ\邷ׂĂnĂ܂
//{̓NXقłˁB
//========================================================================
void ImeDraw::SetObjectInfo(MY_VERTEX *v,D3DXVECTOR2 &vec2Pos,D3DXVECTOR2 &vec2Size,D3DCOLOR color,float tu0,float tv0,float tu1,float tv1)
{
	D3DXVECTOR2 vec2Half;
	D3DXVec2Scale(&vec2Half,&vec2Size,0.5f);
	SetVertex(&v[0],vec2Pos.x - vec2Half.x,vec2Pos.y - vec2Half.y,0.0f,color,tu0,tv0,1.0f);
	SetVertex(&v[1],vec2Pos.x + vec2Half.x,vec2Pos.y - vec2Half.y,0.0f,color,tu1,tv0,1.0f);
	SetVertex(&v[2],vec2Pos.x + vec2Half.x,vec2Pos.y + vec2Half.y,0.0f,color,tu1,tv1,1.0f);
	SetVertex(&v[3],vec2Pos.x - vec2Half.x,vec2Pos.y + vec2Half.y,0.0f,color,tu0,tv1,1.0f);
}

void ImeDraw::SetLineVertex(LINE_VERTEX *v,float x,float y,D3DCOLOR color)
{
	v->x = x;
	v->y = y;
	v->z = 1.0;
	v->color = color;
	v->rhw=1.0;

}

void ImeDraw::Draw(ImeProc &imeProc)
{
	if(count < BLINK_COUNT)
	{
		DirectManager::GetObj()->GetDevice()->SetTexture(0,NULL);
		DirectManager::GetObj()->GetDevice()->SetFVF(LINE_FVF_VERTEX);
		DirectManager::GetObj()->GetDevice()->DrawPrimitiveUP(D3DPT_LINESTRIP,1,v2,sizeof(LINE_VERTEX));
		count++;
	}
	else
	{
		count++;
		if(count > BLINK_COUNT * 2)
		{	
			count = 0;
		}
	}
	

	DirectManager::GetObj()->GetDevice()->SetFVF(MY_FVF_VERTEX);
	DirectManager::GetObj()->GetDevice()->SetTexture(0,m_AllText.GetTex());
	DirectManager::GetObj()->GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,v1,sizeof(MY_VERTEX));

	
	DirectManager::GetObj()->GetDevice()->SetTexture(0,m_ListText.GetTex());
	DirectManager::GetObj()->GetDevice()->DrawPrimitiveUP(D3DPT_TRIANGLEFAN,2,v1,sizeof(MY_VERTEX));
	
}


void ImeDraw::SetListString(char *inListString,bool inNew,int inBackX)
{
	if(inNew)
	{
		m_ListText.SetColor( D3DCOLOR_XRGB(0,0,255));
	}
	else
	{
		m_ListText.SetColor( D3DCOLOR_XRGB(0,0,0));
	}
	m_ListText.DrawText(inListString);
	m_ListText.NL(inBackX);
}

void ImeDraw::StartList(int x,int y)
{
	m_ListText.CleatText();
	m_ListText.BeginText( "lr ", FONT_SIZE );
	m_ListText.SetCursolPos(x,y);
}

void ImeDraw::EndList()
{
	m_ListText.EndText();
}

void ImeDraw::SetAllString(char *inAllString)
{
	m_AllText.SetColor( D3DCOLOR_XRGB(0,0,0) );
	m_AllText.DrawText(inAllString);
}


void ImeDraw::SetImeString(char *inImeString,int inSize,int inNew,int inIndex,int inIndexSize)
{

	if(inNew)
	{
		m_AllText.SetColor( D3DCOLOR_XRGB(255,0,0));
	}
	else
	{
		m_AllText.SetColor( D3DCOLOR_XRGB(0,100,0));
	}
	if(inIndex != inIndexSize - 1)
	{
		inImeString[inSize ] = ' ';
		inImeString[inSize + 1] = '\0';
	}

	m_AllText.DrawText(inImeString);
}

void ImeDraw::StartAll(int x,int y)
{
	m_AllText.CleatText();
	m_AllText.BeginText( "lr ", FONT_SIZE );
	m_AllText.SetCursolPos(x,y);
}

void ImeDraw::EndAll()
{
	m_AllText.EndText();
}

void ImeDraw::CreateText(ImeProc &imeProc)
{

	//============================
	//܂AllString̈ꕔ
	//============================
	DWORD theStart = 0;
	DWORD theY = 50;
	char buffer[BUF_SIZE];
	memcpy(buffer,imeProc.GetAllString(),imeProc.GetThisPoint());
	buffer[imeProc.GetThisPoint()] = '\0';

	StartAll(theStart,theY);
	SetAllString(buffer);
	
	DWORD backX = m_AllText.GetX();
	
	m_AllText.SetCursolPos(m_AllText.GetX(),theY);
	memcpy(buffer,imeProc.GetAllString() + imeProc.GetThisPoint(), imeProc.GetAllStringSize() - imeProc.GetThisPoint());
	buffer[imeProc.GetAllStringSize() - imeProc.GetThisPoint()] = '\0';
	SetAllString(buffer);
	
	m_AllText.SetCursolPos(backX,theY);

	m_AllText.SetOver(1);
	//==========================
	//IMES`
	//==========================
	int num = imeProc.GetBlockNum();

	DWORD theListStart = 0;
	for(int i = 0; i < num;i++)
	{
		char tmp[256];
		bool theNew;
		int theSize;
		imeProc.GetImeBlockString(i,tmp,&theSize,&theNew);
		if(theNew)
		{
			theListStart = m_AllText.GetX();
		}
		SetImeString(tmp,theSize,theNew,i,num);
	}
	
	m_AllText.SetOver(0);
	

	float lineX = (float)m_AllText.GetX();
	float lineY = (float)theY;

	//=============================
	//͌⃊Xg`
	//=============================
	num = imeProc.GetListNum();
	StartList(theListStart,theY + 20);
	for(int i = 0; i < num;i++)
	{
		char tmp[256];
		bool theNew;
		int theSize;
		imeProc.GetListBlockString(i,tmp,&theSize,&theNew);
		SetListString(tmp,theNew,theListStart);
	}
	EndList();


	


	

	
	EndAll();




	SetLineVertex(&v2[0],lineX,lineY,D3DCOLOR_RGBA(0,0,0,255));
	SetLineVertex(&v2[1],lineX,lineY + FONT_SIZE,D3DCOLOR_RGBA(0,0,0,255));



}
