package {
	import flash.events.*;
	import flash.net.*;
	import flash.utils.*;

	public class InsimSocket extends Socket {
		private var Host:String;
		private var Port:int;
		private var ByteBuffer:ByteArray;
		private var SizeByte:int = -1;
		private var pp:Boolean = false;
		private var ReconnTry:int = 0;

		private var AliveTimer:int = 0;
		private var LastIn:int = 0;					// Time of last packet
		
		public function InsimSocket (_Host, _Port) {
			Host = _Host;
			Port = _Port;
			ByteBuffer = new ByteArray ();

			super (Host, Port);
			configureListeners ();
		}
		
		private function configureListeners ():void {
			addEventListener(Event.CONNECT, connectHandler);
			addEventListener(Event.CLOSE, closeHandler);
			addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityHandler);
			addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
			addEventListener(ProgressEvent.SOCKET_DATA, dataHandler);
		}
		
		private function connectHandler (e:Event):void {
			Helpers.dbMsg ("InSim Relay connection created");
			
			// Update Spec.State
			Spec.State = 1;
			ReconnTry = 0;
			
			// Initial acknowledgement packet timer
			AliveTimer = setTimeout (sendACK, 35000);
			
			// Reset RaceData
			RaceData.reset ();
			
			// Figure out what to do now we have connected - get hostlist? Continue spectating?
			if (!Spec.HostName) {
				// Request hostlisting
				HostLister.requestHostList ();
			
			} else  {
				// Send host selection packet again
				HostLister.connectHost (Spec.HostName, HostLister.AdminPass, HostLister.SpecPass);
			}
		}

		private function closeHandler (e:Event):void {
			Helpers.dbMsg ("InSim Relay connection closed by server.");
			if (ReconnTry < 3)
				Helpers.dbMsg ("Will try to reconnect in 3 seconds.");

			Spec.State = 0;
			
			// Popup request to reconnect
			// Reconnect automatically for now
			setTimeout (reconnect, 3000);
		}
		
		private function reconnect ():void {
			if (ReconnTry < 3) {
				ReconnTry++;
				Helpers.dbMsg ("Reconnection attempt #"+ReconnTry);
				connect (Host, Port);
			} else {
				Helpers.dbMsg ("Tried 3 reconnects, but they failed. Giving up.");
				RaceData.reset ();
			}
		}

		private function securityHandler (e:SecurityErrorEvent):void {
			Helpers.dbMsg ("InSim Relay connection failed : "+e.text);
		}

		private function errorHandler (e:IOErrorEvent):void {
			Helpers.dbMsg ("IO Error : "+e.text);
			// Error ocurred when trying to make a connection - try to reconnect
			if (Spec.State == 0) {
				setTimeout (reconnect, 3000);
			}
		}

		private function dataHandler (e:ProgressEvent):void {
			LastIn = getTimer ();
			
			readBytes (ByteBuffer, ByteBuffer.length);
			//Helpers.dbMsg ("Data received : "+e.bytesLoaded+" ("+ByteBuffer.length+") bytes");
			
			if (pp == false) {
				pp = true;
				var packet:ByteArray = new ByteArray ();
				
				// Loop to find LFS packets within the received data
				// Remember, TCP is a stream - one blob of data that you receive may contain several LFS packets.
				while (true) {
					packet = findPacket ();
					if (packet.length == 0)
						break;
					
					// We seem to have to set reverse byte order
					packet.endian = "littleEndian";

					// We've found a packet! Now let's see what to do with it
					var type:int = packet.readUnsignedByte ();
					if (Spec.HostName == "" && type < 250) {
						continue;
					}
					
					switch (type) {
						case 2 :	// VER
							handleVER (packet);
							break;
						case 3 :	// TINY
							handleTINY (packet);
							break;
						case 4 :	// SMALL
							handleSMALL (packet);
							break;

						case 5 :	// STA
							handleSTA (packet);
							break;

						case 10 :	// ISM
							break;

						case 11 :	// MSO
							handleMSO (packet);
							break;
						case 12 :	// III
							break;
						case 13 :	// MST
							break;
						case 14 :	// MTC
							break;

						case 16 :	// VTN
							break;
						case 17 :	// RST
							handleRST (packet);
							break;

						case 18 :	// NCN
							handleNCN (packet);
							break;
						case 19 :	// CNL
							handleCNL (packet);
							break;
						case 20 :	// CPR
							handleCPR (packet);
							break;

						case 21 :	// NPL
							handleNPL (packet);
							break;
						case 22 :	// PLP
							handlePLP (packet);
							break;
						case 23 :	// PLL
							handlePLL (packet);
							break;

						case 24 :	// LAP
							handleLAP (packet);
							break;
						case 25 :	// SPX
							handleSPX (packet);
							break;

						case 26 :	// PIT
							handlePIT (packet);
							break;
						case 27 :	// PSF
							handlePSF (packet);
							break;
						case 28 :	// PLA
							break;

						case 29 :	// CCH
							break;

						case 30 :	// PEN
							handlePEN (packet);
							break;
						case 31 :	// TOC
							handleTOC (packet);
							break;
						case 32 :	// FLG
							handleFLG (packet);
							break;
						case 33 :	// PFL
							break;

						case 34 :	// FIN
							handleFIN (packet);
							break;
						case 35 :	// RES
							handleRES (packet);
							break;
						case 36 :	// REO
							break;

						case 38 :	// MCI
							handleMCI (packet);
							break;

						case 39 :	// MSX
							break;

						case 41 :	// CRS
							break;

						case 43 :	// AXI
							break;
						case 44 :	// AXO
							break;

						case 251 :	// IRP_ARP (out)
							handleARP (packet);
							break;
						case 252 :	// IRP_HLR (out)
							break;
						case 253 :	// IRP_HOS (in)
							HostLister.parseHostPacket (packet);
							break;
						case 254 :	// IRP_SEL (out)
							break;
						case 255 :	// IRP_ERR (in)
							handleERR (packet);
							break;
						default :
							//Helpers.dbMsg ("Unknown packet found of type "+type);
							trace ("Unknown packet found of type "+type);
							break;
					}
				}
				if (SizeByte == -1)
					ByteBuffer = new ByteArray ();
				pp = false;
			}
		}

		private function findPacket ():ByteArray {
			var packet:ByteArray = new ByteArray ();

			if ((ByteBuffer.length - ByteBuffer.position) == 0)
				return packet;
			
			// Read sizebyte
			if (SizeByte < 0)
				SizeByte = ByteBuffer.readUnsignedByte () - 1;
			
			// Check if bytebuffer length is equal or bigger than sizebyte
			if ((ByteBuffer.length - ByteBuffer.position) >= SizeByte) {
				ByteBuffer.readBytes (packet, 0, SizeByte);
				//Helpers.dbMsg ("Sizebyte : "+(SizeByte + 1)+" - packet len : "+packet.length+" ("+ByteBuffer.position+")");
				SizeByte = -1;
			}
			
			return packet;
		}

		private function sendACK ():void {
			if (!connected)
				return;
				
			writeByte (4);
			writeByte (3);
			writeByte (0);
			writeByte (0);
			flush ();
			AliveTimer = setTimeout (sendACK, 25000);
		}
	}
}