﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Linq;

namespace LFSPoints
{
    public static class Config
    {
		private const string ConfigElementName = "Config";
		private static Dictionary<string, string> keyValues = 
			new Dictionary<string, string>();

        #region Get Methods
        public static string GetString(string key)
        {
            return keyValues[key];
        }

        public static byte GetByte(string key)
        {
            return Byte.Parse(GetString(key));
        }

        public static short GetInt16(string key)
        {
            return Int16.Parse(GetString(key));
        }		
		
        public static ushort GetUInt16(string key)
        {
            return UInt16.Parse(GetString(key));
        }			
		
        public static int GetInt32(string key)
        {
            return Int32.Parse(GetString(key));
        }

		public static uint GetUInt32(string key)
        {
            return UInt32.Parse(GetString(key));
        }
		
        public static long GetInt64(string key)
        {
            return Int64.Parse(GetString(key));
        }				

		public static ulong GetUInt64(string key)
        {
            return UInt64.Parse(GetString(key));
        }

        public static float GetFloat(string key)
        {
            return Single.Parse(GetString(key));
        }

        public static double GetDouble(string key)
        {
            return Double.Parse(GetString(key));
        }

        public static bool GetBool(string key)
        {
            return Boolean.Parse(GetString(key));
        }
        #endregion

        #region Set Methods
        public static void Set(string key, byte value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, short value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, ushort value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, int value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, uint value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, long value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, ulong value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, float value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, double value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, bool value)
        {
            Set(key, value.ToString());
        }

        public static void Set(string key, string value)
        {
            if (keyValues.ContainsKey(key))
                keyValues[key] = value;
            else
                keyValues.Add(key, value);
        }
        #endregion

        public static void Remove(string key)
        {
            if (keyValues.ContainsKey(key))
                keyValues.Remove(key);
        }

        public static void Load(string filename)
        {
            foreach (var xConfigs in XDocument.Load(filename).Descendants(ConfigElementName))
            {
                foreach (var xConfig in xConfigs.Elements())
                {
                    keyValues.Add(xConfig.Name.LocalName, xConfig.Value);
                }
            }
        }

        public static void Save(string filename)
        {
            var xConfig = new XElement(ConfigElementName);

            foreach (KeyValuePair<string, string> keyValue in keyValues)
                xConfig.Add(new XElement(keyValue.Key, keyValue.Value));

            xConfig.Save(filename);
        }
    }
}
