using System;
using System.Collections.Generic;
using System.Text;
using LFS_External.InSim;

namespace LFSRestrictions
{
    /// <summary>
    /// Holds all current connections tothe server
    /// </summary>
    public class clsConnection
    {
        protected byte _uniqueid;
        protected string _username;
        protected string _playername;
        protected byte _isadmin;
        protected byte _flags;

        public clsConnection()
        {
        }

        /// <summary>
        /// Connections Unique ID
        /// </summary>
        public byte UniqueID
        {
            get { return _uniqueid; }
            set { _uniqueid = value; }
        }

        /// <summary>
        /// Connections username
        /// </summary>
        public string Username
        {
            get { return _username; }
            set { _username = value; }
        }

        /// <summary>
        /// Connections player name
        /// </summary>
        public string PlayerName
        {
            get { return _playername; }
            set { _playername = value; }
        }

        /// <summary>
        /// Connection is admin
        /// </summary>
        public byte IsAdmin
        {
            get { return _isadmin; }
            set { _isadmin = value; }
        }

        /// <summary>
        /// Bit 2 : remote
        /// </summary>
        public byte Flags
        {
            get { return _flags; }
            set { _flags = value; }
        }
    }

    /// <summary>
    /// Holds all players in the server (On the track of in the pits)
    /// </summary>
    public class clsPlayer
    {
        // Bitwise
        public enum enuPType : byte
        {
            Female = 0,
            AI = 1,
            Remote = 2,
        }

        protected byte _playerid;
        protected byte _uniqueid;
        protected enuPType _ptype;
        protected Flags.PlayerFlags _flags;
        protected string _playername;
        protected string _plate;
        protected string _carname;
        protected string _skinname;
        protected Enums.NPL_Tyres _tyre_rl;
        protected Enums.NPL_Tyres _tyre_rr;
        protected Enums.NPL_Tyres _tyre_fl;
        protected Enums.NPL_Tyres _tyre_fr;
        protected byte _addedmass;
        protected byte _intakerestriction;
        protected byte _passengers;

        public clsPlayer()
        {

        }

        /// <summary>
        /// Unique player id
        /// </summary>
        public byte PlayerID
        {
            get { return _playerid; }
            set { _playerid = value; }
        }

        /// <summary>
        /// This player belogns to this connection (changes on Driver Swap)
        /// </summary>
        public byte UniqueID
        {
            get { return _uniqueid; }
            set { _uniqueid = value; }
        }

        /// <summary>
        /// Type of player
        /// </summary>
        public enuPType PlayerType
        {
            get { return _ptype; }
            set { _ptype = value; }
        }

        /// <summary>
        /// Flags, Packet.PIF_xxx
        /// </summary>
        public Flags.PlayerFlags Flags
        {
            get { return _flags; }
            set { _flags = value; }
        }

        /// <summary>
        /// Players ingame name
        /// </summary>
        public string PlayerName
        {
            get { return _playername; }
            set { _playername = value; }
        }

        /// <summary>
        /// Plate of car
        /// </summary>
        public string Plate
        {
            get { return _plate; }
            set { _plate = value; }
        }

        /// <summary>
        /// Current players car
        /// </summary>
        public string CarName
        {
            get { return _carname; }
            set { _carname = value; }
        }

        /// <summary>
        /// Name of the skin on the car
        /// </summary>
        public string SkinName
        {
            get { return _skinname; }
            set { _skinname = value; }
        }

        /// <summary>
        /// Rear Left tyre type
        /// </summary>
        public Enums.NPL_Tyres Tyre_RL
        {
            get { return _tyre_rl; }
            set { _tyre_rl = value; }
        }

        /// <summary>
        /// Rear Right tyre type
        /// </summary>
        public Enums.NPL_Tyres Tyre_RR
        {
            get { return _tyre_rr; }
            set { _tyre_rr = value; }
        }

        /// <summary>
        /// Front Left tyre type
        /// </summary>
        public Enums.NPL_Tyres Tyre_FL
        {
            get { return _tyre_fl; }
            set { _tyre_fl = value; }
        }

        /// <summary>
        /// Front Right tyre type
        /// </summary>
        public Enums.NPL_Tyres Tyre_FR
        {
            get { return _tyre_fr; }
            set { _tyre_fr = value; }
        }

        /// <summary>
        /// Extra mass in Kg
        /// </summary>
        public byte AddedMass
        {
            get { return _addedmass; }
            set { _addedmass = value; }
        }

        /// <summary>
        /// Passanger in the car
        /// </summary>
        public byte Passengers
        {
            get { return _passengers; }
            set { _passengers = value; }
        }

		/// <summary>
		/// Intake Restriction
		/// </summary>
		public byte IntakeRestriction
		{
			get { return _intakerestriction; }
			set { _intakerestriction = value; }
		}
    }
}
