#include "cpane.h"
#include "ceventredirector.h"

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cPane, wxScrolledWindow)
  EVT_KEY_DOWN(cPane::OnKey)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------

cPane::cPane(wxWindow* parent)
: wxScrolledWindow(parent)
{
  RedirectEvents(this, NULL, true, false); // redirect scrollwheel events to the window at the pointer
}

//-----------------------------------------------------------------------------

cPane::~cPane()
{
}

//-----------------------------------------------------------------------------
// Close the pane when the Escape key is pressed

void cPane::OnKey(wxKeyEvent& event)
{
  switch (event.GetKeyCode()) {
    case WXK_ESCAPE :
      // request to close this pane
      ::CloseView_Send(this);
      break;

    default:
      event.Skip();
      return;
  }
}
