#ifndef _CGRAPHVIEW_H_
#define _CGRAPHVIEW_H_

#include "global.h"
#include "cpane.h"
#include "cgraph.h"
#include "cgraphtools.h"
#include <wx/sizer.h>

class cRuler;

// multiplication/division factor for zooming in/out
#define GRAPH_ZOOM_FACTOR 1.25

//-----------------------------------------------------------------------------
// A window containing one or more graphs

class cGraphView : public cPane
{
private:
  graph_t m_Type;              // the type of graph
  cGraph* m_Graph;             // the graph itself
  cRuler* m_RulerX;            // the ruler for the X axis
  cRuler* m_RulerY;            // the ruler for the Y axis
  cGraphTools* m_Toolbar;      // the toolbar

  wxFlexGridSizer* m_GrrSizer;  // sizer for graph and X and Y rulers
  wxBoxSizer* m_TopSizer;       // top-level sizer

  void OnScroll(wxScrollWinEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

public:
  ENABLE_OBJCHECKER

  cGraphView(wxWindow* parent, graph_t type, wxString settings);
  virtual ~cGraphView();

  graph_t GetType() const { CHECK_THIS; return m_Type; }
  cGraph* GetGraph() { CHECK_THIS; CHECK_PTR(m_Graph); return m_Graph; }

  virtual void UpdateAll();
  virtual void DoShowLap(cLap* WXUNUSED(lap), bool WXUNUSED(shown)) { UpdateAll(); }
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, bool scroll)
      { m_Graph->DoSetTrackCursorPos(view, distance, scroll); }
  virtual void DoSetTrackSelection(float start, float end)
      { m_Graph->DoSetTrackSelection(start, end); }
  virtual void DoSynchronise(cGraphView* view)
      { if ((view != this) && (view->GetType() == m_Type)) m_Graph->DoSynchronise(view->GetGraph()); }

  void ZoomX(float factor) { m_Graph->ZoomX(factor); }
  void ZoomReset() { m_Graph->ZoomReset(wxHORIZONTAL | wxVERTICAL); }
  void FitSelection() { m_Graph->FitSelection(); }

  void RequestSync() { m_Graph->RequestSync(); }
  void ShowCrossHair(bool visible = true) { m_Graph->ShowCrossHair(visible); }

  void AddLap(cLap* lap);
  void DeleteLap(cLap* lap);
  void DeleteAllLaps();

  void GraphPositionIs(bool top, bool bottom);
  void ShowXruler(bool show = true);

  wxString SaveSettings() const;
  void LoadSettings(const wxString& settings);

  void EnableToolTips(bool flag);
};

#endif
