#include "cgraphtools_xy.h"
#include "cgraph.h"
#include "cgraphview.h"
#include "ccarstate.h"
#include "ccar.h"
#include "cmgr.h"

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cGraphToolsXY, cGraphTools)
  EVT_CHOICE(ID_CHOICE_LOGTYPE_X, cGraphToolsXY::OnChangeLogtype)
  EVT_CHOICE(ID_CHOICE_LOGTYPE_Y, cGraphToolsXY::OnChangeLogtype)
  EVT_CHOICE(ID_CHOICE_WHEEL, cGraphToolsXY::OnChangeLogtype)
  EVT_CHECKBOX(ID_CHECK_CONNECT, cGraphToolsXY::OnToggleConnect)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------

cGraphToolsXY::cGraphToolsXY(cGraphView* parent, cGraphXY* graph)
: cGraphTools(parent, graph)
{
  m_LogtypeXChoice = CreateLogtypeControl(ID_CHOICE_LOGTYPE_X);
  m_LogtypeYChoice = CreateLogtypeControl(ID_CHOICE_LOGTYPE_Y);
  m_WheeltypeChoice = CreateWheeltypeControl(ID_CHOICE_WHEEL);

  m_WheelText = new wxStaticText(this, -1, _T("Wheel"));
  m_ConnectCheck = new wxCheckBox(this, ID_CHECK_CONNECT, _T("Dots"));

  EnableControls();

  m_TopSizer->Insert(0, new wxStaticText(this, -1, _T("X")),
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, BASE_MARGIN));
  m_TopSizer->Insert(1, m_LogtypeXChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(2, new wxStaticText(this, -1, _T("Y")),
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(3, m_LogtypeYChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(4, m_WheelText,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(5, m_WheeltypeChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(6, m_ConnectCheck,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));

  UpdateAll();
}

//-----------------------------------------------------------------------------

cGraphToolsXY::~cGraphToolsXY()
{
}

//-----------------------------------------------------------------------------

void cGraphToolsXY::OnChangeLogtype(wxCommandEvent& WXUNUSED(event))
{
  cGraphXY* graph = (cGraphXY*)m_Graph;

  // retrieve user choices
  int log_x = GetLogtypeSelection(m_LogtypeXChoice);
  int log_y = GetLogtypeSelection(m_LogtypeYChoice);
  int wheel = GetWheeltypeSelection(m_WheeltypeChoice);

  // correct invalid choices
  if (log_x < 0) {
    log_x = graph->GetLogtypeX();
    SetLogtypeSelection(m_LogtypeXChoice, log_x);
  }
  if (log_y < 0) {
    log_y = graph->GetLogtypeY();
    SetLogtypeSelection(m_LogtypeYChoice, log_y);
  }
  if (wheel < 0) {
    wheel = graph->GetWheeltype();
    SetWheeltypeSelection(m_WheeltypeChoice, wheel);
  }

  if ((log_x == graph->GetLogtypeX()) &&
      (log_y == graph->GetLogtypeY()) &&
      (wheel == graph->GetWheeltype())) return; // no change

  // update graph and state of controls
  graph->SetLogtype(log_x, log_y, wheel);
  EnableControls();

  graph->FitSelection(); // ensure that curves are visible
}

//-----------------------------------------------------------------------------
// Re-read the data from the graph (to fill the controls on the toolbar)

void cGraphToolsXY::UpdateAll()
{
  cGraphXY* graph = (cGraphXY*)m_Graph;

  SetLogtypeSelection(m_LogtypeXChoice, graph->GetLogtypeX());
  SetLogtypeSelection(m_LogtypeYChoice, graph->GetLogtypeY());
  SetWheeltypeSelection(m_WheeltypeChoice, graph->GetWheeltype());
  m_ConnectCheck->SetValue(!(graph->GetConnect()));

  EnableControls();
}

//-----------------------------------------------------------------------------
// Enable/disable the controls

void cGraphToolsXY::DoEnableControls()
{
  int sel_x = GetLogtypeSelection(m_LogtypeXChoice);
  bool perwheel_x = (sel_x >= 0) && cCarState::IsPerWheel(sel_x);
  int sel_y = GetLogtypeSelection(m_LogtypeYChoice);
  bool perwheel_y = (sel_y >= 0) && cCarState::IsPerWheel(sel_y);
  m_WheeltypeChoice->Enable(perwheel_x || perwheel_y);
  m_WheelText->Enable(m_WheeltypeChoice->IsEnabled());
}

//-----------------------------------------------------------------------------

void cGraphToolsXY::OnToggleConnect(wxCommandEvent& WXUNUSED(event))
{
  m_Graph->SetConnect(!(m_ConnectCheck->IsChecked())); // remember the user's choice
}
