#ifndef _CTRACKPATH_H_
#define _CTRACKPATH_H_

#include "global.h"
#include "cfile.h"

//-----------------------------------------------------------------------------
// A track path, read from a PTH file

class cTrackPath : public cFile
{
private:
  // node data
  wxInt32 m_NodeCount;  // number of nodes
  float* m_RoadLeftX;
  float* m_RoadLeftY;
  float* m_RoadRightX;
  float* m_RoadRightY;

  wxInt32 m_FinishNode; // index of the node where the finish line is

public:
  ENABLE_OBJCHECKER
  friend class cDrivingLine;

  cTrackPath();
  virtual ~cTrackPath();

  bool Load(const wxString& fileName);
};

//-----------------------------------------------------------------------------

#endif
