#ifndef _CTRACKMAP_H_
#define _CTRACKMAP_H_

#include "global.h"
#include "cpane.h"
#include <wx/pen.h>
#include <wx/menu.h>

#define MAX_SECTORS 50

//-----------------------------------------------------------------------------
// The track map

class cTrackMap : public cPane
{
private:
  static wxPen s_Pen_Sel;   // pen for drawing the selected part of the track
  static wxPen s_Pen_UnSel; // pen for drawing the non-selected part of the track
  static wxPen s_ButtonPen; // pen for drawing the buttons

  float m_Scale;            // scaling factor for drawing
  wxCoord m_MarginX;        // X margin for drawing
  wxCoord m_MarginY;        // Y margin for drawing
  float m_MinX, m_MaxY;     // track coordinates corresponding with topleft corner of trackmap

  bool m_ShowSectorToolbar; // show the sector buttons?
  wxCoord m_ButtonSize;     // size of sector buttons
  wxPoint m_ButtonStart;    // topleft corner of the row of buttons
  int m_SelectedButton;     // button number that is shown in 'selected' state (-1 = none)

  bool m_ShowDistance;      // show distance-in-lap values of cursor?
  wxCoord m_ValueStartY;    // Y coordinate from where the distance value is displayed

  bool m_DragMode;          // are we in drag-selecting mode?
  float m_SelStart;         // distance-in-lap where selected part of track starts
  float m_SelEnd;           // distance-in-lap where selected part of track end
  float m_ClickPos;         // distance-in-lap of point of last mouse click

  wxString m_TrackCode;     // code of the currently shown track
  float m_SectorEnd[MAX_SECTORS]; // distance-in-lap of end of each sector
  int m_SectorCount;        // number of slots in m_SectorEnd that are used

  wxMenu m_Context;         // context menu

  wxCoord Track2CoordX(float tc);
  wxCoord Track2CoordY(float tc);
  void AdjustDimensions();
  void DoPaint(wxDC& dc);

  float DecodeMouse(wxMouseEvent& event, int* button = NULL);

  wxCoord Button2CoordY(int button) const;
  int Coord2ButtonY(wxCoord coord) const;
  void SelectButton(int button);
  void DrawSectorButton(wxDC& dc, int button, bool highlight);

  bool m_CursorDrawn;      // is there currently a track cursor?
  float m_CursorDist;      // distance-in-lap of the cursor
  wxCoord m_CursorX;       // the X coordinate where the track cursor has been drawn
  wxCoord m_CursorY;

  void DrawTrackCursor(wxDC& dc, wxCoord x, wxCoord y);
  void PutTrackCursor(wxDC& dc, float distance);
  void RemoveTrackCursor(wxDC& dc);

  void ResetZoom();

  void OnMouseLeftClick(wxMouseEvent& event);
  void OnMouseLeftRelease(wxMouseEvent& event);
  void OnMouseLeftDoubleClick(wxMouseEvent& event);
  void OnMouseMiddleClick(wxMouseEvent& WXUNUSED(event)) { ResetZoom(); }
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseRightClick(wxMouseEvent& event);
  void OnMouseWheel(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& event);
  void OnMouseLeaving(wxMouseEvent& event);

  void OnMenuClick(wxCommandEvent& event);

  void OnPaint(wxPaintEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cTrackMap(wxWindow* parent);
  virtual ~cTrackMap();

  virtual wxSize DoGetBestSize() const { return wxSize(200, 200); }

  virtual void UpdateAll();
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, bool scroll);
  virtual void DoSetTrackSelection(float start, float end);

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
