#ifndef _CLEGEND_H_
#define _CLEGEND_H_

#include "global.h"
#include "cpane.h"
#include <wx/menu.h>

//-----------------------------------------------------------------------------
// The legend for the graphs

class cLegend : public cPane
{
private:
  static wxPen s_GridPen;     // the pen for drawing grid lines

  wxCoord m_LabelX, m_LabelY; // the maximum size of labels (= lap names)
  wxCoord m_LineSpacing;      // vertical distance between lines in the legend
  wxCoord m_MinWidth;         // minimum window width

  // X coordinate where the lap data is displayed
  wxCoord m_IconStart;        // icon
  wxCoord m_LabelStart;       // lap name
  wxCoord m_LabelEnd;
  wxCoord m_CurveValueEnd;    // curve value
  wxCoord m_SteerStart;       // steer gauge
  wxCoord m_PedalStart;       // pedal gauges
  wxCoord m_GearStart;        // gear gauge
  wxCoord m_SpeedEnd;         // speed gauge

  int m_SelectedLine;         // line number that is shown in 'selected' state (-1 = none)

  float m_Distance;           // distance-in-lap of which the state must be shown

  bool m_ShowDashboard;       // show the "dashboard" (gauges, speed, gear)?
  cGraph* m_Graph;            // graph whose curve values must be displayed (may be NULL)

  void OnPaint(wxPaintEvent& event);
  void OnMouseLeftClick(wxMouseEvent& event);
  void OnMouseMiddleClick(wxMouseEvent& WXUNUSED(event)) { ::ShowLap_Send(NULL, true); }
  void OnMouseRightClick(wxMouseEvent& event);
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& event);
  void OnMouseLeaving(wxMouseEvent& event);
  void OnMouseWheel(wxMouseEvent& event);
  void OnMenuClick(wxCommandEvent& event);

  wxMenu m_Context;           // context menu
  wxMenu* m_MenuNames;        // lapnames submenu
  int m_Context_ClickedLine;  // number of the line for which a context menu was created

  wxCoord Logical2DeviceX(wxCoord logicalPosX);
  wxCoord Device2LogicalX(wxCoord devicePosX);
  wxCoord Line2CoordY(int line) const;
  int Coord2LineY(wxCoord coord) const;
  int DecodeMouse(wxMouseEvent& event);

  void DrawAsymmetricGauge(wxDC& dc, wxPoint pos, wxSize size, float range, float value, wxColour colour, int steps);
  void DrawSymmetricGauge(wxDC& dc, wxPoint pos, wxSize size, float range, float value, wxColour colour, int steps);
  void DrawGaugeGrid(wxDC& dc, wxPoint pos, wxSize size, int steps);

  void SelectLine(int line);
  void DrawSelectionRectangle(wxDC& dc, int line);

  DECLARE_EVENT_TABLE()

public:
  cLegend(wxWindow* parent);
  virtual ~cLegend();

  virtual wxSize DoGetBestSize() const;

  virtual void UpdateAll();
  virtual void DoShowLap(cLap* WXUNUSED(lap), bool WXUNUSED(shown)) { Refresh(); }
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, bool scroll);

  void ShowDashboard(bool show);

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
