#ifndef _CGRAPHTOOLS_H_H_
#define _CGRAPHTOOLS_H_H_

#include "global.h"
#include "cgraphtools.h"
#include "cgraph_h.h"
#include <wx/choice.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/choice.h>

class cGraphView;

//-----------------------------------------------------------------------------
// A toolbar on a histogram

class cGraphToolsH : public cGraphTools
{
private:
  wxChoice* m_LogtypeChoice;    // dropdown box for the log type
  wxChoice* m_WheeltypeChoice;  // dropdown box to select the wheel type
  wxStaticText* m_WheelText;    // text for m_WheelChoice
  wxChoice* m_LapChoice;        // dropdown box for the lap
  wxStaticText* m_LapText;      // text for m_LapChoice

  void OnChangeLogtype(wxCommandEvent& event);
  void OnChangeLap(wxCommandEvent& event);

  virtual void DoEnableControls();

  DECLARE_EVENT_TABLE()

public:
  cGraphToolsH(cGraphView* parent, cGraphH* graph);
  virtual ~cGraphToolsH();

  virtual void UpdateAll();
};

#endif
