#include "cgraphtools_h.h"
#include "cgraphview.h"
#include "cmgr.h"

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cGraphToolsH, cGraphTools)
  EVT_CHOICE(ID_CHOICE_LOGTYPE_Y, cGraphToolsH::OnChangeLogtype)
  EVT_CHOICE(ID_CHOICE_WHEEL, cGraphToolsH::OnChangeLogtype)
  EVT_CHOICE(ID_CHOICE_LAP, cGraphToolsH::OnChangeLap)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------

cGraphToolsH::cGraphToolsH(cGraphView* parent, cGraphH* graph)
: cGraphTools(parent, graph)
{
  m_LogtypeChoice = CreateLogtypeControl(ID_CHOICE_LOGTYPE_Y);
  m_WheeltypeChoice = CreateWheeltypeControl(ID_CHOICE_WHEEL);
  m_WheelText = new wxStaticText(this, -1, _T("Wheel"));
  m_LapChoice = new wxChoice(this, ID_CHOICE_LAP, wxDefaultPosition, wxDefaultSize, 0, NULL);
  m_LapText = new wxStaticText(this, -1, _T("Show"));

  EnableControls();

  m_TopSizer->Insert(0, m_LogtypeChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(1, m_WheelText,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(2, m_WheeltypeChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));
  m_TopSizer->Insert(3, m_LapText,
      wxSizerFlags(1).Proportion(0).Center().Border(wxLEFT, 2 * BASE_MARGIN));
  m_TopSizer->Insert(4, m_LapChoice,
      wxSizerFlags(1).Proportion(0).Center().Border(wxALL, BASE_MARGIN));

  UpdateAll();
}

//-----------------------------------------------------------------------------

cGraphToolsH::~cGraphToolsH()
{
}

//-----------------------------------------------------------------------------

void cGraphToolsH::OnChangeLogtype(wxCommandEvent& WXUNUSED(event))
{
  cGraphH* graph = (cGraphH*)m_Graph;

  // retrieve user choices
  int log = GetLogtypeSelection(m_LogtypeChoice);
  int wheel = GetWheeltypeSelection(m_WheeltypeChoice);

  // correct invalid choices
  if (log < 0) {
    log = graph->GetLogtype();
    SetLogtypeSelection(m_LogtypeChoice, log);
  }
  if (wheel < 0) {
    wheel = graph->GetWheeltype();
    SetWheeltypeSelection(m_WheeltypeChoice, wheel);
  }

  if ((log == graph->GetLogtype()) && (wheel == graph->GetWheeltype())) return; // no change

  // update graph and state of controls
  graph->SetLogtype(log, wheel);
  EnableControls();
}

//-----------------------------------------------------------------------------

void cGraphToolsH::OnChangeLap(wxCommandEvent& WXUNUSED(event))
{
  cGraphH* graph = (cGraphH*)m_Graph;
  graph->SetLap(GetLapSelection(m_LapChoice));
}

//-----------------------------------------------------------------------------
// Re-read the data from the graph (to fill the controls on the toolbar)

void cGraphToolsH::UpdateAll()
{
  cGraphH* graph = (cGraphH*)m_Graph;

  SetLogtypeSelection(m_LogtypeChoice, graph->GetLogtype());
  SetWheeltypeSelection(m_WheeltypeChoice, graph->GetWheeltype());
  FillLapSelection(m_LapChoice, graph->GetLap());

  EnableControls();

  Layout(); // re-filling m_LapChoice may change its width
}

//-----------------------------------------------------------------------------
// Enable/disable the controls

void cGraphToolsH::DoEnableControls()
{
  int sel = GetLogtypeSelection(m_LogtypeChoice);
  m_WheeltypeChoice->Enable((sel >= 0) && (cCarState::IsPerWheel(sel)));
  m_WheelText->Enable(m_WheeltypeChoice->IsEnabled());

  m_LapChoice->Enable(m_LapChoice->GetCount() > 0);
  m_LapText->Enable(m_LapChoice->IsEnabled());
}
