#ifndef _CGRAPH_Y_H_
#define _CGRAPH_Y_H_

#include "global.h"
#include "cgraph.h"
#include <wx/menu.h>

//-----------------------------------------------------------------------------
// A graph

class cGraphY : public cGraph
{
private:
  // graph contents
  int m_Logtype;                  // type of log-data to be shown
  int m_Wheel;                    // index of the wheel for which the data must be shown
  cLap* m_DeltaLap;               // delta-lap (i.e. plot differences with data from this lap)
  bool m_DeltaMode;               // did the user choose delta mode?

  // event handlers
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& event);
  void OnMouseLeaving(wxMouseEvent& event);
  void OnPaint(wxPaintEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

protected:
  virtual float GetSelectionStart() { return GetGridStartX(); }
  virtual float GetSelectionEnd() { return GetGridEndX(); }

  virtual rbbmode_t GetRbbMode(wxMouseEvent& event);
  virtual void OnMouseClickRelease(wxPoint pos);

public:
  cGraphY(cGraphView* parent);
  virtual ~cGraphY();

  virtual void DoSync();

  // manage the set of curves
  virtual void AddCurve(cLap* lap);
  virtual void DeleteCurve(cLap* lap);
  virtual void DeleteAllCurves();

  virtual bool IsIntegerX() { return false; }
  virtual bool IsIntegerY() { return cCarState::IsInteger(m_Logtype); }

  int GetLogtype() const { return m_Logtype; }
  int GetWheeltype() const { return m_Wheel; }
  void SetLogtype(int log, int wheel);
  void SetDeltaLap(cLap* lap);
  cLap* GetDeltaLap() const { CHECK_PTR_NULL(m_DeltaLap); return m_DeltaLap; }
  void SetDeltaMode(bool mode) { m_DeltaMode = mode; }
  bool GetDeltaMode() const { return m_DeltaMode; }

  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, bool scroll);
  virtual void DoSetTrackSelection(float start, float end);

  virtual wxString GetCurveValueAtPointer(cLap* lap);

  virtual wxString SaveSettings() const;
  virtual void LoadSettings(const wxString& settings);

  virtual wxString GetUnitsX() { return wxString(_T("m")); }
  virtual wxString GetUnitsY() { return cCarState::GetLogtypeUnits(m_Logtype); }
};

#endif
