#ifndef _CFILEDLG_H_
#define _CFILEDLG_H_

#include "global.h"
#include <wx/dialog.h>
#include <wx/listctrl.h>
#include <wx/sizer.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/menu.h>
#include <wx/dynarray.h>

class wxRegConfig;
class cFileDlgItemData;

WX_DEFINE_ARRAY(cFileDlgItemData*, cFileDlgItemDataPtrArray);

//-----------------------------------------------------------------------------
// The custom "Open File" dialog

class cFileDlg : public wxDialog
{
private:
  wxString m_Dir;             // the current directory with RAF files
  wxString m_CarFilter;       // the applied car filter (empty if none)
  wxString m_TrackFilter;     // the applied track filter (empty if none)
  wxString m_CurrentTrack;    // the current track (for adding files); also filters track choices

  wxListView* m_List;         // the list showing the files
  cFileDlgItemDataPtrArray m_ItemData; // item data attached to the items in the file list
  int m_SortKey;              // indicates the column on which the list is sorted
                              // (1 = 1st, 2 = 2nd etc.; negative means reverse order)

  wxChoice* m_CarChoice;      // dropdown box for the car filter
  wxChoice* m_TrackChoice;    // dropdown box for the track filter
  wxButton* m_AllBtn;         // "All" button
  wxButton* m_OpenBtn;        // "Open" button
  wxButton* m_CancelBtn;      // "Cancel" button
  wxButton* m_FolderBtn;      // "Folder" button
  wxButton* m_DeleteBtn;      // "Delete" button
  wxButton* m_RenameBtn;      // "Rename" button

  wxBoxSizer* m_FilterSizer;  // sizer for the filters
  wxBoxSizer* m_ButtonSizer;  // sizer for the buttons
  wxBoxSizer* m_TopSizer;     // top-level sizer

  wxMenu m_Context;           // context menu

  void ReadFiles();
  void DoSort();

  wxString GetColumnText(int col) const;
  void SetColumnText(int col, const wxString& text);
  void SetSortKey(int key);

  void EnableButtons();
  void DeleteSelection();
  void RenameSelection();
  void SelectAll() { for (int i = 0; i < m_List->GetItemCount(); i++) m_List->Select(i); }

  void OnButton(wxCommandEvent& event);
  void OnColClick(wxListEvent& event);
  void OnItemActivate(wxListEvent& event);
  void OnItemRightClick(wxListEvent& event);
  void OnChangeSelection(wxListEvent& WXUNUSED(event)) { EnableButtons(); }
  void OnChangeCarFilter(wxCommandEvent& event);
  void OnChangeTrackFilter(wxCommandEvent& event);
  void OnKeyDown(wxListEvent& event);
  void OnMenuClick(wxCommandEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cFileDlg(wxWindow* parent);
  virtual ~cFileDlg();

  wxString GetDirectory() const { return m_Dir; }

  int DoShowModal(const wxString& caption, const wxString& directory, bool add);

  void GetPaths(wxArrayString& paths) const;

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

//-----------------------------------------------------------------------------

class cFileDlgItemData
{
public:
  wxString filename;
  wxString name;
  wxString car;
  wxString track;
  int laptime;
  wxString filedate;
  wxString player;
};

#endif
