#include "ccurve.h"
#include "cgraph.h"

#include <wx/arrimpl.cpp>
WX_DEFINE_OBJARRAY(cCurveArray);

//-----------------------------------------------------------------------------

cCurve::cCurve(cLap* lap)
{
  m_Shown = true;
  m_Connect = true;

  m_Lap = lap;
  CHECK_PTR(m_Lap);
  wxASSERT(m_Lap != NULL);
  wxASSERT(m_Lap->GetStateCount() > 1);

  m_Pen = wxPen(m_Lap->GetColour(), 1, wxSOLID);

  m_MinX = 0.0f;
  m_MaxX = 0.0f;
  m_MinY = 0.0f;
  m_MaxY = 0.0f;
}

//-----------------------------------------------------------------------------

cCurve::~cCurve()
{
}

//-----------------------------------------------------------------------------
// Re-calculate the bounding box in a certain part of the lap
// - start, end = start and end of the part of the lap
// - minX, maxX, minY, maxY = receive the calculated values

void cCurve::GetBbox(float start, float end, float& minX, float& maxX, float& minY, float& maxY)
{
  CHECK_THIS;
  CHECK_PTR(m_Lap);

  float x, y;
  Rewind(start, end, MAX_REWIND_POINTS);
  if (!GetNextPoint(x, y)) {
    // no samples - set default
    minX = -1.0f;
    maxX = 1.0f;
    minY = -1.0f;
    maxY = 1.0f;
    return;
  }

  // scan samples
  minX = x;
  maxX = x;
  minY = y;
  maxY = y;
  while (GetNextPoint(x, y)) {
    ::Minimise(minX, x);
    ::Maximise(maxX, x);
    ::Minimise(minY, y);
    ::Maximise(maxY, y);
  }
}

//-----------------------------------------------------------------------------
// Re-calculate the bouding box

void cCurve::AdjustBbox()
{
  GetBbox(0.0f, m_Lap->GetTrackLength(), m_MinX, m_MaxX, m_MinY, m_MaxY);
}

//-----------------------------------------------------------------------------
// Plot the curve in the graph
// - dc = current device context
// - graph = graph to plot in
// - start, end = start and end of the part of the lap to be plotted

void cCurve::Plot(wxDC& dc, cGraph& graph, float start, float end)
{
  CHECK_PTR(m_Lap);
  if (!IsShown()) return;

  dc.SetPen(m_Pen);

  Rewind(start, end, graph.GetSize().GetWidth() / 2);

  float X, Y;
  wxPoint last, next;
  if (!GetNextPoint(X, Y)) return;
  last.x = graph.Value2CoordX(X);
  last.y = graph.Value2CoordY(Y);
  while (GetNextPoint(X, Y)) {
    next.x = graph.Value2CoordX(X);
    next.y = graph.Value2CoordY(Y);

    if (m_Connect) {
      dc.DrawLine(last.x, last.y, next.x, next.y);
    }
    else {
      dc.DrawPoint(next.x, next.y);
    }

    last = next;
  }
}
