#include "ccolourlist.h"

//-----------------------------------------------------------------------------
// Static members

wxString cColourList::s_ColourNames[] = {
  _T("BLUE"),
  _T("RED"),
  _T("FOREST GREEN"),
  _T("CORAL"),
  _T("BROWN"),
  _T("DARK ORCHID"),
  _T("MAGENTA"),
  _T("SPRING GREEN"),
  _T("MEDIUM TURQUOISE"),
  _T("MEDIUM VIOLET RED"),
  _T("SLATE BLUE"),
  _T("ORANGE RED"),
  _T("ORCHID"),
  _T("TAN"),
  _T("PURPLE"),
  _T("GREEN"),
  _T("VIOLET RED"),
  _T("YELLOW")
};

size_t cColourList::s_ColourCount = sizeof(cColourList::s_ColourNames) / sizeof(wxString);

wxArrayInt cColourList::s_Usage;

//-----------------------------------------------------------------------------

cColourList::cColourList()
{
}

//-----------------------------------------------------------------------------

cColourList::~cColourList()
{
}

//-----------------------------------------------------------------------------
// Allocate a new colour (preferably not currently in use)

wxColour cColourList::Alloc()
{
  // initialize usage counters, if needed
  if (s_Usage.GetCount() < s_ColourCount) s_Usage.SetCount(s_ColourCount, 0);

  // find the usage counter with the lowest value
  int id = 0;
  for (size_t c = 1; c < s_ColourCount; c++) {
    if (s_Usage[c] < s_Usage[id]) id = c; // set colour
  }

  // update usage count
  s_Usage[id] += 1;

  return wxTheColourDatabase->Find(s_ColourNames[id]);
}

//-----------------------------------------------------------------------------
// Deallocate a colour

void cColourList::Free(wxColour& colour)
{
  for (size_t id = 0; id < s_ColourCount; id++) {
    if (colour == wxTheColourDatabase->Find(s_ColourNames[id])) {
      // update usage count
      wxASSERT(s_Usage[id] >= 0);
      s_Usage[id] -= 1;
      return;
    }
  }
}
