#ifndef _CRULER_H_
#define _CRULER_H_

#include "global.h"
#include "cgraph.h"
#include <wx/window.h>

//-----------------------------------------------------------------------------
// The horizontal or vertical ruler accompanying a graph

class cRuler : public wxWindow
{
private:
  cGraph* m_Graph;  // the graph to which the ruler belongs
  int m_Side;       // to which side of the graph is the ruler located?
  bool m_ToolTips;  // enable tooltips?

  void OnPaint(wxPaintEvent& event);

  static wxCoord GetTickSize(int index, int count);

  DECLARE_EVENT_TABLE()

public:
  ENABLE_OBJCHECKER

  cRuler(wxWindow* parent, int side);
  virtual ~cRuler();

  void OnMouseEvent(wxMouseEvent& event);

  void SetGraph(cGraph* graph);
  void SetText(const wxString& text);

  void EnableToolTips(bool flag);
};

#endif
