#ifndef _CPRESETS_H_
#define _CPRESETS_H_

#include "global.h"
#include "cpane.h"
#include <wx/sizer.h>
#include <wx/button.h>

//-----------------------------------------------------------------------------
// The pane to choose presets

class cPresets : public cPane
{
private:
  wxBoxSizer* m_TopSizer;

  wxArrayString m_Names;      // the name of each preset
  wxArrayInt m_Shortcuts;     // the keyboard shortcut
  wxArrayString m_Panes;      // the perspective
  wxArrayString m_Graphs;     // the graphs

  void OnButton(wxCommandEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cPresets(wxWindow* parent);
  virtual ~cPresets();

  virtual wxSize DoGetBestSize() const { return GetMinSize(); }

  inline size_t GetCount() const { return m_Names.GetCount(); }
  const wxString GetPresetName(size_t index) const;
  int Find(const wxString& name);
  inline int GetShortcut(size_t index) { return m_Shortcuts[index]; }
  inline const wxString& GetPanes(size_t index) const { return m_Panes[index]; }
  inline const wxString& GetGraphs(size_t index) const { return m_Graphs[index]; }

  size_t AddPreset(const wxString& name, const wxString& panes, const wxString& graphs);
  void ReplacePreset(size_t index, const wxString& panes, const wxString& graphs);
  void DeletePreset(size_t index);

  void LoadConfig(wxRegConfig* config, const wxString& key);
  void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
