#ifndef _CGRAPHTOOLS_XY_H_
#define _CGRAPHTOOLS_XY_H_

#include "global.h"
#include "cgraphtools.h"
#include "cgraph_xy.h"
#include <wx/choice.h>
#include <wx/checkbox.h>
#include <wx/sizer.h>
#include <wx/stattext.h>

class cGraphView;

//-----------------------------------------------------------------------------
// A toolbar on a graph

class cGraphToolsXY : public cGraphTools
{
private:
  wxChoice* m_LogtypeXChoice;  // dropdown box for the log type in the X direction
  wxChoice* m_LogtypeYChoice;  // dropdown box for the log type in the Y direction
  wxChoice* m_WheeltypeChoice; // dropdown box to select the wheel
  wxStaticText* m_WheelText;   // text for m_WheeltypeChoice
  wxCheckBox* m_ConnectCheck;  // 'connect' checkbox

  void OnChangeLogtype(wxCommandEvent& event);
  void OnToggleConnect(wxCommandEvent& event);

  virtual void DoEnableControls();

  DECLARE_EVENT_TABLE()

public:
  cGraphToolsXY(cGraphView* parent, cGraphXY* graph);
  virtual ~cGraphToolsXY();

  virtual void UpdateAll();
};

#endif
