#ifndef _CCURVE_XY_H_
#define _CCURVE_XY_H_

#include "global.h"
#include "ccurve.h"
#include "ccarstate.h"
#include "clap.h"
#include <wx/dc.h>

class cGraph;

//-----------------------------------------------------------------------------
// A curve in an XY-graph

class cCurveXY
: public cCurve
{
private:
  int m_LogtypeX;       // type of log-data to be shown in the X dimension
  int m_LogtypeY;       // type of log-data to be shown in the Y dimension
  int m_Wheel;          // index of the wheel for which the data must be shown

  size_t m_NextState;   // index of next state to be plotted
  float m_LastState;    // distance_in_lap of last state to be plotted
  bool m_Finished;      // have we finished plotting?

public:
  cCurveXY(cLap* lap);
  virtual ~cCurveXY();

  virtual void Rewind(float start, float end, size_t maxPoints);
  virtual bool GetNextPoint(float& x, float& y);
  virtual bool GetValueAt(float distance, float& x, float& y);

  void SetLogtype(int log_x, int log_y, int wheel);
};

#endif
