#include "ccurve_xy.h"
#include "cgraph.h"

//-----------------------------------------------------------------------------

cCurveXY::cCurveXY(cLap* lap)
: cCurve(lap)
{
  m_LogtypeX = LOGTYPE_FIRST;
  m_LogtypeY = LOGTYPE_FIRST;
  m_Wheel = WHEELTYPE_FIRST;

  AdjustBbox();
}

//-----------------------------------------------------------------------------

cCurveXY::~cCurveXY()
{
}

//-----------------------------------------------------------------------------
// Prepare the curve's data for plotting
// - start, end = start and end of the part of the lap to be plotted
// - maxPoints = maximum number of plot points

void cCurveXY::Rewind(float start, float end, size_t WXUNUSED(maxPoints))
{
  wxASSERT(end > start);

  m_NextState = m_Lap->FindStateAt(start);
  m_LastState = end;
  m_Finished = false;
}

//-----------------------------------------------------------------------------
// Get the next point on the curve
// x, y = receive the coordinates of the point

bool cCurveXY::GetNextPoint(float& x, float& y)
{
  if (m_Finished) return false; // no more points to plot

  if (m_NextState >= m_Lap->GetStateCount()) {
    // past last data point
    m_NextState = m_Lap->GetStateCount() - 1;
    m_Finished = true; // no more points after this one
  }

  if (m_Lap->GetState(m_NextState)->GetDistance() > m_LastState) m_Finished = true;
  x = m_Lap->GetState(m_NextState)->GetLogData(m_LogtypeX, m_Wheel);
  y = m_Lap->GetState(m_NextState)->GetLogData(m_LogtypeY, m_Wheel);

  m_NextState += 1;
  return true;
}

//-----------------------------------------------------------------------------
// Get the curve values corresponding with a certain point in the lap
// - distance = distance-in-lap
// - x, y = X and Y values of the curve at that point

bool cCurveXY::GetValueAt(float distance, float& x, float& y)
{
  x = m_Lap->GetLogDataAt(distance, m_LogtypeX, m_Wheel);
  y = m_Lap->GetLogDataAt(distance, m_LogtypeY, m_Wheel);
  return true;
}

//-----------------------------------------------------------------------------
// Set the type of data that is shown
// - log_x, log_y = type of log-data for X and Y dimension
// - wheel = index of the wheel for which the data must be shown

void cCurveXY::SetLogtype(int log_x, int log_y, int wheel)
{
  wxASSERT(log_x >= LOGTYPE_FIRST);
  wxASSERT(log_x < LOGTYPE_LAST);
  wxASSERT(log_y >= LOGTYPE_FIRST);
  wxASSERT(log_y < LOGTYPE_LAST);
  wxASSERT(wheel >= WHEELTYPE_FIRST);
  wxASSERT(wheel < WHEELTYPE_LAST);

  m_LogtypeX = log_x;
  m_LogtypeY = log_y;
  m_Wheel = wheel;
  AdjustBbox();
}
