#include "capp.h"
#include "cmgr.h"
#include "cmainframe.h"
#include <wx/utils.h>

IMPLEMENT_APP(cApp)

// time (in ms) to wait until re-trying to pass the filename to another instance of the app
#define DDE_RETRY_DELAY 500

// maximum number of retries
#define DDE_MAX_RETRIES 20

//-----------------------------------------------------------------------------
// Application initializing

bool cApp::OnInit()
{
  m_Frame = NULL;
  m_Config = NULL;

  SetAppFolder();
  SetAppName(_T(APPLICATION_NAME));

  // process command-line parameters (currently only one: the name of a RAF file to load)
  wxString infile;
  if (argc > 1) infile = argv[1];
  wxASSERT(argc <= 2); // no other parameters allowed

  // check if another program instance is already running
  const wxString instanceName = wxString::Format("%s-%s", _T(APPLICATION_NAME), wxGetUserId().c_str());
  m_Checker = new wxSingleInstanceChecker(instanceName);

  if (m_Checker->IsAnotherRunning()) {
    // pass the filename to that instance via DDE, then quit

    if (infile.IsEmpty()) infile = _T("-"); // DDE will fail on an empty name, so use a dummy name

    wxLogNull logNone; // suppress logged errors from failed DDE attempts
    wxDDEClient client;
    bool success = false;
    // we need to try repeatedly, because an attempt may time out when the main instance is busy
    for (int r = 0; r < DDE_MAX_RETRIES; r++) {
      wxConnectionBase* conn = client.MakeConnection(wxEmptyString, DDE_SERVICE_NAME, DDE_TOPIC_OPENFILE);
      if (conn != NULL) {
        success = conn->Execute(infile.c_str(), infile.Length());
        conn->Disconnect();
        delete conn;
        if (success) break;
        ::wxMilliSleep(DDE_RETRY_DELAY);
      }
    }

    if (success) return false;
    // if DDE was unsuccessful, then we continue with this instance
  }

  // normal application initialisation
  m_Config = new wxConfig(_T(APPLICATION_NAME)); // init config file

  // create and show the main frame
  long posX = wxDefaultPosition.x;
  long posY = wxDefaultPosition.y;
  long sizeX = 800;
  long sizeY = 500;
  CONFIG->Read(_T("/windows/main/pos/x"), &posX);
  CONFIG->Read(_T("/windows/main/pos/y"), &posY);
  CONFIG->Read(_T("/windows/main/size/x"), &sizeX);
  CONFIG->Read(_T("/windows/main/size/y"), &sizeY);
  m_Frame = new cMainFrame(_T(APPLICATION_NAME), wxPoint(posX, posY), wxSize(sizeX, sizeY), infile);
  m_Frame->Show(true);
  SetTopWindow(m_Frame);

  // register the DDE server
  m_DDEServer.Create(DDE_SERVICE_NAME);

  // done
  return true;
}

//-----------------------------------------------------------------------------
// Application closing

int cApp::OnExit()
{
  // write config entries
  delete m_Config;
  m_Config = NULL;

  // destroy the cMgr object
  delete MGR;

  // destroy the instance object
  delete m_Checker;

  // check object count
  wxASSERT(cObjChecker::GetCount() == 0);

  return 0;
}

//-----------------------------------------------------------------------------
// Derive the value of m_AppFolder

void cApp::SetAppFolder()
{
  // get executable name from command line
  wxString argv0(wxTheApp->argv[0]);

  // is it an absolute path?
  if (wxIsAbsolutePath(argv0))
  {
    m_AppFolder = wxPathOnly(argv0);
    return;
  }

  // is it a relative path?
  wxString fn = wxGetCwd();
  if (fn.Last() != wxFILE_SEP_PATH) fn += wxFILE_SEP_PATH;
  fn += argv0;
  if (wxFileExists(fn))
  {
    m_AppFolder = wxPathOnly(fn);
    return;
  }

  // search with PATH environment variable
  wxPathList pathList;
  pathList.AddEnvList(_T("PATH"));
  fn = pathList.FindAbsoluteValidPath(argv0);
  if (!fn.IsEmpty())
  {
    m_AppFolder = wxPathOnly(fn);
    return;
  }

  // failed
  m_AppFolder = wxEmptyString;
  return;
}
