<?php

function PIE_settings()
  {
    return array('flags'      => ISF_LOCAL,
                 'insimname'  => 'ObjectGroups');
  }
  
function PIE_start()
  {
    $PIE = PIE::connect();
    
    $PIE->set('loadid',           17);
    $PIE->set('saveid',           18);
    $PIE->set('savenameid',       19);
    $PIE->set('savename',         'default');
    $PIE->set('panelbaseid',      20);
    $PIE->set('maxgroups',        30);
    $PIE->set('paneltop',         7);
    $PIE->set('panelleft',        134);
    $PIE->set('panelwidth',       40);
    $PIE->set('panelbheight',     5);
    
    $PIE->set('groups',           array());
    $PIE->set('buttonspergroup',  5);
    
    ///////////
    
    if (file_exists(PIE_SCRIPTDIR.'objectgroups.default.dat'))
      loadfromfile();
    
    drawpanel();
  }
  
function PIE_BTC($data)
  {
    $PIE = PIE::connect();
    
    $lid = $PIE->get('loadid');
    $sid = $PIE->get('saveid');
    $bid = $PIE->get('panelbaseid');
    $max = $PIE->get('maxgroups');
    $bpg = $PIE->get('buttonspergroup');
    
    // load
    if ($data['ClickID'] == $lid)
      {
        loadfromfile();
        drawpanel();
      }
    
    // save
    if ($data['ClickID'] == $sid)
      {
        $name = $PIE->get('savename');
        $filename = 'objectgroups.'.$name.'.dat';
        $gdata = $PIE->get('groups');
        $ndata = $PIE->get('groupnames');
        $jdata = json_encode(array('g'=>$gdata,'n'=>$ndata));
        
        $fp = fopen(PIE_SCRIPTDIR.$filename, 'w');
        if (fwrite($fp, $jdata))
          PIE_saylocal('Saved "'.$filename.'"');
        else
          PIE_saylocal('Save failed');
        fclose($fp);      

        drawpanel();
      }
    
    // group funcs
    if (($data['ClickID'] < $bid) || ($data['ClickID'] > ($bid+($max*$bpg))))
      return;
    
    $cid    = $data['ClickID'] - $bid;
    $group  = floor($cid / $bpg);
    $type   = $cid % $bpg;
    
    switch ($type)
      {
        case 2: // 2 = set button
          $PIE->set('AXMtargetgroup', $group);
          PIE_sendTTC(TTC_SEL);
          break;
          
        case 3: // 3 = get button         
          sendobjects($group);
          break;
         
        case 4: // 4 = place button
          sendobjects($group, true);
          break;
      }
  }
  
function PIE_BTT($data)
  {
    $PIE = PIE::connect();
    
    $sid = $PIE->get('savenameid');
    $bid = $PIE->get('panelbaseid');
    $max = $PIE->get('maxgroups');
    $bpg = $PIE->get('buttonspergroup');
    
    if ($data['ClickID'] == $sid)
      {
        $name = preg_replace('~[^a-z0-9]~', '', strtolower($data['Text']));
        $PIE->set('savename', $name);
        drawpanel();
        return;
      }    
    
    if (($data['ClickID'] < $bid) || ($data['ClickID'] > ($bid+($max*$bpg))))
      return;
    
    $cid    = $data['ClickID'] - $bid;
    $group  = floor($cid / $bpg);
    $type   = $cid % $bpg;
    
    if ($type) // 0 = name field
      return;
    
    $PIE->seta('groupnames', $group, $data['Text']);
    
    drawpanel();
  }
  
function PIE_AXM($data)
  {
    if ($data['PMOAction'] != PMO_TTC_SEL)
      return;
    
    $PIE = PIE::connect();
    
    $target = $PIE->get('AXMtargetgroup');
    $PIE->seta('groups', $target, $data['Info']);
    
    drawpanel();
  }
  
function sendobjects($groupid, $layout=false)
  {
    $PIE = PIE::connect();
    
    $action = PMO_SELECTION;
    if ($layout)
      $action = PMO_ADD_OBJECTS;
    
    $data = $PIE->get('groups', $groupid);
    if (empty($data))
      return;
      
    $packet = array('Type'      => ISP_AXM,
                    'PMOAction' => $action,
                    'Info'      => $data);
    PIE_sendpacket($packet);
  }
    
function loadfromfile()
  {
    $PIE = PIE::connect();
    
    $name = $PIE->get('savename');
    $filename = 'objectgroups.'.$name.'.dat';
    $loadok = true;
    
    if (!$fp = fopen(PIE_SCRIPTDIR.$filename, 'r'))
      {
        PIE_saylocal('Unable to open "'.$filename.'"');
        $loadok = false;
      }
      
    if ($loadok)
      {
        if (!$raw = fread($fp, 1440000))
          {
            PIE_saylocal('Unable to read "'.$filename.'"');
            $loadok = false;
          }            
      }
    
    if ($loadok)
      {
        $data = json_decode($raw, true);
        
        if (empty($data['g']))
          {
            PIE_saylocal('Invalid data in "'.$filename.'"');
            $loadok = false;
          }            
      }
      
    if ($loadok)
      {
        
        $PIE->set('groups',     $data['g']);
        $PIE->set('groupnames', $data['n']);
        PIE_saylocal('Loaded "'.$filename.'"');
      }
    
    fclose($fp);
  }
  
function drawpanel()
  {
    $PIE = PIE::connect();
    $bid      = $PIE->get('panelbaseid');
    $lid      = $PIE->get('loadid');
    $sid      = $PIE->get('saveid');
    $nid      = $PIE->get('savenameid');
    $sname    = $PIE->get('savename');      
    $max      = $PIE->get('maxgroups');
    $bpg      = $PIE->get('buttonspergroup');
    $top      = $PIE->get('paneltop');
    $left     = $PIE->get('panelleft');
    $width    = $PIE->get('panelwidth');
    $bheight  = $PIE->get('panelbheight');
    
    for ($i=0; $i<$max; $i++)
      {
        $groupname = $PIE->get('groupnames', $i);
        if (empty($groupname))
          $groupname = 'Group '.$i;
        else
          $groupname = '^7'.$groupname;
        
        $groupsize = 0;
        $group = $PIE->get('groups', $i);
        if (!empty($group))
          $groupsize = sizeof($group);
        
        // name button
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $bid + ($i * $bpg),
                        'BStyle'   => ISB_DARK | ISB_CLICK | ISB_LEFT,
                        'T'        => $top + ($i * $bheight),
                        'L'        => $left,
                        'W'        => $width - 18,
                        'H'        => $bheight,
                        'Text'     => $groupname,
                        'TypeIn'   => 30);
        PIE_sendpacket($packet);
        
        // object count button
        $text = $groupsize;
        if ($groupsize)
          $text = '^7'.$text;
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $bid + ($i * $bpg) + 1,
                        'BStyle'   => ISB_DARK | ISB_RIGHT,
                        'T'        => $top + ($i * $bheight),
                        'L'        => $left + ($width - 18),
                        'W'        => 4,
                        'H'        => $bheight,
                        'Text'     => $text);
        PIE_sendpacket($packet);        
        
        // set button
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $bid + ($i * $bpg) + 2,
                        'BStyle'   => ISB_DARK | ISB_CLICK,
                        'T'        => $top + ($i * $bheight),
                        'L'        => $left + ($width - 14),
                        'W'        => 4,
                        'H'        => $bheight,
                        'Text'     => 'set');  
        PIE_sendpacket($packet);
        
        // get button
        $style = ISB_DARK;
        $text = '';
        if ($groupsize)
          {
            $style |= ISB_CLICK;
            $text = 'get';
          }        
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $bid + ($i * $bpg) + 3,
                        'BStyle'   => $style,
                        'T'        => $top + ($i * $bheight),
                        'L'        => $left + ($width - 10),
                        'W'        => 4,
                        'H'        => $bheight,
                        'Text'     => $text);
        PIE_sendpacket($packet);
        
        // place button
        $style = ISB_DARK;
        $text = '';
        if ($groupsize)
          {
            $style |= ISB_CLICK;
            $text = 'place';
          }        
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $bid + ($i * $bpg) + 4,
                        'BStyle'   => $style,
                        'T'        => $top + ($i * $bheight),
                        'L'        => $left + ($width - 6),
                        'W'        => 6,
                        'H'        => $bheight,
                        'Text'     => $text);
        PIE_sendpacket($packet);
      }   

    // file row

    // (file)name button
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $nid,
                    'BStyle'   => ISB_DARK | ISB_CLICK | ISB_LEFT,
                    'T'        => $top + ($max * $bheight),
                    'L'        => $left,
                    'W'        => $width - 16,
                    'H'        => $bheight,
                    'Text'     => chr(0).'filename:'.chr(0).$sname,
                    'TypeIn'   => 30);
    PIE_sendpacket($packet);

    // save/load buttons
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $sid,
                    'BStyle'   => ISB_DARK | ISB_CLICK,
                    'T'        => $top + ($max * $bheight),
                    'L'        => $left + ($width - 16),
                    'W'        => 8,
                    'H'        => $bheight,
                    'Text'     => 'save');  
    PIE_sendpacket($packet);
    
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $lid,
                    'BStyle'   => ISB_DARK | ISB_CLICK,
                    'T'        => $top + ($max * $bheight),
                    'L'        => $left + ($width - 8),
                    'W'        => 8,
                    'H'        => $bheight,
                    'Text'     => 'load');  
    PIE_sendpacket($packet);

  }
  