<?php

function PIE_settings()
  {
    return array('flags'              => ISF_LOCAL,
                 'insimname'          => 'FuelMon',
                 'outgaugehost'       => '127.0.0.1',
                 'outgaugeport'       => 49999);
  }
  
function PIE_start()
  {
    $PIE = PIE::connect(); 
    
    $PIE->set('top',          140); // top of panel
    $PIE->set('baseclickid',  30);  // change if incompatible with other insims
    
    $PIE->set('racelaps',     0);
    $PIE->set('lastlapfuel',  0);
    $PIE->set('lastfuelraw',  0);
    $PIE->set('lastfuel',     0);
    $PIE->set('lastspeed',    0);
    $PIE->set('lastkspeed',   0);
    $PIE->set('lastgear',     0);
    $PIE->set('lastpower',    0);
    
    clearbuttons();
  }
  
function PIE_RST($data)
  {
    resetfuelcounter();
  }
  
function PIE_NPL($data)
  {
    if (!PIE_isme($data['PLID']))
      return;
    
    resetfuelcounter();
    clearbuttons(true);
  }
  
function PIE_STA($data)
  {    
    $clearbuttons = false;
  
    if (!($data['Flags'] & ISS_GAME)) // lobby etc screens
      $clearbuttons = true;
      
    // extra conditions?
      
    if ($clearbuttons)
      clearbuttons();
      
  }
  
function PIE_LAP($data)
  {
    // skip viewed others - they will wonk next lap data
    if (!PIE_isme($data['PLID']))
      return;
    
    $PIE = PIE::connect();
    $top = $PIE->get('top');
    $bid = $PIE->get('baseclickid');
    $lfr = $PIE->get('lastfuelraw');
    $llf = $PIE->get('lastlapfuel');
      $PIE->set('lastlapfuel', $lfr);
      
    $STA = $PIE->get('PIE_STA');
        
    $lastlapuse   = '-';
    $lapbudget    = '-';
    $range        = '-';
    
    // last lap usage
    $llu = 0;
    if (!empty($llf))
      {
        $llu = $llf - $lfr;
        $lastlapuse = number_format(($llu * 100), 2).'%';
      }
     
    // range
    if (!empty($llu))
      {        
        $r = $data['LapsDone'] + ($lfr / $llu);
        $range = number_format($r, 2);
        
        // highlight if more than racelaps
        if (!empty($STA['Laps']))
          {
            if ($STA['Laps'] > $r)
              $range = '^1'.$range;
          }
      }
      
    // lap budget
    if (!empty($STA['Laps']))
      {
        $lapsleft = $STA['Laps'] - $data['LapsDone'];
        if ($lapsleft)
          $lapbudget = number_format((($lfr / $lapsleft)*100), 2).'%';
      }
      
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 1,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 101,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => $lastlapuse));
    
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 2,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 107,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => $range));
                          
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 3,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 95,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => $lapbudget));
  }
  
function PIE_OutGauge($data)
  {
    $PIE = PIE::connect();
    
    $lasttime   = $PIE->get('lastOutGauge');
    $top        = $PIE->get('top');
    $bid        = $PIE->get('baseclickid');
    $thistime   = $data['Time'];
    
    
    $PIE->set('lastOutGauge', $thistime);
    if ($lasttime > $thistime)
      return;
    
    // skip in replay above 2x speed (anti-lag / anti-crash measure)
    $STA = $PIE->get('PIE_STA');
    if (!empty($STA['ReplaySpeed']) && ($STA['ReplaySpeed'] > 2))
      return;
    
    // live fuel/power  [remaining]
    $lf = $PIE->get('lastfuel');
    $fuel = number_format(($data['Fuel']*100), 2);
    if ($fuel != $lf)
      {
        PIE_sendpacket(array( 'Type'     => ISP_BTN,
                              'ClickID'  => $bid,
                              'BStyle'   => ISB_RIGHT | ISB_DARK,
                              'T'        => $top,
                              'L'        => 87,
                              'W'        => 8,
                              'H'        => 5,
                              'Text'     => $fuel.'%'));
        $PIE->set('lastfuel', $fuel);
      }
    
    // for best accuracy in _LAP 
    $PIE->set('lastfuelraw', $data['Fuel']);
    
    // set llf if not set (lap 0 on start/join/reset)
    $llf = $PIE->get('lastlapfuel');
    if (empty($llf))
      $PIE->set('lastlapfuel', $data['Fuel']);
    
  }   

function resetfuelcounter()
  {    
    $PIE = PIE::connect();    
    $PIE->set('lastlapfuel',  0);
    $PIE->set('lastfuelraw',  0);
  }
  
function clearbuttons($setblank=false)
  {
    if (!$setblank)
      { 
        PIE_sendpacket(array( 'Type' => ISP_BFN,
                              'SubT' => BFN_CLEAR));
        return;
      }    
                          
    $PIE = PIE::connect();
    $top = $PIE->get('top');
    $bid = $PIE->get('baseclickid');    
                          
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 87,
                          'W'        => 8,
                          'H'        => 5,
                          'Text'     => '%'));                            

    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 1,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 101,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => '%'));
    
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 2,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 107,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => '-'));
    
    PIE_sendpacket(array( 'Type'     => ISP_BTN,
                          'ClickID'  => $bid + 3,
                          'BStyle'   => ISB_RIGHT | ISB_DARK,
                          'T'        => $top,
                          'L'        => 95,
                          'W'        => 6,
                          'H'        => 5,
                          'Text'     => '%'));
  }
  