<?php
	interface Delegate
	{
		function Invoke();
	}
	
	class SingleCastDelegate implements Delegate
	{
		public $return_type	= NULL;
		public $param_list	= NULL;
		
		function __construct($methodReference)
		{
			if ($this->return_type === NULL || strtolower($this->return_type) == 'void') {
				$this->return_type = 'NULL';
			}
			
			$this->method		= $methodReference;
			$this->param_count	= sizeof(preg_split('/\s*,\s*/', $this->param_list, -1, PREG_SPLIT_NO_EMPTY));
			
			$this->checkSignature();
		}
		
		function checkSignature()
		{
			if (is_array($this->method)) {
				$signature = get_class($this->method[0]) . '_' . $this->method[1] . '_signature';
			}
			else {
				$signature = $this->method . '_signature';
			}
			
			if (FALSE == function_exists($signature)) {
				$this->createSignature($signature);
			}
			
			$pList = preg_split('/\s*,\s*/', $this->param_list, -1, PREG_SPLIT_NO_EMPTY);
			
			$this->resolveParameters($pList);
			
			try {
				$returned = call_user_func_array($signature, $pList);
			}
			catch (Exception $e) {
				if (is_array($this->method)) {
					throw new Exception('Signature for "'.get_class($this->method[0]) . '::' . $this->method[1].'" does not match '.get_class($this));
				}
				else {
					throw new Exception('Signature for "'.$this->method.'" does not match '.get_class($this));
				}
			}
			
			if (gettype($returned) != $this->return_type) {
				if (is_array($this->method)) {
					throw new Exception('Return type from "'.get_class($this->method[0]) . '::' . $this->method[1].'" ('.gettype($returned).') does not match '.get_class($this) . ' ('.$this->return_type.')');
				}
				else {
					throw new Exception('Return type from "'.$this->method.'" does not match '.get_class($this));
				}
			}
		}
		
		function createSignature($funcname)
		{
			if (is_array($this->method)) {
				$reflect = new ReflectionMethod($this->method[0], $this->method[1]);
			}
			else {
				$reflect = new ReflectionFunction($this->method);
			}
			
			$doc = $reflect->getDocComment();
			
			if (empty($doc)) {
				if (is_array($this->method)) {
					throw new Exception('No signature found for '.get_class($this->method[0]).'::'.$this->method[1]);
				}
				else {
					throw new Exception('No signature found for '.$this->method[1]);
				}
			}
			
			$signature = preg_split('/\s+/', str_replace(array('(', ')'), '', $doc), -1, PREG_SPLIT_NO_EMPTY);
			
			array_shift($signature); array_pop($signature);
			
			if (strtoupper($signature[0]) == 'NULL' || strtolower($signature[0]) == 'void') {
				$return = 'return NULL;';
			}
			else {
				$return = 'return (' . $signature[0] . ') 1;';
			}
			
			$argn			= 2;
			$argv_n			= 0;
			$paramchecks	= array();
			
			while (isset($signature[$argn])) {
				$paramchecks[] =
				'
					if (gettype($argv['.$argv_n.']) != \''.$signature[$argn].'\' && FALSE == ($argv['.$argv_n.'] instanceof '.$signature[$argn].')) {
						throw new Exception();
					}
				';
				
				++$argv_n;
				$argn += 2;
			}
			
			eval
			('
				function '. $funcname . '()
				{
					$argv = func_get_args();
					
					'.join($paramchecks, "\n").'
					
					'.$return.'
				}
			');
		}
		
		function resolveParameters(&$pList)
		{
			foreach ($pList as &$param) {
				$tmp = explode(' ', $param);
				
				switch ($tmp[0]) {
					case 'boolean':
					case 'integer':
					case 'double':
					case 'string':
					case 'array':
					case 'object':
					case 'resource':
						$param = eval('return (' . $tmp[0] . ') 1;');
						break;
					
					case 'NULL':
						$param = NULL;
						break;
					
					default:
						$param = unserialize('O:'.strlen($tmp[0]).':"'.$tmp[0].'":0:{}');
						break;
				}
			}
		}
		
		function Invoke()
		{
			$argv = func_get_args();
			
			if (sizeof($argv) < $this->param_count) {
				throw new Exception('Missing parameters (expecting '.$this->param_list.').');
			}
			
			if ($this->param_count > 0) {
				$pList = preg_split('/\s*,\s*/', $this->param_list, -1, PREG_SPLIT_NO_EMPTY);
				
				$this->resolveParameters($pList);
				
				foreach ($pList as $n => &$param) {
					if (gettype($param) == 'object' && get_class($param) != 'stdClass') {
						$cls = get_class($param);
						
						if ($argv[$n] instanceof $cls) {
							continue;
						}
					}
					else {
						if (gettype($param) === gettype($argv[$n])) {
							continue;
						}
					}
					
					if (gettype($param) == 'object') {
						$expect = get_class($param);
						
						if ($expect == 'stdClass') {
							$expect = 'object';
						}
						
						if (is_object($argv[$n])) {
							throw new Exception('Invalid type argv['.$n.'] ('.get_class($argv[$n]).') expecting '.$expect.'.');
						}
						else {
							throw new Exception('Invalid type argv['.$n.'] ('.gettype($argv[$n]).') expecting '.$expect.'.');
						}
					}
					else {
						throw new Exception('Invalid type argv['.$n.'] ('.gettype($argv[$n]).') expecting '.gettype($param).'.');
					}
				}
			}
			
			return call_user_func_array($this->method, $argv);
		}
		
		function Combine()
		{
			$argv = func_get_args();
			
			if (sizeof($argv) > 0) {
				$n = 0;
				
				while (isset($argv[$n])) {
					if (FALSE === ($argv[$n] instanceof Delegate)) {
						throw new Exception('Argument type mismatch');
					}
					
					$eval_argv[] = '$argv['.$n.']';
					++$n;
				}
				
				$eval_argv = join($eval_argv, ',');
				
				return eval
				('
					return new MultiCastDelegate($this, '.$eval_argv.');
				');
			}
			else {
				return eval
				('
					return new MultiCastDelegate($this);
				');
			}
		}
	}
	
	class MultiCastDelegate implements Delegate
	{
		protected $delegates;
		
		function __construct()
		{
			$this->delegates = new ArrayObject();
			
			$argv = func_get_args();
			
			foreach ($argv as $delegate) {
				if ($delegate instanceof Delegate) {
					if (strtoupper($delegate->return_type) != 'NULL') {
						throw new Exception('All delegates in MultiCastDelegate collection must return NULL');
					}
					
					$this->Append($delegate);
				}
			}
			
			$this->return_type = 'NULL';
		}
		
		function Invoke()
		{
			$argv = func_get_args();
			
			foreach ($this->delegates as $delegate) {
				call_user_func_array(array(&$delegate, 'Invoke'), $argv);
			}
		}
		
		function Append(Delegate $delegate)
		{
			$this->delegates->Append($delegate);
		}
		
		function Combine()
		{
			$argv = func_get_args();
			
			if (sizeof($argv) > 0) {
				$n = 0;
				
				while (isset($argv[$n])) {
					if (FALSE === ($argv[$n] instanceof Delegate)) {
						throw new Exception('Argument type mismatch');
					}
					
					$eval_argv[] = '$argv['.$n.']';
					++$n;
				}
				
				$eval_argv = join($eval_argv, ',');
				
				return eval
				('
					return new MultiCastDelegate($this, '.$eval_argv.');
				');
			}
			else {
				return eval
				('
					return new MultiCastDelegate($this);
				');
			}
		}
	}
	
	function delegate_create($setup)
	{
		if (gettype($setup) == 'string') {
			$setup = preg_split('/\s+/', str_replace(array('(', ')', ','), '', $setup), -1, PREG_SPLIT_NO_EMPTY);
			
			$options = array();
			$options['ClassName']	= $setup[1];
			$options['ReturnType']	= $setup[0];
			$options['ParamList']	= array();
			
			$n = 2;
			
			while (isset($setup[$n])) {
				$options['ParamList'][] = $setup[$n] . ' ' . $setup[++$n];
				++$n;
			}
		}
		elseif (is_array($setup)) {
			$options = $setup;
		}
		
		eval
		('
			class '.$options['ClassName'].'	extends SingleCastDelegate
			{
				public $return_type = '.$options['ReturnType'].';
				public $param_list = \''.join($options['ParamList'], ', ').'\';
			}
		');
	}
	
	/** integer MyFunction (integer $a, integer $b) */
	function MyFunction($a, $b)
	{
		echo $a * $b, PHP_EOL;
	}
	
	class MyClass
	{
		/** null MyFunction (string $a, integer $b) */
		function MyFunction($a, $b)
		{
			echo str_repeat($a, $b), PHP_EOL;
		}
		
		/** null MyOtherFunction (string $a, integer $b) */
		function MyOtherFunction($a, $b)
		{
			echo (string) $a . $b, PHP_EOL;
		}
	}
	
	delegate_create('integer MyDelegate (integer $a, integer $b)');
	
	delegate_create(array(
		'ClassName' => 'MyClassDelegate',
		'ReturnType' => 'null',
		'ParamList' => array(
			'string a',
			'integer b'
		)
	));
	
	$dlg = new MyDelegate(MyFunction);
	$dlg->Invoke(10, 15);
	
	$myclass = new MyClass();
	
	$dlg = new MyClassDelegate(array($myclass, MyFunction));
	$dlg->Invoke('Hello', 4);
	
	$dlg = $dlg->Combine(new MyClassDelegate(array($myclass, MyOtherFunction)));
	$dlg->Invoke('Hello', 4);
	
	delegate_create('string MyBrokenDelegate (MyClass $a, ArrayObject $b)');
	
	$dlg = new MyBrokenDelegate(MyFunction);
?>
