#define MONO

using System;
using System.Diagnostics;
using System.Threading;
using System.Reflection;


namespace LFSLapper
{
    class LFSLapper
    {
        #region Main

        /// <summary>
        /// References GNU GPL License
        /// </summary>
        static void PrintLicense()
        {
            Console.WriteLine(System.Reflection.Assembly.GetExecutingAssembly().ToString());
            Console.WriteLine("Copyright (C) 2005-2007 Janez Cufer and Gai-Luron");
            Console.WriteLine("LFSLapper comes with ABSOLUTELY NO WARRANTY");
            Console.WriteLine("This is free software, and you are welcome to redistribute it");
            Console.WriteLine("under certain conditions. Read LICENSE for details.");
            Console.WriteLine();
        }

        /// <summary>
        /// Prints command line usage with license.
        /// </summary>
        static void PrintUsage()
        {
            Console.WriteLine("Usage: LFSLapper.exe scriptfilename [debug]\n");
            Console.WriteLine("Report bugs and suggestions http://www.lfsforum.net/showthread.php?t=25756\n");
        }

        static void Main(string[] Args)
        {
            LFSDebug.debug debug = new LFSDebug.debug("./logerr.txt", 200);
            try
            {
                PrintLicense();

                if (Args.Length > 2)
                {
                    PrintUsage();
                    return;
                }
                bool debugmode = false;
                if (Args.Length > 1)
                    debugmode = Args[1].ToUpper() == "DEBUG";


                if (Args.Length == 0)
                {
                    LFSClient lfsclient = new LFSClient("LFSLapper.cfg",debug, false);
//                    LFSClient lfsclient = new LFSClient("LFSLapper.cfg",debug, true);
                }
                else
                {
                    LFSClient lfsclient = new LFSClient(Args[0], debug ,debugmode);
                }
            }
            catch (Exception ex)
            {
//                System.Console.WriteLine(ex.Message);
                Console.WriteLine("The following error occurred:");
                Console.WriteLine(ex.Message);   // Print the error message.
                Console.WriteLine(ex.Source);    // Name of application or object that caused the error.
                Console.WriteLine(ex.StackTrace); //String that contains the stack trace for this exception.
                Console.WriteLine(ex.TargetSite ); //String that contains the stack trace for this exception.
                Console.WriteLine("");
                Console.WriteLine("Save Debug Infos");
                debug.save();
                System.Threading.Thread.Sleep(50000);
            }
        }

        #endregion
    }
    public class posQualUser
    {
        public int posUser;
        public int totalUser;
        public int groupUser;

        public posQualUser(int pos, int total, int group)
        {
            this.posUser = pos;
            this.totalUser = total;
            this.groupUser = group;
        }
    }
    public class infoHandUser
    {
        public int H_Mass = 0;
        public int H_TRes = 0;
        public infoHandUser(int H_Mass, int H_TRes)
        {
            this.H_Mass = H_Mass;
            this.H_TRes = H_TRes;
        }
    }
    class LFSClient
    {
        Mutex myMutex = new Mutex(false);
        LFSDebug.debug debug;
        LFS.Db lfsDb;
        LFS.DriftDb lfsDriftDb;
        cfguser cfu = new cfguser();

        enum btnID
        {
            NOT_USED,
            LIBEL_SPB,
            BUT_SESS,
            BUT_PB,
            BUT_WR,
            LIBEL_SHOW_SPB,
            BUT_SHOW,
            BUT_HIDE,
            LIBEL_SPEED_UNIT,
            BUT_KMH,
            BUT_MPH,
        };
        InSim.Connect insimConnection = new InSim.Connect();

        class UN
        {
            public string userName;
            public string nickName;
            public UN(string userName, string nickName)
            {
                this.userName = userName;
                this.nickName = nickName;
            }
        }
        trackCarData trackInfo;
        System.Collections.Hashtable playerHandicap = new System.Collections.Hashtable();
        System.Collections.Hashtable playerFilter = new System.Collections.Hashtable();
        #region file configuration options
        bool wrLoaded = false;
        string[] onConnectLines;
        string[] autoActionLines;
        string[] autoMsgLinesPrivate;
        string PBAction;
        string PBQualAction;
        string DriftPBAction;
        string DriftLapAction;
        string DriftTooLowAction;
        string RaceStartAction;
        string[] PrivMessSpbUp = new string[(int)paramLapper.maxSplit];
        string[] PrivMessSpbLow = new string[(int)paramLapper.maxSplit];
        string PrivMessSpbLastLow;
        string PrivMessSpbLastUp;
        string BeginPitPrivMess;
        string EndPitPrivMess;
        string OnBeginPit;
        string OnEndPit;
        string OnIdleAction1;
        string OnIdleAction2;
        int OnIdleTimeout1 = 60;
        int OnIdleTimeout2 = 120;
        string OnToLowHandicap;
        bool TCPmode = true;
        
        //####################################
        //Start ConfigVars for LicenseHack by Venni
        //####################################
        string CheckLicense; 
        string[] NoLicenseActionLines;
        //####################################
        //End ConfigVars for LicenseHack by Venni
        //####################################

        int MaxNbInStunt = -1;
        String MaxNbInStuntAction = "";

        #region Drifting options
        int MinimumDriftScore = 1;
        string PrivateMessageOnDriftScore;
        int MinimumDriftSpeed = 50;
        int MinimumDriftAngle = 15; int MaximumDriftAngle = 90;
        string GoodDriftAction = "";
        int GoodDriftScore = 5000;
        #endregion

        #region Acceleration options
        double AccelerationStartSpeed = 1000;//0.1;
        double AccelerationEndSpeed = 10000;//100.0;
        double AccelerationStartSpeedMph = 1000;//0.1;
        double AccelerationEndSpeedMph = 10000;//100.0;
        string AccelerationPrivateMessage = "";
        double AccelerationPrivateMaxTime = 10;
        #endregion

        #region Flood options

        string FloodAction = "";
        int MaxFloodLines = 3;
        int MaxFloodLinesTime = 3000;

        #endregion

        string EnterPitAction = "";
        string LeaveRaceAction = "";

        string DriveThroughPenaltyAction = "";
        string StopGoPenaltyAction = "";
        string Time45PenaltyAction = "";
        string Time30PenaltyAction = "";
        int MaxDriveThroughPenalties = 3;
        int MaxStopGoPenalties = 3;

        bool UseUsernameForAuthentication = false;
        bool ShowPlayerControl = false;

        bool ShowSplitPB = true;
        
        #region Qualification Option
        string QualUsers;
        bool RefreshQualUsers = false;
        string HandicapUsers;
        bool RefreshHandicapUsers = false;
        int MaxGroupQual = 0;
        int MaxUserGroupQual = 0;
        int MinUserGroupQual = 0;
        #endregion

        int MinAngleVelocity = 200;
        string AngleVelocityAction = "";

        string DefaultTopCar = "";

        int MessageTime = 10000;

        System.Collections.ArrayList shortCarNames = new System.Collections.ArrayList();
        System.Collections.ArrayList longCarNames = new System.Collections.ArrayList();
        bool debugmode = false;
        string currentTrackName = "";
        System.Timers.Timer timer;
        System.Timers.Timer ScheduleTimer;

        System.Collections.ArrayList Tasks = new System.Collections.ArrayList();

        listPlayers listOfPlayers = new listPlayers();

        #endregion
        
        #region Send Message Helpers

        /// <summary>
        /// Executes action
        /// </summary>
        /// <param name="msg"></param>

        public double getSpeed(bool unitSpeedKmh, double speed )
        {
            if (unitSpeedKmh)
                return speed;
            else
                return speed / 1.609344;
        }
        string getUnitSpeed(bool unitSpeedKmh)
        {
            if (unitSpeedKmh)
                return "Km/h";
            else
                return "Mph";
        }
        bool UpdateQualUsers(string QualUsers)
        {
            int authidx;

            playerFilter.Clear();
            if (QualUsers == "")
                return true;

            authidx = QualUsers.IndexOf("@"); // If list of user is in cfg file
            if (authidx != -1)
            {
                string[] ListUsers = QualUsers.Substring(authidx + 1).Split(',');
                foreach (string userinfo in ListUsers)
                {
                    if (userinfo.IndexOf("DefGroup") != -1)
                    {
                        string[] line = userinfo.Split(':');
                        string[] value = line[1].Trim().Split(';');
                        try
                        {
                            MaxGroupQual = int.Parse(value[0]);
                            MaxUserGroupQual = int.Parse(value[1]);
                            MinUserGroupQual = int.Parse(value[2]);
                        }
                        catch (Exception)
                        {
                            MaxGroupQual = 0;
                            MaxUserGroupQual = 0;
                            MinUserGroupQual = 0;
                        }

                    }
                    else
                    {
                        playerFilter[userinfo.ToLower()] = true;
                    }
                }
                return true;
            }
            authidx = QualUsers.IndexOf("&"); // if QualUsers is a name of file containing list of user
            if (authidx != -1)
            {
                string userinfo;
                try
                {
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(QualUsers.Substring(authidx + 1)))
                    {
                        while (true)
                        {
                            userinfo = sr.ReadLine();
                            if (userinfo == null)
                                return true;
                            if (userinfo.IndexOf("DefGroup") != -1)
                            {
                                string[] line = userinfo.Split(':');
                                string[] value = line[1].Trim().Split(';');
                                try
                                {
                                    MaxGroupQual = int.Parse(value[0]);
                                    MaxUserGroupQual = int.Parse(value[1]);
                                    MinUserGroupQual = int.Parse(value[2]);
                                }
                                catch (Exception)
                                {
                                    MaxGroupQual = 0;
                                    MaxUserGroupQual = 0;
                                    MinUserGroupQual = 0;
                                }

                            }
                            else
                            {
                                playerFilter[userinfo.ToLower()] = true;
                            }
                        }
                    }
                }
                catch (System.Exception ex)
                {
                    Console.WriteLine("(" + QualUsers + ")" + ex.Message);   // Print the error message.
                    return false;
                }
            }
            return false;
        }
        bool UpdateHandicapUsers(string HandicapUsers)
        {
            int authidx;

            playerHandicap.Clear();
            if (HandicapUsers == "")
                return true;

            authidx = HandicapUsers.IndexOf("@"); // If list of user is in cfg file
            if (authidx != -1)
            {
                string[] ListUsers = HandicapUsers.Substring(authidx + 1).Split(',');
                foreach (string userinfo in ListUsers)
                {
                    string[] usersplit = userinfo.Split(':');
                    int H_Mass = 0;
                    int H_TRes = 0;
                    try
                    {
                        H_Mass = int.Parse(usersplit[1]);
                    }
                    catch { H_Mass = 0; }
                    try
                    {
                        H_TRes = int.Parse(usersplit[2]);
                    }
                    catch { H_TRes = 0; }
                    playerHandicap[usersplit[0].ToLower()] = new infoHandUser(H_Mass, H_TRes);

                }
                return true;
            }
            authidx = HandicapUsers.IndexOf("&"); // if QualUsers is a name of file containing list of user
            if (authidx != -1)
            {
                string userinfo;
                try
                {
                    using (System.IO.StreamReader sr = new System.IO.StreamReader(QualUsers.Substring(authidx + 1)))
                    {
                        while (true)
                        {
                            userinfo = sr.ReadLine();
                            if (userinfo == null)
                                return true;
                            string[] usersplit = userinfo.Split(':');
                            int H_Mass = 0;
                            int H_TRes = 0;
                            try
                            {
                                H_Mass = int.Parse(usersplit[1]);
                            }
                            catch { H_Mass = 0; }
                            try
                            {
                                H_TRes = int.Parse(usersplit[2]);
                            }
                            catch { H_TRes = 0; }
                            playerHandicap[usersplit[0].ToLower()] = new infoHandUser(H_Mass, H_TRes);
                        }
                    }
                }
                catch (System.Exception ex)
                {
                    Console.WriteLine("(" + QualUsers + ")" + ex.Message);   // Print the error message.
                    return false;
                }
            }
            return false;
        }
        void SendMsg(string msg)
        {
            if (msg.Length > 0)
            {
                byte[] outMsg = InSim.Encoder.MST(msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        void SendMsg(byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MST(msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }
        bool executeCmdLapper(int UCID, string msg)
        {
            infoPlayer currPly = listOfPlayers.getPlayerByUCID(UCID);

            if (msg.IndexOf("/cleanspb") == 0)
            {
                msg = "!" + msg.Substring(1);

                currPly.splitLast = 0;
                for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                    currPly.sessBestSplitDiff[i] = 0;
                currPly.sessBestSplitDiffLast = 0;
                currPly.bestSpeed = (double)0;

                try
                {
                    SendMsgToConnection(UCID, currPly.nickName + "^8 SPB Cleaned");
                }
                catch { }
                return true;
            }

            if (msg.IndexOf("/spb") == 0)
            {
                msg = "!" + msg.Substring(1);

                string spb = "";
                try
                {
                    switch (currPly.viewSPBSplit)
                    {
                        case 'W':
                        case 'P':
                            spb = "PB ";
                            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                            {
                                if (currPly.PBBestSplitDiff[i] != 0)
                                    spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + timeConv.LongToHMS(currPly.PBBestSplitDiff[i]);
                            }
                            if (currPly.PBBestSplitDiffLast != 0)
                                spb = spb + "^7SPL:^8" + timeConv.LongToHMS(currPly.PBBestSplitDiffLast);
                            break;
                        case 'S':
                            spb = "Sess ";
                            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
                            {
                                if (currPly.sessBestSplitDiff[i] != 0)
                                    spb = spb + "^7SP" + (i + 1).ToString() + ":^8" + timeConv.LongToHMS(currPly.sessBestSplitDiff[i]);
                            }
                            if (currPly.sessBestSplitDiffLast != 0)
                                spb = spb + "^7SPL:^8" + timeConv.LongToHMS(currPly.sessBestSplitDiffLast);
                            break;
                    }
                    SendMsgToConnection(UCID, spb);
                    SendMsgToConnection(UCID, timeConv.LongToHMS(currPly.TPb));
                }
                catch (Exception) { }
                return true;

            }

            if (msg.IndexOf("/statsqual") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowStats(UCID, currPly.userName, currPly.nickName, msg, true);
                return true;
            }
            if (msg.IndexOf("/stats") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowStats(UCID, currPly.userName, currPly.nickName, msg, false);
                return true;
            }

            if (msg.IndexOf("/hand") == 0)
            {
                msg = "!" + msg.Substring(1);
                if (RefreshHandicapUsers)
                    UpdateHandicapUsers(HandicapUsers);
                ShowHand(currPly, msg);
                return true;
            }
            if (msg.IndexOf("/dstats") == 0)
            {
                msg = "!" + msg.Substring(1);
                ShowDriftStats(UCID, currPly.userName, currPly.nickName, msg);
                return true;
            }
            if (msg.IndexOf("/ver") == 0)
            {
                Ver(UCID);
                return true;
            }
            if (msg.IndexOf("/nearqual") == 0)
            {
                string mymess;
                msg = "!" + msg.Substring(1);
                // Update the FilterTop for qualified
                if (RefreshQualUsers)
                    UpdateQualUsers(QualUsers);
                posQualUser retValue = getPosQual(currPly, true);
                int iposabs = retValue.posUser;
                if (iposabs == 0)
                    iposabs = 1;
                if (iposabs > 8)
                    iposabs -= 7;
                else
                    iposabs = 1;
                mymess = "!topqual " + iposabs.ToString();
                Top(UCID, currPly.userName, currPly.nickName, mymess, true);
                return true;
            }
            if (msg.IndexOf("/near") == 0)
            {

                string mymess;
                msg = "!" + msg.Substring(1);
                posQualUser retValue = getPosQual(currPly, false);
                int iposabs = retValue.posUser;

                if (iposabs == 0)
                    iposabs = 1;
                if (iposabs > 8)
                    iposabs -= 7;
                else
                    iposabs = 1;
                mymess = "!top " + iposabs.ToString();
                Top(UCID, currPly.userName, currPly.nickName, mymess, false);
                return true;
            }
            if (msg.IndexOf("/drf") == 0){
                msg = "!" + msg.Substring(1);
                TopDrift(UCID, currPly.userName, currPly.nickName, msg);
                return true;
            }
            if (msg.IndexOf("/topqual") == 0)
            {
                msg = "!" + msg.Substring(1);
                if (RefreshQualUsers)
                    UpdateQualUsers(QualUsers);
                Top(UCID, currPly.userName, currPly.nickName, msg, true);
                return true;
            }
            if (msg.IndexOf("/top") == 0)
            {
                msg = "!" + msg.Substring(1);
                Top(UCID, currPly.userName, currPly.nickName, msg, false);
                return true;
            }
            return false;
        }

        void SendMsgToConnection(int UCID, string msg)
        {
            if (msg.Length > 0)
            {
                if (executeCmdLapper(UCID,msg) == false)
                {
                    byte[] outMsg = InSim.Encoder.MTC(UCID, 0, msg);
                    insimConnection.Send(outMsg, outMsg.Length);
                }
            }
        }

        void SendMsgToConnection(int UCID, byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MTC(UCID, 0, msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }
        void ClearButton(infoPlayer currInfoPlayer)
        {
            // Clear all buttons
            byte[] bfn = InSim.Encoder.BFN(1, currInfoPlayer.UCID, 0);
            insimConnection.Send(bfn, bfn.Length);
        }
        void AddButton(int L, int T, int W, int H, int UCID, btnID ClickID, string Caption, string Text, bool ClickButton, bool Selected )
        {
            int style;
            byte[] btn;

            if (ClickButton)
            {
                style = (int)InSim.BTN_style.ISB_CLICK;
                if (Selected)
                    style |= (int)InSim.BTN_style.ISB_LIGHT | 3;
                else
                    style |= (int)InSim.BTN_style.ISB_LIGHT | 2;
            }
            else
                style = (int)InSim.BTN_style.ISB_DARK | (int)InSim.BTN_style.ISB_LEFT;


            btn = InSim.Encoder.BTN(L, T, W, H, UCID, (int)ClickID, style, Caption, Text);
            insimConnection.Send(btn, btn.Length);


        }
        void UpButton( infoPlayer currInfoPlayer )
        {

            #region InsimButton
            switch (currInfoPlayer.showButton)
            {
                case 0:
                    break;
                case 1:
                    bool select_PB = false;
                    bool select_session = false;
                    bool select_wr = false;

                    switch (currInfoPlayer.viewSPBSplit)
                    {
                        case 'S':
                            select_session = true;
                            break;
                        case 'P':
                            select_PB = true;
                            break;
                        case 'W':
                            select_wr = true;
                            break;
                    }
                    AddButton(60, 30, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SPB, "", "Sector time relative to: ", false, false);
                    AddButton(90, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_SESS, "", "Session", true, select_session);
                    AddButton(110, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_PB, "", "Server", true, select_PB);
                    if (wrLoaded)
                    {
                        AddButton(130, 30, 20, 5, currInfoPlayer.UCID, btnID.BUT_WR, "", "World Record", true, select_wr);
                    }
// Button for show of not Sector PB
                    AddButton(60, 35, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SHOW_SPB, "", "Show splitting info: ", false, false);
                    AddButton(90, 35, 20, 5, currInfoPlayer.UCID, btnID.BUT_SHOW, "", "Show", true, currInfoPlayer.showSplitPB);
                    AddButton(110, 35, 20, 5, currInfoPlayer.UCID, btnID.BUT_HIDE, "", "Hide", true, !currInfoPlayer.showSplitPB);
// Is speed Km/h
                    AddButton(60, 40, 30, 5, currInfoPlayer.UCID, btnID.LIBEL_SPEED_UNIT, "", "Speed Unit: ", false, false);
                    AddButton(90, 40, 20, 5, currInfoPlayer.UCID, btnID.BUT_KMH, "", "Km/h", true, currInfoPlayer.unitSpeedKmh);
                    AddButton(110, 40, 20, 5, currInfoPlayer.UCID, btnID.BUT_MPH, "", "Mph", true, !currInfoPlayer.unitSpeedKmh);
                    break;
            }
        }
#endregion

/*
        void SendMsgToPlayer(int playerID, string msg)
        {
            if (msg.Length > 0)
            {
                byte[] outMsg = InSim.Encoder.MTC(0, playerID, msg);
                insimConnection.Send(outMsg, outMsg.Length);
            }
        }

        void SendMsgToPlayer(int PLID, byte []msg)
        {
            byte[] outMsg = InSim.Encoder.MTC(0, PLID, msg);
            insimConnection.Send(outMsg, outMsg.Length);
        }
*/
        #endregion


        bool SplitNotify(infoPlayer currInfoPlayer, InSim.Decoder.SPX splitdec)
        {
            string splitAction = "";
            string spbAction = "";

            try
            {

                int idxSplit = splitdec.Split - 1;

                switch (currInfoPlayer.viewSPBSplit)
                {
                    case 'P':
                        if (currInfoPlayer.newPBBestSplit)
                            spbAction = PrivMessSpbLow[idxSplit];
                        else
                            spbAction = PrivMessSpbUp[idxSplit];
                        break;
                    case 'S':
                        if (currInfoPlayer.newSessBestSplit)
                            spbAction = PrivMessSpbLow[idxSplit];
                        else
                            spbAction = PrivMessSpbUp[idxSplit];
                        break;
                    case 'W':
                        if (currInfoPlayer.newWRBestSplit)
                            spbAction = PrivMessSpbLow[idxSplit];
                        else
                            spbAction = PrivMessSpbUp[idxSplit];
                        break;
                }
            }
            catch
            {
                Console.WriteLine("Error on take SpbAction");
            }

//            try
//            {
                splitAction = trackInfo.getSplitAction(currentTrackName, currInfoPlayer.CName, splitdec.Split, splitdec.STime);
                if (splitAction != "")
                {
                    splitAction = splitAction.Replace("{SplitTime}", timeConv.LongToHMS(splitdec.STime));
                    splitAction = splitAction.Replace("{Nickname}", currInfoPlayer.nickName);

                    if (splitAction.IndexOf("/rcm_") != -1)
                        RestartTimer();

                    string[] respcommands = splitAction.Split('|');
                    foreach (string respcommand in respcommands)
                        SendMsg(respcommand);
                }
 //           }
 //           catch 
 //           { 
 //               Console.WriteLine("Error on splitAction");
 //           }
            try
            {

                if (ShowSplitPB && currInfoPlayer.showSplitPB && spbAction != "")
                {
                    spbAction = spbAction.Replace("{Nickname}", currInfoPlayer.nickName);
                    spbAction = spbAction.Replace("{Username}", currInfoPlayer.userName);
                    spbAction = spbAction.Replace("{CurSplit}", timeConv.LongToHMS(currInfoPlayer.currSplit));
                    spbAction = spbAction.Replace("{BestSplit}", timeConv.LongToHMS(currInfoPlayer.bestSplit));
                    spbAction = spbAction.Replace("{DiffSplit}", timeConv.LongToHMS(currInfoPlayer.diffSplit));
                    spbAction = spbAction.Replace("{BestSpeed}", string.Format("{0:n}", getSpeed(currInfoPlayer.unitSpeedKmh, currInfoPlayer.bestSpeed)));
                    spbAction = spbAction.Replace("{UnitSpeed}", getUnitSpeed( currInfoPlayer.unitSpeedKmh ));
                    spbAction = spbAction.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                    spbAction = spbAction.Replace("{Laps}", currInfoPlayer.laps.ToString());
                    spbAction = spbAction.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                    spbAction = spbAction.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                    spbAction = spbAction.Replace("{Car}", currInfoPlayer.CName);
                    if (currInfoPlayer.viewSPBSplit == 'P')
                        spbAction = spbAction.Replace("{typ}", "PB");
                    if (currInfoPlayer.viewSPBSplit == 'S')
                        spbAction = spbAction.Replace("{typ}", "Sess");
                    if (currInfoPlayer.viewSPBSplit == 'W')
                        spbAction = spbAction.Replace("{typ}", "WR");
                    posQualUser retValue;
                    retValue = getPosQual(currInfoPlayer, true);
                    if (retValue.posUser != 0)
                        spbAction = spbAction.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                    else
                        spbAction = spbAction.Replace("{Posqual}", "-/-");
                    if (retValue.groupUser != -1)
                        spbAction = spbAction.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                    else
                        spbAction = spbAction.Replace("{Groupqual}", "-");

                    retValue = getPosQual(currInfoPlayer, false);
                    spbAction = spbAction.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);

//                    SendMsgToConnection(currInfoPlayer.UCID, spbAction);
                    SendMultilineMsgPrivate(currInfoPlayer.UCID, spbAction );
//                SendMsgToPlayer(currInfoPlayer.PLID, spbAction);
                }
            }
            catch {
                Console.WriteLine("Error on SpbAction");
            }
          
            return true;

        }

        void Ver(int UCID)
        {
            try
            {
//                playerIdToSend = (byte)(playerTmpStatTable[(string)playerNameToSend] as tempStat).PLID;


                SendMsgToConnection(UCID, System.Reflection.Assembly.GetExecutingAssembly().FullName);
                SendMsgToConnection(UCID, "^3http://www.lfsforum.net/showthread.php?t=25756");
            }
            catch (System.Exception)
            {
                return;
            }
        }
        
        void SendMultilineMsgPrivate(int UCID, string resp)
        {
            string[] multilineresp = resp.Split(':');
            try
            {
                for (int i = 0; i < multilineresp.Length; i++)
                {
                    string lineToSend = multilineresp[i];

//                    lineToSend = lineToSend.Replace("{Nickname}", playerNameToSend);
                    SendMsgToConnection(UCID, this.GlobalOptionsReplace(lineToSend));
                }
            }
            catch (System.Exception)
            {
                return;
            }
        }
        
        void Top(int UCID,string username,string nickname,string cmd, bool flagqual )
        {

            string playerNameToSend = nickname;
            string filtervalue = "";

            string carName = DefaultTopCar;
            int from = 1;

            string [] splitCmd = cmd.Split(' ');
            for (int i = 1; i <= splitCmd.GetUpperBound(0); i++) {
                if (splitCmd[i].Trim() == "")
                    continue;
// find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
// Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].IndexOf(shortCarName) != -1)
                    {
                        carName = (string)shortCarNames[j];
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
// Find if offset
                try{from = int.Parse(splitCmd[i]);}
                catch (System.Exception){}
            }

            System.Collections.ArrayList list;
            if( flagqual )
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual );
            else
                list = lfsDb.GetTable(currentTrackName, carName, filtervalue, false, null,0,0,0);

            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + 14); i++)
            {
                System.Text.StringBuilder sname = new System.Text.StringBuilder();

                string userName = (list[i] as LFS.Db.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.Db.DriverLapEntry).playerStats.nickName;
                sname.Append(nickName);

                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                string sGroup = "";
                if ((list[i] as LFS.Db.DriverLapEntry).group != -1)
                {
                    sGroup = ((char)((list[i] as LFS.Db.DriverLapEntry).group + 65)).ToString();
                }
                if (username.ToLower() == userName.ToLower())
                    sb.AppendFormat("^3{0}. {3}^8 {1} {2}^8", 
                                        i + 1, 
                                        timeConv.LongToHMS((list[i] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime ),
                                        sname,
                                        sGroup
                    );
                else
                    sb.AppendFormat("^7{0}. {3}^8 {1} {2}^8", 
                                        i + 1, 
                                        timeConv.LongToHMS((list[i] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime),
                                        sname,
                                        sGroup
                    );

                for (int k = 0; k < 3; k++)
                {
                    long SplitTime = (list[i] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                    //only show split time if it is not zero
                    if ( SplitTime != 0 )
                    {
                        sb.Append(" ");
                        sb.Append( timeConv.LongToHMS( SplitTime ));
                    }
                }
                if (username.ToLower() == userName.ToLower())
                    sb.Append("^3 <--------------");
                SendMsgToConnection(UCID, sb.ToString());
            }
        }


        void TopDrift(int UCID, string username, string nickname, string cmd)
        {

            string playerNameToSend = nickname;
            string filtervalue = "";

            string carName = DefaultTopCar;

            int from = 1;

            string[] splitCmd = cmd.Split(' ');
            for (int i = 1; i <= splitCmd.GetUpperBound(0); i++)
            {
                if (splitCmd[i].Trim() == "")
                    continue;
                // find if filter is present
                if (splitCmd[i] == "filter")
                {
                    i++;
                    try { filtervalue = splitCmd[i]; continue; }
                    catch { filtervalue = ""; continue; }
                }
                // Find if car is present in line of command
                int j = 0;
                bool flagFind = false;
                foreach (string shortCarName in shortCarNames)
                {
                    if (splitCmd[i].IndexOf(shortCarName) != -1)
                    {
                        carName = (string)shortCarNames[j];
                        flagFind = true;
                        break;
                    }
                    j++;
                }
                if (flagFind)
                    continue;
                // Find if offset
                try { from = int.Parse(splitCmd[i]); }
                catch (System.Exception) { }
            }

            System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName, filtervalue, false);

            for (int i = from - 1; i >= 0 && i < System.Math.Min(list.Count, from + 14); i++)
            {
                string userName = (list[i] as LFS.DriftDb.DriverLapEntry).userName;
                string nickName = (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;

                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                if (username.ToLower() == userName.ToLower())
                    sb.AppendFormat("^3{0}.^8 {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName);
                else
                    sb.AppendFormat("^7{0}.^8 {1} {2}^8", i + 1, (list[i] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap, nickName);

                if (username.ToLower() == userName.ToLower())
                    sb.Append("^3 <--------------");
                SendMsgToConnection(UCID, sb.ToString());
            }

        }

        void ShowHand( infoPlayer currInfoPlayer, string cmd )
        {
            string searchUserName = currInfoPlayer.userName;
            try
            {
                searchUserName = cmd.Substring(cmd.IndexOf("!hand") + 6);
            }
            catch { }
            int H_Mass = 0;
            int H_TRes = 0;
            try
            {
                H_Mass = (playerHandicap[searchUserName.ToLower()] as infoHandUser).H_Mass;
                H_TRes = (playerHandicap[searchUserName.ToLower()] as infoHandUser).H_TRes;
            }
            catch { }
            SendMsgToConnection(currInfoPlayer.UCID,
                            "^3" + searchUserName + " handicap Mass : "
            );
            SendMsgToConnection(currInfoPlayer.UCID,
                            "  - Current " + currInfoPlayer.H_Mass.ToString() + "Kg - Intake Restriction : " + currInfoPlayer.H_TRes.ToString() + "%"
            );
            SendMsgToConnection(currInfoPlayer.UCID,
                            "  - Required " + H_Mass.ToString() + "Kg - Intake Restriction : " + H_TRes.ToString() + "%"
            );

        }
        void ShowStats(int UCID, string username, string nickname, string cmd, bool flagqual)
        {
            string searchName = "";
            string playerNameToSend = nickname;

            // get parameter of command
            try
            {
                if (flagqual)
                    searchName = cmd.Substring(cmd.IndexOf("!statsqual") + 11);
                else
                    searchName = cmd.Substring(cmd.IndexOf("!stats") + 7);
            }
            catch (Exception)
            {
            }
            if (searchName.Trim() == "")
                searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            try
            {
                System.Collections.ArrayList cars = lfsDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list;
                    if (flagqual)
                        list = lfsDb.GetTable(currentTrackName, carName, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual);
                    else
                        list = lfsDb.GetTable(currentTrackName, carName, null,0,0,0);
                    int position = -1;
                    int tmppos = 0;
                    int nb = list.Count;
                    foreach (LFS.Db.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    System.Text.StringBuilder sname = new System.Text.StringBuilder();

                    string userName = (list[position] as LFS.Db.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.Db.DriverLapEntry).playerStats.nickName;
                    sname.Append(nickName);
                    SendMsgToConnection(UCID, string.Format("{3}/{4}. {0}^8 {1} {2}",
                                                                    sname, 
                                                                    timeConv.LongToHMS((list[position] as LFS.Db.DriverLapEntry).playerStats.personalBestLapTime),
                                                                    carName, 
                                                                    position + 1,
                                                                    nb)
                     );

                    System.Text.StringBuilder sb = new System.Text.StringBuilder();

                    for (int k = 0; k < 3; k++)
                    {
                        long SplitTime = (list[position] as LFS.Db.DriverLapEntry).playerStats.splitTime[k];

                        //only show split time if it is not zero
                        if ( SplitTime != 0 )
                        {
                            sb.Append(" ");
                            sb.Append(timeConv.LongToHMS( SplitTime ));
                        }
                    }
                    SendMsgToConnection(UCID, sb.ToString());
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }
        posQualUser getPosQual(infoPlayer currInfoPlayer, bool flagqual)
        {
            string searchName = currInfoPlayer.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            string playerNameToSend = currInfoPlayer.nickName;
            if (!playerFilter.ContainsKey(currInfoPlayer.userName.ToLower()) && flagqual)
                return new posQualUser(0, 0, -1);
            try

            {
                string carName;
                carName = currInfoPlayer.CName;
                if (currInfoPlayer.CName == "")
                    carName = DefaultTopCar;
                else
                    carName = currInfoPlayer.CName;


                System.Collections.ArrayList list;
                if (flagqual)
                    list = lfsDb.GetTable(currentTrackName,  carName, playerFilter,MaxGroupQual,MaxUserGroupQual,MinUserGroupQual);
                else
                    list = lfsDb.GetTable(currentTrackName,  carName, null,0,0,0);
                int position = -1;
                int tmppos = 0;
                int nb = list.Count;
                foreach (LFS.Db.DriverLapEntry de in list)
                {
                    if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                    {
                        position = tmppos;
                        break;
                    }
                    else tmppos++;
                }
                if (position == -1) return new posQualUser(0, 0, -1);


                System.Text.StringBuilder sname = new System.Text.StringBuilder();

                string userName = (list[position] as LFS.Db.DriverLapEntry).userName;
                string nickName = (list[position] as LFS.Db.DriverLapEntry).playerStats.nickName;
                return new posQualUser(position + 1, nb, (list[position] as LFS.Db.DriverLapEntry).group  );
            }
            catch (System.Exception)
            {
                return new posQualUser(0,0,-1);
            }
        }

        void ShowDriftStats(int UCID, string username, string nickname, string cmd)
        {
            string searchName = "";
            string playerNameToSend = nickname;

            // get parameter of command
            try
            {
                searchName = cmd.Substring(cmd.IndexOf("!dstats") + 8);
            }
            catch (Exception)
            {
            }
            if( searchName.Trim() == "" )
                searchName = nickname.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "");
            try
            {

                System.Collections.ArrayList cars = lfsDb.GetCars(currentTrackName);

                foreach (string carName in cars)
                {
                    System.Collections.ArrayList list = lfsDriftDb.GetTable(currentTrackName, carName);
                    int position = -1;
                    int tmppos = 0;
                    foreach (LFS.DriftDb.DriverLapEntry de in list)
                    {
                        if (de.playerStats.nickName.Replace("^0", "").Replace("^1", "").Replace("^2", "").Replace("^3", "").Replace("^4", "").Replace("^5", "").Replace("^6", "").Replace("^7", "").Replace("^8", "").IndexOf(searchName) != -1)
                        {
                            position = tmppos;
                            break;
                        }
                        else tmppos++;
                    }

                    if (position == -1) continue;

                    string userName = (list[position] as LFS.DriftDb.DriverLapEntry).userName;
                    string nickName = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.nickName;
                    int driftScore = (list[position] as LFS.DriftDb.DriverLapEntry).playerStats.personalBestLap;
                    
                    SendMsgToConnection(UCID, string.Format("{3}. {0}^8 {1} {2}", nickName, driftScore, carName, position + 1));
                }

            }
            catch (System.Exception)
            {
                return;
            }
        }

        void CheckForFlooding( infoPlayer currInfoPlayer )
        {
            try
            {
                DateTime now = DateTime.Now;

                    System.TimeSpan ts = now - currInfoPlayer.LastLine;
                    currInfoPlayer.LastLine = now;

                    if (ts.TotalMilliseconds < MaxFloodLinesTime) //Maximum time betweeen lines to count as flood
                        currInfoPlayer.floodcount++;
                    else
                    {
                        currInfoPlayer.floodcount = 1;
                        return;
                    }

                    if (currInfoPlayer.floodcount > MaxFloodLines)   //max lines to tolerate
                    {
                        currInfoPlayer.floodcount = 0;

                        if (FloodAction.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        string _FloodAction = FloodAction;
                        _FloodAction = _FloodAction.Replace("{Nickname}", currInfoPlayer.nickName);
                        _FloodAction = _FloodAction.Replace("{Username}", currInfoPlayer.userName);
                        string[] floodcommands = _FloodAction.Split('|');
                        foreach (string floodcommand in floodcommands)
                            SendMsg(GlobalOptionsReplace(floodcommand));
                    }
            }
            catch(Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }
// To intercept Ctrl-C, ..., and other break and Close Lapper in safe mode
        public void inputHandler(ConsoleCtrl.ConsoleEvent consoleEvent)
        {
            if (consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlC
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlClose
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlBreak
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlLogoff
                || consoleEvent == ConsoleCtrl.ConsoleEvent.CtrlShutdown )
            {
                byte[] cl = InSim.Encoder.IS_TINY( (byte)InSim.TypePack.ISP_TINY, 0, (byte)InSim.TypeTiny.TINY_CLOSE);
                insimConnection.Send(cl, cl.Length);
                System.Environment.Exit(-1);
            }
        }
        public LFSClient(string scriptfilename, LFSDebug.debug Pdebug, bool debugmode)
        {
            this.debug = Pdebug;
            this.debugmode = debugmode;
            this.lfsDb = new LFS.Db(myMutex);
            this.lfsDriftDb = new LFS.DriftDb(myMutex);

// Here to intercept keys Ctrl
            try
            {
                ConsoleCtrl cc = new ConsoleCtrl();
                cc.ControlEvent += new ConsoleCtrl.ControlEventHandler(inputHandler);
            }
            catch { Console.WriteLine("Intercept don't work"); }

            #region Car Names Tables
            shortCarNames.Add("UF1"); longCarNames.Add("UF 1000");
            shortCarNames.Add("XFG"); longCarNames.Add("XF GTI");
            shortCarNames.Add("XRG"); longCarNames.Add("XR GT");
            shortCarNames.Add("XRT"); longCarNames.Add("XR GT TURBO");
            shortCarNames.Add("RB4"); longCarNames.Add("RB4 GT");
            shortCarNames.Add("FXO"); longCarNames.Add("FXO TURBO");
            shortCarNames.Add("LX4"); longCarNames.Add("LX4");
            shortCarNames.Add("LX6"); longCarNames.Add("LX6");
            shortCarNames.Add("RAC"); longCarNames.Add("RA");
            shortCarNames.Add("FZ5"); longCarNames.Add("FZ50");
            shortCarNames.Add("MRT"); longCarNames.Add("MRT5");
            shortCarNames.Add("XFR"); longCarNames.Add("XF GTR");
            shortCarNames.Add("UFR"); longCarNames.Add("UF GTR");
            shortCarNames.Add("FOX"); longCarNames.Add("FORMULA XR");
            shortCarNames.Add("FO8"); longCarNames.Add("FORMULA V8");
            shortCarNames.Add("FXR"); longCarNames.Add("FXO GTR");
            shortCarNames.Add("XRR"); longCarNames.Add("XR GTR");
            shortCarNames.Add("FZR"); longCarNames.Add("FZ50 GTR");
            shortCarNames.Add("BF1"); longCarNames.Add("BMW SAUBER");
            #endregion

            #region Configuring LFSLapper

            Configurator cfg = new Configurator();

            cfu.load();
            cfg.Load(scriptfilename);

            string adminPassword = cfg.Get("Password");

            string PubStatIdk = cfg.Get("PubStatIdk");
            string PubStatUser = cfg.Get("PubStatLogin");
            string PubStatPass = cfg.Get("PubStatPass");
            Console.Write( "Loading WR..." );
//            if (wr.load(PubStatUser, PubStatPass, PubStatIdk))
            if (wr.load("", "", PubStatIdk))
                {
                wrLoaded = true;
                Console.WriteLine("Ok");
            }
            else
            {
                wrLoaded = false;
                Console.WriteLine("Not Loaded");
            }
            string trackInfoFile = cfg.Get("TrackInfoFile");
            trackInfo = new trackCarData(trackInfoFile);
            string databaseFilePath = cfg.Get("Database");
            if (databaseFilePath == "")
                databaseFilePath = "./PB.txt";

            string driftdatabaseFilePath = cfg.Get("DriftDatabase");
            if (driftdatabaseFilePath == "")
                driftdatabaseFilePath = "./DriftPB.txt";

            string FtpServer = cfg.Get("FtpServer");
            string FtpLogin = cfg.Get("FtpLogin");
            string FtpPasswd = cfg.Get("FtpPasswd");
            string FtpRemotePath = cfg.Get("FtpRemotePath");


            string host = cfg.Get("Host");
            if (host == "") host = "127.0.0.1";

            int port = 29999;
            try { port = int.Parse(cfg.Get("Port")); }
            catch (Exception) { }

            try { TCPmode = bool.Parse(cfg.Get("TCPmode")); }
            catch (Exception) { }

            onConnectLines = cfg.Get("ConnectMsg").Split('|');
            PBAction = cfg.Get("PBAction");
            PBQualAction = cfg.Get("PBQualAction");

            EnterPitAction = cfg.Get("EnterPitAction");
            LeaveRaceAction = cfg.Get("LeaveRaceAction");

            #region Pitting Penalties


            DriveThroughPenaltyAction = cfg.Get("DriveThroughPenaltyAction");
            StopGoPenaltyAction = cfg.Get("StopGoPenaltyAction");
            Time45PenaltyAction = cfg.Get("Time45PenaltyAction");
            Time30PenaltyAction = cfg.Get("Time30PenaltyAction");



            try { MaxDriveThroughPenalties = int.Parse(cfg.Get("MaxDriveThroughPenalties")); }
            catch (Exception) { }
            try { MaxStopGoPenalties = int.Parse(cfg.Get("MaxStopGoPenalties")); }
            catch (Exception) { }

            #endregion

            #region Flooding options


            FloodAction = cfg.Get("FloodAction");

            try { MaxFloodLinesTime = int.Parse(cfg.Get("MaxFloodLinesTime")); }
            catch (Exception) { }

            try { MaxFloodLines = int.Parse(cfg.Get("MaxFloodLines")); }
            catch (Exception) { }

            #endregion

            #region Drifting options

            DriftPBAction = cfg.Get("DriftPBAction");
            DriftTooLowAction = cfg.Get("DriftTooLowAction");


            try { MinimumDriftScore = int.Parse(cfg.Get("MinimumDriftScore")); }
            catch (Exception) { }

            try { MinimumDriftSpeed = int.Parse(cfg.Get("MinimumDriftSpeed")); }
            catch (Exception) { }

            try { MinimumDriftAngle = int.Parse(cfg.Get("MinimumDriftAngle")); }
            catch (Exception) { }

            try { MaximumDriftAngle = int.Parse(cfg.Get("MaximumDriftAngle")); }
            catch (Exception) { }

            PrivateMessageOnDriftScore = cfg.Get("PrivateMessageOnDriftScore");
            DriftLapAction = cfg.Get("DriftLapAction");

            GoodDriftAction = cfg.Get("GoodDriftAction");
            try { GoodDriftScore = int.Parse(cfg.Get("GoodDriftScore")); }
            catch (Exception) { }

            #endregion
            #region Handicap options
            OnToLowHandicap = cfg.Get("OnToLowHandicap");
            #endregion
            #region Idling options

            OnIdleAction1 = cfg.Get("OnIdleAction1");
            OnIdleAction2 = cfg.Get("OnIdleAction2");

            try { OnIdleTimeout1 = 10 * int.Parse(cfg.Get("OnIdleTimeout1")); }
            catch (Exception) { }
            try { OnIdleTimeout2 = 10 * int.Parse(cfg.Get("OnIdleTimeout2")); }
            catch (Exception) { }

            #endregion

            try { MaxNbInStunt = int.Parse(cfg.Get("MaxNbInStunt")); }
            catch (Exception) { }
            if (MaxNbInStunt == -1)
                MaxNbInStunt = 32768;
            MaxNbInStuntAction = cfg.Get("MaxNbInStuntAction");

            autoActionLines = cfg.Get("AutoAction").Split('|');
            autoMsgLinesPrivate = cfg.Get("AutoMsgPrivate").Split('|');
            RaceStartAction = cfg.Get("RaceStartAction");

            //####################################
            //Start Read ConfigVars for LicenseHack by Venni
            //####################################
            CheckLicense = cfg.Get("CheckLicense");
            NoLicenseActionLines = cfg.Get("NoLicenseAction").Split('|'); ;
            //####################################
            //Start Read ConfigVars for LicenseHack by Venni
            //####################################

            for (int i = 0; i < (int)paramLapper.maxSplit; i++)
            {
                PrivMessSpbLow[i] = cfg.Get("PrivMessSpb" + (i+1).ToString() + "Low");
                PrivMessSpbUp[i] = cfg.Get("PrivMessSpb" + (i+1).ToString() + "Up");
            }
            PrivMessSpbLastLow = cfg.Get("PrivMessSpbLastLow");
            PrivMessSpbLastUp = cfg.Get("PrivMessSpbLastUp");

            BeginPitPrivMess = cfg.Get("BeginPitPrivMess");
            EndPitPrivMess = cfg.Get("EndPitPrivMess");

            OnBeginPit = cfg.Get("OnBeginPit");
            OnEndPit = cfg.Get("OnEndPit");

            #region Qualification
            try { RefreshQualUsers = bool.Parse(cfg.Get("RefreshQualUser")); }
            catch (Exception) { }
            QualUsers = cfg.Get("QualUsers");
            UpdateQualUsers(QualUsers);
            #endregion

            #region Handicap
            try { RefreshHandicapUsers = bool.Parse(cfg.Get("RefreshHandicapUser")); }
            catch (Exception) { }
            HandicapUsers = cfg.Get("HandicapUsers");
            UpdateHandicapUsers(HandicapUsers);
            #endregion


            try { ShowPlayerControl = bool.Parse(cfg.Get("ShowPlayerControl")); }
            catch (Exception) { }

            try { ShowSplitPB = bool.Parse(cfg.Get("ShowSplitPB")); }
            catch (Exception) { }

            try { UseUsernameForAuthentication = bool.Parse(cfg.Get("UseUsernameForAuthentication")); }
            catch (Exception) { }

            try { MinAngleVelocity = int.Parse(cfg.Get("MinAngleVelocity")); }
            catch (Exception) { }

            AngleVelocityAction = cfg.Get("AngleVelocityAction");

            #region Acceleration options
            try { AccelerationStartSpeed = double.Parse(cfg.Get("AccelerationStartSpeed").Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)); }
            catch (Exception) { }
            try { AccelerationEndSpeed = double.Parse(cfg.Get("AccelerationEndSpeed").Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)); }
            catch (Exception) { }
            try { AccelerationStartSpeedMph = double.Parse(cfg.Get("AccelerationStartSpeedMph").Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)); }
            catch (Exception) { }
            try { AccelerationEndSpeedMph = double.Parse(cfg.Get("AccelerationEndSpeedMph").Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)); }
            catch (Exception) { }
            try { AccelerationPrivateMaxTime = double.Parse(cfg.Get("AccelerationPrivateMaxTime").Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)); }
            catch (Exception) { }
            AccelerationPrivateMessage = cfg.Get("AccelerationPrivateMessage");
            #endregion

            DefaultTopCar = cfg.Get("DefaultTopCar");
            if (DefaultTopCar == "")
                DefaultTopCar = "XRT";

            try { MessageTime = int.Parse(cfg.Get("MessageTime")); }
            catch (Exception) { }

            timer = new System.Timers.Timer(10000);
            timer.AutoReset = false;
            timer.Elapsed += new System.Timers.ElapsedEventHandler(timer_Elapsed);


            #region load scheduled tasks

            string taskline = cfg.Get("ScheduledAction");
            string[] tasks = taskline == string.Empty ? null : taskline.Split('|');

            string[] schedules ={ };
            string[] commands = { };
            int par = 0;
            if (tasks != null)
                foreach (string task in tasks)
                {
                    if (par % 2 == 0)
                        schedules = task.Split(':');
                    else
                    {
                        commands = task.Split(':');

                        foreach (string taskCommand in commands)
                            foreach (string taskSchedule in schedules)
                                Tasks.Add(new Task(taskCommand, taskSchedule));
                    }

                    par++;
                }

            //if (par>1)
            {
                ScheduleTimer = new System.Timers.Timer(1000);
                ScheduleTimer.AutoReset = true;
                ScheduleTimer.Elapsed += new System.Timers.ElapsedEventHandler(ScheduleTimer_Elapsed);
            }

            #endregion

            #endregion

            insimConnection.insimConnect(host, port, adminPassword, "U","LFSLapper",false,TCPmode);
            string info = "Product:" + insimConnection.Product + " Version:" + insimConnection.Version + " InSim Version:" + insimConnection.InSimVersion;
            Console.WriteLine(info);
            if (!lfsDb.Load(databaseFilePath, FtpServer, FtpLogin, FtpPasswd, FtpRemotePath))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", databaseFilePath);

            if (!lfsDriftDb.Load(driftdatabaseFilePath, FtpServer, FtpLogin, FtpPasswd, FtpRemotePath))
                System.Console.WriteLine("Warning:Error loading {0} or file does not exist yet!", driftdatabaseFilePath);

            ScheduleTimer.Enabled = true;

            byte[] intervalReq = InSim.Encoder.NLI(100);    //receive status every 100 ms
            insimConnection.Send(intervalReq, intervalReq.Length);



            Console.WriteLine("LFSLapper is running...");
            byte[] sstreq = InSim.Encoder.SST();
            insimConnection.Send(sstreq, sstreq.Length);

            Loop(insimConnection);

            // terminate
            byte[] terreq = InSim.Encoder.ISC();
            insimConnection.Send(terreq, terreq.Length);

            insimConnection.Close();
        }

        void ScheduleTimer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            try
            {
                for (int i = 0; i < Tasks.Count; i++)
                {
                    Task task = (Task)Tasks[i];
                    if (task.IsToExecuteNow())
                    {
                        if (task.Command.IndexOf("/rcm_") != -1)
                            RestartTimer();

                        this.SendMsg(this.GlobalOptionsReplace(task.Command));
                        if (task.IsOnceToExecuteOnly)
                            Tasks.RemoveAt(i--);
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }

        void RestartTimer()
        {
            timer.Stop();
            timer.Interval = MessageTime;
            timer.Start();
        }
        
        void timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            SendMsg("/rcc_all");
        }

        string GlobalOptionsReplace(string action)
        {

            #region time
            action = action.Replace("{ShortTime}", System.DateTime.Now.ToShortTimeString());
            action = action.Replace("{LongTime}", System.DateTime.Now.ToLongTimeString());
            #endregion

            #region date
            action = action.Replace("{ShortDate}", System.DateTime.Now.ToShortDateString());
            action = action.Replace("{LongDate}", System.DateTime.Now.ToLongDateString());
            #endregion

            #region other
            action = action.Replace("{ShortTrackName}", this.currentTrackName);
            action = action.Replace("{LongTrackName}", InSim.Decoder.getLongTrackName( this.currentTrackName ));
            #endregion

            #region special chars
            action = action.Replace("{colon}", ":");
            action = action.Replace("{vbar}", "|");
            action = action.Replace("{at}", "@");
            #endregion

            return action;
        }

        void Loop(InSim.Connect insimConnection)
        {
            bool InRace = false;
            bool flagFirst = true;
            bool imediateSaveDb = false;
            bool delayedSaveDb = false;
            DateTime nextSaveDb = DateTime.Now.AddSeconds((double)paramLapper.delayedSave);
            bool imediateSaveDriftDb = false;
            bool delayedSaveDriftDb = false;
            bool bugAutoAction = false;
            bool bugAutoMsg = false;
            DateTime nextSaveDriftDb = DateTime.Now.AddSeconds((double)paramLapper.delayedSave);
            string tmpPrivMess;
            posQualUser tmpPosQualUser;
            infoPlayer currInfoPlayer;


            while (true)
            {
                byte[] recvPacket = insimConnection.Receive();
#if MONO
#else
                if (remoteEP.Port != ((System.Net.IPEndPoint)uc.Client.RemoteEndPoint).Port)
                {
                    Console.WriteLine("Received UDP packet from unknown port {0}", ((System.Net.IPEndPoint)uc.Client.RemoteEndPoint).Port);
                    continue;
                }
#endif
                // Query of save DBS
                if (imediateSaveDb || (delayedSaveDb && DateTime.Now > nextSaveDb))
                {
/*
                    if (imediateSaveDb)
                        Console.WriteLine("immediate saveDB");
                    else
                        Console.WriteLine("Delayed saveDB");
*/
                    delayedSaveDb = false;
                    imediateSaveDb = false;
                    nextSaveDb = DateTime.Now.AddSeconds((double)paramLapper.delayedSave);
                    lfsDb.Save();
                }
                // Query of save DBS
                if (imediateSaveDriftDb || (delayedSaveDriftDb && DateTime.Now > nextSaveDriftDb))
                {
/*
                    if (imediateSaveDriftDb)
                        Console.WriteLine("immediate saveDriftDB");
                    else
                        Console.WriteLine("Delayed saveDriftDB");
*/
                    delayedSaveDriftDb = false;
                    imediateSaveDriftDb = false;
                    nextSaveDriftDb = DateTime.Now.AddSeconds((double)paramLapper.delayedSave);
                    lfsDriftDb.Save();
                }
                if (recvPacket.Length > 3)
                {
                    string packetHead = insimConnection.packetHead(recvPacket);
                    uint verifyID = insimConnection.verifyID(recvPacket);
//                    if (packetHead != "MCI")
//                        Console.WriteLine(packetHead);

                    switch (packetHead)
                    {
                        case "TINY"://confirm ack with ack
                            // Keep ALIVE
                            InSim.Decoder.TINY tiny = new InSim.Decoder.TINY(recvPacket);
                            // Keep alive connection
                            if (tiny.SubT == "TINY_NONE")
                            {
                                byte[] stiny = InSim.Encoder.TINY_NONE();
                                insimConnection.Send(stiny, stiny.Length);
                            }
                            break;

                        case "RST":
                            InRace = true;
                            InSim.Decoder.RST rst = new InSim.Decoder.RST(recvPacket);

                            debug.Add(packetHead, rst, rst.GetType(), debugmode);

                            //Raz of idle on start
                            listOfPlayers.raceRestart();
                            if (rst.QualMins == 0) //race began
                            {
                                string Action = RaceStartAction;
                                string[] respcommands = Action.Split('|');
                                foreach (string respcommand in respcommands)
                                    Tasks.Add(new Task(respcommand, DateTime.Now + new TimeSpan(0, 0, 5)));
                            }

                            break;

                        case "REN":
                            if(debugmode)Console.WriteLine("Race ENd (return to entry screen)");

                            debug.Add(packetHead, "Race ENd (return to entry screen)", debugmode);

                            break;
                        case "NCN":
                            InSim.Decoder.NCN newConnection = new InSim.Decoder.NCN(recvPacket);

                            debug.Add(packetHead, newConnection, newConnection.GetType(), debugmode);

                            listOfPlayers.newPlayer(newConnection.UCID, newConnection.userName, newConnection.nickName, insimConnection.Product);

                            //##############################
                            //# StartLicense Hack by Venni
                            //##############################
                            if (CheckLicense != "") 
                            {
                                licenses lc = new licenses();
                                if (!lc.islicensed(newConnection.userName, CheckLicense.Replace("{Username}", newConnection.userName)))
                                {
                                    foreach (string respcommand in NoLicenseActionLines)
                                    {
                                        Tasks.Add(new Task(respcommand.Replace("{Username}", newConnection.userName), DateTime.Now + new TimeSpan(0, 0, 5)));
                                    }
                                }
                            }
                            //###############################
                            //# End of License Hack by Venni
                            //###############################

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(newConnection.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            cfu.retreive(currInfoPlayer);
                            if (currInfoPlayer.CName == "")
                                currInfoPlayer.CName = DefaultTopCar;
                            if (currInfoPlayer.CName != "")
                            {
                                LFS.PlayerStats nplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                currInfoPlayer.updateSaved(nplys);
                                LFS.DriftPlayerStats plysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                currInfoPlayer.updateSavedDrift(plysDrift);

                            }
                            foreach (string line in onConnectLines)
                            {
                                string line2;
                                posQualUser retValue;
                                line2 = line;
                                retValue = getPosQual(currInfoPlayer, true);
                                if (retValue.posUser != 0)
                                    line2 = line2.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                                else
                                    line2 = line2.Replace("{Posqual}", "-/-");
                                if (retValue.groupUser != -1)
                                    line2 = line2.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                else
                                    line2 = line2.Replace("{Groupqual}", "-");
                                retValue = getPosQual(currInfoPlayer, false);
                                line2 = line2.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);
                                line2 = line2.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                line2 = line2.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                line2 = line2.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                line2 = line2.Replace("{Car}", currInfoPlayer.CName);

                                SendMsgToConnection(newConnection.UCID, this.GlobalOptionsReplace(line2));
                            }

                            break;

                        case "CNL": // ConN Leave (end connection is moved down into this slot)
                            InSim.Decoder.CNL lostConnection = new InSim.Decoder.CNL(recvPacket);

                            debug.Add(packetHead, lostConnection, lostConnection.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(lostConnection.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }

                            listOfPlayers.removePlayer(lostConnection.UCID);
                            if (debugmode)
                                Console.WriteLine(string.Format("Username:{0} Nickname:{1} ConnectionNumber:{2}", currInfoPlayer.userName, currInfoPlayer.nickName, lostConnection.UCID));
                            break;

                        case "NPL": // New PLayer joining race (if number already exists, then leaving pits)
                            InSim.Decoder.NPL newPlayer = new InSim.Decoder.NPL(recvPacket);

                            debug.Add(packetHead, newPlayer, newPlayer.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(newPlayer.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            listOfPlayers.majIndexPLID(newPlayer.UCID, newPlayer.PLID);
// If player change car, Clear session
                            if (currInfoPlayer.CName != newPlayer.CName)
                            {
                                currInfoPlayer.clearSessionInfo();
                            }
                            currInfoPlayer.CName = newPlayer.CName;
                            LFS.PlayerStats plys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSaved(plys);
                            LFS.DriftPlayerStats nplplysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSavedDrift(nplplysDrift);
// If indication of Handicap of current player
                            currInfoPlayer.H_Mass = newPlayer.H_Mass;
                            currInfoPlayer.H_TRes = newPlayer.H_TRes;
                            if (playerHandicap.ContainsKey(currInfoPlayer.userName.ToLower()))
                            {
                                if (newPlayer.H_Mass < (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandUser).H_Mass
                                     || newPlayer.H_TRes < (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandUser).H_TRes)
                                {
                                    string _toLow = OnToLowHandicap;
                                    _toLow = _toLow.Replace("{Nickname}", currInfoPlayer.nickName);
                                    _toLow = _toLow.Replace("{Username}", currInfoPlayer.userName);
                                    _toLow = _toLow.Replace("{H_Mass}", (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandUser).H_Mass.ToString());
                                    _toLow = _toLow.Replace("{H_TRes}", (playerHandicap[currInfoPlayer.userName.ToLower()] as infoHandUser).H_TRes.ToString());

                                    string[] respcommands2 = _toLow.Split('|');
                                    foreach (string respcommand in respcommands2)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                            }
                            string addInfo = "";

                            for (int i = 1; i < 13; i++)
                            {
                                if (((uint)(newPlayer.Flags) & (uint)(2 << i)) != 0)
                                    addInfo += ((InSim.Decoder.NPL.PlayerFlags)(2 << i)).ToString() + " ";
                            }
                            if (addInfo.Length != 0 && ShowPlayerControl)
                                SendMsg("/msg " + addInfo);
                            break;

                        case "PLP": //PLayer Pits (go to settings - stays in player list)
                            InSim.Decoder.PLP plp = new InSim.Decoder.PLP(recvPacket);

                            debug.Add(packetHead, plp, plp.GetType(), debugmode);


                            currInfoPlayer = listOfPlayers.getPlayerByPLID(plp.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }

                            if (EnterPitAction.IndexOf("/rcm_") != -1)
                                RestartTimer();
                            string _EnterPitAction = EnterPitAction;
                            _EnterPitAction = _EnterPitAction.Replace("{Nickname}", currInfoPlayer.nickName );
                            _EnterPitAction = _EnterPitAction.Replace("{Username}", currInfoPlayer.userName );
                            string[] enterpitcommands = _EnterPitAction.Split('|');
                            foreach (string enterpitcommand in enterpitcommands)
                                SendMsg(GlobalOptionsReplace(enterpitcommand));

                            break;

                        case "PLL": // PLayer Leave race (spectate - leaves player list, all are shunted down)
                            InSim.Decoder.PLL pll = new InSim.Decoder.PLL(recvPacket);

                            debug.Add(packetHead, pll, pll.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pll.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            currInfoPlayer.showButton = 0;
                            ClearButton(currInfoPlayer);
                            if (LeaveRaceAction.IndexOf("/rcm_") != -1)
                                RestartTimer();
                            string _LeaveRaceAction = LeaveRaceAction;
                            _LeaveRaceAction = _LeaveRaceAction.Replace("{Nickname}", currInfoPlayer.nickName );
                            _LeaveRaceAction = _LeaveRaceAction.Replace("{Username}", currInfoPlayer.userName);
                            string[] leaveracecommands = _LeaveRaceAction.Split('|');
                            foreach (string leaveracecommand in leaveracecommands)
                                SendMsg(GlobalOptionsReplace(leaveracecommand));

                            listOfPlayers.removeIndexPLID(pll.PLID);

                            break;

                        case "CPR": // Player rename
                            InSim.Decoder.CPR cpr = new InSim.Decoder.CPR(recvPacket);

                            debug.Add(packetHead, cpr, cpr.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(cpr.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            // For make bug programm to test object debug
/*
                            currInfoPlayer = listOfPlayers.getPlayerByUCID(300);
                            currInfoPlayer.CName = "";
*/

                            string oldNickName = currInfoPlayer.nickName;
                            currInfoPlayer.Rename(cpr.newNickName);
                            if (currInfoPlayer.demoPlayer)
                            {
                                if (currInfoPlayer.CName == "")
                                    currInfoPlayer.CName = DefaultTopCar;
                                if (currInfoPlayer.CName != "")
                                {
                                    LFS.PlayerStats nplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                    currInfoPlayer.updateSaved(nplys);
                                    LFS.DriftPlayerStats plysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                                    currInfoPlayer.updateSavedDrift(plysDrift);
                                }
                            }
// Sometime LFS send a CPR with same oldNickname and newNickname, maybe a new uniqueID
// if you do .Remove of Var the programm crash because the ref of var are same and the program crash;
                            if (debugmode) Console.WriteLine(string.Format("Conn Player {0} Rename from {1} to {2}, id:{3}",
                                                        currInfoPlayer.userName,
                                                        oldNickName,
                                                        cpr.newNickName,
                                                        cpr.UCID)
                             );
                            break;

                        case "CLR": // "CLear Race - all players removed from race in one go"
                            InRace = false; 

                            debug.Add(packetHead, "CLear Race - all players removed from race in one go", debugmode);

                            break;

                        case "LAP": // LAP time
                            InSim.Decoder.LAP lapDec = new InSim.Decoder.LAP(recvPacket);

                            debug.Add(packetHead, lapDec, lapDec.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(lapDec.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            delayedSaveDb = true;   // enable delayed save DB on new Lap

                            if (lapDec.LTime == timeConv.HMSToLong(60, 0, 0))
                                goto endOfLap;
                            if (debugmode) Console.WriteLine(string.Format(
                                    "UserName:{0} NickName:{1} CarName:{2} PlayerID:{3} Time:{4}",
                                    currInfoPlayer.userName,
                                    currInfoPlayer.nickName,
                                    currInfoPlayer.CName,
                                    lapDec.PLID.ToString(),
                                    timeConv.LongToHMS(lapDec.LTime)
                            ));
                            string lapTimeAction = trackInfo.getLapAction(currentTrackName, currInfoPlayer.CName, lapDec.LTime);
                            if (lapTimeAction != "")
                            {
                                lapTimeAction = lapTimeAction.Replace("{LapTime}", timeConv.LongToHMS(lapDec.LTime));
                                lapTimeAction = lapTimeAction.Replace("{Nickname}", currInfoPlayer.nickName);

                                if (lapTimeAction.IndexOf("/rcm_") != -1)
                                    RestartTimer();
                                string[] respcommands = lapTimeAction.Split('|');
                                foreach (string respcommand in respcommands)
                                    SendMsg(respcommand);
                            }

                            // drift scores
                            if (currInfoPlayer.totaldriftscore >= MinimumDriftScore)
                            {
                                currInfoPlayer.updateLapDriftScore(currentTrackName);
                                if (currInfoPlayer.newBestdriftScore)
                                {
                                    lfsDriftDb.updateRow(currInfoPlayer, currentTrackName);
                                    imediateSaveDriftDb = true;
                                    try
                                    {
                                        if (DriftPBAction.IndexOf("/rcm_") != -1)
                                            RestartTimer();

                                        string Action = DriftPBAction;
                                        Action = Action.Replace("{Nickname}", currInfoPlayer.nickName);
                                        Action = Action.Replace("{DriftScore}", ((int)currInfoPlayer.totaldriftscore).ToString());
                                        Action = Action.Replace("{Car}", currInfoPlayer.CName);
                                        Action = Action.Replace("{Username}", currInfoPlayer.userName);
                                        Action = Action.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                        Action = Action.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                        Action = Action.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                        string[] respcommands = Action.Split('|');
                                        foreach (string respcommand in respcommands)
                                            SendMsg(this.GlobalOptionsReplace(respcommand));
                                    }
                                    catch (Exception ex)
                                    {
                                        Console.WriteLine(ex.ToString());
                                    }
                                }
                                else
                                {
                                    try
                                    {

                                        if (DriftLapAction.IndexOf("/rcm_") != -1)
                                            RestartTimer();

                                        string Action = DriftLapAction;
                                        Action = Action.Replace("{Nickname}", currInfoPlayer.nickName);
                                        Action = Action.Replace("{DriftScore}", ((int)currInfoPlayer.totaldriftscore).ToString());
                                        Action = Action.Replace("{Car}", currInfoPlayer.CName);
                                        Action = Action.Replace("{Username}", currInfoPlayer.userName);
                                        Action = Action.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                        Action = Action.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                        Action = Action.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));

                                        string[] respcommands = Action.Split('|');
                                        foreach (string respcommand in respcommands)
                                            SendMsg(this.GlobalOptionsReplace(respcommand));
                                    }
                                    catch (Exception ex)
                                    {
                                        Console.WriteLine(ex.ToString());
                                    }
                                }
                            }
                            else
                            {
                                try
                                {
                                    if (DriftTooLowAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string Action = DriftTooLowAction;
                                    Action = Action.Replace("{Nickname}", currInfoPlayer.nickName);
                                    Action = Action.Replace("{DriftScore}", ((int)currInfoPlayer.totaldriftscore).ToString());
                                    Action = Action.Replace("{Car}", currInfoPlayer.CName);
                                    Action = Action.Replace("{Username}", currInfoPlayer.userName);
                                    Action = Action.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                    Action = Action.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                    Action = Action.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                    string[] respcommands = Action.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.ToString());
                                }
                            }
                            // For non drifting Update row of DB Every Laps
                            currInfoPlayer.updateLap(lapDec.LTime, trackInfo.getMaxLapTime(currentTrackName, currInfoPlayer.CName), currentTrackName);
                            lfsDb.updateRow(currInfoPlayer, currentTrackName);
                            // On new Split
                            string spbAction = "";
                            switch( currInfoPlayer.viewSPBSplit ){
                                case 'P':
                                    if (currInfoPlayer.newPBBestSplit)
                                        spbAction = PrivMessSpbLastLow;
                                    else
                                        spbAction = PrivMessSpbLastUp;
                                    break;
                                case 'S':
                                    if (currInfoPlayer.newSessBestSplit)
                                        spbAction = PrivMessSpbLastLow;
                                    else
                                        spbAction = PrivMessSpbLastUp;
                                    break;
                                case 'W':
                                    if (currInfoPlayer.newWRBestSplit)
                                        spbAction = PrivMessSpbLastLow;
                                    else
                                        spbAction = PrivMessSpbLastUp;
                                    break;
                            }
                            if (ShowSplitPB && currInfoPlayer.showSplitPB && spbAction != "")
                            {
                                spbAction = spbAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                spbAction = spbAction.Replace("{Username}", currInfoPlayer.userName);
                                spbAction = spbAction.Replace("{CurSplit}", timeConv.LongToHMS(currInfoPlayer.currSplit));
                                spbAction = spbAction.Replace("{BestSplit}", timeConv.LongToHMS(currInfoPlayer.bestSplit));
                                spbAction = spbAction.Replace("{DiffSplit}", timeConv.LongToHMS(currInfoPlayer.diffSplit));
                                spbAction = spbAction.Replace("{BestSpeed}", string.Format("{0:n}",getSpeed( currInfoPlayer.unitSpeedKmh, currInfoPlayer.bestSpeed)));
                                spbAction = spbAction.Replace("{UnitSpeed}", getUnitSpeed( currInfoPlayer.unitSpeedKmh ));
                                spbAction = spbAction.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                                spbAction = spbAction.Replace("{AvgSpeed}", string.Format("{0:n}",getSpeed(currInfoPlayer.unitSpeedKmh,trackInfo.getAvgSpeed(currentTrackName, lapDec.LTime))));
                                spbAction = spbAction.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                spbAction = spbAction.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                spbAction = spbAction.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                spbAction = spbAction.Replace("{Car}", currInfoPlayer.CName);
                                if (currInfoPlayer.viewSPBSplit == 'P')
                                    spbAction = spbAction.Replace("{typ}", "PB");
                                if (currInfoPlayer.viewSPBSplit == 'S')
                                    spbAction = spbAction.Replace("{typ}", "Sess");
                                if (currInfoPlayer.viewSPBSplit == 'W')
                                    spbAction = spbAction.Replace("{typ}", "WR ");

                                posQualUser retValue;
                                retValue = getPosQual(currInfoPlayer, true);
                                if (retValue.posUser != 0)
                                    spbAction = spbAction.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                                else
                                    spbAction = spbAction.Replace("{Posqual}", "-/-");
                                if (retValue.groupUser != -1)
                                    spbAction = spbAction.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                else
                                    spbAction = spbAction.Replace("{Groupqual}", "-");
                                retValue = getPosQual(currInfoPlayer, false);
                                spbAction = spbAction.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);
                                SendMultilineMsgPrivate(currInfoPlayer.UCID, spbAction);
                            }
                            // If new PB
                            if (currInfoPlayer.isNewPBLtime)
                            {
                                imediateSaveDb = true;
                                try
                                {
                                    string CurAction;
                                    if (playerFilter.ContainsKey(currInfoPlayer.userName.ToLower()))
                                        CurAction = PBQualAction;
                                    else
                                        CurAction = PBAction;
                                    if (CurAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();
                                    string Action = CurAction;
                                    Action = Action.Replace("{Nickname}", currInfoPlayer.nickName);
                                    Action = Action.Replace("{LapTime}", timeConv.LongToHMS(lapDec.LTime));
                                    Action = Action.Replace("{Car}", currInfoPlayer.CName);
                                    Action = Action.Replace("{Username}", currInfoPlayer.userName);
                                    Action = Action.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                    Action = Action.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                    Action = Action.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                    Action = Action.Replace("{UnitSpeed}", getUnitSpeed(currInfoPlayer.unitSpeedKmh ));
                                    Action = Action.Replace("{AvgSpeed}", string.Format("{0:n}", getSpeed(currInfoPlayer.unitSpeedKmh, trackInfo.getAvgSpeed(currentTrackName, lapDec.LTime))));

                                    posQualUser retValue;
                                    retValue = getPosQual(currInfoPlayer, true);
                                    if (retValue.posUser != 0)
                                        Action = Action.Replace("{Posqual}", retValue.posUser + "/" + retValue.totalUser);
                                    else
                                        Action = Action.Replace("{Posqual}", "-/-");
                                    if (retValue.groupUser != -1)
                                        Action = Action.Replace("{Groupqual}", ((char)(retValue.groupUser + 65)).ToString());
                                    else
                                        Action = Action.Replace("{Groupqual}", "-");
                                    retValue = getPosQual(currInfoPlayer, false);
                                    Action = Action.Replace("{Posabs}", retValue.posUser + "/" + retValue.totalUser);
                                    string[] respcommands = Action.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                                catch (Exception ex)
                                {
                                    Console.WriteLine(ex.ToString());
                                }
                            }
                        endOfLap:
                            currInfoPlayer.totaldriftscore = 0;//reset score to 0
                            currInfoPlayer.maxLapSpeed = 0;//reset maxlapspeed to 0
                            currInfoPlayer.bestSpeed = (double)0;


                            break;

                        case "SP1":
                        case "SP2":
                        case "SP3":
                        case "SPX": // Splitting info
                            InSim.Decoder.SPX splitdec = new InSim.Decoder.SPX(recvPacket);

                            debug.Add(packetHead, splitdec, splitdec.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(splitdec.PLID);
                            if ( currInfoPlayer == null )
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            if (splitdec.STime == timeConv.HMSToLong(60, 0, 0))
                                break;
                            debug.Add(packetHead, "Before Update Split", debugmode);
                            currInfoPlayer.updateSplit(splitdec.Split, splitdec.STime, currentTrackName);
                            debug.Add(packetHead, "After Update Split", debugmode);
                            // If new splitting on PB file, save value and query save delayed DB
                            if (currInfoPlayer.newPBBestSplit)
                            {
                                lfsDb.updateRow(currInfoPlayer, currentTrackName);
                                delayedSaveDb = true;
                            }

                            debug.Add(packetHead, "Before SplitNotify", debugmode);
                            SplitNotify(currInfoPlayer, splitdec);
                            debug.Add(packetHead, "After SplitNotify", debugmode);
                            break;

                        case "RES": // RESult (qualify or finish)
                            InSim.Decoder.RES res = new InSim.Decoder.RES(recvPacket);

                            debug.Add(packetHead, res, res.GetType(), debugmode);

                            InRace = false;
                            break;
                        case "FIN": // New Insim Packet
                            InSim.Decoder.FIN fin = new InSim.Decoder.FIN(recvPacket);

                            debug.Add(packetHead, fin, fin.GetType(), debugmode);
                            
                            break;
                        case "REO": // REOrder (when race restarts after qualifying)
                            InSim.Decoder.REO reo = new InSim.Decoder.REO(recvPacket);

                            debug.Add(packetHead, reo, reo.GetType(), debugmode);
                            break;

                        case "STA": // State
                            InSim.Decoder.STA state = new InSim.Decoder.STA(recvPacket);

                            debug.Add(packetHead, state, state.GetType(), debugmode);

                            if (currentTrackName != state.ShortTrackName)
                            {
                                listOfPlayers.changeTrack(state.ShortTrackName,lfsDb,lfsDriftDb);
                            }
                            currentTrackName = state.ShortTrackName;
                            if (debugmode) Console.WriteLine("Current track:" + currentTrackName
                                                     + " Conn:" + state.NumConns
                                        + " Player:" + state.NumP
                                        + " Flags:" + ( state.Flags & 512 )
                            );
                            if (flagFirst == true && (state.Flags & 512) == 512 )
                            {
                                flagFirst = false;
                                // Get All Connections
                                byte[] ncn = InSim.Encoder.NCN();
                                insimConnection.Send(ncn, ncn.Length);
                                // Get All Players
                                byte[] npl = InSim.Encoder.NPL();
                                insimConnection.Send(npl, npl.Length);
                            }

                            break;
/*
                        case "MSS":
                            InSim.Decoder.MSS mss = new InSim.Decoder.MSS(recvPacket);
                            if (debugmode) Console.WriteLine("MSS Message received Username:{0} Player name:{1} Message:{2}",mss.UserName,mss.PlayerName,mss.Message);
*/
                        case "MSO":
                            InSim.Decoder.MSO msg = new InSim.Decoder.MSO(recvPacket);

                            debug.Add(packetHead, msg, msg.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(msg.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            string nicknamewithoutcolors = currInfoPlayer.nickName;
                            if (msg.UserType == 1)
                            {
                                CheckForFlooding(currInfoPlayer);

                                try
                                {
                                    for (int i = 0; i < autoActionLines.Length; i += 2)
                                    {
                                        string reqline = this.autoActionLines[i];

                                        bool allowAction = true;
                                        int authidx = reqline.IndexOf("@");
                                        if (authidx != -1)
                                        {
                                            allowAction = false;
                                            string[] authUsers = reqline.Substring(authidx + 1).Split(',');
                                            reqline = reqline.Substring(0, authidx);

                                            foreach (string authuser in authUsers)
                                            {

                                                if (UseUsernameForAuthentication)
                                                {
                                                    if (currInfoPlayer.userName.Trim().ToLower() == authuser.Trim().ToLower())//   <- for licensed players
                                                    {
                                                        allowAction = true;
                                                        break;
                                                    }
                                                }
                                                else
                                                {
                                                    if (currInfoPlayer.nickName.Trim() == authuser.Trim())//   <- for demo players
                                                    {
                                                        allowAction = true;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        // For user in File
                                        authidx = reqline.IndexOf("&");
                                        if (authidx != -1)
                                        {
                                            allowAction = false;
                                            string authUsersFile = reqline.Substring(authidx + 1);
                                            reqline = reqline.Substring(0, authidx);
                                            if (authUsersFile != "")
                                            {
                                                try
                                                {
                                                    using (System.IO.StreamReader sr = new System.IO.StreamReader(authUsersFile))
                                                    {
                                                        string lusername;
                                                        while (true)
                                                        {
                                                            lusername = sr.ReadLine();

                                                            if (lusername == null)
                                                                break;
                                                            if (UseUsernameForAuthentication)
                                                            {
                                                                if (currInfoPlayer.userName.Trim().ToLower() == lusername.Trim().ToLower())//   <- for licensed players
                                                                {
                                                                    allowAction = true;
                                                                    break;
                                                                }
                                                            }
                                                            else
                                                            {
                                                                if (currInfoPlayer.nickName.Trim() == lusername.Trim())//   <- for demo players
                                                                {
                                                                    allowAction = true;
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                catch
                                                {
                                                    allowAction = false;
                                                }
                                            }
                                        }

                                        string[] words = reqline.Split(':');
                                        string respline = this.autoActionLines[i + 1];
                                        if (allowAction)
                                            foreach (string w in words)
                                            {
                                                int off = msg.message.ToUpper().IndexOf(w.ToUpper());
                                                if (off != -1)
                                                {
                                                    respline = respline.Replace("{Nickname}", currInfoPlayer.nickName);
                                                    respline = respline.Replace("{Username}", currInfoPlayer.userName);
                                                    respline = respline.Replace("{*}", msg.message.Substring(off + w.Length).Trim());
                                                    Console.WriteLine(respline);

                                                    if (respline.IndexOf("/rcm_") != -1)
                                                        RestartTimer();

                                                    string[] respcommands = respline.Split(':');
                                                    foreach (string respcommand in respcommands)
                                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                                }
                                            }
                                    }
                                }
                                catch (System.Exception)
                                {
                                    if (bugAutoAction == false)
                                    {
                                        SendMsg("Parameter PB on AutoAction contact admin Server");
                                        bugAutoAction = true;
                                    }
                                    break;
                                }
                                try
                                {
                                    for (int i = 0; i < autoMsgLinesPrivate.Length; i += 2)
                                    {
                                        string reqline = this.autoMsgLinesPrivate[i];

                                        string[] words = reqline.Split(':');
                                        string respline = this.autoMsgLinesPrivate[i + 1];
                                        respline = respline.Replace("{Car}", currInfoPlayer.CName);
                                        respline = respline.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                        respline = respline.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                        respline = respline.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                        respline = respline.Replace("{Nickname}", currInfoPlayer.nickName);
                                        respline = respline.Replace("{Username}", currInfoPlayer.userName);

                                        foreach (string w in words)
                                        {
                                            int off = msg.message.ToUpper().IndexOf(w.ToUpper());
                                            if (off != -1)
                                            {
                                                respline = respline.Replace("{*}", msg.message.Substring(off + w.Length).Trim());
                                                SendMultilineMsgPrivate(msg.UCID, respline);
                                                goto finautomess;
                                            }
                                        }
                                    }
                                finautomess:
                                    int nop;
                                }
                                catch (System.Exception)
                                {
                                    if (bugAutoMsg == false)
                                    {
                                        SendMsg("Parameter PB on autoMsgLinesPrivate contact admin server");
                                        bugAutoMsg = true;
                                    }

                                }
                            }
                            break;
                        case "MCI":

                            InSim.Decoder.MCI mci = new InSim.Decoder.MCI(recvPacket);
                            for (int i = 0; i < System.Math.Min(8,mci.numOfPlayers); i++)
                            {
                                double xm = mci.compCar[i].x / 65536d;
                                double ym = mci.compCar[i].y / 65536d;
                                double zm = mci.compCar[i].z / 65536d;

                                double spm = mci.compCar[i].speed / 327.68 * 3.6; // kmh
                                double dirm = mci.compCar[i].direction * 180 / 32768d;
                                double headm = mci.compCar[i].heading * 180 / 32768d;
                                double angm = mci.compCar[i].angvel * 180 / 8192d;
                                currInfoPlayer = listOfPlayers.getPlayerByPLID( mci.compCar[i].PLID );
                                if (currInfoPlayer != null)
                                {
                                    double accStart;
                                    double accStop;
                                    if (currInfoPlayer.unitSpeedKmh)
                                    {
                                        accStart = AccelerationStartSpeed;
                                        accStop = AccelerationEndSpeed;
                                    }
                                    else
                                    {
                                        accStart = AccelerationStartSpeedMph * 1.609344;
                                        accStop = AccelerationEndSpeedMph * 1.609344;
                                    }
                                    currInfoPlayer.UpdateState(xm, ym, zm, spm, dirm, headm, angm, MinimumDriftSpeed, MinimumDriftAngle, MaximumDriftAngle, MinAngleVelocity, accStart, accStop);
                                }
                            }
                            foreach (System.Collections.DictionaryEntry de in listOfPlayers.playersUCID )
                            {
                                currInfoPlayer = (infoPlayer)de.Value;

                                // check for instunt time player

                                if (currInfoPlayer.stuntticks == MaxNbInStunt)
                                {
                                    if (MaxNbInStuntAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string MaxStuntAction = MaxNbInStuntAction;
                                    MaxStuntAction = MaxStuntAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                    MaxStuntAction = MaxStuntAction.Replace("{AngleVelocity}", currInfoPlayer.AngVel.ToString("F0"));
                                    MaxStuntAction = MaxStuntAction.Replace("{Username}", currInfoPlayer.userName);
                                    string[] respcommands = MaxStuntAction.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }
                                else if (currInfoPlayer.stuntticks == 1)
                                {
                                    if (AngleVelocityAction.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string StuntAction = AngleVelocityAction;

                                    StuntAction = StuntAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                    StuntAction = StuntAction.Replace("{AngleVelocity}", currInfoPlayer.AngVel.ToString("F0"));
                                    StuntAction = StuntAction.Replace("{Username}", currInfoPlayer.userName);

                                    string[] respcommands = StuntAction.Split('|');
                                    foreach (string respcommand in respcommands)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                }

                                // check for idle time
                                if (InRace == false) // if not in race, Force IdleTick for each player to 0
                                    currInfoPlayer.idleticks = 0;
                                if (currInfoPlayer.idleticks > OnIdleTimeout2)
                                {
                                    if (OnIdleAction1.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string _IdleAction = OnIdleAction2;
                                    _IdleAction = _IdleAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                    _IdleAction = _IdleAction.Replace("{Username}", currInfoPlayer.nickName);

                                    string[] respcommands2 = _IdleAction.Split('|');
                                    foreach (string respcommand in respcommands2)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));

                                    currInfoPlayer.idleticks = 0; //reset to zero afterwards, don't want flooding
                                    currInfoPlayer.OnIdleAction1Sended = false;
                                }
                                if ((currInfoPlayer.idleticks > OnIdleTimeout1) && (currInfoPlayer.OnIdleAction1Sended == false))
                                {
                                    if (OnIdleAction1.IndexOf("/rcm_") != -1)
                                        RestartTimer();

                                    string _IdleAction = OnIdleAction1;
                                    _IdleAction = _IdleAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                    _IdleAction = _IdleAction.Replace("{Username}", currInfoPlayer.userName);

                                    string[] respcommands2 = _IdleAction.Split('|');
                                    foreach (string respcommand in respcommands2)
                                        SendMsg(this.GlobalOptionsReplace(respcommand));
                                    currInfoPlayer.OnIdleAction1Sended = true;
//                                    p.idleticks = 0; //reset to zero afterwards, don't want flooding
                                }
                                
                                // write current drift score
                                if (currInfoPlayer.driftticks == 0 && currInfoPlayer.lastdriftscore > 0 && currInfoPlayer.totaldriftscore > 0)
                                {
                                    string _PrivateMsg = this.PrivateMessageOnDriftScore;
                                    _PrivateMsg = _PrivateMsg.Replace("{Nickname}", currInfoPlayer.nickName);
                                    _PrivateMsg = _PrivateMsg.Replace("{Username}", currInfoPlayer.userName);
                                    _PrivateMsg = _PrivateMsg.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                    _PrivateMsg = _PrivateMsg.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                    _PrivateMsg = _PrivateMsg.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                    _PrivateMsg = _PrivateMsg.Replace("{Car}", currInfoPlayer.CName);
                                    _PrivateMsg = _PrivateMsg.Replace("{LastDriftScore}", ((int)currInfoPlayer.lastdriftscore).ToString());
                                    _PrivateMsg = _PrivateMsg.Replace("{DriftScore}", ((int)currInfoPlayer.totaldriftscore).ToString());
                                    SendMsgToConnection(currInfoPlayer.UCID, this.GlobalOptionsReplace(_PrivateMsg));

                                    if (currInfoPlayer.lastdriftscore >= GoodDriftScore)
                                    {
                                        string _GoodDriftAction = GoodDriftAction;
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Nickname}", currInfoPlayer.nickName);
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Username}", currInfoPlayer.userName);
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                        _GoodDriftAction = _GoodDriftAction.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                        _GoodDriftAction = _GoodDriftAction.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                        _GoodDriftAction = _GoodDriftAction.Replace("{Car}", currInfoPlayer.CName);
                                        _GoodDriftAction = _GoodDriftAction.Replace("{LastDriftScore}", ((int)currInfoPlayer.lastdriftscore).ToString());

                                        SendMsg(this.GlobalOptionsReplace(_GoodDriftAction));
                                    }

                                    currInfoPlayer.lastdriftscore = 0;
                                }

                                if (currInfoPlayer.accelerationTimeValid && currInfoPlayer.accelerationTime.TotalSeconds <= AccelerationPrivateMaxTime)
                                {
                                    currInfoPlayer.accelerationTimeValid = false;
                                    string _PrivateAccMsg = AccelerationPrivateMessage;
                                    if (currInfoPlayer.unitSpeedKmh)
                                    {
                                        _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationStartSpeed}", AccelerationStartSpeed.ToString("F0"));
                                        _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationEndSpeed}", AccelerationEndSpeed.ToString("F0"));
                                    }
                                    else
                                    {
                                        _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationStartSpeed}", AccelerationStartSpeedMph.ToString("F0"));
                                        _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationEndSpeed}", AccelerationEndSpeedMph.ToString("F0"));
                                    }
                                    _PrivateAccMsg = _PrivateAccMsg.Replace("{UnitSpeed}", getUnitSpeed(currInfoPlayer.unitSpeedKmh));
                                    _PrivateAccMsg = _PrivateAccMsg.Replace("{AccelerationTime}", currInfoPlayer.accelerationTime.TotalSeconds.ToString("F1"));

                                    SendMsgToConnection(currInfoPlayer.UCID, this.GlobalOptionsReplace(_PrivateAccMsg));
                                }
                            }

                            break;
                        case "ISM": //ISM multiplayer notification packet
                            InSim.Decoder.ISM ism = new InSim.Decoder.ISM(recvPacket);

                            debug.Add(packetHead, ism, ism.GetType(), debugmode);

// Get All Connections
                            System.Threading.Thread.Sleep(100);
                            byte[] ismncn = InSim.Encoder.NCN();
                            insimConnection.Send(ismncn, ismncn.Length);
// Get All Players
                            System.Threading.Thread.Sleep(100);
                            byte[] ismnpl = InSim.Encoder.NPL();
                            insimConnection.Send(ismnpl, ismnpl.Length);
                            break;
                        case "PEN": // NEW PEN : (penalty)
                            InSim.Decoder.PEN pen = new InSim.Decoder.PEN(recvPacket);

                            debug.Add(packetHead, pen, pen.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pen.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            if (pen.NewPen == (int)InSim.pen.PENALTY_SG)
                                ActionOnStopGoPenalty(currInfoPlayer);
                            if( pen.NewPen == (int)InSim.pen.PENALTY_DT )
                                ActionOnDriveThroughPenalty(currInfoPlayer);
                            if( pen.NewPen == (int)InSim.pen.PENALTY_30 )
                                ActionOn30SecondTimePenalty(currInfoPlayer);
                            if( pen.NewPen == (int)InSim.pen.PENALTY_45 )
                                ActionOn45SecondTimePenalty(currInfoPlayer);
                            
                            break;

                        case "BFN": // NEW BFN : (Button request)
                            InSim.Decoder.BFN bfn = new InSim.Decoder.BFN(recvPacket);

                            debug.Add(packetHead, bfn, bfn.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(bfn.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            if (currInfoPlayer.PLID == -1)
                                break;
                            currInfoPlayer.showButton++;
                            if (currInfoPlayer.showButton > 1)
                                currInfoPlayer.showButton = 0;
                            UpButton(currInfoPlayer);
                            break;
                        case "BTC": // NEW BTC : (Button click)
                            InSim.Decoder.BTC btc = new InSim.Decoder.BTC(recvPacket);

                            debug.Add(packetHead, btc, btc.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByUCID(btc.UCID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            if (btc.ClickID == (int)btnID.BUT_SESS) // Session Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'S';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_PB) // PB server Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'P';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_WR) // WR Spb
                            {
                                currInfoPlayer.viewSPBSplit = 'W';
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_SHOW) // Show Split PB
                            {
                                currInfoPlayer.showSplitPB = true; // show
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_HIDE) // Hide Split PB
                            {
                                currInfoPlayer.showSplitPB = false; // Hide
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_KMH) // Speed in KM
                            {
                                currInfoPlayer.unitSpeedKmh = true; // Km/h
                                cfu.update(currInfoPlayer);
                            }
                            if (btc.ClickID == (int)btnID.BUT_MPH) // Speed in MPH
                            {
                                currInfoPlayer.unitSpeedKmh = false; // Mp/h
                                cfu.update(currInfoPlayer);
                            }
                            UpButton(currInfoPlayer);
                            break;
                        case "TOC": // NEW TOC : (take over car)
                            InSim.Decoder.TOC toc = new InSim.Decoder.TOC(recvPacket);

                            debug.Add(packetHead, toc, toc.GetType() , debugmode);

                            infoPlayer oldCurrInfoPlayer = listOfPlayers.getPlayerByPLID(toc.PLID);

                            if (oldCurrInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }

                            listOfPlayers.removeIndexPLID(toc.PLID); // Remove PLID OF oldPlayer
                            listOfPlayers.majIndexPLID(toc.NewUCID, toc.PLID); // Attach PLID to new player

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(toc.PLID);
                            currInfoPlayer.H_Mass = oldCurrInfoPlayer.H_Mass;
                            currInfoPlayer.H_TRes = oldCurrInfoPlayer.H_TRes;
                            currInfoPlayer.CName = oldCurrInfoPlayer.CName;
// Retreive Info of this Player in DBS
                            LFS.PlayerStats tocplys = lfsDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSaved(tocplys);
                            LFS.DriftPlayerStats tocplysDrift = lfsDriftDb.retreiveRow(currInfoPlayer.userName, currInfoPlayer.CName, currentTrackName);
                            currInfoPlayer.updateSavedDrift(tocplysDrift);

                            break;

                        case "PIT": // NEW PIT : (pit stop)
                            InSim.Decoder.PIT pit = new InSim.Decoder.PIT(recvPacket);

                            debug.Add(packetHead, pit, pit.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(pit.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            if (BeginPitPrivMess != "")
                            {
                                tmpPrivMess = BeginPitPrivMess;
                                tmpPrivMess = tmpPrivMess.Replace("{Nickname}", currInfoPlayer.nickName);
                                tmpPrivMess = tmpPrivMess.Replace("{Username}", currInfoPlayer.userName);
                                tmpPrivMess = tmpPrivMess.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                                tmpPrivMess = tmpPrivMess.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                tmpPrivMess = tmpPrivMess.Replace("{Work}", pit.sWork);
                                tmpPrivMess = tmpPrivMess.Replace("{Car}", currInfoPlayer.CName);
                                tmpPosQualUser = getPosQual(currInfoPlayer, true);
                                if (tmpPosQualUser.posUser != 0)
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", "-/-");
                                if (tmpPosQualUser.groupUser != -1)
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", ((char)(tmpPosQualUser.groupUser + 65)).ToString());
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", "-");
                                tmpPosQualUser = getPosQual(currInfoPlayer, false);
                                tmpPrivMess = tmpPrivMess.Replace("{Posabs}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                SendMultilineMsgPrivate(currInfoPlayer.UCID,tmpPrivMess);
                            }
                            if (OnBeginPit != "")
                            {
                                tmpPrivMess = OnBeginPit;
                                tmpPrivMess = tmpPrivMess.Replace("{Nickname}", currInfoPlayer.nickName);
                                tmpPrivMess = tmpPrivMess.Replace("{Username}", currInfoPlayer.userName);
                                tmpPrivMess = tmpPrivMess.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                                tmpPrivMess = tmpPrivMess.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                tmpPrivMess = tmpPrivMess.Replace("{Work}", pit.sWork);

                                tmpPrivMess = tmpPrivMess.Replace("{Car}", currInfoPlayer.CName);

                                tmpPosQualUser = getPosQual(currInfoPlayer, true);
                                if (tmpPosQualUser.posUser != 0)
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", "-/-");
                                if (tmpPosQualUser.groupUser != -1)
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", ((char)(tmpPosQualUser.groupUser + 65)).ToString());
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", "-");
                                tmpPosQualUser = getPosQual(currInfoPlayer, false);
                                tmpPrivMess = tmpPrivMess.Replace("{Posabs}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                SendMsg(tmpPrivMess);
                            }

                            break;

                        case "PSF": // NEW PSF : (pit stop finished)
                            InSim.Decoder.PSF psf = new InSim.Decoder.PSF(recvPacket);

                            debug.Add(packetHead, psf, psf.GetType(), debugmode);

                            currInfoPlayer = listOfPlayers.getPlayerByPLID(psf.PLID);
                            if (currInfoPlayer == null)
                            {
                                debug.Add(packetHead, "Warning, player not found", true);
                                break;
                            }
                            currInfoPlayer.totalPitTime += psf.STime;
                            if (EndPitPrivMess != "")
                            {
                                tmpPrivMess = EndPitPrivMess;
                                tmpPrivMess = tmpPrivMess.Replace("{Nickname}", currInfoPlayer.nickName);
                                tmpPrivMess = tmpPrivMess.Replace("{Username}", currInfoPlayer.userName);
                                tmpPrivMess = tmpPrivMess.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                                tmpPrivMess = tmpPrivMess.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{Car}", currInfoPlayer.CName);
                                tmpPrivMess = tmpPrivMess.Replace("{PitTime}", timeConv.LongToHMS(psf.STime));
                                tmpPrivMess = tmpPrivMess.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                tmpPosQualUser = getPosQual(currInfoPlayer, true);
                                if (tmpPosQualUser.posUser != 0)
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", "-/-");
                                if (tmpPosQualUser.groupUser != -1)
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", ((char)(tmpPosQualUser.groupUser + 65)).ToString());
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", "-");
                                tmpPosQualUser = getPosQual(currInfoPlayer, false);
                                tmpPrivMess = tmpPrivMess.Replace("{Posabs}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                SendMultilineMsgPrivate(currInfoPlayer.UCID, tmpPrivMess);

                            }
                            if (OnEndPit != "")
                            {
                                tmpPrivMess = OnEndPit;
                                tmpPrivMess = tmpPrivMess.Replace("{Nickname}", currInfoPlayer.nickName);
                                tmpPrivMess = tmpPrivMess.Replace("{Username}", currInfoPlayer.userName);
                                tmpPrivMess = tmpPrivMess.Replace("{Tpb}", timeConv.LongToHMS(currInfoPlayer.TPb));
                                tmpPrivMess = tmpPrivMess.Replace("{Laps}", currInfoPlayer.laps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{SessLaps}", currInfoPlayer.sessLaps.ToString());
                                tmpPrivMess = tmpPrivMess.Replace("{Car}", currInfoPlayer.CName);
                                tmpPrivMess = tmpPrivMess.Replace("{PitTime}", timeConv.LongToHMS(psf.STime));
                                tmpPrivMess = tmpPrivMess.Replace("{TotalPitTime}", timeConv.LongToHMS(currInfoPlayer.totalPitTime));
                                tmpPosQualUser = getPosQual(currInfoPlayer, true);
                                if (tmpPosQualUser.posUser != 0)
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Posqual}", "-/-");
                                if (tmpPosQualUser.groupUser != -1)
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", ((char)(tmpPosQualUser.groupUser + 65)).ToString());
                                else
                                    tmpPrivMess = tmpPrivMess.Replace("{Groupqual}", "-");
                                tmpPosQualUser = getPosQual(currInfoPlayer, false);
                                tmpPrivMess = tmpPrivMess.Replace("{Posabs}", tmpPosQualUser.posUser + "/" + tmpPosQualUser.totalUser);
                                SendMsg(tmpPrivMess);
                            }
                            break;
                        case "NLP":
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "VTC":
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "VTN": // Insim Vote
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "VTA": // Insim Vote Action
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "III": // NEW III : InSimInfo
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "PLA": // NEW PLA : (Pit LAne)
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "FLG": // NEW FLG : (yellow or blue flags)
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "PFL": // NEW PFL : (player help flags)
                            debug.Add(packetHead, "", debugmode);
                            break;
                        case "CCH": // NEW CCH : (camera changed)
                            debug.Add(packetHead, "", debugmode);
                            break;
                        default:
                            debug.Add(packetHead, "Unknown packet received", debugmode);
                            break;
                    }

                }
            }

        }

        private void ActionOnDriveThroughPenalty(infoPlayer currInfoPlayer )
        {
            try
            {
                currInfoPlayer.drivethroughcount++;

                if (debugmode) Console.WriteLine("PEN DriveThroughPenalty: " + currInfoPlayer.nickName );


                if (currInfoPlayer.drivethroughcount > MaxDriveThroughPenalties)   //max attempts to tolerate
                {

                    currInfoPlayer.drivethroughcount = 0;
                    if (DriveThroughPenaltyAction.IndexOf("/rcm_") != -1)
                        RestartTimer();

                    string _Action = DriveThroughPenaltyAction;
                    _Action = _Action.Replace("{Nickname}", currInfoPlayer.nickName);
                    _Action = _Action.Replace("{Username}", currInfoPlayer.userName);
                    string[] commands = _Action.Split('|');
                    foreach (string command in commands)
                        SendMsg(GlobalOptionsReplace(command));
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }
        private void ActionOnStopGoPenalty(infoPlayer currInfoPlayer)
        {
            try
            {
                currInfoPlayer.stopgocount++;

                if (debugmode) Console.WriteLine("PEN StopGoPenalty: " + currInfoPlayer.nickName);

                if (currInfoPlayer.stopgocount > MaxStopGoPenalties)   //max attempts to tolerate
                {

                    currInfoPlayer.stopgocount = 0;

                    if (StopGoPenaltyAction.IndexOf("/rcm_") != -1)
                        RestartTimer();

                    string _Action = StopGoPenaltyAction;
                    _Action = _Action.Replace("{Nickname}", currInfoPlayer.nickName);
                    _Action = _Action.Replace("{Username}", currInfoPlayer.userName);
                    string[] commands = _Action.Split('|');
                    foreach (string command in commands)
                        SendMsg(GlobalOptionsReplace(command));
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        private void ActionOn30SecondTimePenalty(infoPlayer currInfoPlayer)
        {
            try
            {
                if (debugmode) Console.WriteLine("PEN 30SecondTimePenalty: " + currInfoPlayer.nickName);

                if (Time30PenaltyAction.IndexOf("/rcm_") != -1)
                    RestartTimer();

                string _Action = Time30PenaltyAction;
                _Action = _Action.Replace("{Nickname}", currInfoPlayer.nickName);
                _Action = _Action.Replace("{Username}", currInfoPlayer.userName);
                string[] commands = _Action.Split('|');
                foreach (string command in commands)
                    SendMsg(GlobalOptionsReplace(command));
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

        private void ActionOn45SecondTimePenalty(infoPlayer currInfoPlayer)
        {
            try
            {
                if (debugmode) Console.WriteLine("PEN 45SecondTimePenalty: " + currInfoPlayer.nickName);

                if (Time45PenaltyAction.IndexOf("/rcm_") != -1)
                    RestartTimer();

                string _Action = Time45PenaltyAction;
                _Action = _Action.Replace("{Nickname}", currInfoPlayer.nickName);
                _Action = _Action.Replace("{Username}", currInfoPlayer.userName);
                string[] commands = _Action.Split('|');
                foreach (string command in commands)
                    SendMsg(GlobalOptionsReplace(command));

            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }


    }
}
