using System;
using System.Text;

namespace UDPGateway
{
    public class UDPPortGateway
    {

        #region Public variables

        public int ListeningPort=30000;
        public string host = "127.0.0.1";

        #endregion

        #region Internal variables

        System.Net.Sockets.Socket sock = new System.Net.Sockets.Socket(System.Net.Sockets.AddressFamily.InterNetwork, System.Net.Sockets.SocketType.Dgram, System.Net.Sockets.ProtocolType.Udp);
        System.Net.EndPoint er;
        byte[] inb = new byte[256];

        System.Collections.ArrayList ports = new System.Collections.ArrayList();
        AsyncCallback callback;

        #endregion
                
        void listener(IAsyncResult ar)
        {
            object So = ar.AsyncState;

            int received = sock.EndReceiveFrom(ar, ref er);
            //Console.WriteLine("received:" + received);

            if (received > 0)
            {
                foreach (System.Net.IPEndPoint lep in ports)
                        sock.SendTo(inb, received, System.Net.Sockets.SocketFlags.None, lep);
            }
            else
                Console.WriteLine("didn't receive anything");

            sock.BeginReceiveFrom(inb, 0, 92, System.Net.Sockets.SocketFlags.None, ref er, callback, So);
        }

        public UDPPortGateway()
        {
            lipa = System.Net.Dns.Resolve(host);
            callback = new AsyncCallback(listener);
        }

        #region Public interface

        public void AddPort(int port)
        {
            System.Net.IPEndPoint ep = new System.Net.IPEndPoint(lipa.AddressList[0], port);
            ports.Add(ep);
        }

        System.Net.IPHostEntry lipa;

        public void Start()
        {
            System.Net.IPEndPoint remote = new System.Net.IPEndPoint(lipa.AddressList[0]/*System.Net.IPAddress.Any*/, ListeningPort);
            er = (System.Net.EndPoint)remote;
            sock.Bind(er);

            sock.BeginReceiveFrom(inb, 0, 92, System.Net.Sockets.SocketFlags.None, ref er, callback, null);
        }

        public void Stop()
        {
            sock.Close();
        }

        #endregion
    }
}
