Attribute VB_Name = "FileCode"
Option Explicit

Public Type LFSSetupFile
    Identifier As String * 6 '0
    Blank1 As Byte '6
    Version As Byte '7
    Revision As Byte '8
    Blank2 As Byte '9
    RevRatio As Integer '10 'replaces Blank3 and Blank4
    'Blank3 As Byte '10
    'Blank4 As Byte '11
    MiscFlags As Byte '12
    Unknown As Byte '13
    HandicapMassPos As Byte '14
    TyreBrand As Byte '15
    
    'Brakes
    BrakeStrength As Single '16
    
    'Downforce
    StaticRearWingAngle As Byte '20
    StaticFrontWingAngle As Byte '21
    HandicapMass As Byte '22
    HandicapIntake As Byte '23
    
    'Steering
    SteeringLock As Byte '24
    ParallelSteer As Byte '25
    BrakeBalance As Byte '26
    EngineBrakeReduction As Byte '27
    
    'Centre Diff
    CentreDiffType As Byte '28
    CentreDiffVicous As Byte '29
    Blank5 As Byte '30
    CentreDiffTorqueSplit As Byte '31
    
    'Tranmission
    GearRatio7 As Integer '32 'Actually unsigned integer, VB6 does not support these
    FinalDrive As Integer '34 'Need to convert to unsigned before processing
    GearRatio1 As Integer '36
    GearRatio2 As Integer '38
    GearRatio3 As Integer '40
    GearRatio4 As Integer '42
    GearRatio5 As Integer '44
    GearRatio6 As Integer '46
    
    'Misc
    Passengers As Byte '48
    CarConfig As Byte '49
    TCSlip As Byte '50
    TCSpeed As Byte '51
    
    'Rear suspension & wheels
    RearRideHeight As Single '52
    RearSpringStiffness As Single '56
    RearBumpDamping As Single '60
    RearReboundDamping As Single '64
    RearAntiRollStiffness As Single '68
    Blank6 As Byte '72
    Blank7 As Byte '73
    Blank8 As Byte '74
    Blank9 As Byte '75
    RearToeIn As Byte '76
    RearCaster As Byte '77
    RearTyreType As Byte '78
    Blank10 As Byte '79
    LRCamberAdjust As Byte '80
    RRCamberAdjust As Byte '81
    Blank11 As Byte '82
    RearClutchPreload As Byte '83
    RearDiffType As Byte '84
    RearViscousLock As Byte '85
    RearPowerLock As Byte '86
    RearCoastLock As Byte '87
    LRTyrePressure As Integer '88
    RRTyrePressure As Integer '90
    
    'Front suspension & wheels
    FrontRideHeight As Single '92
    FrontSpringStiffness As Single '96
    FrontBumpDamping As Single '100
    FrontReboundDamping As Single '104
    FrontAntiRollStiffness As Single '108
    Blank12 As Byte '112
    Blank13 As Byte '113
    Blank14 As Byte '114
    Blank15 As Byte '115
    FrontToeIn As Byte '116
    FrontCaster As Byte '117
    FrontTyreType As Byte '118
    Blank16 As Byte '119
    LFCamberAdjust As Byte '120
    RFCamberAdjust As Byte '121
    Blank17 As Byte '122
    FrontClutchPreload As Byte '123
    FrontDiffType As Byte '124
    FrontViscousLock As Byte '125
    FrontPowerLock As Byte '126
    FrontCoastLock As Byte '127
    LFTyrePressure As Integer '128
    RFTyrePressure As Integer '130
End Type

Public Const SetupFileHeading As String * 6 = "SRSETT"
Public Const SetupFileVersion As Byte = 250
Public Const SetupFileRevision As Byte = 2

Public SetupFilenames() As String
Public FolderPath As String
Public TyreBrand(4) As String

Public Sub ReadSetups()
Dim i As Integer
Dim SetupData As LFSSetupFile
Dim nFileNum As Integer
Dim WorkingPathFilename As String

For i = 0 To UBound(SetupFilenames)
    WorkingPathFilename = FolderPath & SetupFilenames(i)
    
    nFileNum = FreeFile
    If FileExists(WorkingPathFilename) = 1 Then
        Open WorkingPathFilename For Binary Access Read Write Lock Read Write As #nFileNum
            'read data into var
            Get #nFileNum, , SetupData
        Close #nFileNum
        
        If SetupData.Identifier = SetupFileHeading Then
            If SetupData.Version = SetupFileVersion And SetupData.Revision = SetupFileRevision Then
                BatchSetupEditor.SetupListing.ListItems(i + 1).ListSubItems.Add , , TyreBrand(SetupData.TyreBrand)
            Else: BatchSetupEditor.SetupListing.ListItems(i + 1).ListSubItems.Add , , "Incorrect setup version"
            End If
        Else: BatchSetupEditor.SetupListing.ListItems(i + 1).ListSubItems.Add , , "Not setup file"
        End If
    Else: BatchSetupEditor.SetupListing.ListItems(i + 1).ListSubItems.Add , , "File not found"
    End If
Next
End Sub

Public Sub WriteSetups()
Dim i As Integer
Dim SetupData As LFSSetupFile
Dim nFileNum As Integer
Dim WorkingPathFilename As String

For i = 0 To UBound(SetupFilenames)
    If BatchSetupEditor.SetupListing.ListItems(i + 1).Checked Then
        WorkingPathFilename = FolderPath & SetupFilenames(i)
        
        nFileNum = FreeFile
        If FileExists(WorkingPathFilename) = 1 Then
            Open WorkingPathFilename For Binary Access Read Write Lock Read Write As #nFileNum
            Get #nFileNum, , SetupData
            
            If SetupData.Identifier = SetupFileHeading Then
                If SetupData.Version = SetupFileVersion And SetupData.Revision = SetupFileRevision Then
                    SetupData.TyreBrand = BatchSetupEditor.NewTyreBrand.ListIndex
                    Put #nFileNum, 1, SetupData
                    BatchSetupEditor.SetupListing.ListItems(i + 1).SubItems(1) = TyreBrand(SetupData.TyreBrand)
                End If
            End If
            Close #nFileNum
        End If
    End If
Next
End Sub

Public Sub GetStatus()
Dim CountItems As Integer, CountSelected As Integer, CountChecked As Integer
Dim itm As ListItem
CountItems = BatchSetupEditor.SetupListing.ListItems.Count
For Each itm In BatchSetupEditor.SetupListing.ListItems
    With itm
        If .Checked Then CountChecked = CountChecked + 1
        If .Selected Then CountSelected = CountSelected + 1
    End With
Next
BatchSetupEditor.Status.Caption = CountItems & " Setups / " & CountSelected & " Selected / " & CountChecked & " Checked"
End Sub

Public Function FileExists(strFile As String) As Integer
'********************************************************************************
'* Name : FileExists
'* Date : Feb-17, 2000
'* Author : David Costelloe
'* Returns : -1 = Does not exists 0 = Exists with zero bytes 1 = Exists > 0 Bytes
'*********************************************************************************
Dim lSize As Long

On Error Resume Next
lSize = -1
lSize = FileLen(strFile)
If lSize = 0 Then
    FileExists = 0
ElseIf lSize > 0 Then
    FileExists = 1
Else
    FileExists = -1
End If
End Function
