#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <dirent.h> /* Relies on MinGW / Unix-like systems */

typedef unsigned char byte;
typedef unsigned short word;

struct set_t
{
    char header[7];
    byte version;
    byte revision;
    byte zero[3];
    byte bitfield;
    byte randomfield;
    byte handicap_mass_pos;
    byte tyre_brand;
    float brake_strength;
    byte wing_rear;
    byte wing_front;
    byte vol_handicap;
    byte vol_intake;
    byte max_steering_lock;
    byte parallel_steer;
    byte brake_balance;
    byte engine_brake_reduction;
    byte centre_diff_type;
    byte centre_diff_viscous_torque;
    byte zero2;
    byte centre_torque_split;
    word gear_7;
    word gear_final;
    word gear_1;
    word gear_2;
    word gear_3;
    word gear_4;
    word gear_5;
    word gear_6;
    byte passenger;
    byte car_conf;
    byte traction_slip;
    byte traction_engage_speed;
    float ride_rear;
    float spring_stiff_rear;
    float damping_rear;
    float rebound_rear;
    float antiroll_stiff_rear;
    byte zero3;
    byte toe_rear;
    byte caster_rear;
    byte tyre_type_rear;
    byte zero4;
    byte camber_lr;
    byte camber_rr;
    byte zero5;
    byte diff_clutch_rear;
    byte diff_type_rear;
    byte viscous_torque_rear;
    byte power_locking_rear;
    byte coast_locking_rear;
    word tyre_pressure_lr;
    word tyre_pressure_rr;
    float ride_front;
    float spring_stiff_front;
    float damping_front;
    float rebound_front;
    float antiroll_stiff_front;
    byte zero6;
    byte toe_front;
    byte caster_front;
    byte tyre_type_front;
    byte zero7;
    byte camber_lf;
    byte camber_rf;
    byte zero8;
    byte diff_clutch_front;
    byte diff_type_front;
    byte viscous_torque_front;
    byte power_locking_front;
    byte coast_locking_front;
    word tyre_pressure_lf;
    word tyre_pressure_rf;
};

#define DESC "Converts setups so that they all have plain tyres"
#define WARRANTY "This product is developed as open source software\nThis product comes with no warranty, and the author cannot be held responsible for any damage caused"
#define AUTHOR "Karl 'the_angry_angel' Southern"

int main(int argc, char **argv)
{
    printf("setup2plain\n" DESC "\n" WARRANTY "\n" AUTHOR "\n\n");
    if (argc < 3)
    {
        printf("Not enough arguments. Should be %s setupinputdirectory setupoutputdirectory\n", argv[0]);
        system("pause");
        return -1;
    }

    printf("Files:\n From: '%s'\n To: '%s'\n", argv[1], argv[2]);
    system("pause");

	int ret = 0;
	DIR *d = NULL;
	struct stat st;
	struct dirent *e = NULL;
	char b[MAX_PATH];
	char c[MAX_PATH];
	FILE *fp;
	struct set_t set;

	d = opendir(argv[1]);
	if (d != NULL)
	{
		for (e = readdir(d); e; e = readdir(d))
		{
		    /* XXX: This sucks huge cock, but it's fast */
			if ((*(e->d_name) == '.') || (strstr(e->d_name, ".set") == NULL))
				continue;

			memset(b, 0, sizeof(b));
			snprintf(b, sizeof(b) - 1, "%s\\%s", argv[1], e->d_name);

			memset(&st, 0, sizeof(st));

			ret = stat(b, &st);
			if (ret == -1)
			{
				fprintf(stderr, "stat on '%s' failed\n", b);
				continue;
			}

			/* We don't care about subdirectories. Sorry */
			if ((S_ISDIR(st.st_mode)))
				continue;

			printf("Loading %s\n", b);

            fp = fopen(b, "r");
			if (fp == NULL)
            {
                fprintf(stderr, "Failed to open '%s'\n", b);
                continue;
            }

            memset(&set, 0, sizeof(struct set_t));
            fread(&set, sizeof(struct set_t), 1, fp);
            set.tyre_brand = 0;
            fclose(fp);

            memset(c, 0, MAX_PATH);
            snprintf(c, sizeof(struct set_t) - 1, "%s\\%s", argv[2], e->d_name);
            fp = fopen(c, "w+");
            fwrite(&set, sizeof(struct set_t), 1, fp);
            fclose(fp);
		}
		closedir(d);
	}
	system("pause");
	return 0;
}
