

//todo
typedef struct
{
	BYTE minutes;
	BYTE seconds;
	BYTE hundrets;
	BYTE thousands;
} MSHT;// long

#define PCKTID_ISI 0x00495349
#define PCKTID_VER 0x00524556
#define PCKTID_ISC 0x00435349
#define PCKTID_ACK 0x004B4341
#define PCKTID_STA 0x00415453
#define PCKTID_SST 0x00545353
#define PCKTID_SFP 0x00504653
#define PCKTID_ISM 0x004D5349

// Messages
#define PCKTID_MSO 0x004F534D
#define PCKTID_MTC 0x0043544D
#define PCKTID_SCH 0x00484353

//
#define PCKTID_RST 0x00545352
#define PCKTID_REN 0x004E4552
#define PCKTID_NCN 0x004E434E
#define PCKTID_CNL 0x004C4E43
#define PCKTID_NPL 0x004C504E
#define PCKTID_PLP 0x00504C50
#define PCKTID_PLL 0x004C4C50
#define PCKTID_CPR 0x00525043
#define PCKTID_CLR 0x00524C43
#define PCKTID_LAP 0x0050414C
//#define PCKTID_SPX 0x00585053
#define PCKTID_SP1 0x00315053
#define PCKTID_SP2 0x00325053
#define PCKTID_SP3 0x00335053

// new packets since patch V3
#define PCKTID_PIT 0x00544950
#define PCKTID_PSF 0x00465350
#define PCKTID_PEN 0x004E4550
#define PCKTID_TOC 0x00434F54
#define PCKTID_FLG 0x00474C46
#define PCKTID_PFL 0x004C4650

#define PCKTID_RES 0x00534552
#define PCKTID_REO 0x004F4552

#define PCKTID_NLP 0x00504C4E
#define PCKTID_MCI 0x0049434D
#define PCKTID_NLI 0x00494C4E

// Camera Packet
#define PCKTID_SCC 0x00434353
#define PCKTID_CPP 0x00505043
#define PCKTID_SCP 0x00504353

#define ISS_GAME		1	// in game (or MPR)
#define ISS_REPLAY		2	// in SPR
#define ISS_PAUSED		4	// paused
#define ISS_SHIFTU		8	// in SHIFT+U mode
#define ISS_SHIFTU_HIGH		16	// HIGH view
#define ISS_SHIFTU_FOLLOW	32	// following car
#define ISS_SHIFTU_NO_OPT	64	// buttons are hidden
#define ISS_SHOW_2D		128	// showing 2d display
#define ISS_FRONT_END		256	// in front end screen
#define ISS_MULTI		512	// multiplayer mode
#define ISS_MPSPEEDUP		1024	// multiplayer speedup option
#define ISS_WINDOWED		2048	// lfs is running in a window
#define ISS_SOUND_MUTE		4096	// sound is switched off
#define ISS_VIEW_OVERRIDE	8192	// override user view

#define ISF_RACE_TRACKING	1	// bit 0 : turns on race tracking
#define ISF_GUARANTEE		2	// bit 1 : turns on guaranteed delivery
#define ISF_SPLIT_MESSAGE	4	// bit 2 : use MSS, not MSO for user messages
#define ISF_NO_WARNINGS		8	// bit 3 : turns off packet warnings
#define ISF_KEEP_ALIVE		16	// bit 4 : makes lfs send keep alive packets
#define ISF_NLP_MCI		32	// bit 5 : makes lfs send MCI instead of NLP


typedef union
{
	char c[4];
	long l;
} tIdent;

typedef struct		// UDP packet to initialise the InSim system
{
	tIdent	Id;			// ISI + zero
	WORD	Port;		// Port for UDP replies from LFS (0...65535)
	BYTE	Flags;		// Bit flags for options - see below
	BYTE	NodeSecs;	// Number of seconds between NLP or MCI packets (0=none)
	char	Admin	[16];	// Admin password (required if set in LFS host options)
} tInSimInit;

typedef struct		// General purpose 8 byte UDP packet
{
	tIdent	Id;			// 3 character identifier followed by zero character
	long	Value;		// 32 bit value depending on the type of InSimPack
} tInSimPack;

typedef struct
{
	tIdent	Id;			// VER + zero
	char	Version	[8];	// LFS version, e.g. 0.3G
	char	Product	[6];	// Product : DEMO or S1
	WORD	InSimVer;	// InSim Version : increased when InSim packets change
} tInSimVersion;

typedef struct
{
	tIdent	Id;			// ISM
	BYTE	Host;		// 0 = guest / 1 = host
	BYTE	Sp1;
	BYTE	Sp2;
	BYTE	Sp3;
	char	Name	[32];	// the name of the host joined or started
} tInSimMulti;

typedef struct
{
	tIdent	Id;			// STA + zero
	float	ReplaySpeed;	// 4-byte float - 1.0 is normal speed

	WORD	Flags;		// State Flags (see below)
	BYTE	InGameCam;	// Which type of camera is selected (see below)
	BYTE	ViewPlayer;	// Player index of viewed car

	BYTE	NumPlayers;	// Num in race
	BYTE	NumConns;	// Num connections including host
	BYTE	NumFinished;	// Number finished or qualified
	BYTE	RaceInProgress;	// 0 - no / 1 - race / 2 - qualifying

	BYTE	QualMins;
	BYTE	RaceLaps;	// see "RaceLaps" near the top of this document
	BYTE	Spare2;
	BYTE	Spare3;

	char	Track	[6];	// short name for track e.g. FE2R
	BYTE	Weather;	// 0,1,2...
	BYTE	Wind;		// 0=off 1=weak 2=strong
} tStatePack;

typedef struct
{
	tIdent	Id;			// SFP + zero
	WORD	Flag;		// the state to set (ISS_xxx)
	BYTE	OffOn;		// 0 = off / 1 = on
	BYTE	Sp3;		// spare
} tStateFlagsPack;

typedef struct  // 64 chars - send to LFS to simulate typing message or command
{
	tIdent	Id;			// MST + zero
	char	Msg	[64];	// text message or /command, must end with zero
} tMsgTypePack;

typedef struct // 64 chars - send to LFS and on to a chosen connection (0 = host)
{
	tIdent	Id;			// MTC + zero
	BYTE	Conn;		// connection
	BYTE	UniqueId;	// destination player UniqueId : if set, Conn is ignored
	BYTE	Sp2;
	BYTE	Sp3;
	char	Msg	[64];	// text message or /command, must end with zero
} tMsgToConn;

typedef struct // 128 chars - LFS reporting displayed messages
{
	tIdent	Id;			// MSO + zero
	char	Msg	[128];	// displayed message, with colours removed
} tMsgOutPack;

typedef struct  // send to LFS to simulate single character
{
	tIdent	Id;			// SCH + zero
	char	Char;		// key to press
	BYTE	Flags;		// bit 0 : SHIFT / bit 1 : CTRL
	BYTE	Spare2;
	BYTE	Spare3;
} tSingleCharPack;

typedef struct  // Race STart
{
	tIdent	RST;

	BYTE	RaceLaps;	// see "RaceLaps" near the top of this document
	BYTE	QualMins;	// 0 if race
	BYTE	NumInRace;
	BYTE	Spare;

	char	Track	[6];
	BYTE	Weather;
	BYTE	Wind;

	BYTE	Sp0;
	BYTE	Sp1;
	WORD	VerifyId;
} tIS_RST;

typedef struct  // Race ENd (return to entry screen)
{
	tIdent	REN;

	BYTE	Sp0;
	BYTE	Sp1;
	WORD	VerifyId;
} tIS_REN;

typedef struct  // New ConN
{
	tIdent	NCN;

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	BYTE	Admin;
	BYTE	Sp1;
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	ConnNum;	// new conn's number (0 = host, 1, 2...)
	BYTE	Total;		// number of connections on host, including host
	WORD	VerifyId;
} tIS_NCN;

typedef struct  // ConN Leave (end connection is moved down into this slot)
{
	tIdent	CNL;

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	BYTE	ConnNum;
	BYTE	Total;
	WORD	VerifyId;
} tIS_CNL;

typedef struct  // New PLayer joining race (if number already exists, then leaving pits)
{
	tIdent	NPL;

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	Plate	[8];	// number plate - NO ZERO AT END!
	char	CName	[32];	// car name

	WORD	Flags;		// player flags (see below)
	BYTE	Type;		// bit 0 - female / bit 1 - AI
	BYTE	UniqueId;	// player's assigned unique id

	BYTE	PlyNum;		// player's number (0 = pole, 1, 2...)
	BYTE	Total;		// number in race (same when leaving pits, 1 more if new)
	WORD	VerifyId;
} tIS_NPL;

typedef struct  // PLayer Pits (go to settings - stays in player list)
{
	tIdent	PLP;

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	BYTE	UniqueId;	// player's assigned unique id
	BYTE	Sp1;
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	PlyNum;		// player's number (stays in list)
	BYTE	Total;		// new total (expect : same as before)
	WORD	VerifyId;
} tIS_PLP;

typedef struct  // PLayer Leave race (spectate - leaves player list, all are shunted down)
{
	tIdent	PLL;

	char	UName	[24];	// username
	char	PName	[24];	// nickname

	BYTE	UniqueId;	// player's assigned unique id
	BYTE	Sp1;
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	PlyNum;		// player's number (others shunt down)
	BYTE	Total;		// new total (expect : 1 less than before)
	WORD	VerifyId;
} tIS_PLL;

typedef struct  // Conn Player Rename
{
	tIdent	CPR;

	char	UName	[24];	// username
	char	OldName	[24];	// old name
	char	NewName	[24];	// new name
	char	Plate	[8];	// number plate - NO ZERO AT END!

	BYTE	UniqueId;	// unique id : 0 = connection has no player in race
	BYTE	Sp1;
	WORD	VerifyId;
} tIS_CPR;

typedef struct  // CLear Race - all players removed from race in one go
{
	tIdent	CLR;

	BYTE	Sp0;
	BYTE	Sp1;
	WORD	VerifyId;
} tIS_CLR;

typedef struct  // LAP time
{
	tIdent	LAP;

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	CName	[32];	// car name

	MSHT	Time;		// lap time

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's assigned unique id
	WORD	VerifyId;
} tIS_LAP;

typedef struct  // SPlit X time
{
	tIdent	SPX;	// SP1 / SP2 / SP3 + zero

	MSHT	Time;			// split time

	BYTE	PlyNum;			// player's number
	BYTE	UniqueId;		// player's assigned unique id
	WORD	VerifyId;
} tIS_SPX;

typedef struct  // PIT stop (stop at pit garage) ... NEW! ... if guest is V3 or later
{
	char	PIT	[4];

	WORD	LapsDone;	// laps completed
	WORD	Flags;		// player flags
	BYTE	Penalty;	// current penalty value (see below)
	BYTE	NumStops;	// number of pit stops
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	Tyres	[4];	// tyres changed

	unsigned	Work;	// pit work (see below)
	unsigned	Spare;

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's unique id
	WORD	VerifyId;
} tIS_PIT;

typedef struct  // Pit Stop Finished ... NEW! ... if guest is V3 or later
{
	char	PSF	[4];

	MSHT		Time;	// stop time
	unsigned	Spare;

	BYTE	PlyNum;
	BYTE	UniqueId;
	WORD	VerifyId;
} tIS_PSF;

typedef struct  // Pit LAne ... NEW! ... if guest is V3 or later
{
	char	PLA	[4];

	BYTE	Fact;		// pit lane fact (see below)
	BYTE	Sp1;
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	PlyNum;
	BYTE	UniqueId;
	WORD	VerifyId;
} tIS_PLA;

typedef struct  // PENalty (given or cleared) ... NEW!
{
	char	PEN	[4];

	BYTE	OldPen;		// old penalty value (see below)
	BYTE	NewPen;		// new penalty value (see below)
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's unique id
	WORD	VerifyId;
} tIS_PEN;

typedef struct  // Take Over Car ... NEW!
{
	char	TOC	[4];

	char	OldUName[24];	// old username
	char	OldPName[24];	// old nickname
	char	NewUName[24];	// new username
	char	NewPName[24];	// new username

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's unique id (stays with this car)
	WORD	VerifyId;
} tIS_TOC;

typedef struct  // FLaG (yellow or blue flag changed) ... NEW!
{
	char	FLG	[4];

	BYTE	OffOn;		// 0 = off / 1 = on
	BYTE	Flag;		// 1 = given blue / 2 = causing yellow
	BYTE	Sp2;
	BYTE	Sp3;

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's unique id
	WORD	VerifyId;
} tIS_FLG;

typedef struct  // Player FLags (help flags changed) ... NEW!
{
	char	PFL	[4];

	WORD	Flags;		// player flags (see below)
	WORD	Spare;

	BYTE	PlyNum;		// player's number
	BYTE	UniqueId;	// player's unique id
	WORD	VerifyId;
} tIS_PFL;

typedef struct  // RESult (qualify or finish)
{
	tIdent	RES;

	char	UName	[24];	// username
	char	PName	[24];	// nickname
	char	Plate	[8];	// number plate - NO ZERO AT END!
	char	CName	[4];	// short car name / skin prefix (e.g. XRT)

	char	Spare	[20];	// zero

	WORD	Hours;		// total hours (when TotalTime >= 1 hour)
	WORD	SpareW;		// zero

	WORD	LapsDone;	// laps completed
	WORD	Flags;		// player flags : help settings etc - see below

	BYTE	ConfirmFlags;	// confirmation flags : disqualified etc - see below
	BYTE	NumStops;	// number of pit stops
	BYTE	Type;		// bit 0 - female / bit 1 - AI
	BYTE	UniqueId;	// unique id : 0 = player already left before result was sent

	MSHT	TotalTime;	// race time
	MSHT	BestLap;	// best lap

	BYTE	ResultNum;	// position in results table (qualify may be inserted not at end)
	BYTE	NumResults;	// total number of results (qualify doesn't always add a new one)
	WORD	VerifyId;
} tIS_RES;

typedef struct  // NOT A PACKET - small 2-byte structure - part of the REO (below)
{
	BYTE	OldPos;		// old position in list
	BYTE	UniqueId;	// player's assigned unique id
} tPosId;

typedef struct  // REOrder (when race restarts after qualifying)
{
	tIdent	REO;

	tPosId	Info	[28];	// old positions and unique id

	BYTE	Sp0;		// spare
	BYTE	NumPlayers;	// number of players in race
	WORD	VerifyId;
} tIS_REO;


typedef struct // NOT A PACKET - small 4-byte structure - part of the NLP (below)
{
	WORD	Node_Lap_Hi3;	// current path node (and high 3 bits of Lap)
	BYTE	Lap_Lo8;	// current lap (low byte... see above : NODE/LAP)
	BYTE	UniqueId;	// player's assigned unique id
} tNodeLap;

typedef struct // Node and Lap Packet
{
	tIdent	NLP;

	WORD	NumNodes;	// total number of nodes in the path
	WORD	FinishLine;	// the node number of the finish line

	BYTE	NumPlayers;	// number of players in race
	BYTE	Sp1;		// spare
	BYTE	Sp2;		// spare
	BYTE	Sp3;		// spare

	tNodeLap	Info	[28];	// node and lap of each player
} tIS_NLP;

typedef struct  // NOT A PACKET - Car info in a 24-byte structure - part of the MCI (below)
{
	WORD	Node_Lap_Hi3;	// current path node (and high 3 bits of Lap)
	BYTE	Lap_Lo8;	// current lap (low byte... see above : NODE/LAP)
	BYTE	UniqueId;	// player's assigned unique id
	int	X;		// X map (65536 = 1 metre)
	int	Y;		// Y map (65536 = 1 metre)
	int	Z;		// Z alt (65536 = 1 metre)
	WORD	Speed;		// speed (32768 = 100 m/s)
	WORD	Direction;	// direction of car's motion : (see note 1 below)
	WORD	Heading;	// direction of forward axis : (see note 1 below)
	short	AngVel;		// signed, rate of change of heading : (see note 2)
} tCompCar;

//Note 1 : 0 = world y axis direction, 32768 = 180 degrees, anticlockwise from above
//Note 2 : 0 = no change in heading, 8192 = 180 degrees per second anticlockwise

typedef struct  // MultiCarInfo - if more than 8 in race then more than one of these is sent
{
	tIdent	MCI;

	WORD	NumNodes;	// total number of nodes in the path
	WORD	FinishLine;	// the node number of the finish line

	BYTE	NumPlayers;	// number of players in race
	BYTE	FirstPly;	// first player in this packet (0 in 1st packet, 8 in 2nd...)
	BYTE	Sp2;		// spare
	BYTE	Sp3;		// spare

	tCompCar	Info	[8];	// car info for each player, max 8 per packet
} tIS_MCI;

typedef struct 		// Simplified camera packet (not SHIFT+U mode)
{
	tIdent	Id;	// SCC + zero
	BYTE	ViewPlayer;	// Player Index of car to view (0 = pole...)
	BYTE	InGameCam;	// InGameCam (as reported in StatePack)
	BYTE	UniqueId;	// Overrides ViewPlayer if set
	BYTE	Spare3;
} tSetCarCamera;

typedef struct 		// Full camera packet (in game OR SHIFT+U mode)
{
	tIdent	Id;	// CPP + zero
	int	X;		// X map (65536 = 1 metre)
	int	Y;		// Y map (65536 = 1 metre)
	int	Z;		// Z alt (65536 = 1 metre)
	WORD	Heading;	// 0 points along Y axis
	WORD	Pitch;		// 0 means looking at horizon
	WORD	Roll;		// 0 means no roll
	BYTE	ViewPlayer;	// Player Index of car to view (0 = pole...)
	BYTE	InGameCam;	// InGameCam (as reported in StatePack)
	float	FOV;		// 4-byte float : FOV in radians
	WORD	Time;		// Time to get there (0 means instant + reset)
	WORD	Flags;		// State Flags
} tCamPosPack;

typedef union
{
	tMsgOutPack MSO;
	tMsgToConn MCT;
	tSingleCharPack SCH;
	tCamPosPack CPP;
	tStatePack STA;
	tInSimVersion VER;
	tInSimMulti ISM;

	tIS_RST RST;
	tIS_REN REN;
	tIS_NCN NCN;
	tIS_CNL CNL;
	tIS_NPL NPL;
	tIS_PLP PLP;
	tIS_PLL PLL;
	tIS_CPR CPR;
	tIS_CLR CLR;
	tIS_LAP LAP;
	tIS_SPX SPX;

	tIS_PIT PIT;
	tIS_PSF PSF;
	tIS_PEN PEN;
	tIS_TOC TOC;
	tIS_FLG FLG;
	tIS_PFL PFL;

	tIS_RES RES;
	tIS_REO REO;

	tIS_NLP NLP;
	tIS_MCI MCI;
} tPcktColl;



/* V4 defs */

enum // the second byte in all packets is one of these
{
	ISP_NONE,		//  0					: not used
	ISP_ISI,		//  1 - instruction		: insim initialise
	ISP_VER,		//  2 - info			: version info
	ISP_TINY,		//  3 - both ways		: multi purpose
	ISP_SMALL,		//  4 - both ways		: multi purpose
	ISP_STA,		//  5 - info			: state info
	ISP_SCH,		//  6 - instruction		: single character
	ISP_SFP,		//  7 - instruction		: state flags pack
	ISP_SCC,		//  8 - instruction		: set car camera
	ISP_CPP,		//  9 - both ways		: cam pos pack
	ISP_ISM,		// 10 - info			: start multiplayer
	ISP_MSO,		// 11 - info			: message out
	ISP_III,		// 12 - info			: hidden /i message
	ISP_MST,		// 13 - instruction		: type message or /command
	ISP_MTC,		// 14 - instruction		: message to a connection
	ISP_MOD,		// 15 - instruction		: set screen mode
	ISP_VTN,		// 16 - info			: vote notification
	ISP_RST,		// 17 - info			: new connection
	ISP_NCN,		// 18 - info			: new connection
	ISP_CNL,		// 19 - info			: connection left
	ISP_CPR,		// 20 - info			: connection renamed
	ISP_NPL,		// 21 - info			: new player (joined race)
	ISP_PLP,		// 22 - info			: player pit (keeps slot in race)
	ISP_PLL,		// 23 - info			: player leave (spectate - loses slot)
	ISP_LAP,		// 24 - info			: lap time
	ISP_SPX,		// 25 - info			: split x time
	ISP_PIT,		// 26 - info			: pit stop start
	ISP_PSF,		// 27 - info			: pit stop finish
	ISP_PLA,		// 28 - info			: pit lane enter / leave
	ISP_CCH,		// 29 - info			: camera changed
	ISP_PEN,		// 30 - info			: penalty given or cleared
	ISP_TOC,		// 31 - info			: take over car
	ISP_FLG,		// 32 - info			: flag (yellow or blue)
	ISP_PFL,		// 33 - info			: player flags (help flags)
	ISP_FIN,		// 34 - info			: finished race
	ISP_RES,		// 35 - info			: result confirmed
	ISP_REO,		// 36 - both ways		: reorder (info or instruction)
	ISP_NLP,		// 37 - info			: node and lap packet
	ISP_MCI,		// 38 - info			: multi car info
	ISP_MSX,		// 39 - instruction		: type message
	ISP_MSL,		// 40 - instruction		: message to local computer
	ISP_CRS,		// 41 - info			: car reset
	ISP_BFN,		// 42 - both ways		: delete buttons / receive button requests
	ISP_43,			// 43
	ISP_44,			// 44
	ISP_BTN,		// 45 - instruction		: show a button on local or remote screen
	ISP_BTC,		// 46 - info			: sent when a user clicks a button
	ISP_BTT,		// 47 - info			: sent after typing into a button
};
enum // the fourth byte of IS_TINY packets is one of these
{
	TINY_NONE,		//  0					: used in ISF_KEEP_ALIVE
	TINY_VER,		//  1 - info request	: get version
	TINY_CLOSE,		//  2 - instruction		: close insim
	TINY_PING,		//  3 - ping request	: external progam requesting a reply
	TINY_REPLY,		//  4 - ping reply		: reply to a ping request
	TINY_VTC,		//  5 - info			: vote cancelled
	TINY_SCP,		//  6 - info request	: send camera pos
	TINY_SST,		//  7 - info request	: send state info
	TINY_GTH,		//  8 - info request	: get time in hundredths (i.e. SMALL_RTP)
	TINY_MPE,		//  9 - info			: multi player end
	TINY_ISM,		// 10 - info request	: get multiplayer info (i.e. ISP_ISM)
	TINY_REN,		// 11 - info			: race end (return to game setup screen)
	TINY_CLR,		// 12 - info			: all players cleared from race
	TINY_NCN,		// 13 - info			: get all connections
	TINY_NPL,		// 14 - info			: get all players
	TINY_RES,		// 15 - info			: get all results
	TINY_NLP,		// 16 - info request	: send an NLP packet
	TINY_MCI,		// 17 - info request	: send an MCI packet
};

enum // the fourth byte of IS_SMALL packets is one of these
{
	SMALL_NONE,		//  0					: not used
	SMALL_SSP,		//  1 - instruction		: start sending positions
	SMALL_SSG,		//  2 - instruction		: start sending gauges
	SMALL_VTA,		//  3 - report			: vote action
	SMALL_TMS,		//  4 - instruction		: time stop
	SMALL_STP,		//  5 - instruction		: time step
	SMALL_RTP,		//  6 - info			: race time packet (reply to GTH)
	SMALL_NLI,		//  7 - instruction		: set node lap interval
};

typedef struct // New PLayer joining race (if PLID already exists, then leaving pits)
{
	BYTE	Size;			// 76
	BYTE	Type;			// ISP_NPL
	BYTE	ReqI;			// 0 unless this is a reply to an info request
	BYTE	PLID;			// player's newly assigned unique id

	BYTE	UCID;			// connection's unique id
	BYTE	PType;			// bit 0 - female / bit 1 - AI
	WORD	Flags;			// player flags

	char	PName	[24];	// nickname
	char	Plate	[8];	// number plate - NO ZERO AT END!

	char	CName	[4];	// car name
	char	SName	[16];	// skin name - MAX_CAR_TEX_NAME
	BYTE	Tyres	[4];	// compounds

	BYTE	H_Mass;			// added mass (kg)		... NEW_W9
	BYTE	H_TRes;			// intake restriction	... NEW_W9
	BYTE	SpB;
	BYTE	Passengers;		// passengers byte		... NEW_W9

	int		Spare;

	BYTE	Sp0;
	BYTE	NumP;			// number in race (same when leaving pits, 1 more if new)
	BYTE	Sp2;
	BYTE	Sp3;
} t4IS_NPL;

typedef struct // Car info in 6 bytes - there is an array of these in the NLP (below)
{
	WORD	Node;		// current path node
	WORD	Lap;		// current lap
	BYTE	PLID;		// player's unique id
	BYTE	Position;	// current race position : 0 = unknown, 1 = leader, etc...
} t4NodeLap;

typedef struct // Node and Lap Packet - variable size
{
	BYTE	Size;		// 4 + NumP * 6 (PLUS 2 if needed to make it a multiple of 4)
	BYTE	Type;		// ISP_NLP
	BYTE	ReqI;		// 0 unless this is a reply to an TINY_NLP request
	BYTE	NumP;		// number of players in race

	t4NodeLap	Info[32];	// node and lap of each player, 1 to 32 of these (NumP)
} t4IS_NLP;

typedef struct // Car info in 28 bytes - there is an array of these in the MCI (below)
{
	WORD	Node;		// current path node
	WORD	Lap;		// current lap
	BYTE	PLID;		// player's unique id
	BYTE	Position;	// current race position : 0 = unknown, 1 = leader, etc...
	BYTE	Info;		// flags and other info - see below
	BYTE	Sp3;
	int		X;			// X map (65536 = 1 metre)
	int		Y;			// Y map (65536 = 1 metre)
	int		Z;			// Z alt (65536 = 1 metre)
	WORD	Speed;		// speed (32768 = 100 m/s)
	WORD	Direction;	// direction of car's motion : 0 = world y direction, 32768 = 180 deg
	WORD	Heading;	// direction of forward axis : 0 = world y direction, 32768 = 180 deg
	short	AngVel;		// signed, rate of change of heading : (16384 = 360 deg/s)
} t4CompCar;

// NOTE 1) Info byte - the bits in this byte have the following meanings :

#define CCI_BLUE		1		// this car is in the way of a driver who is a lap ahead
#define CCI_YELLOW		2		// this car is slow or stopped and in a dangerous place
#define CCI_FIRST		64		// this is the first compcar in this set of MCI packets
#define CCI_LAST		128		// this is the last compcar in this set of MCI packets

// NOTE 2) Heading : 0 = world y axis direction, 32768 = 180 degrees, anticlockwise from above
// NOTE 3) AngVel  : 0 = no change in heading,    8192 = 180 degrees per second anticlockwise

typedef struct // Multi Car Info - if more than 8 in race then more than one of these is sent
{
	BYTE	Size;		// 228
	BYTE	Type;		// ISP_MCI
	BYTE	ReqI;		// 0 unless this is a reply to an TINY_MCI request
	BYTE	NumC;		// number of valid CompCar structs in this packet

	t4CompCar	Info[8];	// car info for each player
} t4IS_MCI;

typedef struct // InSim Init - packet to initialise the InSim system
{
	BYTE	Size;		// 44
	BYTE	Type;		// ISP_ISI
	BYTE	ReqI;		// If non-zero LFS will send an IS_VER packet
	BYTE	Zero;		// 0

	WORD	UDPPort;	// Port for UDP replies from LFS (0 to 65535)
	WORD	Flags;		// Bit flags for options (see below)

	BYTE	Sp0;		// 0
	BYTE	Prefix;		// Special host message prefix character
	WORD	Interval;	// Time in ms between NLP or MCI (0 = none)

	char	Admin[16];	// Admin password (if set in LFS)
	char	IName[16];	// A short name for your program
} t4IS_ISI;
