
#include "stdafx.h"
#include "resource.h"
#include <stdio.h>
#include "insimdefs.h"

LRESULT CALLBACK GatewayDlgProc(HWND, UINT, WPARAM, LPARAM);
BOOLEAN CreateInsimThread();
BOOLEAN StopInsimThread();

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
#ifdef _DEBUG
	AllocConsole();
	freopen("CON", "w", stdout);
#endif

	WSADATA WSAData;
	if (0 != WSAStartup(MAKEWORD(1,1), &WSAData))
	{
		MessageBox(NULL, "WSAStartup failed", "Insim Gateway", MB_OK);
		return 0;
	}

	DialogBox(hInstance, (LPCTSTR)IDD_DIALOG_GW, NULL, (DLGPROC)GatewayDlgProc);

	WSACleanup();

#ifdef _DEBUG
	FreeConsole();
#endif

	return 0;
}


HANDLE g_hInsimThread = NULL;
volatile BOOLEAN g_bStopThread;
BYTE g_InsimVersion;

WORD g_PortNrLFS;
WORD g_PortNrAPP;

#define INSIM_LFSV3  1
#define INSIM_LFSV4  2
#define INSIM_APPV3  4
#define INSIM_APPV4  8

#define L3A3     (g_InsimVersion == 0x05)
#define L4A3     (g_InsimVersion == 0x06)
#define INSIM_V4 (g_InsimVersion & 0x02)

LRESULT CALLBACK GatewayDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch( message )
	{
		case WM_INITDIALOG:
			SetDlgItemInt(hDlg, IDC_EDIT_PORTLFS, 32300, FALSE);
			SetDlgItemInt(hDlg, IDC_EDIT_PORTAPP, 32301, FALSE);
			SendDlgItemMessage(hDlg, IDC_RADIO_LFSv4, BM_SETCHECK, (WPARAM)BST_CHECKED, (LPARAM)0);
			SendDlgItemMessage(hDlg, IDC_RADIO_APPv3, BM_SETCHECK, (WPARAM)BST_CHECKED, (LPARAM)0);

			g_PortNrLFS = 32300;
			g_PortNrAPP = 32301;
			g_InsimVersion = 0x06;
			CreateInsimThread();
			if (g_hInsimThread != NULL)
			{
				SetDlgItemText(hDlg, IDC_BUTTON_RUN, "Stop Gateway");
				SendDlgItemMessage(hDlg, IDC_EDIT_PORTLFS, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
				SendDlgItemMessage(hDlg, IDC_EDIT_PORTAPP, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
			}
			return TRUE;

		case WM_COMMAND:			
			if (LOWORD(wParam) == IDC_BUTTON_RUN) 
			{
				if (g_hInsimThread == NULL)
				{
					SendDlgItemMessage(hDlg, IDC_EDIT_PORTLFS, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
					SendDlgItemMessage(hDlg, IDC_EDIT_PORTAPP, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_LFSv3, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);//todo: does not work
//					SendDlgItemMessage(hDlg, IDC_RADIO_LFSv4, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_APPv3, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_APPv4, WM_ENABLE, (WPARAM)FALSE, (LPARAM)0);
					SetDlgItemText(hDlg, IDC_BUTTON_RUN, "Stop Gateway");

					LONG bmL3 = SendDlgItemMessage(hDlg, IDC_RADIO_LFSv3, BM_GETCHECK, (WPARAM)0, (LPARAM)0 );
					LONG bmL4 = SendDlgItemMessage(hDlg, IDC_RADIO_LFSv4, BM_GETCHECK, (WPARAM)0, (LPARAM)0 );
					LONG bmA3 = SendDlgItemMessage(hDlg, IDC_RADIO_APPv3, BM_GETCHECK, (WPARAM)0, (LPARAM)0 );
					LONG bmA4 = SendDlgItemMessage(hDlg, IDC_RADIO_APPv4, BM_GETCHECK, (WPARAM)0, (LPARAM)0 );
					g_InsimVersion = 0;
					if (bmL3) g_InsimVersion |= 0x01;
					if (bmL4) g_InsimVersion |= 0x02;
					if (bmA3) g_InsimVersion |= 0x04;
					if (bmA4) g_InsimVersion |= 0x08;

					BOOL bSuccess1, bSuccess2;
					g_PortNrLFS = GetDlgItemInt(hDlg, IDC_EDIT_PORTLFS, &bSuccess1, FALSE);
					g_PortNrAPP = GetDlgItemInt(hDlg, IDC_EDIT_PORTAPP, &bSuccess2, FALSE);
					if (bSuccess1 && bSuccess2)
					{
						if (L3A3 || L4A3)
						{
							if (!CreateInsimThread())
							{
								MessageBox(hDlg, "could not start thread", "Insim Gateway", MB_OK);
							}
						}
						else
						{
							MessageBox(hDlg, "this combination is currently not supported", "Insim Gateway", MB_OK);
						}
					}
					else
					{
						MessageBox(hDlg, "please enter valid port numbers", "Insim Gateway", MB_OK);
					}
				}
				else
				{
					StopInsimThread();
				}

				if (g_hInsimThread == NULL)
				{
					SetDlgItemText(hDlg, IDC_BUTTON_RUN, "Start Gateway");
					SendDlgItemMessage(hDlg, IDC_EDIT_PORTLFS, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
					SendDlgItemMessage(hDlg, IDC_EDIT_PORTAPP, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_LFSv3, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_LFSv4, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_APPv3, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
//					SendDlgItemMessage(hDlg, IDC_RADIO_APPv4, WM_ENABLE, (WPARAM)TRUE, (LPARAM)0);
				}
			}

			if (LOWORD(wParam) == IDCANCEL)
			{
				StopInsimThread();
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}

			break;
	}

	return FALSE;
}


SOCKET CreateServerSocket()
{
	SOCKET listensocket = socket(AF_INET, (g_InsimVersion & INSIM_APPV4) ? SOCK_STREAM : SOCK_DGRAM, 0);
	if (listensocket == INVALID_SOCKET)
	{
		/* error: ToDo */
//		printf("creating a socket failed\n");
		return INVALID_SOCKET;
	}

	// Fill out the local socket's address information.
	sockaddr_in local_sin;
	memset(&local_sin, 0, sizeof(local_sin));
	local_sin.sin_family = AF_INET;
	local_sin.sin_port = htons(g_PortNrAPP);
	local_sin.sin_addr.s_addr = INADDR_ANY;//htonl(INADDR_ANY);

	// Associate the local address with WinSocket.
	if (bind(listensocket, (struct sockaddr*)&local_sin, sizeof(local_sin)) == SOCKET_ERROR)
	{
		/* error: ToDo */
//		printf("binding a socket failed\n");
		closesocket(listensocket);
		return INVALID_SOCKET;
	}

	if (g_InsimVersion & INSIM_APPV4)
	{
		// Establish a socket to listen for incoming connections.
		if (listen(listensocket, 1) == SOCKET_ERROR) 
		{
			/* error: ToDo */
//			printf("listening on a socket failed\n");
			closesocket(listensocket);
			return INVALID_SOCKET;
		}
	}

	return listensocket;
}


void OnSTAinfo(BYTE* ptr);
void OnVERinfo(BYTE* ptr);
void OnISMinfo(BYTE* ptr);
void OnMSOinfo(BYTE* ptr);
void OnCPPinfo(BYTE* ptr);
void OnRSTinfo(BYTE* ptr);
void OnNCNinfo(BYTE* ptr);
void OnCNLinfo(BYTE* ptr);
void OnNLPinfo(BYTE* ptr);
void OnMCIinfo(BYTE* ptr);
void OnNPLinfo(BYTE* ptr);
void OnPLPinfo(BYTE* ptr);
void OnPLLinfo(BYTE* ptr);
void OnLAPinfo(BYTE* ptr);
void OnSPXinfo(BYTE* ptr);

void SendOutstandingUDPpackets(SOCKET udpsocket, SOCKADDR_IN *pAddr);

int OnISIreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnVERreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnISCreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnACKreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnSSTreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnSFPreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnNLIreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnSCPreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnSCCreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnCPPreq(BYTE* ptr, SOCKET tcpsock, int len);
int OnMTCreq(BYTE* ptr, SOCKET tcpsock, int len);

int OnNPLreq(BYTE* ptr, int len);

/* internally used */
extern BOOLEAN g_bRequestNPL;
void RequestTiny(BYTE* ptr, SOCKET tcpsock, BYTE subT);

int HandleV3Packets2LFS(BYTE* pBuf, SOCKET tcpsock, int len)
{
	BYTE* ptr;
	int BufLen = len; // BufLen stores the length of the whole buffer
	while (len >= 4)
	{
		ptr = &pBuf[BufLen - len];
		DWORD pckid = *((DWORD*)ptr);
		tPcktColl* pPckt = (tPcktColl*)ptr;

		int PcktLen;

		switch (pckid)
		{
			case PCKTID_ISI: PRINT("ISI\n"); PcktLen = OnISIreq(ptr, tcpsock, len); break;
			case PCKTID_VER: PRINT("VER\n"); PcktLen = OnVERreq(ptr, tcpsock, len); break;
			case PCKTID_ISC: PRINT("ISC\n"); PcktLen = OnISCreq(ptr, tcpsock, len); break;
			case PCKTID_ACK: PRINT("ACK\n"); PcktLen = OnACKreq(ptr, tcpsock, len); break;
			case PCKTID_SST: PRINT("SST\n"); PcktLen = OnSSTreq(ptr, tcpsock, len); break;
			case PCKTID_SFP: PRINT("SFP\n"); PcktLen = OnSFPreq(ptr, tcpsock, len); break;
			case PCKTID_NLI: PRINT("NLI\n"); PcktLen = OnNLIreq(ptr, tcpsock, len); break;
			case PCKTID_SCP: PRINT("SCP\n"); PcktLen = OnSCPreq(ptr, tcpsock, len); break;
			case PCKTID_SCC: PRINT("SCC\n"); PcktLen = OnSCCreq(ptr, tcpsock, len); break;
			case PCKTID_CPP: PRINT("CPP\n"); PcktLen = OnCPPreq(ptr, tcpsock, len); break;
			case PCKTID_MTC: PRINT("MTC\n"); PcktLen = OnMTCreq(ptr, tcpsock, len); break;

			case PCKTID_NPL: PRINT("NPL\n"); PcktLen = OnNPLreq(ptr, len); break;
			default:
			{
				printf("unknown %s (%d)\n", (char*)ptr, len);
				len = 0;
				PcktLen = 0;
				break;
			}
		}

		if (PcktLen == 0)
		{
			break;
		}

		len -= PcktLen;

		Sleep(10);  //rem
	}

	if (len > 0)
		memmove(pBuf, ptr, len);

	return len;
}

extern DWORD UDPpacketListCnt;

int HandleV4Packets2APP(BYTE* pBuf, int len)
{
	BYTE* ptr;
	int BufLen = len; // BufLen stores the length of the whole buffer
	while (len >= 4)
	{
		ptr = &pBuf[BufLen - len];

		if (ptr[0] > len)
			break;

		if (UDPpacketListCnt < 1000)
		{
			switch (ptr[1])
			{
				case ISP_TINY: break;
				case ISP_SMALL: break;
				case ISP_VER: PRINT(">VER\n"); OnVERinfo(ptr); break;
				case ISP_STA: PRINT(">STA\n"); OnSTAinfo(ptr); break;
				case ISP_ISM: PRINT(">ISM\n"); OnISMinfo(ptr); break;
				case ISP_MSO: PRINT(">MSO\n"); OnMSOinfo(ptr); break;
				case ISP_RST: PRINT(">RST\n"); OnRSTinfo(ptr); break;
				case ISP_NCN: PRINT(">NCN\n"); OnNCNinfo(ptr); break;
				case ISP_CNL: PRINT(">CNL\n"); OnCNLinfo(ptr); break;
//				case ISP_CPR: OnCPRinfo(ptr); break;
				case ISP_NPL: PRINT(">NPL\n"); OnNPLinfo(ptr); break;
				case ISP_PLP: PRINT(">PLP\n"); OnPLPinfo(ptr); break;
				case ISP_PLL: PRINT(">PLL\n"); OnPLLinfo(ptr); break;
				case ISP_LAP: PRINT(">LAP\n"); OnLAPinfo(ptr); break;
				case ISP_SPX: PRINT(">SPX\n"); OnSPXinfo(ptr); break;
//				case ISP_FIN: OnFINinfo(ptr); break;
//				case ISP_RES: OnRESinfo(ptr); break;
//				case ISP_REO: OnREOinfo(ptr); break;
				case ISP_NLP: OnNLPinfo(ptr); break;
				case ISP_CPP: OnCPPinfo(ptr); break;
				case ISP_MCI: OnMCIinfo(ptr); break;
				default: printf("unknown TCP packet %d\n", ptr[1]); break;
			}
		}
		else
		{
			/* todo: no free entries for UDP packets */
		}

		len -= ptr[0];

		Sleep(10);  //rem
	}

	if (len > 0)
		memmove(pBuf, ptr, len);

	return len;
}

void GatewayL3A3(SOCKET listensocket)
{
	BYTE Buffer[10000];

	SOCKET sock = socket(AF_INET, SOCK_DGRAM, 0);
	if (sock == INVALID_SOCKET)
		return;
	
	SOCKADDR_IN source_sin, destination_sin;
	memset(&destination_sin, 0, sizeof(destination_sin));
	destination_sin.sin_family = AF_INET;
	destination_sin.sin_addr.s_addr = htonl(INADDR_LOOPBACK);//inet_addr("127.0.0.1");
	destination_sin.sin_port = htons(g_PortNrLFS);

	BOOLEAN bSrc = FALSE;
	while (g_bStopThread == FALSE)
	{
		fd_set fd;
		fd.fd_count = 2;
		fd.fd_array[0] = listensocket;
		fd.fd_array[1] = sock;
		timeval tv = {1, 0};

		//int retval;
		int retval = select(0, &fd, NULL, NULL, &tv);
		if (retval == SOCKET_ERROR)
		{
			printf("<<>>  socket error select\n");
			Sleep(100);
		}
		if (retval == 0)
		{
			printf("-");
			continue;
		}
//			Sleep(100);

		fd.fd_count = 1;
		fd.fd_array[0] = listensocket;
		timeval tv0 = {0, 0};
		retval = select(0, &fd, NULL, NULL, &tv0);
		if (retval == 1)
		{
			int destlen = sizeof(SOCKADDR_IN);
			retval = recvfrom(listensocket, (char*)Buffer, sizeof(Buffer), 0,(struct sockaddr*)&source_sin, &destlen);
			if (retval == SOCKET_ERROR)
			{
				printf("<<==  socket error recv\n");
				continue;
		//		closesocket(listensocket);
		//		closesocket(sock);
		//		return 0;
			}
			printf("<<==  %s, len=%d\n", Buffer, retval);
			retval = sendto(sock, (char*)Buffer, retval, 0, (struct sockaddr*)&destination_sin, destlen);
			if (retval == SOCKET_ERROR)
			{
				printf("<<==  socket error send\n");
				closesocket(sock);
				return;
			}
			bSrc = TRUE;
		}
		else if (retval == SOCKET_ERROR)
		{
			printf("<<==  socket error select\n");
		}
		else
		{
			printf(".");
		}

		fd.fd_count = 1;
		fd.fd_array[0] = sock;
//			timeval tv0 = {0, 0};
		retval = select(0, &fd, NULL, NULL, &tv0);
		if (retval == 1)
		{
			int destlen = sizeof(SOCKADDR_IN);
			retval = recvfrom(sock, (char*)Buffer, sizeof(Buffer), 0,(struct sockaddr*)&destination_sin, &destlen);
			if (retval == SOCKET_ERROR)
			{
				printf("==>>  socket error recv\n");
				continue;
		//		closesocket(listensocket);
		//		closesocket(sock);
		//		return 0;
			}
			printf("==>>  %s, len=%d\n", Buffer, retval);
			if (bSrc)
			{
				sendto(listensocket, (char*)Buffer, retval, 0, (struct sockaddr*)&source_sin, destlen);
				if (retval == SOCKET_ERROR)
				{
					printf("==>>  socket error send\n");
					closesocket(sock);
					return;
				}
			}
		}
		else if (retval == SOCKET_ERROR)
		{
			printf("==>>  socket error select\n");
		}
		else
		{
			printf(",");
		}
	}

	closesocket(sock);
}


void GatewayL4A3(SOCKET listensocket)
{
	BYTE BufferAPP2LFS[1000];
	BYTE BufferLFS2APP[1000];

	SOCKET clientsock = socket(AF_INET, SOCK_STREAM, 0);
	if (clientsock == INVALID_SOCKET)
		return;

	SOCKADDR_IN source_sin, destination_sin;
	memset(&destination_sin, 0, sizeof(destination_sin));
	destination_sin.sin_family = AF_INET;
	destination_sin.sin_addr.s_addr = htonl(INADDR_LOOPBACK);//inet_addr("127.0.0.1");
	destination_sin.sin_port = htons(g_PortNrLFS);


	int StartUDPix = 0;
	int StartTCPix = 0;
	BOOLEAN bConnected2LFS = FALSE;

	UDPpacketListCnt = 0;
	while (g_bStopThread == FALSE)
	{
		fd_set fd;
		int retval;
#if 0
		fd.fd_count = bConnected2LFS ? 2 : 1;
		fd.fd_array[0] = listensocket;
		fd.fd_array[1] = clientsock;
		timeval tv = {1, 0};

		//int retval;
		int retval = select(0, &fd, NULL, NULL, &tv);
		if (retval == SOCKET_ERROR)
		{
			printf("<<>>  socket error select\n");
			Sleep(100);
		}
		if (retval == 0)
		{
			printf("-");
			continue;
		}
#endif

		Sleep(10);

		fd.fd_count = 1;
		fd.fd_array[0] = listensocket;
		timeval tv0 = {0, 0};
		retval = select(0, &fd, NULL, NULL, &tv0);
		if (retval == 1)
		{
			int destlen = sizeof(SOCKADDR_IN);
			retval = recvfrom(listensocket, (char*)&BufferAPP2LFS[StartUDPix], sizeof(BufferAPP2LFS) - StartUDPix, 0,(struct sockaddr*)&source_sin, &destlen);
			if (retval == SOCKET_ERROR)
			{
				printf("<<==  socket error recv\n");
				continue;
			}
//			printf("<<==  %s, len=%d\n", BufferAPP2LFS, retval + StartUDPix);
			if (bConnected2LFS == FALSE)
			{
				int retvcon = connect(clientsock, (struct sockaddr*)&destination_sin, destlen);
				if (retvcon != SOCKET_ERROR)
				{
					bConnected2LFS = TRUE;
				}
			}
			if (bConnected2LFS == FALSE)
			{
				continue;
			}

			StartUDPix = HandleV3Packets2LFS(BufferAPP2LFS, clientsock, retval + StartUDPix);
		}
		else if (retval == SOCKET_ERROR)
		{
			printf("<<==  socket error select\n");
		}
		else
		{
			printf(".");
		}

		if (bConnected2LFS == FALSE)
			continue;

		fd.fd_count = 1;
		fd.fd_array[0] = clientsock;
//			timeval tv0 = {0, 0};
		retval = select(0, &fd, NULL, NULL, &tv0);
		if (retval == 1)
		{
			int destlen = sizeof(SOCKADDR_IN);
			retval = recv(clientsock, (char*)&BufferLFS2APP[StartTCPix], sizeof(BufferLFS2APP) - StartTCPix, 0);
			if (retval == SOCKET_ERROR)
			{
				
				printf("==>>  socket error recv\n");
				closesocket(clientsock);
				bConnected2LFS = FALSE;
				Sleep(100);
				continue;
			}
			if (retval > 0)
			{
//				printf("==>>  TCP from Lfs, len=%d\n", retval + StartTCPix);
				StartTCPix = HandleV4Packets2APP(BufferLFS2APP, retval + StartTCPix);
				if (g_bRequestNPL)
				{

					BYTE Buffer[4];
					RequestTiny(Buffer, clientsock, TINY_NPL);
					g_bRequestNPL = FALSE;
				}
			}
			else
			{
				printf("retv send=%i\n", retval);
				closesocket(clientsock);
				bConnected2LFS = FALSE;
				Sleep(100);
				continue;
			}

	/*		sendto(listensocket, (char*)Buffer, retval, 0, (struct sockaddr*)&source_sin, destlen);
			if (retval == SOCKET_ERROR)
			{
				printf("==>>  socket error send\n");
				closesocket(clientsock);
				return;
			}*/
		}
		else if (retval == SOCKET_ERROR)
		{
			printf("==>>  socket error select\n");
		}
		else
		{
			printf(",");
		}

		SendOutstandingUDPpackets(listensocket, &source_sin);
	}

	if (bConnected2LFS)
		closesocket(clientsock);
}

DWORD WINAPI InsimThread(LPVOID lpParameter)
{
	SOCKET listensocket = CreateServerSocket();
	if (L3A3)
	{
		GatewayL3A3(listensocket);
	}
	if (L4A3)
	{
		GatewayL4A3(listensocket);
	}

	closesocket(listensocket);
	return 0;
}

BOOLEAN CreateInsimThread()
{
	DWORD ThreadID;
	g_bStopThread = FALSE;
	g_hInsimThread = CreateThread(NULL, 0, InsimThread, NULL, 0, &ThreadID);
	SetThreadPriority(g_hInsimThread, THREAD_PRIORITY_TIME_CRITICAL);//ToDo
	return (g_hInsimThread != NULL);
}

BOOLEAN StopInsimThread()
{
	if (g_hInsimThread != NULL)
	{
		g_bStopThread = TRUE;
		if (WaitForSingleObject(g_hInsimThread, 3000) == WAIT_TIMEOUT)
			return FALSE;

		CloseHandle(g_hInsimThread);
		g_hInsimThread = NULL;
	}

	return TRUE;
}
