
#include "stdafx.h"
#include <stdio.h>
#include "insimdefs.h"


/* put all packets from LFS to application into */
/* a queue to implement Guaranteed Delivery.    */
/* 15 retries in 4 s interval before discarding */
typedef struct
{
	tPcktColl Packet;
	int sizeofPacket;
	DWORD TimeStamp;
	WORD verifyID;
	BYTE nRetries;
} tUDPpacketListEntry;

DWORD UDPpacketListCnt;
tUDPpacketListEntry UDPpacketList[1000];
WORD g_VerifyID = 1;
BOOLEAN g_bGuaranteedDelivery = FALSE;

/* keep track of a lot of information */

tIS_NCN NCN_ConnectionList[256];
tIS_NPL NPL_PlayerList[256];
int g_TrackingPlyNum = 0;
BYTE g_NumPlayers = 0;
BOOLEAN g_bRequestNPL = FALSE;  // trigger a NPL request with this flag

WORD GetNextVerifyID()
{
	g_VerifyID++;
	if (g_VerifyID == 0) g_VerifyID++;
	return g_VerifyID;
}

/*******************************************/
/* all conversions from application to LFS */
/*******************************************/

void RequestTiny(BYTE* ptr, SOCKET tcpsock, BYTE subT)
{
	ptr[0] = 4;
	ptr[1] = ISP_TINY;
	ptr[2] = 1;
	ptr[3] = subT;
	send(tcpsock, (char*)ptr, 4, 0);
}

int OnISIreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimInit))
		return 0;

	g_bGuaranteedDelivery = (ptr[6] & 0x02);

	tInSimInit* pt3 = (tInSimInit*)ptr;
	t4IS_ISI isi;
	memset(&isi, 0, sizeof(isi));
	isi.Size = 44;
	isi.Type = ISP_ISI;
	isi.UDPPort = pt3->Port;
	isi.Flags = (pt3->Flags & ISF_NLP_MCI) ? 32 : 16;//ISF_MCI : ISF_NLP;

	isi.Interval = pt3->NodeSecs * 1000;
	memcpy(isi.Admin, pt3->Admin, 16);

	send(tcpsock, (char*)&isi, 44, 0);
	return sizeof(tInSimInit);
}

int OnVERreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	RequestTiny(ptr, tcpsock, TINY_VER);
	return sizeof(tInSimPack);
}

int OnISCreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	RequestTiny(ptr, tcpsock, TINY_CLOSE);
	return sizeof(tInSimPack);
}

int OnACKreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	tInSimPack* pPack = (tInSimPack*)ptr;
	if (pPack->Value == 0)
	{
		ptr[0] = 4;
		ptr[1] = ISP_TINY;
		ptr[2] = 0;
		ptr[3] = TINY_NONE;
		send(tcpsock, (char*)ptr, 4, 0);
	}
	else
	{
		// remove the packet from the list
		DWORD i = 0;
		while (i < UDPpacketListCnt)
		{
			if (UDPpacketList[i].verifyID == pPack->Value)
			{
				UDPpacketListCnt--;
				UDPpacketList[i] = UDPpacketList[UDPpacketListCnt];
				break;
			}

			i++;
		}
	}

	return sizeof(tInSimPack);
}

int OnSSTreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	RequestTiny(ptr, tcpsock, TINY_SST);
	return sizeof(tInSimPack);
}

int OnSFPreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tStateFlagsPack))
		return 0;

	ptr[0] = 8;
	ptr[1] = ISP_SFP;
	ptr[2] = 1;
	send(tcpsock, (char*)ptr, 8, 0);
	return sizeof(tStateFlagsPack);
}

int OnMODreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < 20)//sizeof(tInSimPack))
		return 0;

	ptr[0] = 20;
	ptr[1] = ISP_MOD;
	ptr[2] = 1;
	send(tcpsock, (char*)ptr, 20, 0);
	return 20;//sizeof(tInSimPack);
}

int OnNLIreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	ptr[0] = 8;
	ptr[1] = ISP_SMALL;
	ptr[2] = 1;
	ptr[3] = SMALL_NLI;
	send(tcpsock, (char*)ptr, 8, 0);
	return sizeof(tInSimPack);
}

int OnSCPreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	RequestTiny(ptr, tcpsock, TINY_SCP);
	return sizeof(tInSimPack);
}

int OnSCCreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tSetCarCamera))
		return 0;

	ptr[0] = 8;
	ptr[1] = ISP_SCC;
	ptr[2] = 1;
	ptr[3] = 0;
	// todo: if UniqueId(v3) is unused translate from ViewPlayer(v3) to PLID(v4), what means unused?
	ptr[4] = ptr[6];
//	ptr[5] = 0;
	ptr[6] = 0;
	ptr[7] = 0;
	send(tcpsock, (char*)ptr, 8, 0);
	return sizeof(tSetCarCamera);
}

int OnCPPreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tCamPosPack))
		return 0;

	ptr[0] = 32;
	ptr[1] = ISP_CPP;
	ptr[2] = 1;
	ptr[3] = 0;

	/* we need to replace the ViewPlayer(v3) by the ViewPLID(v4) */
	BYTE PNum = ptr[22];
	ptr[22] = 0;

	/* search for the PLID */
	for (int i = 0; i < 256; i++)
	{
		if ((NPL_PlayerList[i].NPL.l == PCKTID_NPL) &&
			(NPL_PlayerList[i].PlyNum == PNum))
		{
			// translate from PlyNum into PLID
			ptr[22] = i;
			break;
		}
	}

	send(tcpsock, (char*)ptr, 32, 0);
	return sizeof(tCamPosPack);
}

int OnMTCreq(BYTE* ptr, SOCKET tcpsock, int len)
{
	if (len < sizeof(tMsgToConn))
		return 0;

	BYTE MSLbuf[132];
	memset(MSLbuf, 0, 132);
	MSLbuf[0] = 132;
	MSLbuf[1] = ISP_MSL;
	MSLbuf[2] = 1;
	memcpy(&MSLbuf[4], &ptr[8], 64);
	send(tcpsock, (char*)MSLbuf, 132, 0);
	return sizeof(tMsgToConn);
}

int OnNPLreq(BYTE* ptr, int len)
{
	if (len < sizeof(tInSimPack))
		return 0;

	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_NPL* p3 = &pEntry->Packet.NPL;
	tInSimPack* pReq = (tInSimPack*)ptr;

	/* search for the players number */
	for (int i = 0; i < 256; i++)
	{
		if ((NPL_PlayerList[i].NPL.l == PCKTID_NPL) &&
			(NPL_PlayerList[i].PlyNum == pReq->Value))
		{
			*p3 = NPL_PlayerList[i];

			p3->Total = g_NumPlayers;
			p3->VerifyId = GetNextVerifyID();
			pEntry->sizeofPacket = sizeof(tIS_NPL);
			pEntry->nRetries = 16;
			pEntry->verifyID = p3->VerifyId;
			UDPpacketListCnt++;
			break;
		}
	}

	return sizeof(tInSimPack);
}

/*******************************************/
/* all conversions from LFS to application */
/*******************************************/

void OnSTAinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tStatePack* p = &pEntry->Packet.STA;
	memcpy(p, ptr, 28);
	p->Id.l = PCKTID_STA;
	pEntry->sizeofPacket = sizeof(tStatePack);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;

	g_NumPlayers = p->NumPlayers;

	if (g_NumPlayers > g_TrackingPlyNum)
		g_bRequestNPL = TRUE;
}

void OnVERinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tInSimVersion* p = &pEntry->Packet.VER;
	memcpy(p, ptr, 20);
	p->Id.l = PCKTID_VER;
	pEntry->sizeofPacket = sizeof(tInSimVersion);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;
}

void OnISMinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tInSimMulti* p = &pEntry->Packet.ISM;
	memcpy(p, ptr, 40);
	p->Id.l = PCKTID_ISM;
	pEntry->sizeofPacket = sizeof(tInSimMulti);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;
}

void OnMSOinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tMsgOutPack* p = &pEntry->Packet.MSO;
	memcpy(&p->Msg, &ptr[8], 64);
	p->Msg[63] = 0;
	p->Id.l = PCKTID_MSO;
	pEntry->sizeofPacket = sizeof(tMsgOutPack);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;
}

void OnCPPinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tCamPosPack* p = &pEntry->Packet.CPP;
	memcpy(p, ptr, 32);
	p->Id.l = PCKTID_CPP;
	pEntry->sizeofPacket = sizeof(tCamPosPack);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;
}

void OnRSTinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_RST* p = &pEntry->Packet.RST;
	memcpy(p, ptr, 20);
	p->RST.l = PCKTID_RST;
	p->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_RST);
	pEntry->nRetries = 16;
	pEntry->verifyID = p->VerifyId;
	UDPpacketListCnt++;

	g_NumPlayers = p->NumInRace;
	g_bRequestNPL = TRUE;  // request all players
}

void OnNCNinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_NCN* p = &pEntry->Packet.NCN;
	memcpy(p, ptr, 56);
	p->ConnNum = ptr[3];
	p->NCN.l = PCKTID_NCN;
	p->Total = p->Sp1;
	p->Sp1 = 0;
	p->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_NCN);
	pEntry->nRetries = 16;
	pEntry->verifyID = p->VerifyId;

	/* store user name and nickname in an arry */
	NCN_ConnectionList[p->ConnNum] = *p;
	UDPpacketListCnt++;
}

void OnCNLinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_CNL* p = &pEntry->Packet.CNL;
	memset(p, 0, sizeof(tIS_CNL));
	p->ConnNum = ptr[3];
	p->Total = ptr[5];
	memcpy(p->PName, NCN_ConnectionList[p->ConnNum].PName, 24);
	memcpy(p->UName, NCN_ConnectionList[p->ConnNum].UName, 24);
	p->VerifyId = GetNextVerifyID();
	p->CNL.l = PCKTID_NCN;
	pEntry->sizeofPacket = sizeof(tIS_CNL);
	pEntry->nRetries = 16;
	pEntry->verifyID = p->VerifyId;
	UDPpacketListCnt++;
}

void OnNPLinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_NPL* p3 = &pEntry->Packet.NPL;
	t4IS_NPL* p4 = (t4IS_NPL*)ptr;

	if (g_TrackingPlyNum == 0)
		memset(NPL_PlayerList, 0, sizeof(NPL_PlayerList));

	memset(p3, 0, sizeof(tIS_NPL));
	p3->NPL.l = PCKTID_NPL;
	memcpy(p3->UName, NCN_ConnectionList[p4->UCID].UName, 24);
	memcpy(p3->PName, p4->PName, 24);
	memcpy(NCN_ConnectionList[p4->UCID].PName, p4->PName, 24);  // udate user list
	memcpy(p3->Plate, p4->Plate, 8);
	memcpy(p3->CName, p4->CName, 4); // todo: convert 2 car long name
	p3->Flags = p4->Flags;
	p3->Type = p4->Type;
	p3->UniqueId = p4->PLID;

	if (NPL_PlayerList[p3->UniqueId].NPL.l == PCKTID_NPL)
	{
		/* player leaves pits, alredy in race */
		p3->PlyNum = NPL_PlayerList[p3->UniqueId].PlyNum;
	}
	else
	{
		/* player joined race */
		p3->PlyNum = g_TrackingPlyNum;
		g_TrackingPlyNum++;
	}

	p3->Total = p4->NumP;
	p3->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_NPL);
	pEntry->nRetries = 16;
	pEntry->verifyID = p3->VerifyId;
	UDPpacketListCnt++;

	/* store user name and nickname in an arry */
	NPL_PlayerList[p4->PLID] = *p3;
	g_NumPlayers = p4->NumP;
}

void OnPLPinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_PLP* p3 = &pEntry->Packet.PLP;

	memset(p3, 0, sizeof(tIS_PLP));
	p3->PLP.l = PCKTID_PLP;
	p3->UniqueId = ptr[3];
	memcpy(p3->UName, NPL_PlayerList[p3->UniqueId].UName, 24);
	memcpy(p3->PName, NPL_PlayerList[p3->UniqueId].PName, 24);
	p3->PlyNum = NPL_PlayerList[p3->UniqueId].PlyNum;
	p3->Total = g_NumPlayers;
	p3->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_PLP);
	pEntry->nRetries = 16;
	pEntry->verifyID = p3->VerifyId;
	UDPpacketListCnt++;
}

void OnPLLinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_PLL* p3 = &pEntry->Packet.PLL;

	memset(p3, 0, sizeof(tIS_PLL));
	p3->PLL.l = PCKTID_PLL;
	p3->UniqueId = ptr[3];
	memcpy(p3->UName, NPL_PlayerList[p3->UniqueId].UName, 24);
	memcpy(p3->PName, NPL_PlayerList[p3->UniqueId].PName, 24);
	p3->PlyNum = NPL_PlayerList[p3->UniqueId].PlyNum;

	if (NPL_PlayerList[p3->UniqueId].NPL.l == PCKTID_NPL) // just a check
	{
		/* search for the player with the highest PlyNum */
		g_TrackingPlyNum--;
		BOOLEAN bFound = FALSE;
		for (int i = 0; i < 256; i++)
		{
			if ((NPL_PlayerList[i].NPL.l == PCKTID_NPL) &&
				(NPL_PlayerList[i].PlyNum == g_TrackingPlyNum))
			{
				/* found, this player now gets the freed PlyNum */
				NPL_PlayerList[i].PlyNum = p3->PlyNum;
				bFound = TRUE;
				break;
			}
		}

		if (bFound == FALSE)
		{
			/* Todo: ??? what to do? no idea, something seemed to go terrible wrong */
		}
	}

	g_NumPlayers--;
	p3->Total = g_NumPlayers;
	p3->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_PLL);
	pEntry->nRetries = 16;
	pEntry->verifyID = p3->VerifyId;
	UDPpacketListCnt++;

	/* mark this data record as unavailable */
	NPL_PlayerList[p3->UniqueId].NPL.l = 0;
}

MSHT GetMSHT(DWORD lapTime)
{
	MSHT tmp;
	tmp.minutes = (BYTE)(lapTime / 60000);
	lapTime -= tmp.minutes * 60000;
	tmp.seconds = (BYTE)(lapTime / 1000);
	lapTime -= tmp.seconds * 1000;
	tmp.hundrets = (BYTE)(lapTime / 10);
	lapTime -= tmp.hundrets * 10;
	tmp.thousands = (BYTE)(lapTime);

	return tmp;
}

void OnLAPinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_LAP* p3 = &pEntry->Packet.LAP;

	memset(p3, 0, sizeof(tIS_LAP));
	p3->LAP.l = PCKTID_LAP;
	p3->UniqueId = ptr[3];
	memcpy(p3->UName, NPL_PlayerList[p3->UniqueId].UName, 24);
	memcpy(p3->PName, NPL_PlayerList[p3->UniqueId].PName, 24);
	memcpy(p3->CName, NPL_PlayerList[p3->UniqueId].CName, 32);
	p3->PlyNum = NPL_PlayerList[p3->UniqueId].PlyNum;
	p3->Time = GetMSHT(*((DWORD*)(&ptr[4])));

	p3->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_PLL);
	pEntry->nRetries = 16;
	pEntry->verifyID = p3->VerifyId;
	UDPpacketListCnt++;
}

void OnSPXinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_SPX* p3 = &pEntry->Packet.SPX;

	memset(p3, 0, sizeof(tIS_SPX));
	p3->SPX.l = PCKTID_SP1;
	p3->SPX.c[2] = ptr[12] + '0';
	p3->UniqueId = ptr[3];
	p3->PlyNum = NPL_PlayerList[p3->UniqueId].PlyNum;
	p3->Time = GetMSHT(*((DWORD*)(&ptr[4])));

	p3->VerifyId = GetNextVerifyID();
	pEntry->sizeofPacket = sizeof(tIS_PLL);
	pEntry->nRetries = 16;
	pEntry->verifyID = p3->VerifyId;
	UDPpacketListCnt++;
}

void OnNLPinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_NLP* p3 = &pEntry->Packet.NLP;
	t4IS_NLP* p4 = (t4IS_NLP*)ptr;

	memset(p3, 0, sizeof(tIS_NLP));
	p3->NLP.l = PCKTID_NLP;
	p3->FinishLine = 0;// todo
	p3->NumNodes = 0; // todo
	p3->NumPlayers = p4->NumP;

	BYTE num = p4->NumP;
	if (num > 28) num = 28;
	for (int i = 0; i < num; i++)
	{
		p3->Info[i].Node_Lap_Hi3 = ((p4->Info[i].Lap & 0xFF00) << 5) | (p4->Info[i].Node & 0x1FFF);
		p3->Info[i].Lap_Lo8 = (BYTE)p4->Info[i].Lap;
		p3->Info[i].UniqueId = p4->Info[i].PLID;
	}

	pEntry->sizeofPacket = sizeof(tIS_NLP);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;

	g_NumPlayers = p3->NumPlayers;
}

void OnMCIinfo(BYTE* ptr)
{
	tUDPpacketListEntry* pEntry = &UDPpacketList[UDPpacketListCnt];
	tIS_MCI* p3 = &pEntry->Packet.MCI;
	t4IS_MCI* p4 = (t4IS_MCI*)ptr;

	memset(p3, 0, sizeof(tIS_MCI));

	p3->MCI.l = PCKTID_MCI;
	p3->FinishLine = 0;//g_State.; // todo
	p3->NumNodes = 0; // todo

	static BYTE FirstPlayer = 0;
	FirstPlayer += 8;
	BOOLEAN bLast = FALSE;

#ifdef PATCH_W35
	/* generate FirstPly and NumPlayers based on timing between MCI packets */
	static DWORD lasttick;

	DWORD tick = GetTickCount();
	DWORD td = tick - lasttick;
	FirstPlayer = (td < 50) ? (FirstPlayer + 8) : 0;
	lasttick = tick;

	// verification
	if (p4->NumC == 8)
	{
		if ((FirstPlayer + p4->NumC) > g_NumPlayers)
		{
			printf("large correction in MCI (%d->%d)\n", g_NumPlayers, FirstPlayer + p4->NumC);
			g_NumPlayers = FirstPlayer + p4->NumC;
		}
	}
	else
	{
		if ((FirstPlayer + p4->NumC) != g_NumPlayers)
		{
			printf("small correction in MCI (%d->%d)\n", g_NumPlayers, FirstPlayer + p4->NumC);
			g_NumPlayers = FirstPlayer + p4->NumC;
		}
	}

	p3->FirstPly = FirstPlayer;
	p3->NumPlayers = g_NumPlayers;//p4->NumC;
#endif

	BYTE num = p4->NumC;
	if (num > 8) num = 8;
	for (int i = 0; i < num; i++)
	{
		memcpy(&p3->Info[i].X, &p4->Info[i].X, 20);
		p3->Info[i].Node_Lap_Hi3 = ((p4->Info[i].Lap & 0xFF00) << 5) | (p4->Info[i].Node & 0x1FFF);
		p3->Info[i].Lap_Lo8 = (BYTE)p4->Info[i].Lap;
		p3->Info[i].UniqueId = p4->Info[i].PLID;
		if (p4->Info[i].Info & CCI_FIRST)
			FirstPlayer = 0;
		if (p4->Info[i].Info & CCI_LAST)
			bLast = TRUE;
	}

	p3->FirstPly = FirstPlayer;
	if (bLast)
	{
		p3->NumPlayers = FirstPlayer + p4->NumC;
		// verification
		if (p3->NumPlayers != g_NumPlayers)
		{
			printf("Number of players wrong (%d->%d)\n", g_NumPlayers, p3->NumPlayers);
			g_NumPlayers = p3->NumPlayers;
		}
	}
	else
	{
		p3->NumPlayers = g_NumPlayers;
		// verification
		if (p4->NumC != 8)
		{
			printf("bug in MCI: this should NEVER happen!\n");
		}
		if (p3->NumPlayers <= FirstPlayer + 8)
		{
			printf("Number of players too low (%d/%d)\n", FirstPlayer, p3->NumPlayers);
		}
	}

	pEntry->sizeofPacket = sizeof(tIS_MCI);
	pEntry->nRetries = 0;
	pEntry->verifyID = 0;
	UDPpacketListCnt++;
}


void SendOutstandingUDPpackets(SOCKET udpsocket, SOCKADDR_IN *pAddr)
{
	DWORD currenttime = GetTickCount();

	DWORD i = 0;
	while (i < UDPpacketListCnt)
	{
		DWORD timediff = currenttime - UDPpacketList[i].TimeStamp;
		if ((UDPpacketList[i].nRetries == 16) ||
			(UDPpacketList[i].nRetries == 0) ||
			(timediff > 4000))
		{
			int addrlen = sizeof(SOCKADDR_IN);
			sendto(udpsocket, (char*)&UDPpacketList[i].Packet, UDPpacketList[i].sizeofPacket, 0, (struct sockaddr*)pAddr, addrlen);

			if ((UDPpacketList[i].nRetries > 0) && (g_bGuaranteedDelivery))
			{
				UDPpacketList[i].TimeStamp = currenttime;
				UDPpacketList[i].nRetries--;
				i++;
			}
			else
			{
				UDPpacketListCnt--;
				UDPpacketList[i] = UDPpacketList[UDPpacketListCnt];
			}
		}
		else
		{
			i++;
		}
	}
}
