<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- Simple best times stylesheet v.1.0 by: Aquilifer -->


	<xsl:template match="/">
		<!-- <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"/> -->
		<html>
			<head>
				<title>
					Server best times at
					<xsl:value-of select="server_best/server/name"/>
				</title>
			</head>
			<body bgcolor="#000000" text="#ffffff" background="../pics/bg_sb.jpg">
				<font face="Verdana, Geneva, Arial, Helvetica, sans-serif" size="3" color="#fffff">
					<br/>
					<br/>
					<!-- <h1 align='center'>Server best times</h1> -->

					<table align="center">
						<tr>
						<td>
						<img src="../pics/title_sb.gif" alt="Server best times" halign="center"/>
						</td>
						</tr>
					</table>

					<br/>
					<xsl:apply-templates select="server_best">
						<xsl:sort select="entry/lap" order = "ascending" />
					</xsl:apply-templates>

					<font size="2"><p align="center">Generated by VCom</p></font>

				</font>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="server">
		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Server: </b></td>
				<!-- <td><xsl:value-of select="name"/></td> -->
				<td>
					<xsl:apply-templates select="name"/>
				</td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Time: </b></td>
				<td><xsl:value-of select="../time"/></td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Track: </b></td>
				<td><xsl:value-of select="../track/name"/> (<xsl:value-of select="../track/length"/> meters)</td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
		</table>
		<p></p>
	</xsl:template>

	
	<xsl:template match="server_best">
	
		<xsl:apply-templates select="comment"/>
		<br/>
	
		<xsl:apply-templates select="server"/>
		<br/>
	
		<!-- <table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#CCDDCC"> -->
		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td>
					<xsl:attribute name="colspan"><xsl:value-of select="5+track/splits"/>)</xsl:attribute>
				</td>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Pos.</b></td>
				<td><b>Driver</b></td>
				<td><b>Car</b></td>
				<td></td> <!-- car picture -->
				<td><b>Lap time</b></td>
				<xsl:if test="number(track/splits) > 0">
					<td><b>Split 1</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 1">
					<td><b>Split 2</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 2">
					<td><b>Split 3</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 3">
					<td><b>Split 4</b></td>
				</xsl:if>
				<td></td>
			</tr>
			<xsl:apply-templates select="entry"/>
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td>
					<xsl:attribute name="colspan"><xsl:value-of select="5+track/splits"/>)</xsl:attribute>
				</td>
				<td width="12" height="12"></td>
			</tr>
		</table>

		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	
	<xsl:template match="comment">
		<xsl:if test="string-length(.) > 0">
			<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
				<tr bgcolor="#555555">
					<td></td>
					<td><xsl:value-of select="."/></td>
					<td></td>
				</tr>
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="entry">
		<tr bgcolor="#555555">
			<td></td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="position()"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<p valign="center"><xsl:value-of select="position()"/></p>
				<!-- </xsl:if> -->
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="driver"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<!-- <p valign="center"><xsl:value-of select="driver"/></p> -->
					<!-- <xsl:value-of select="driver"/> -->
					<xsl:apply-templates select="name"/>
				<!-- </xsl:if> -->
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="car"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->

				<p valign="center"><xsl:value-of select="car"/></p>
				<!-- </xsl:if> -->
			</td>
			<td>
				<img border="0" width="128" height="64" align="center">
					<xsl:attribute name="src">../pics/<xsl:value-of select="car"/>.jpg</xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="car"/></xsl:attribute>
				</img>
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="lap"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<p avalign="center">
						<xsl:value-of select="lap"/>
						<xsl:if test="time_diff">
							<font size="1">
								<br/>
								(+<xsl:value-of select="time_diff"/>)
							</font>
						</xsl:if>
						<xsl:if test="average_speed">
							<font size="1">
								<br/>
								(<xsl:value-of select="average_speed"/> km/h)
							</font>
						</xsl:if>
					</p>
				<!-- </xsl:if> -->
			</td>
			
			<!--
			<xsl:apply-templates select="split"/>
			-->

			<xsl:for-each select="split">
				<td>
					<!--
					<xsl:if test="position() = 1">
					 <xsl:if test="../position()=1">
						<font size="5">
							<xsl:value-of select="."/>
						</font>
					</xsl:if>
					<xsl:if test="not(position() = 1)">
					-->
					<!-- <xsl:if test="not(..[1]) = 1)"> -->
						<p avalign="center"><xsl:value-of select="."/></p>
					<!-- </xsl:if> -->
				</td>
			</xsl:for-each>

			
			<!--
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			-->
			<!--
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			-->
			<td></td>
		</tr>
	</xsl:template>
	<!--
	<xsl:template match="split">
		<td>
			<xsl:if test="../[position() = 1]">
				<font size="5"/>
			</xsl:if> 
			<xsl:value-of select="."/>
			<xsl:if test="../[position() = 1]">
				<font size="4"/>
			</xsl:if>
		</td>	
	</xsl:template>
	-->

	<xsl:template match="name">
		<xsl:if test="font">
			<xsl:apply-templates select="font"/>
		</xsl:if>
		<xsl:if test="not(font)">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template>
		
	<xsl:template match="font">
		<!-- <xsl:attribute name="color"> -->
		<font>
			<xsl:attribute name="color"> <xsl:value-of select="@color"/> </xsl:attribute>
			<xsl:value-of select="."/>
		</font>
	</xsl:template>
</xsl:stylesheet>

