/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include "hooks_keepalive.h"

void hkeepalive_create(struct insim_t *I, void **ctx)
{
	*ctx = malloc(sizeof(struct hkeepalive_t));
	memset(*ctx, 0, sizeof(struct hkeepalive_t));

	return;
}

void hkeepalive_connected(struct insim_t *I, void *ctx)
{
    struct hkeepalive_t *t = ctx;
    time(&(t->conntime));
    time(&(t->last));

    return;
}

void hkeepalive_prerecv(struct insim_t *I, void *ctx)
{
    struct hkeepalive_t *t = ctx;
    time_t now;
    now = time(NULL);

    // Timeout handling
    if (difftime(now, t->last) > I->socket.timeout)
    {
        fprintf(stderr, "hkeepalive_prerecv: Connection Timeout\n");
        I->internals.quit = TRUE;
        return;
    }

    // Version recv check
    if (t->gotvers != TRUE)
    {
        if (difftime(now, t->conntime) > INSIM_VERSION_TIMEOUT_MAX)
        {
            fprintf(stderr, "hkeepalive_prerecv: Didn't receive ISP_VER response in a seemly amount of time.\n");
            I->internals.quit = TRUE;
            return;
        }
    }
    return;
}

void hkeepalive_recv(struct insim_t *I, void *ctx, void *data, unsigned int size)
{
    struct hkeepalive_t *t = ctx;
    unsigned int p = *((char *)data+1);

    // Update the last time LFS contacted us
    time(&(t->last));

    // Check to see if we've got an ISP_VER yet
    if (I->internals.gotvers != TRUE)
    {
        if (p == ISP_VER)
        {
            printf("Got VER\n");
            t->gotvers = TRUE;
            return;
        }
    }

    // If it's a KeepAlive, respond
    if (p == ISP_TINY)
    {
        struct IS_TINY *t = data;
        if ((t->reqI == 0) && (t->subT == TINY_NONE))
        {
            printf("Ping? ");
            struct IS_TINY a;
            memset(&a, 0, sizeof(struct IS_TINY));
            a.size = sizeof(struct IS_TINY);
            a.type = ISP_TINY;

            insim_send(I, (char *)&a, sizeof(struct IS_TINY));

            printf("Pong!\n");
            return;
        }
    }
    return;
}

void hkeepalive_close(struct insim_t *I, void *ctx)
{
    free(ctx);
    return;
}
