srv = {
	connections = { number = 0, },
}

function undercontrol_init()
	luaLFS:mst("Undercontrol v"..config.undercontrol.version.." active.")
end

function undercontrol_newconn(imsg)
	local t = luaLFS:ncn(imsg)
	local topic = string.gsub(config.undercontrol.welcome, "$p", luaLFS:stripctrlchars(t.pname))

	srv.connections.number = t.total - 1

	-- print(os.date('%x %X').." : Player joined ("..t.uname.."). "..srv.connections.number.." in server.")

	luaLFS:mtc(t.ucid, 0, topic)

	if (t.admin == 1) then
		luaLFS:mtc(t.ucid, 0, ":You are currently logged in as an administrator.")
	else
		if (config.undercontrol.canspectate ~= true) then
			local k, v
			for k, v in pairs(config.undercontrol.racers) do
				if (t.uname == v) then
					i = 1
				end
			end
			if (i ~= 1) then
				luaLFS:mtc(t.ucid, 0, config.undercontrol.deniedmsg)
				luaLFS_sleep(1)
				luaLFS:mst("/kick "..t.uname)
				srv.connections.number = srv.connections.number - 1
				return
			end		
		end
	end

	table.insert(srv.connections, t.ucid, t)
	return
end

function undercontrol_connleave(imsg)
	local t = luaLFS:cnl(imsg)
	srv.connections.number = t.total-1
	-- print(os.date('%x %X').." : Player left ("..srv.connections[t.ucid].uname.."). "..srv.connections.number.." in server.")

	if (srv.connections[t.ucid] ~= nil) then
		table.remove(srv.connections, t.ucid)
	end
end

function undercontrol_magicwords(imsg)
	local t = luaLFS:mso(imsg)
	if (luaLFS.versions.product ~= "DEMO") then
		local said = luaLFS:stripctrlchars(string.match(t.msg, "[%w%s%p]+ : (.+)"))
		if ((srv.connections[t.ucid] ~= nil) and (srv.connections[t.ucid].admin > 0)) then
			if (said == config.LFS.prefix.."restart") then
				luaLFS:mst("/restart")
			elseif (said == config.LFS.prefix.."qualify") then
				luaLFS:mst("/qualify")
			elseif (said == config.LFS.prefix.."quit") then
				luaLFS_quit()
			elseif (said == config.LFS.prefix.."rehash") then
				luaLFS_rehash()
			end
		end
	else
		luaLFS:mtc(t.ucid, 0, "Magic words isn't designed for DEMO mode. Sorry.")
	end
end


function undercontrol_byebye(imsg)
	local o = luaLFS:iii(imsg)
	if ((srv.connections[o.ucid] ~= nil) and (srv.connections[o.ucid].admin > 0)) then
		if (o.msg == config.LFS.prefix.."quit") then
			luaLFS:mst("luaLFS leaving.")
			luaLFS_quit()
		elseif (o.msg == config.LFS.prefix.."rehash") then
			luaLFS:mst("luaLFS rehashing.")
			luaLFS_rehash()
		end
	end
end

function undercontrol_playerjoins(imsg)
	local o = luaLFS:npl(imsg)
	local k, v
	i = 0
	for k, v in pairs(config.undercontrol.racers) do
		if (srv.connections[o.ucid].uname == v) then
			i = 1
		end
	end
print(i)
	if ((i ~= 1) and (srv.connections[o.ucid].admin ~= 1)) then
		luaLFS:mst("/spectate "..o.pname)
		luaLFS:mtc(o.ucid, 0, config.undercontrol.deniedmsg)
	end
end

evt_bind(ISP_III, undercontrol_byebye)

evt_bind(EVT_CONNECTED, undercontrol_init)

evt_bind(ISP_NCN, undercontrol_newconn)
evt_bind(ISP_CNL, undercontrol_connleave)

evt_bind(ISP_MSO, undercontrol_magicwords)

evt_bind(ISP_NPL, undercontrol_playerjoins)
