VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RayOK's VB6 OutSim Example! (edited by Bob Smith)"
   ClientHeight    =   4800
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   6735
   BeginProperty Font 
      Name            =   "Tahoma"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   320
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   449
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtLongAcceleration 
      Height          =   285
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   33
      Top             =   3480
      Width           =   1575
   End
   Begin VB.TextBox txtLatAcceleration 
      Height          =   285
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   32
      Top             =   3480
      Width           =   1575
   End
   Begin VB.TextBox txtSpeed 
      Height          =   285
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   31
      Top             =   3120
      Width           =   1575
   End
   Begin VBOutSimExample.okSocket OutSimSocket 
      Left            =   3360
      Top             =   3960
      _ExtentX        =   450
      _ExtentY        =   450
      Protocol        =   17
   End
   Begin VB.TextBox txtPort 
      Height          =   285
      Left            =   5040
      MaxLength       =   5
      TabIndex        =   1
      Top             =   3930
      Width           =   855
   End
   Begin VB.TextBox txtGameID 
      Height          =   285
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   18
      Top             =   120
      Width           =   1575
   End
   Begin VB.TextBox txtPosition 
      Height          =   285
      Index           =   2
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   17
      Top             =   1560
      Width           =   1575
   End
   Begin VB.TextBox txtPosition 
      Height          =   285
      Index           =   1
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   16
      Top             =   1560
      Width           =   1575
   End
   Begin VB.TextBox txtPosition 
      Height          =   285
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   15
      Top             =   1560
      Width           =   1575
   End
   Begin VB.TextBox txtVelocity 
      Height          =   285
      Index           =   2
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   14
      Top             =   1920
      Width           =   1575
   End
   Begin VB.TextBox txtVelocity 
      Height          =   285
      Index           =   1
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   13
      Top             =   1920
      Width           =   1575
   End
   Begin VB.TextBox txtVelocity 
      Height          =   285
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   12
      Top             =   1920
      Width           =   1575
   End
   Begin VB.TextBox txtAcceleration 
      Height          =   285
      Index           =   2
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   11
      Top             =   2280
      Width           =   1575
   End
   Begin VB.TextBox txtAcceleration 
      Height          =   285
      Index           =   1
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   10
      Top             =   2280
      Width           =   1575
   End
   Begin VB.TextBox txtAcceleration 
      Height          =   285
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   9
      Top             =   2280
      Width           =   1575
   End
   Begin VB.TextBox txtOrientation 
      Height          =   285
      Index           =   2
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   8
      Top             =   840
      Width           =   1575
   End
   Begin VB.TextBox txtOrientation 
      Height          =   285
      Index           =   1
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   7
      Top             =   840
      Width           =   1575
   End
   Begin VB.TextBox txtOrientation 
      Height          =   285
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   6
      Top             =   840
      Width           =   1575
   End
   Begin VB.TextBox txtTime 
      Height          =   285
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   2
      Top             =   120
      Width           =   1575
   End
   Begin VB.TextBox txtAVelocity 
      Height          =   285
      Index           =   2
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   5
      Top             =   2640
      Width           =   1575
   End
   Begin VB.TextBox txtAVelocity 
      Height          =   285
      Index           =   1
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   4
      Top             =   2640
      Width           =   1575
   End
   Begin VB.TextBox txtAVelocity 
      Height          =   285
      Index           =   0
      Left            =   1680
      Locked          =   -1  'True
      TabIndex        =   3
      Top             =   2640
      Width           =   1575
   End
   Begin VBOutSimExample.ucStatusbar StatusBar 
      Height          =   255
      Left            =   0
      Top             =   4440
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   450
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Turn On"
      Enabled         =   0   'False
      Height          =   285
      Left            =   1680
      TabIndex        =   0
      Top             =   3960
      Width           =   1575
   End
   Begin VB.Label Label16 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Longitundinal Acc.:"
      Height          =   255
      Left            =   3480
      TabIndex        =   38
      Top             =   3480
      Width           =   1455
   End
   Begin VB.Label Label15 
      BackStyle       =   0  'Transparent
      Caption         =   "Body Roll"
      Height          =   255
      Left            =   5040
      TabIndex        =   37
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label14 
      BackStyle       =   0  'Transparent
      Caption         =   "Body Pitch"
      Height          =   255
      Left            =   3360
      TabIndex        =   36
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label13 
      BackStyle       =   0  'Transparent
      Caption         =   "Heading"
      Height          =   255
      Left            =   1680
      TabIndex        =   35
      Top             =   600
      Width           =   1455
   End
   Begin VB.Label Label12 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Time:"
      Height          =   255
      Left            =   120
      TabIndex        =   34
      Top             =   120
      Width           =   1455
   End
   Begin VB.Line Line1 
      X1              =   112
      X2              =   440
      Y1              =   200
      Y2              =   200
   End
   Begin VB.Label Label11 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Speed:"
      Height          =   255
      Left            =   120
      TabIndex        =   30
      Top             =   3120
      Width           =   1455
   End
   Begin VB.Label Label10 
      BackStyle       =   0  'Transparent
      Caption         =   "Horizontal (X)"
      Height          =   255
      Left            =   1680
      TabIndex        =   29
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label9 
      BackStyle       =   0  'Transparent
      Caption         =   "Horizontal (Y)"
      Height          =   255
      Left            =   3360
      TabIndex        =   28
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label Label8 
      BackStyle       =   0  'Transparent
      Caption         =   "Vertical (Z)"
      Height          =   255
      Left            =   5040
      TabIndex        =   27
      Top             =   1320
      Width           =   1455
   End
   Begin VB.Label lblPort 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Receive Port:"
      Height          =   255
      Left            =   3840
      TabIndex        =   26
      Top             =   4005
      Width           =   1095
   End
   Begin VB.Label Label7 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Game ID:"
      Height          =   255
      Left            =   3480
      TabIndex        =   25
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label Label6 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Position:"
      Height          =   255
      Left            =   120
      TabIndex        =   24
      Top             =   1560
      Width           =   1455
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Velocity:"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      Top             =   1920
      Width           =   1455
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Acceleration:"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      Top             =   2280
      Width           =   1455
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Orientation:"
      Height          =   255
      Left            =   120
      TabIndex        =   21
      Top             =   840
      Width           =   1455
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Angular Velocity:"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   2640
      Width           =   1455
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Lateral Acc.:"
      Height          =   255
      Left            =   120
      TabIndex        =   19
      Top             =   3480
      Width           =   1455
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Option Explicit

'My first OutSim attempt! It outputs to the form of course, but after that I have no
'idea what to do with the values. I'm not even sure if the values are correct! :P
'C++ to VB6 data types is sometimes a mystery to me. Everything in VB6, except bytes, are
'signed! A little reading said that floats are singles in VB6. For the unsigned ints, a
'conversion to an 8-byte currency (to avoid overflow errors) then multiply by its place in
'the integer. Signed ints are just longs in VB6 (each 4 bytes). Seems to work alright.

'                                                               - RayOK (needs to sleep)

Private lngOutSimServer As Long      'listen for LFS on this socket with the receive port
Private timeMinutes As Integer
Private timeSeconds As Single

Private Type OutSim
'   unsigned int         :time in milliseconds (to check order)
    bytTime(0 To 3) As Byte
'   Angular Velocity     :3 floats
    sngAVelocity0 As Single
    sngAVelocity1 As Single
    sngAVelocity2 As Single
'   Orientation          :3 floats Heading, Pitch, Roll
    sngOrientation0 As Single
    sngOrientation1 As Single
    sngOrientation2 As Single
'   Acceleration         :3 floats X, Y, Z
    sngAcceleration0 As Single
    sngAcceleration1 As Single
    sngAcceleration2 As Single
'   Velocity             :3 floats X, Y, Z
    sngVelocity0 As Single
    sngVelocity1 As Single
    sngVelocity2 As Single
'   Position             :3 ints X, Y, Z (metres x 65536)
    bytPosition0(0 To 3) As Byte
    bytPosition1(0 To 3) As Byte
    bytPosition2(0 To 3) As Byte
'   Game ID              :1 int (optional ID - if specified in cfg.txt)
    lngGameID As Long
End Type
'Note 1 : X and Y axes are on the ground, Z is up.
Private udtOutSim As OutSim

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)

Private Sub Form_Load()
    Dim ctl As Control
    
    'flatter controls :)
    For Each ctl In Me.Controls
        If TypeName(ctl) = "TextBox" Or TypeName(ctl) = "CommandButton" Then MakeFlat ctl.hWnd
    Next
    
    'setup the status bar, a Charles P.V. user-control. found here:
    'http://www.pscode.com/vb/scripts/ShowCode.asp?txtCodeId=56837&lngWId=1
    StatusBar.Initialize False, True
    StatusBar.AddPanel sbNormal, , , sbSpring, "It might work!"
End Sub

'only enable connect if we have a port to listen to!
Private Sub txtPort_Change()
    cmdConnect.Enabled = Len(txtPort.Text) > 0
End Sub

'only numbers
Private Sub txtPort_KeyPress(KeyAscii As Integer)
    If KeyAscii = 8 Or KeyAscii >= 48 And KeyAscii <= 57 Then
        'its backspace or a number, don't change it
    Else
        KeyAscii = 0
    End If
End Sub

Private Sub cmdConnect_Click()
    'depending on the caption either connect, cancel or disconnect
    If cmdConnect.Caption = "Turn On" Then
        lngOutSimServer = OutSimSocket.ListenTo(CLng(txtPort.Text))
        If lngOutSimServer Then    'connected to sockets, send INI packet
            cmdConnect.Caption = "Turn Off"
        Else
            StatusBar.PanelText(1) = "Could not listen on socket!"
        End If
    ElseIf cmdConnect.Caption = "Turn Off" Then
        Call OutSimSocket.CloseIt(lngOutSimServer)
        cmdConnect.Caption = "Turn On"
    End If
End Sub

Private Sub OutSimSocket_ReceivedBytes(lngSocket As Long, bytData As Variant, lngLength As Long)
On Error GoTo OutSimErr
    Dim i As Integer, bytRecvData() As Byte

    If lngSocket = lngOutSimServer Then
        ReDim bytRecvData(lngLength)
  
        'copy the returned array so we can manipulate it
        For i = 0 To lngLength
              bytRecvData(i) = bytData(i)
        Next
        CopyMemory udtOutSim, bytRecvData(0), LenB(udtOutSim)

        'if you know of a better way to implement
        With udtOutSim
            timeSeconds = (CStr(CCur(.bytTime(0)) + (CCur(.bytTime(1)) * 256) + (CCur(.bytTime(2)) * 65536) + (CCur(.bytTime(3)) * 16777216)) / 1000) - (timeMinutes * 60)
            If timeSeconds >= 60 Then
                timeSeconds = timeSeconds - 60
                timeMinutes = timeMinutes + 1
            ElseIf timeSeconds < 0 Then
                timeSeconds = timeSeconds + 60
                timeMinutes = timeMinutes - 1
            End If
            txtTime.Text = timeMinutes & " m " & Round(timeSeconds, 2) & " s"
            txtGameID.Text = CStr(.lngGameID)
            txtOrientation(0).Text = Round(CStr(.sngOrientation0) * 180 / 3.14159, 2) & " degrees"
            txtOrientation(1).Text = Round(CStr(.sngOrientation1) * 180 / 3.14159, 2) & " degrees"
            txtOrientation(2).Text = Round(CStr(.sngOrientation2) * 180 / 3.14159, 2) & " degrees"
            txtPosition(0).Text = Round((CStr(CCur(.bytPosition0(0)) + (CCur(.bytPosition0(1)) * 256) + (CCur(.bytPosition0(2)) * 65536) + (CCur(.bytPosition0(3)) * 16777216))) / 65536, 2) & " ?"
            txtPosition(1).Text = Round((CStr(CCur(.bytPosition1(0)) + (CCur(.bytPosition1(1)) * 256) + (CCur(.bytPosition1(2)) * 65536) + (CCur(.bytPosition1(3)) * 16777216))) / 65536, 2) & " ?"
            txtPosition(2).Text = Round((CStr(CCur(.bytPosition2(0)) + (CCur(.bytPosition2(1)) * 256) + (CCur(.bytPosition2(2)) * 65536) + (CCur(.bytPosition2(3)) * 16777216))) / 65536, 2) & " ?"
            txtVelocity(0).Text = Round(CStr(.sngVelocity0), 2) & " m/s"
            txtVelocity(1).Text = Round(CStr(.sngVelocity1), 2) & " m/s"
            txtVelocity(2).Text = Round(CStr(.sngVelocity2), 2) & " m/s"
            txtAcceleration(0).Text = Round(CStr(.sngAcceleration0) / 9.81, 2) & " g"
            txtAcceleration(1).Text = Round(CStr(.sngAcceleration1) / 9.81, 2) & " g"
            txtAcceleration(2).Text = Round(CStr(.sngAcceleration2) / 9.81, 2) & " g"
            txtAVelocity(0).Text = Round(CStr(.sngAVelocity0), 3)
            txtAVelocity(1).Text = Round(CStr(.sngAVelocity1), 3)
            txtAVelocity(2).Text = Round(CStr(.sngAVelocity2), 3)
            txtSpeed.Text = Round((CStr(.sngVelocity0) ^ 2 + CStr(.sngVelocity1) ^ 2 + CStr(.sngVelocity2) ^ 2) ^ 0.5 * 3.6 / 1.609344, 2) & " mph"
            txtLatAcceleration.Text = Round((Cos(.sngOrientation0) * .sngAcceleration0 + Sin(.sngOrientation0) * .sngAcceleration1) / 9.81, 2) & " g"
            txtLongAcceleration.Text = Round((-Sin(.sngOrientation0) * .sngAcceleration0 + Cos(.sngOrientation0) * .sngAcceleration1) / 9.81, 2) & " g"
        End With
    End If
    
    Exit Sub
OutSimErr:
    StatusBar.PanelText(1) = "ERROR! " & CStr(err.Number) & ": " & err.Description
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call OutSimSocket.CloseIt(lngOutSimServer)
End Sub
