DRAG = {}
DRAG.START = 0
DRAG.PLIDS = {}
DRAG.STARTLINE = 0

function drag_init(imsg)
	racer = {}
	luaLFS:small(0, SMALL_NLI, 50)
	luaLFS:tiny(1, TINY_NPL)
end
evt_bind(EVT_CONNECTED, drag_init)

function mci_drag(imsg)
	local mci = luaLFS:mci(imsg)

	if (DRAG.START == 0) and (table.maxn(DRAG.PLIDS)) then
		for i=1,table.maxn(DRAG.PLIDS) do
			-- coordinates of the area for starting line for XR@BL1
			local cross = vectors(10462997,28055764, 11288748,28279023, 11365833,27986862, 10560491,27771643, mci.compcar[DRAG.PLIDS[i]].x,mci.compcar[DRAG.PLIDS[i]].y)
			if (not(cross)) then
				DRAG.STARTLINE = 0
				luaLFS:bfn(0, 255,100+(i-1) , 0)
			elseif (cross) then
				DRAG.STARTLINE = 1
				luaLFS:btn(100+(i-1), 255, 100+(i-1), 0, 17, 0, 0, 90+i*10, 200, 10, racer[DRAG.PLIDS[i]].." ^9^cross starting line")
			end
		end
	elseif (DRAG.START == 1) then
		for i=1,table.maxn(DRAG.PLIDS) do
			-- coordinates of the finish area for XR@BL1
			local cross = vectors(18379340,2221338, 17468965,1976709, 17309117,2608274, 18208925,2855925, mci.compcar[DRAG.PLIDS[i]].x,mci.compcar[DRAG.PLIDS[i]].y)
			if (cross) then
				local plid = DRAG.PLIDS[i]
				DRAG.PLIDS = {}
				DRAG.START = 0
				info("^1Winner^9 "..racer[plid], 8)
			end
		end
	end
end
evt_bind(ISP_MCI, mci_drag)

function racers(imsg)
	local npl = luaLFS:npl(imsg)
	racer[npl.plid] = npl.pname
end
evt_bind(ISP_NPL, racers)

-- If someone leave, changes the name or moves over to spectators update the base a racer on route.
evt_bind(ISP_CNL, drag_init)
evt_bind(ISP_CPR, drag_init)
evt_bind(ISP_PLL, drag_init)
