/// Created by Gutholz 2014
///
/// Version 1.1 by Marek "Lagger" Laszlo 2018
///
/// Main thread:
/// https://www.lfs.net/forum/thread/86722-SVG-to-Layout%3A-autocross-layouts-from-pictures-or-drawings


//inkscape: Menu Erweiterungen, Streuung = Rechtecke entlang eines Pfades verteilen

/*
Layout labels:
https://www.lfs.net/programmer/lyt

LFS Track images:
https://www.lfs.net/forum/post/676857


http://stackoverflow.com/questions/13329125/removing-transforms-in-svg-files
http://stackoverflow.com/questions/14684846/flattening-svg-matrix-transforms-in-inkscape

===> !! LEAVE GROUPING !! <===

*/

#include <iostream>
#include <iostream>
#include <fstream>
#include "pthread.h"
#include "CInsim.h"
#include <string>
#include <string.h>
#include <stdlib.h> //atof
#include <cmath>
#include <sstream>
#include <stdexcept>
#include <algorithm>



#define AXO_CHALK_LINE 4
#define AXO_CHALK_LINE2 5
#define AXO_CHALK_AHEAD 6
#define AXO_CHALK_AHEAD2 7
#define AXO_CHALK_LEFT 8
#define AXO_CHALK_LEFT2 9
#define AXO_CHALK_LEFT3 10
#define AXO_CHALK_RIGHT 11
#define AXO_CHALK_RIGHT2 12
#define AXO_CHALK_RIGHT3 13

#define AXO_CONE_RED 20
#define AXO_CONE_RED2 21
#define AXO_CONE_RED3 22
#define AXO_CONE_BLUE 23
#define AXO_CONE_BLUE2 24
#define AXO_CONE_GREEN 25
#define AXO_CONE_GREEN2 26
#define AXO_CONE_ORANGE 27
#define AXO_CONE_WHITE 28
#define AXO_CONE_YELLOW 29
#define AXO_CONE_YELLOW2 30

#define AXO_CONE_PTR_RED 40
#define AXO_CONE_PTR_BLUE 41
#define AXO_CONE_PTR_GREEN 42
#define AXO_CONE_PTR_YELLOW 43

#define AXO_TYRE_SINGLE 48
#define AXO_TYRE_STACK2 49
#define AXO_TYRE_STACK3 50
#define AXO_TYRE_STACK4 51
#define AXO_TYRE_SINGLE_BIG 52
#define AXO_TYRE_STACK2_BIG 53
#define AXO_TYRE_STACK3_BIG 54
#define AXO_TYRE_STACK4_BIG 55

#define AXO_ARMCO1 96
#define AXO_ARMCO3 97
#define AXO_ARMCO5 98

#define AXO_BARRIER_LONG 104
#define AXO_BARRIER_RED 105
#define AXO_BARRIER_WHITE 106

#define AXO_RAMP1 120
#define AXO_RAMP2 121

#define AXO_POST_GREEN 136
#define AXO_POST_ORANGE 137
#define AXO_POST_RED 138
#define AXO_POST_WHITE 139

#define AXO_BALE 144

#define AXO_RAILING 148
#define AXO_START_LIGHTS 149

#define AXO_TYRE_SINGLE 48
#define AXO_TYRE_STACK4_BIG 55

#define PI 3.141593

using namespace std;
CInsim insim;
int readSVG();
float valueFromString (string s, string keyString);
void putByConsole();

/*
struct ObjectInfo // Info about a single object - explained in the layout file format
{
	short	X;
	short	Y;
	char	Zchar;
	byte	Flags;
	byte	Index;
	byte	Heading;
};

struct IS_AXM // AutoX Multiple objects - variable size
{
	byte	Size;		// 8 + NumO * 8
	byte	Type;		// ISP_AXM
	byte	ReqI;		// 0
	byte	NumO;		// number of objects in this packet

	byte	UCID;		// unique id of the connection that sent the packet
	byte	PMOAction;	// see below
	byte	PMOFlags;	// see below
	byte	Sp3;

	ObjectInfo	Info[30];	// info about each object, 0 to 30 of these
};*/

// Bad global definition for a trransformation data used in SVG
typedef struct
{
    float translation[2];
    float matrix[3][2];
    float rotation;
} TRANSFORM_Tag;

int putAXObject (byte index, short x, short y, short heading)
{
    struct ObjectInfo newObject;
    newObject.Y = y;
    newObject.X = x;
    newObject.Heading = heading;
    newObject.Zchar = 127;
    newObject.Index = index;
    newObject.Flags = 0;

    struct IS_AXM axm_packet;
    memset(&axm_packet, 0, sizeof(struct IS_AXM));
    axm_packet.Size=8+8;
    axm_packet.Type=ISP_AXM;
    axm_packet.ReqI=0;
    axm_packet.NumO=1;
    axm_packet.UCID=0;
    axm_packet.PMOAction=PMO_ADD_OBJECTS;
    axm_packet.PMOFlags=0;
    axm_packet.Sp3=0;
    axm_packet.Info[0] = newObject;

    insim.send_packet(&axm_packet);

    //cout << "  axm check: "<<axm_packet.Info[0].X<<":"<<axm_packet.Info[0].Y<<endl;
}

void state_message ()
{
    struct IS_STA* statePacket = (struct IS_STA*)insim.get_packet(); //packet abholen
    word Flags = statePacket->Flags;
    float ReplaySpeed = statePacket->ReplaySpeed;

    cout << "Flags:" << Flags <<endl;
    cout << "ReplaySpeed:" << ReplaySpeed <<endl;

    if (Flags & ISS_PAUSED)
    {
        cout << "paused!" << endl;
    }
}

void text_message ()
{
    struct IS_MSO* textPacket = (struct IS_MSO*)insim.get_packet(); //packet abholen
    byte UserType = textPacket->UserType;

    // NOTE : Typing "/o MESSAGE" into LFS will send an IS_MSO with UserType = MSO_O
    if (UserType == MSO_O)
    {
        char *msg;
        msg = textPacket->Msg; //[128]
        cout<<"IS_MSO textmessage:" <<msg<<endl;
        if (strcmp (msg, "m")==0)
        {
            putByConsole();
        }
        if (strcmp (msg, "svg")==0)
        {
            readSVG();
        }
    }
}


void object_message ()
{
    struct IS_AXM * objectpacket = (struct IS_AXM*)insim.get_packet();
    byte bNumO = objectpacket->NumO;
    int ReqI = (int) objectpacket->ReqI;
    int NumO = (int) bNumO;

    cout << "objects:" <<  NumO;
    cout << "ReqI:" << ReqI;

    ObjectInfo *info;
    info = objectpacket->Info;
    for (int i=0; i < NumO; i++)
    {
        byte bheading = info[i].Heading;
        int heading = (360*(((float)bheading)+0.5f)/256.0f)-180; //

        cout <<"RECV:"<<"  x="<< info[i].X << "  y=" << info[i].Y <<"  heading="<<heading<<endl;
        //putAXObject (AXO_CHALK_AHEAD, info[i].X, info[i].Y+20);
    }


}



int main(int argc, char* argv[])
{
    int retVal = 0;
    struct IS_VER verPack;	//LFS can tell us info about it's version and InSim version, store that info in this struct.
    //Try to connect to LFS
    retVal = insim.init("127.0.0.1",	//LFS will run on local machine
              (word)29999,	//InSim will accept connection on port 29999
              "SVG-to-Layout started!",	//Short name for our app, will appear in LFS
              "",		//No admin password
              &verPack,		//Pointer to IS_VERSION packet
              '!',		//InSim command character
            //what kind of packets to recieve:
//              ISF_MCI,  //multi car information (positions, speed)
              //ISF_MSO, //message out from lfs (text chat) gibts nicht?
              //ISF_CON+ //player (dis) connecting
              //ISF_OBH+  //autocross object hit
              ISF_AXM_LOAD+ISF_AXM_EDIT, //autocross loaded
              //ISP_LAP,
              //ISF_PIT,
  //            ISP_LAP+  //lap times
  //            ISP_SPX,  //split times
              75,		//Receive updates every x msecs
              0);		//No UDP today

    //Could we connect to LFS?
    if(retVal < 0) //We could not
    {
        //Tell the user and exit
        cout << "Error connecting to LFS!\r\n" << endl;
        cout << "Have you run /insim 2999 command in LFS?" << endl;
        Sleep(1000);
        return -555;
    }
    //All OK, report version of LFS and InSim.
    cout << "Its happening! Connected to LFS " << verPack.Version << ", InSim ver. " << verPack.InSimVer<< endl;
    cout << "\r\nVersion 1.1 - Tested with LFS0.6R and Inkscape 0.92.3" << endl;
    cout << "Accurate as never before and with support of objects heading.\r\n" << endl;

    cout << "TIPs: -Be sure to have your image of size 2560x2560 pixels" << endl;
    cout << "      -For rectangle object labels use www.lfs.net/programmer/lyt" << endl;
    cout << "      -Place rectangles on layer with 0,0 position (be careful with accidental layer switch). "<< endl;
    cout << "      -Do not move center of rotation of rectangles. "<< endl;
    cout << "      -Do not transform rectangle except for rotation." << endl;
    cout << "      -Name your layout as layout.svg and save it in project folder (where executable is located)." << endl;
    cout << "      -Read .svg or edit .xml to check if rectangles are in correct layer and with only 1 rotate / matrix attribute."<< endl;
    cout << "\r\nWaiting for textmessage in LFS: /o svg \r\n"<< endl;


    //addButton ("Place Camera", 1);
    while (true)
    {
        int errorReturn = insim.next_packet();  //get next packet in queue

        if(errorReturn < 0)	//Something went wrong
        {
            cout<<"insim.next_packet() failed:" << errorReturn<< endl;
            return -666;
        }

        int packetType = insim.peek_packet();   //what type of packet is it? (this just tells the type but does not actuelly get the package)
        //    cout<<packetType<<endl;



        if (packetType == ISP_STA) //status (track name, amount of laps)
        {
            cout<<"IS_STA (state)"<<endl;
            state_message ();
        }
        if (packetType == ISP_MSO)
        {
            text_message ();
        }
        if (packetType == ISP_AXM)
        {
            cout<<"AUTOCROSS!"<<endl;
            object_message();
        }
    }
    return 0;

}


void putByConsole ()
{
    int ax;
    int ay;
    int aheading;

    cin >> ax;
    cin >> ay;
    cin >> aheading;

    putAXObject (AXO_CHALK_AHEAD, ax, ay, aheading);
}



//----------SVG reader
//FIXME: end of the string should be recognized correctly:
// x="17697.873" - works
// x="17697.873" /> - works, but only because atof throws the stuff out
float valueFromString (string s, string keyString)
{
    int startN=s.find(keyString) + keyString.length(); // Start of value data
    int endN=s.length()-startN-1; // Data end
    string N = s.substr (startN,endN);
    float number = atof (N.c_str()); //double to int
    //cout << "*Value="<<number<<endl;
    return number;
}

// Works only for transform (rotation or matrix)
int getTransformMatrix (string s, TRANSFORM_Tag *trans)
{
    int i1=0, i2=-1;

    if(s.find("translate")!=  string::npos) // Parse translation data
    {
        cout << " Translation is unsupported" <<endl;
    }
    else if(s.find("matrix") !=  string::npos) // Parse svg matrix data
    {
        std::string token;
        size_t pos = 0;

        std::string delimiter = "("; // erase everything before data
        // Delete matrix string
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
        }
        s.erase(0, pos + delimiter.length());

        delimiter = ",";
        // Parse the matrix values
        while ((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
            //std::cout << token << std::endl;
            s.erase(0, pos + delimiter.length());
            if(++i2>1)
            {
                i2=0;
                i1++;
            }
            trans->matrix[i1][i2] = ::atof(token.c_str());
        }

        delimiter = ")";
        // Parse the last matrix value separatedly using different delimiter
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
            trans->matrix[2][1] = ::atof(token.c_str());
            //std::cout << token << std::endl;
        }


        //trans->rotation = std::atan2(trans->matrix[1][0],trans->matrix[0][0]) * 180/PI;
        trans->rotation = std::atan2(trans->matrix[0][1],trans->matrix[0][0]);

        cout << " * Rotational matrix[ "<<trans->matrix[0][0]<<", "<<trans->matrix[0][1]<<"; "<<trans->matrix[1][0]<<", "<<trans->matrix[1][1]<<"]"<<endl;
        std::cout << " * Rotation: " << trans->rotation * 180/PI << std::endl;

        return 0;
    }
    else if(s.find("rotate") !=  string::npos)  // Parse rotation data
    {
        std::string token;
        size_t pos = 0;

        std::string delimiter = "("; // erase everything before data
        // delete rotation string before the number
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
        }
        s.erase(0, pos + delimiter.length());

        delimiter = ")";
        // Parse the rotation number
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
            //std::cout << token << std::endl;
        }
        trans->rotation = ::atof(token.c_str()) * PI/180;

        //Calculate rotational matrix (used for SVG coordinates transformation)
        trans->matrix[0][0] = std::cos(trans->rotation);
        trans->matrix[0][1] = std::sin(trans->rotation);
        trans->matrix[1][0] = -std::sin(trans->rotation);
        trans->matrix[1][1] = std::cos(trans->rotation);
        trans->matrix[2][0] = 0;
        trans->matrix[2][1] = 0;

        std::cout << " * Rotation: " << trans->rotation* 180/PI << std::endl;
        cout << " * Rotational matrix[ "<<trans->matrix[0][0]<<", "<<trans->matrix[0][1]<<"; "<<trans->matrix[1][0]<<", "<<trans->matrix[1][1]<<"]"<<endl;

        return 0;
    }
    else if(s.find("scale") !=  string::npos) // Special type of rotation that can happen is scale -1
    {
        std::string token;
        size_t pos = 0;

        std::string delimiter = "("; // erase everything before data
        // delete scale string before the number
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
        }
        s.erase(0, pos + delimiter.length());

        delimiter = ")";
        // Parse the scale number
        if((pos = s.find(delimiter)) != std::string::npos)
        {
            token = s.substr(0, pos);
            //std::cout << token << std::endl;
        }
        if(!token.compare("-1"))
        {
            trans->rotation = PI;
        }

        //Calculate rotational matrix (used for SVG coordinates transformation)
        trans->matrix[0][0] = std::cos(trans->rotation);
        trans->matrix[0][1] = std::sin(trans->rotation);
        trans->matrix[1][0] = -std::sin(trans->rotation);
        trans->matrix[1][1] = std::cos(trans->rotation);
        trans->matrix[2][0] = 0;
        trans->matrix[2][1] = 0;

        std::cout << " * Rotation: " << trans->rotation* 180/PI << std::endl;
        cout << " * Rotational matrix[ "<<trans->matrix[0][0]<<", "<<trans->matrix[0][1]<<"; "<<trans->matrix[1][0]<<", "<<trans->matrix[1][1]<<"]"<<endl;

        return 0;
    }

    return -1;
}

int placedN=0;

int readSVG(void)
{
    string line;
    string FILEname = "layout.svg";
    ifstream SVGfile (FILEname);
    if (!SVGfile.is_open())
    {
        cout << "Could not open file." << endl;
        return 1;
    }
    else { cout << "\r\nReading: "<<FILEname<<" file.\r\n" << endl; }

    //what the interessting lines start with yo
    string idStringKey = "id=\"";
    string xStringKey = "x=\"";
    string yStringKey = "y=\"";
    string heightKey = "width=\"";
    string widthKey = "height=\"";
    string objectTypeKey = "inkscape:label=\""; //Identifier in Inkscape's object properties
    string transformKey = "transform=\"";
    int counts = 0;
    int rect = 0;
    int senddata = 0;
    float x=-1;
    float y=-1;
    float u=-1; // width
    float v=-1; // height
    int heading_flag = -1;
    int objectType = -1; //FIXME: objectType should be optional
    TRANSFORM_Tag trans;

    while ( getline (SVGfile,line) ) // Go throught whole svg
    {
        //cout << line << '\n'; // Too much text output
        if (line.find("<rect") !=  string::npos)
        {
            rect = 1; //within rectangle section
            counts += 1;
            cout << "** Rectangle tag found. Expecting x,y coordinates and its transformation" << endl;
            //cout << counts;
            //Reset variables
            x=-1;
            y=-1;
            u=-1; // width
            v=-1; // height
            heading_flag = -1;
            objectType = -1; //FIXME: objectType should be optional
            trans = {};

        }
        if (line.find(idStringKey) !=  string::npos && rect == 1) { }
        if (line.find(objectTypeKey) !=  string::npos && rect == 1) { objectType = valueFromString (line, objectTypeKey); }
        if (line.find(xStringKey) !=  string::npos && rect == 1) { x = valueFromString (line, xStringKey); }
        if (line.find(yStringKey) !=  string::npos && rect == 1) { y = valueFromString (line, yStringKey); }
        if (line.find(heightKey) !=  string::npos && rect == 1) { v = valueFromString (line, heightKey); }
        //if (senddata == 1) {senddata = 2;} //Doesn't work, not sure why
        if (line.find(widthKey) !=  string::npos && rect == 1) { u = valueFromString (line, widthKey); senddata = 1;}
        if (line.find(transformKey) !=  string::npos && rect == 1) // If any transformation of rectangle is present process it
        {
            heading_flag = getTransformMatrix(line, &trans);
            senddata = 2; //FIXME: Data won't be sent unless object has a transform.
        }

        if (rect == 1 && senddata == 2)
        {  // If end is found in rectangle object
            rect = 0; //no longer within rectangle section
            senddata = 0;

            if(objectType == -1)
            {
                cout<<" * Undefined object type (label)"<<endl;
            }
            if(x == -1 || y == -1)
            {
                cout<<" * Problem with svg coordinates"<<endl;
            }
            if(x != -1 && y != -1 && objectType != -1) // Place the object if we have correct coordinates
            {

                if(heading_flag == -1)
                {
                        cout<<" * No rotation defined - using default rotation"<<endl;

                        trans.rotation=0;

                        trans.matrix[0][0] = 1;
                        trans.matrix[0][1] = 0;
                        trans.matrix[1][0] = 0;
                        trans.matrix[1][1] = 1;
                        trans.matrix[2][1] = 0;
                        trans.matrix[2][1] = 0;
                }

                // Calculate SVG rotation coordinates system
                //Matrix calculation rotmat'*(pos+[width/2;height/2])

                float x_c1 = x+v/2; // Get object center
                float y_c1 = y+u/2; // get object center

                //cout<<"  x_c: "<<x_c1<<"   y_c: "<<y_c1<<endl;

                // Inverse rotational matrix position multiply (SVG -> LFS layout coordinates)
                float x_c2 = trans.matrix[0][0] * x_c1 + trans.matrix[1][0] * y_c1;
                float y_c2 = trans.matrix[0][1] * x_c1 + trans.matrix[1][1] * y_c1;

                //cout<<"  x_c: "<<x_c2<<"   y_c: "<<y_c2<<endl;

                // Calculate to LFS coordinate system
                short x_lfs = (x_c2-1280.0) * 16.0; // Calculate in layouts coordinate system and units
                short y_lfs = (1280.0-y_c2) * 16.0; // Calculate in layouts coordinate system and units
                short heading_lfs = -(((trans.rotation+PI)/PI)/2.0)*256.0-0.5f; // Heading in lfs Heading = (heading_in_degrees + 180) * 256 / 360

                cout << " * Placed object: "<<objectType<<"  lyt pos x: "<<x_lfs<<" y: "<<y_lfs<< " heading: "<<heading_lfs<<endl;
                putAXObject (objectType, x_lfs, y_lfs, heading_lfs);
                //putAXObject (42, x_lfs, y_lfs, heading_lfs);
                placedN++;
            }

        }
        //linelock = 0; //after one loop, allow looking for end of rectangle
    }
    cout<<"Placed : "<<placedN<<" Objects\r\n\r\n"<<endl;
    placedN = 0;

    SVGfile.close();

    return 0;
}
