-- TYPES : (all multi-byte types are PC style - lowest byte first)
-- ===============================================================
-- char(1)	- A
-- byte(1)	- b
-- word(2)	- H
-- short(2)	- h
-- unsigned(4)	- L
-- int(4)	- l
-- float(4)	- f
-- string	- z


luaLFS_VERSION_API = "0.1X10"

print("Loading API v"..luaLFS_VERSION_API)

luaLFSapi = {}
luaLFSapi.__index = luaLFSapi

function luaLFSapi.create()
	l = {}
	setmetatable(l, luaLFSapi)
	l.versions = { api = luaLFS_VERSION_API, insim = 0, lfs = nil, product = nil, }
	return l
end

function luaLFSapi:version()
	return self.versions
end

--- Misc
-- IS_TINY
function luaLFSapi:tiny(reqi, subt)
	local omsg = bpack("bbbb", 4, ISP_TINY, reqi, subt)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

-- IS_SMALL
function luaLFSapi:small(reqi, subt, uval)
	local omsg = bpack("bbbbL", 8, ISP_SMALL, reqi, subt, uval)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

-- Strip chars
-- ^L = Latin 1
-- ^G = Greek
-- ^C = Cyrillic
-- ^J = Japanese
-- ^E = Central Europe
-- ^T = Turkish
-- ^B = Baltic
-- ^0-9
function luaLFSapi:stripctrlchars(imsg)
	return string.gsub(imsg, "%^[%L%G%C%J%E%T%B%d]", "")
end

--- TO START COMMUNICATION 
--function luaLFSapi:isi(reqi, udpport, flags, prefix, interval, admin, iname)
--	local omsg = bpack("bbbbHHbbHA16A16", 44, ISP_ISI, reqi, 0, udpport, flags, 0, prefix, interval, admin, iname)
--	luaLFS_sendmsg(omsg, string.len(omsg))
--end

--- VERSION REQUEST
function luaLFSapi:ver(imsg)
	local n, psize, pty, reqi, zero, version, product, insimver = bunpack(imsg, "bbbbA8A6H")
	return { version = version, product = product, insimver = insimver }
end

--- STATE REPORTING AND REQUESTS
function luaLFSapi:sta(imsg)
	print("Parsing STA")
	local n, psize, pty, reqi, zero, replayspeed, flags, ingamecam, viewplid, nump, numconns, numfinished, raceinprog, qualmins, racelaps, spare2, spare3, track, weather, wind = bunpack(imsg, "bbbbfHbbbbbbbbbbA6bb")
	print("STA parsed")
	return { replayspeed = replayspeed, flags = flags, ingamecam = ingamecam, nump = nump, numconns = numconns, numfinished = numfinished, raceinprog = raceinprog, qualmins = qualmins, racelaps = racelaps, track = track, weather = weather, wind = wind }
end

function luaLFSapi:sfp(imsg)
end

--- SCREEN MODE
function luaLFSapi:mod(bits, rr, width, height)
	local omsg = bpack("bbbbllll", 20, ISP_MOD, 0, 0, bits, rr, width, height)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

--- TEXT MESSAGES AND KEY PRESSES
function luaLFSapi:mso(imsg)
	local n, psize, pty, reqi, zero, ucid, plid, usertype, textstart, msg = bunpack(imsg, "bbbbbbbbz")
	return { ucid = ucid, plid = plid, usertype = usertype, textstart = textstart, msg = msg }
end

function luaLFSapi:iii(imsg)
	local n, psize, pty, reqi, zero, ucid, plid, spare2, spare3, msg = bunpack(imsg, "bbbbbbbbz")
	return { ucid = ucid, plid = plid, msg = msg}
end

--- MESSAGES IN (TO LFS)
function luaLFSapi:mst(imsg)
	-- XXX: Add multi-packet support for msgs longer than 63 bytes (last byte is always \0)
	local omsg = bpack("bbbbz", 68, ISP_MST, 0, 0, imsg..string.rep("\0", 63 - string.len(imsg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:msx(imsg)
	local omsg = bpack("bbbbz", 100, ISP_MSX, 0, 0, imsg..string.rep("\0", 95 - string.len(imsg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:msl(imsg, sound)
	local omsg = bpack("bbbbz", 132, ISP_MSL, 0, sound, imsg..string.rep("\0", 127 - string.len(imsg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:mtc(ucid, plid, imsg)
	local omsg = bpack("bbbbbbbbz", 72, ISP_MTC, 0, 0, ucid, plid, 0, 0, imsg..string.rep("\0", 63 - string.len(imsg)))
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:sch(char, flags)
	local omsg = bpack("bbbbbbbb", 8, ISP_SCH, 0, 0, string.byte(char), flags, 0, 0)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

--- MULTIPLAYER NOTIFICATION
function luaLFSapi:ism(imsg)
	local n, psize, pty, reqi, zero, host, spare1, spare2, spare3, hname = bunpack(imsg, "bbbbbbbbz")
	return { host = host, hname = hname }
end

--- VOTE NOTIFY AND CANCEL
function luaLFSapi:vtn(imsg)
	local n, psize, pty, requ, zero, ucid, action, spare2, spare3 = bunpack(imsg, "bbbbbbbb")
	return { ucid = ucid, action = action }
end

-- Send a vote cancel
function luaLFSapi:vtc()
	-- UPDATED
	self:tiny(0, TINY_VTC)
end

-- Vote outcome
-- Subscribe to a IS_SMALL and it will return non-nil values if it was a completed vote action
function luaLFSapi:vta(imsg)
	-- UPDATED
	local n, psize, pty, reqi, subt, uval1 = bunpack(imsg, "bbbbL")
	print("Subt: "..subt)
	print("UVal: "..uval1.." "..SMALL_VTA)
	if (uval == SMALL_VTA) then
		print("It was a VTA!")
		return uval
	else
		return nil
	end
end

--- RACE TRACKING
function luaLFSapi:rst(imsg)
	local n, psize, pty, reqi, zero, racelaps, qualmins, nump, spare, track, weather, wind, flags, numnodes, finish, slit1, split2, split3 = bunpack(imsg, "bbbbbbbbA6bbHHHHHH")
	local n, track = bunpack(track, "z")
	return { racelaps = racelaps, qualmins = qualmins, nump = nump, track = track, weather = weather, wind = wind, flags = flags, numnodes = numnodes, finish = finish, split1 = slit1, split2 = split2, split3 = split3 }
end

function luaLFSapi:ncn(imsg)
	local n, psize, pty, reqi, ucid, uname, pname, admin, total, flags, spare3 = bunpack(imsg, "bbbbA24A24bbbb")
	local n, uname = bunpack(uname, "z")
	local n, pname = bunpack(pname, "z")
	return { ucid = ucid, uname = uname, pname = pname, admin = admin, total = total, flags = flags}
end

function luaLFSapi:cnl(imsg)
	local n, psize, pty, reqi, ucid, reason, total, spare2, spare3 = bunpack(imsg, "bbbbbbbb")
	return { ucid = ucid, reason = reason, total = total }
end

function luaLFSapi:cpr(imsg)
	print("Parsing CPR")
	local n, psize, pty, reqi, ucid, pname, plate = bunpack(imsg, "bbbbA24A8")
	local n, pname = bunpack(pname, "z")
	print("CPR parsed")
	return { ucid = ucid, pname = pname, plate = plate }
end

function luaLFSapi:npl(imsg)
	local n, psize, pty, reqi, plid, ucid, ptype, flags, pname, plate, cname, sname, tyres, h_mass, h_tres, model, pass, spare, sp0, nump, sp2, sp3 = bunpack(imsg, "bbbbbbHA24A8A4A16A4bbbblbbbb")
	local n, pname = bunpack(pname, "z")
	local n, cname = bunpack(cname, "z")
	local n, sname = bunpack(sname, "z")
	return { plid = plid, ucid = ucid, ptype = ptype, flags = flags, pname = pname, plate = plate, cname = cname, sname = sname, tyres = tyres, h_mass = h_mass, h_tres = h_tres, model = model, pass = pass, nump = nump }
end

function luaLFSapi:plp(imsg)
	local n, psize, pty, reqi, plid = bunpack(imsg, "bbbb")
	return { plid = plid }
end

function luaLFSapi:pll(imsg)
	local n, psize, pty, reqi, plid = bunpack(imsg, "bbbb")
	return { plid = plid }
end

function luaLFSapi:crs(imsg)
	print("Parsing CRS")
	local n, psize, pty, reqi, plid = bunpack(imsg, "bbbb")
	print("CRS parsed")
	return { plid = plid }
end

function luaLFSapi:lap(imsg)
	local n, psize, pty, reqi, plid, ltime, etime, lapsdone, flags, sp0, penalty, numstops, sp3 = bunpack(imsg, "bbbbLLHHbbbb")
	return { plid = plid, ltime = ltime, etime = etime, lapsdone = lapsdone, flags = flags, penalty = penalty, numstops = numstops }
end

function luaLFSapi:spx(imsg)
	local n, psize, pty, reqi, plid, stime, etime, split, penalty, numstops, sp3 = bunpack(imsg, "bbbbLLbbbb")
	return { plid = plid, stime = stime, etime = etime, split = split, penalty = penalty, numstops = numstops }
end

function luaLFSapi:pit(imsg)
	print("Parsing PIT")
	local n, psize, pty, reqi, plid, lapsdone, flags, sp0, penalty, numstops, sp3, tyres, work, spare = bunpack(imsg, "bbbbHHbbbbb4LL")
	print("PIT parsed")
	return { plid = plid, lapsdone = lapsdone, flags = flags, penalty = penalty, numstops == numstops, tyres = tyres, work = work }
end

function luaLFSapi:psf(imsg)
	print("Parsing PSF")
	local n, psize, pty, reqi, plid, stime, spare = bunpack(imsg, "bbbbLL")
	print("PSF parsed")
	return { plid = plid, stime = stime }
end

function luaLFSapi:pla(imsg)
	print("Parsing PLA")
	local n, psize, pty, reqi, plid, fact, sp1, sp2, sp3 = bunpack(imsg, "bbbbbbbb")
	print("PLA parsed")
	return { plid = plid, fact = fact }
end

function luaLFSapi:cch(imsg)
	print("Parsing CCH")
	local n, psize, pty, reqi, plid, camera, sp1, sp2, sp3 = bunpack(imsg, "bbbbbbbb")
	print("CCH parsed")
	return { plid = plid, camera = camera }
end

function luaLFSapi:pen(imsg)
	print("Parsing PEN")
	local n, psize, pty, reqi, plid, oldpen, newpen, reason, sp3 = bunpack(imsg, "bbbbbbbb")
	print("PEN parsed")
	return { plid = plid, oldpen = oldpen, newpen = newpen, reason = reason }
end

function luaLFSapi:toc(imsg)
	print("Parsing TOC")
	local n, psize, pty, reqi, plid, olducid, newucid, sp2, sp3 = bunpack(imsg, "bbbbbbbb")
	print("TOC parsed")
	return { plid = plid, olducid = olducid, newucid = newucid }
end

function luaLFSapi:flg(imsg)
	local n, psize, pty, reqi, plid, offon, flag, carbehind, sp3 = bunpack(imsg, "bbbbbbbb")
	return { plid = plid, offon = offon, flag = flag, carbehind = carbehind }
end

function luaLFSapi:pfl(imsg)
	print("Parsing PFL")
	local n, psize, pty, reqi, plid, flags, spare = bunpack(imsg, "bbbbHH")
	print("PFL parsed")
	return { plid = plid, flags = flags }
end

function luaLFSapi:fin(imsg)
	print("Parsing FIN")
	local n, psize, pty, reqi, plid, ttime, btime, spa, numstops, confirm, spb, lapsdone, flags = bunpack(imsg, "bbbbLLbbbbHH")
	print("FIN parsed")
	return { plid = plid, ttime = ttime, btime = btime, numstops = numstops, confirm = confirm, lapsdone = lapsdone, flags = flags }
end

function luaLFSapi:res(imsg)
	print("Parsing RES")
	local n, psize, pty, reqi, plid, uname, pname, plate, cname, ttime, btime, spa, numstops, confirm, spb, lapsdone, flags, resultnum, numres, pseconds = bunpack(imsg, "bbbbA24A24A8A4LLbbbbHHbbH")
	local n, uname = bunpack(uname, "z")
	local n, pname = bunpack(pname, "z")
	local n, cname = bunpack(cname, "z")
	print("RES parsed")
	return { plid = plid, uname = uname, pname = pname, plate = plate, cname = cname, ttime = ttime, btime = btime, numstops = numstops, confirm = confirm, lapsdone = lapsdone, flags = flags, resultnum = resultnum, numres = numres, pseconds = pseconds }
end

function luaLFSapi:reo(imsg)
	-- INCOMPLETE
	print("Parsing REO")
	local n, psize, pty, reqi, nump, plid = bunpack(imsg, "bbbbb32")
	print("REO parsed")
	return { nump = nump, plid = plid }
end

--- AUTOCROSS
function luaLFSapi:axi(imsg)
	print("Parsing AXI")
	local n, psize, pty, reqi, zero, axstart, numcp, numo, lname = bunpack(imsg, "bbbbbbHA32")
	local n, lname = bunpack(lname, "z")
	print("AXI parsed")
	return { axstart = axstart, numcp = numcp, numo = numo, lname = lname }
end

function luaLFSapi:axo(imsg)
	print("Parsing AXO")
	local n, psize, pty, reqi, plid = bunpack(imsg, "bbbb")
	print("AXO parsed")
	return { plid = plid }
end

--- CAR TRACKING PACKETS
--function luaLFSapi:nlp(imsg)
--	print("Parsing NLP")
--	local n, psize, pty, reqi, nump, nodelap = bunpack(imsg, "bbbb A?")
--	print("NLP parsed")
--	return {nump = nump, nodelap = nodelap }
--end

--function luaLFSapi:mci(imsg)
--	print("Parsing MCI")
--	local n, psize, pty, reqi, numc, compcar = bunpack(imsg, "bbbb A?")
--	print("MCI parsed")
--	return { numc = numc, compcar = compcar }
--end	

--- IN GAME camera control
--function luaLFSapi:scc(racer_position_to_view, ingamecam, uniqueid)
--	omsg = bpack("zbbbb", "SCC", racer_position_to_view, uniqueid, 0)
--	sendmsg(omsg, string.len(omsg))
--end

--- DIRECT camera control
function luaLFSapi:cpp(imsg)
end

--- BUTTONS
function luaLFSapi:bfn(subt, ucid, clickid, inst)
	-- test
	local omsg = bpack("bbbbbbbb", 8, ISP_BFN, 0, subt, ucid, clickid, inst, 0)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:btn(reqi, ucid, clickid, inst, bstyle, typein, l, t, w, h, imsg)
	local imsg = imsg..string.rep("\0", 239 - string.len(imsg))
	local omsg = bpack("bbbbbbbbbbbbz", 12 + string.len(imsg)+1, ISP_BTN, reqi, ucid, clickid, inst, bstyle, typein, l, t, w, h, imsg)
	luaLFS_sendmsg(omsg, string.len(omsg))
end

function luaLFSapi:btc(imsg)
	print("Parsing BTC")
	local n, psize, pty, reqi, ucid, clickid, inst, cflags, sp3 = bunpack(imsg, "bbbbbbbb")
	print("BTC parsed")
	return { reqi = reqi, ucid = ucid, clickid = clickid, inst = inst, cflags = cflags }
end

function luaLFSapi:btt(imsg)
	print("Parsing BTT")
	local n, psize, pty, reqi, ucid, clickid, inst, typein, sp3, text = bunpack(imsg, "bbbbbbbbA96")
	print("BTT parsed")
	return { reqi = reqi, ucid = ucid, clickid = clickid, inst = inst, typein = typein, text = text }
end

------------------------------------------------------

luaLFS = luaLFSapi.create()

function recv_version(imsg)
	local n = nil
	local t = luaLFS:ver(imsg)
	luaLFS.versions.insim = t.insimver
	n, luaLFS.versions.lfs = bunpack(t.version, "z")
	n, luaLFS.versions.product = bunpack(t.product, "z")
	print("LFS "..luaLFS.versions.lfs.." running in "..luaLFS.versions.product.." mode, using InSim v"..luaLFS.versions.insim)
end

evt_bind(ISP_VER, recv_version)
