<?php

function PIE_settings()
  {
    return array('flags'      => ISF_LOCAL,
                 'insimname'  => 'ObjectInfo');
  }
  
function PIE_start()
  {
    $PIE = PIE::connect();
    
    $PIE->set('panelbaseid',      20);
    $PIE->set('paneltop',         7);
    $PIE->set('panelleft',        154);
    $PIE->set('panelwidth',       20);
    $PIE->set('panelbheight',     5);
    $PIE->set('object',           array());
    
    drawpanel();
  }
  
function PIE_BTC($data)
  {
    $PIE = PIE::connect();
    
    $bid = $PIE->get('panelbaseid');  
    if ($data['ClickID'] == $bid)
      PIE_sendTTC(TTC_SEL);
  }
  
function PIE_AXM($data)
  {
    if ($data['PMOAction'] != PMO_TTC_SEL)
      return;
    
    if ($data['NumO'] < 1)
      $object = array();
    else
      $object = $data['Info'][0];
    
    $PIE = PIE::connect();
       
    $PIE->set('object', $object);
    drawpanel();
  }
  
function drawpanel()
  {
    $PIE = PIE::connect();
    
    $bid      = $PIE->get('panelbaseid');
    $top      = $PIE->get('paneltop');
    $left     = $PIE->get('panelleft');
    $width    = $PIE->get('panelwidth');
    $bheight  = $PIE->get('panelbheight');
    
    $object   = $PIE->get('object');
    $id       = $bid;
    
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $id++,
                    'BStyle'   => ISB_DARK | ISB_CLICK,
                    'T'        => $top,
                    'L'        => $left,
                    'W'        => $width,
                    'H'        => $bheight,
                    'Text'     => '^7Get Object Info');
    PIE_sendpacket($packet);
        
    $row = 1;
    foreach($object as $k=>$v)
      {
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $id++,
                        'BStyle'   => ISB_DARK | ISB_RIGHT,
                        'T'        => $top + ($row * $bheight),
                        'L'        => $left,
                        'W'        => 8,
                        'H'        => $bheight,
                        'Text'     => $k.':');
        PIE_sendpacket($packet);
        
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $id++,
                        'BStyle'   => ISB_DARK | ISB_LEFT,
                        'T'        => $top + ($row * $bheight),
                        'L'        => $left+8,
                        'W'        => 12,
                        'H'        => $bheight,
                        'Text'     => $v);
        PIE_sendpacket($packet);
        $row += 1;
      }
    
    $max = $bid + 12;
    if ($id < $max)
      PIE_sendpacket(array( 'Type'      => ISP_BFN,
                            'SubType'   => BFN_DEL_BTN,
                            'ClickID'   => $id,
                            'ClickMax'  => $max));
    
  }
  